/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Queryable;
import org.intermine.objectstore.query.iql.IqlQuery;
import org.intermine.util.CombinedIterator;

public class Query
implements FromElement,
Queryable {
    private boolean distinct = true;
    private Constraint constraint = null;
    private Set<FromElement> queryClasses = new LinkedHashSet<FromElement>();
    private List<QuerySelectable> select = new ArrayList<QuerySelectable>();
    private List<QueryOrderable> orderBy = new ArrayList<QueryOrderable>();
    private Set<QueryNode> groupBy = new LinkedHashSet<QueryNode>();
    private Map<Object, String> aliases = new IdentityHashMap<Object, String>();
    private Map<String, Object> reverseAliases = new HashMap<String, Object>();
    private int limit = Integer.MAX_VALUE;
    private IqlQuery iqlQuery;
    private int aliasNo = 1;

    public void setLimit(int limit) {
        this.iqlQuery = null;
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public Query addFrom(FromElement cls) {
        if (cls == null) {
            throw new NullPointerException("cls must not be null");
        }
        this.iqlQuery = null;
        this.queryClasses.add(cls);
        this.alias(cls, null);
        return this;
    }

    public Query addFrom(FromElement cls, String alias) {
        if (cls == null) {
            throw new NullPointerException("cls must not be null");
        }
        this.iqlQuery = null;
        this.queryClasses.add(cls);
        this.alias(cls, alias);
        return this;
    }

    public Query deleteFrom(FromElement cls) {
        this.iqlQuery = null;
        this.queryClasses.remove(cls);
        String alias = this.aliases.remove(cls);
        if (alias != null) {
            this.reverseAliases.remove(alias);
        }
        return this;
    }

    public Set<FromElement> getFrom() {
        return Collections.unmodifiableSet(this.queryClasses);
    }

    @Override
    public void setConstraint(Constraint constraint) {
        this.iqlQuery = null;
        this.constraint = constraint;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }

    public Query addToGroupBy(QueryNode node) {
        this.iqlQuery = null;
        this.groupBy.add(node);
        return this;
    }

    public Query deleteFromGroupBy(QueryNode node) {
        this.iqlQuery = null;
        this.groupBy.remove(node);
        return this;
    }

    public Set<QueryNode> getGroupBy() {
        return Collections.unmodifiableSet(this.groupBy);
    }

    public Query addToOrderBy(QueryOrderable node) {
        this.iqlQuery = null;
        this.orderBy.add(node);
        return this;
    }

    public Query addToOrderBy(QueryOrderable node, String direction) {
        this.iqlQuery = null;
        if ("desc".equals(direction)) {
            OrderDescending o = new OrderDescending(node);
            this.orderBy.add(o);
        } else {
            this.orderBy.add(node);
        }
        return this;
    }

    public Query deleteFromOrderBy(QueryOrderable node) {
        this.iqlQuery = null;
        this.orderBy.remove(node);
        return this;
    }

    public void clearOrderBy() {
        this.iqlQuery = null;
        this.orderBy.clear();
    }

    public List<QueryOrderable> getOrderBy() {
        return Collections.unmodifiableList(this.orderBy);
    }

    public List<Object> getEffectiveOrderBy() {
        HashSet seenQueryClasses = new HashSet();
        ArrayList retval = new ArrayList();
        ArrayList<Iterator<Iterator<Object>>> iterators = new ArrayList<Iterator<Iterator<Object>>>();
        iterators.add(this.orderBy.iterator());
        iterators.add(this.select.iterator());
        CombinedIterator iter = new CombinedIterator(iterators);
        while (iter.hasNext()) {
            FromElement qc;
            Object node = iter.next();
            if (node instanceof QueryClass) {
                if (seenQueryClasses.contains(node)) continue;
                retval.add(node);
                seenQueryClasses.add(node);
                continue;
            }
            if (node instanceof QueryField) {
                qc = ((QueryField)node).getFromElement();
                if (qc instanceof QueryClass || qc instanceof QueryClassBag) {
                    if (seenQueryClasses.contains(qc)) continue;
                    if ("id".equals(((QueryField)node).getFieldName())) {
                        seenQueryClasses.add(qc);
                    }
                    retval.add(node);
                    continue;
                }
                if (!(qc instanceof Query)) continue;
                retval.add(node);
                continue;
            }
            if (node instanceof QueryObjectReference) {
                qc = ((QueryObjectReference)node).getQueryClass();
                if (seenQueryClasses.contains(qc)) continue;
                retval.add(node);
                continue;
            }
            retval.add(node);
        }
        return Collections.unmodifiableList(retval);
    }

    @Override
    public void addToSelect(QuerySelectable node) {
        this.iqlQuery = null;
        this.select.add(node);
        if (node instanceof PathExpressionField) {
            this.alias(((PathExpressionField)node).getQope(), null);
        }
        this.alias(node, null);
    }

    public Query addToSelect(QuerySelectable node, String alias) {
        this.iqlQuery = null;
        this.select.add(node);
        if (node instanceof PathExpressionField) {
            this.alias(((PathExpressionField)node).getQope(), null);
        }
        this.alias(node, alias);
        return this;
    }

    public Query deleteFromSelect(QuerySelectable node) {
        String alias;
        this.iqlQuery = null;
        this.select.remove(node);
        if (!(node instanceof FromElement) && (alias = this.aliases.remove(node)) != null) {
            this.reverseAliases.remove(alias);
        }
        return this;
    }

    @Override
    public List<QuerySelectable> getSelect() {
        return Collections.unmodifiableList(this.select);
    }

    public void clearSelect() {
        this.iqlQuery = null;
        for (QuerySelectable qs : this.select) {
            String alias;
            if (qs instanceof FromElement || (alias = this.aliases.remove(qs)) == null) continue;
            this.reverseAliases.remove(alias);
        }
        this.select.clear();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.iqlQuery = null;
        this.distinct = distinct;
    }

    public Map<Object, String> getAliases() {
        return Collections.unmodifiableMap(this.aliases);
    }

    public Map<String, Object> getReverseAliases() {
        return Collections.unmodifiableMap(this.reverseAliases);
    }

    public String toString() {
        return this.getIqlQuery().toString();
    }

    public IqlQuery getIqlQuery() {
        if (this.iqlQuery == null) {
            this.iqlQuery = new IqlQuery(this);
        }
        return this.iqlQuery;
    }

    public void alias(Object obj, String alias) {
        this.iqlQuery = null;
        if (alias != null && this.reverseAliases.containsKey(alias) && !obj.equals(this.reverseAliases.get(alias))) {
            throw new IllegalArgumentException("Alias " + alias + " is already in use. Adding to " + this.toString() + " object " + obj + " with alias " + alias);
        }
        if (alias != null && this.aliases.containsKey(obj) && !alias.equals(this.aliases.get(obj))) {
            throw new IllegalArgumentException("Cannot re-alias the same element");
        }
        while (this.reverseAliases.containsKey("a" + this.aliasNo + "_")) {
            ++this.aliasNo;
        }
        if (!this.aliases.containsKey(obj)) {
            if (alias == null) {
                alias = "a" + this.aliasNo + "_";
            }
            this.aliases.put(obj, alias);
            this.reverseAliases.put(alias, obj);
        }
    }
}

