/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.ResultsBatches;

public final class PrefetchManager {
    private static final Logger LOG = Logger.getLogger(PrefetchManager.class);
    protected static Set<Request> pending = new HashSet<Request>();
    protected static Set<Request> serviced = Collections.synchronizedSet(new HashSet());
    protected static int serviceThreads = 0;
    private static Object sync = new Object();
    protected static final int LOADING = 3;

    private PrefetchManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRequest(ResultsBatches result, int batchNo, boolean optimise, boolean explain) {
        Request request = new Request(result, batchNo, optimise, explain);
        Object object = sync;
        synchronized (object) {
            ResultsBatches resultsBatches = result;
            synchronized (resultsBatches) {
                if (!result.batches.containsKey(new Integer(batchNo)) && !serviced.contains(request)) {
                    pending.add(request);
                    if (pending.size() + serviced.size() > serviceThreads * 3) {
                        ServiceThread newThread = new ServiceThread();
                        newThread.setDaemon(true);
                        newThread.setName("PrefetchManager ServiceThread");
                        newThread.start();
                        LOG.info((Object)("addRequest - creating new ServiceThread. We now have " + ++serviceThreads));
                    } else {
                        sync.notify();
                    }
                }
            }
        }
    }

    public static List<Object> doRequest(ResultsBatches result, int batchNo, boolean optimise, boolean explain) throws ObjectStoreException {
        return PrefetchManager.doRequest(new Request(result, batchNo, optimise, explain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<Object> doRequest(Request request) throws ObjectStoreException {
        boolean needToWait = false;
        List<Object> retval = null;
        Object object = sync;
        synchronized (object) {
            ResultsBatches resultsBatches = request.result;
            synchronized (resultsBatches) {
                retval = ((Request)request).result.batches.get(new Integer(request.batchNo));
                if (retval != null) {
                    return retval;
                }
                if (pending.contains(request)) {
                    serviced.add(request);
                    pending.remove(request);
                } else if (serviced.contains(request)) {
                    needToWait = true;
                } else {
                    serviced.add(request);
                }
            }
        }
        if (needToWait) {
            object = request.result;
            synchronized (object) {
                if (serviced.contains(request)) {
                    try {
                        request.result.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            retval = PrefetchManager.doRequest(request);
        } else {
            try {
                retval = request.result.fetchBatchFromObjectStore(request.batchNo, request.optimise, request.explain);
            }
            finally {
                PrefetchManager.reportDone(request);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reportDone(Request request) {
        ResultsBatches resultsBatches = request.result;
        synchronized (resultsBatches) {
            serviced.remove(request);
            request.result.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Request getRequest() {
        Request retval;
        Object object = sync;
        synchronized (object) {
            while (pending.isEmpty()) {
                try {
                    sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            retval = pending.iterator().next();
            serviced.add(retval);
            pending.remove(retval);
        }
        return retval;
    }

    private static class ServiceThread
    extends Thread {
        private ServiceThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {}
                catch (Error e) {
                    LOG.error((Object)"Failure of PrefetchManager service thread with error", (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                LOG.error((Object)"ServiceThread died unexpectedly. PrefetchManager may stop working");
                --serviceThreads;
                throw throwable;
            }
            while (true) {
                Request request = PrefetchManager.getRequest();
                try {
                    List<Object> batch = request.result.fetchBatchFromObjectStore(request.batchNo, request.optimise, request.explain);
                    continue;
                }
                catch (Exception e) {
                    LOG.warn((Object)("ServiceThread.run - Received exception                " + request + " " + e));
                    continue;
                }
                finally {
                    PrefetchManager.reportDone(request);
                    continue;
                }
                break;
            }
        }
    }

    private static class Request {
        private ResultsBatches result;
        private int batchNo;
        private boolean optimise;
        private boolean explain;

        public Request(ResultsBatches result, int batchNo, boolean optimise, boolean explain) {
            this.result = result;
            this.batchNo = batchNo;
            this.optimise = optimise;
            this.explain = explain;
        }

        public int hashCode() {
            return 2 * this.result.query.hashCode() + 3 * this.batchNo;
        }

        public boolean equals(Object obj) {
            return this.result == ((Request)obj).result && ((Request)obj).batchNo == this.batchNo;
        }

        public String toString() {
            return "Result " + this.result.query.hashCode() + ", batch " + this.batchNo;
        }
    }
}

