/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.OverlapRange;

public class OverlapConstraint
extends Constraint {
    protected OverlapRange left;
    protected OverlapRange right;
    protected List<ConstraintOp> validOps = Arrays.asList(ConstraintOp.CONTAINS, ConstraintOp.DOES_NOT_CONTAIN, ConstraintOp.IN, ConstraintOp.NOT_IN, ConstraintOp.OVERLAPS, ConstraintOp.DOES_NOT_OVERLAP);

    public OverlapConstraint(OverlapRange left, ConstraintOp op, OverlapRange right) {
        if (left == null) {
            throw new NullPointerException("left argument cannot be null");
        }
        if (right == null) {
            throw new NullPointerException("right argument cannot be null");
        }
        if (!this.validOps.contains(op)) {
            throw new IllegalArgumentException("Invalid constraint " + op + " for overlap constraint");
        }
        this.left = left;
        this.right = right;
        this.op = op;
    }

    public OverlapRange getLeft() {
        return this.left;
    }

    public OverlapRange getRight() {
        return this.right;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OverlapConstraint) {
            OverlapConstraint oc = (OverlapConstraint)obj;
            return oc.left.equals(this.left) && oc.op == this.op && oc.right.equals(this.right);
        }
        return false;
    }

    public int hashCode() {
        return this.left.hashCode() + 5 * this.op.hashCode() + 7 * this.right.hashCode();
    }
}

