/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.util.DynamicUtil;
import org.intermine.util.Util;

public class ContainsConstraint
extends Constraint {
    protected QueryReference ref;
    protected QueryClass cls;
    protected InterMineObject obj;
    public static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.CONTAINS, ConstraintOp.DOES_NOT_CONTAIN);
    public static final List<ConstraintOp> VALID_OPS_NULL = Arrays.asList(ConstraintOp.IS_NULL, ConstraintOp.IS_NOT_NULL);

    public ContainsConstraint(QueryReference ref, ConstraintOp op, QueryClass cls) {
        if (ref == null) {
            throw new NullPointerException("ref cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        if (cls == null) {
            throw new NullPointerException("cls cannot be null");
        }
        Class<? extends FastPathObject> c1 = ref.getType();
        Class<? extends FastPathObject> c2 = cls.getType();
        Set<Class<?>> cs1 = DynamicUtil.decomposeClass(c1);
        Set<Class<?>> cs2 = DynamicUtil.decomposeClass(c2);
        if (!(cs1.size() != 1 || cs2.size() != 1 || c1.isInterface() || c2.isInterface() || c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1))) {
            throw new IllegalArgumentException("Invalid constraint: " + c1 + " " + op + " " + c2);
        }
        this.ref = ref;
        this.op = op;
        this.cls = cls;
        this.obj = null;
    }

    public ContainsConstraint(QueryReference ref, ConstraintOp op, InterMineObject obj) {
        if (ref == null) {
            throw new NullPointerException("ref cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        if (obj == null) {
            throw new NullPointerException("obj cannot be null");
        }
        this.ref = ref;
        this.op = op;
        this.obj = obj;
        this.cls = null;
    }

    public ContainsConstraint(QueryObjectReference ref, ConstraintOp op) {
        if (ref == null) {
            throw new NullPointerException("ref cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS_NULL.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        this.ref = ref;
        this.op = op;
        this.cls = null;
        this.obj = null;
    }

    public QueryReference getReference() {
        return this.ref;
    }

    public QueryClass getQueryClass() {
        return this.cls;
    }

    public InterMineObject getObject() {
        return this.obj;
    }

    public boolean equals(Object obj1) {
        if (obj1 instanceof ContainsConstraint) {
            ContainsConstraint cc = (ContainsConstraint)obj1;
            return this.ref.equals(cc.ref) && this.op == cc.op && Util.equals(this.obj, cc.obj) && Util.equals(this.cls, cc.cls);
        }
        return false;
    }

    public int hashCode() {
        return this.ref.hashCode() + 3 * this.op.hashCode() + 7 * (this.cls == null ? 0 : this.cls.hashCode()) + 11 * (this.obj == null ? 0 : this.obj.hashCode());
    }
}

