/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;

public class ConstraintSet
extends Constraint {
    protected LinkedHashSet<Constraint> constraints;
    protected static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.AND, ConstraintOp.OR, ConstraintOp.NAND, ConstraintOp.NOR);

    public ConstraintSet(ConstraintOp op) {
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        this.op = op;
        this.constraints = new LinkedHashSet();
    }

    public ConstraintSet addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public ConstraintSet removeConstraint(Constraint constraint) {
        if (!this.constraints.contains(constraint)) {
            throw new IllegalArgumentException("Constraint does not exist in set");
        }
        this.constraints.remove(constraint);
        return this;
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstraintSet) {
            ConstraintSet cs = (ConstraintSet)obj;
            return this.constraints.equals(cs.constraints) && this.op == cs.op;
        }
        return false;
    }

    public int hashCode() {
        return this.constraints.hashCode() + 3 * this.op.hashCode();
    }

    public String toString() {
        return "ConstraintSet@" + Integer.toHexString(System.identityHashCode(this)) + "(" + this.op + ", " + this.constraints + ")";
    }
}

