/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.List;

public final class ConstraintOp {
    private static List<ConstraintOp> values = new ArrayList<ConstraintOp>();
    private final String name;
    public static final ConstraintOp EQUALS = new ConstraintOp("=");
    public static final ConstraintOp NOT_EQUALS = new ConstraintOp("!=");
    public static final ConstraintOp LESS_THAN = new ConstraintOp("<");
    public static final ConstraintOp LESS_THAN_EQUALS = new ConstraintOp("<=");
    public static final ConstraintOp GREATER_THAN = new ConstraintOp(">");
    public static final ConstraintOp GREATER_THAN_EQUALS = new ConstraintOp(">=");
    public static final ConstraintOp MATCHES = new ConstraintOp("LIKE");
    public static final ConstraintOp DOES_NOT_MATCH = new ConstraintOp("NOT LIKE");
    public static final ConstraintOp IS_NULL = new ConstraintOp("IS NULL");
    public static final ConstraintOp IS_NOT_NULL = new ConstraintOp("IS NOT NULL");
    public static final ConstraintOp CONTAINS = new ConstraintOp("CONTAINS");
    public static final ConstraintOp DOES_NOT_CONTAIN = new ConstraintOp("DOES NOT CONTAIN");
    public static final ConstraintOp IN = new ConstraintOp("IN");
    public static final ConstraintOp NOT_IN = new ConstraintOp("NOT IN");
    public static final ConstraintOp EXISTS = CONTAINS;
    public static final ConstraintOp DOES_NOT_EXIST = DOES_NOT_CONTAIN;
    public static final ConstraintOp AND = new ConstraintOp("AND");
    public static final ConstraintOp OR = new ConstraintOp("OR");
    public static final ConstraintOp NAND = new ConstraintOp("NAND");
    public static final ConstraintOp NOR = new ConstraintOp("NOR");
    public static final ConstraintOp LOOKUP = new ConstraintOp("LOOKUP");
    public static final ConstraintOp OVERLAPS = new ConstraintOp("OVERLAPS");
    public static final ConstraintOp DOES_NOT_OVERLAP = new ConstraintOp("DOES NOT OVERLAP");
    public static final ConstraintOp ONE_OF = new ConstraintOp("ONE OF");
    public static final ConstraintOp NONE_OF = new ConstraintOp("NONE OF");

    private ConstraintOp(String name) {
        this.name = name;
        values.add(this);
    }

    public String toString() {
        return this.name;
    }

    public Integer getIndex() {
        return new Integer(values.indexOf(this));
    }

    public static ConstraintOp getOpForIndex(Integer index) {
        return values.get(index);
    }

    public static List<ConstraintOp> getValues() {
        return values;
    }

    public ConstraintOp negate() {
        if (this == EQUALS) {
            return NOT_EQUALS;
        }
        if (this == NOT_EQUALS) {
            return EQUALS;
        }
        if (this == LESS_THAN) {
            return GREATER_THAN_EQUALS;
        }
        if (this == GREATER_THAN_EQUALS) {
            return LESS_THAN;
        }
        if (this == GREATER_THAN) {
            return LESS_THAN_EQUALS;
        }
        if (this == LESS_THAN_EQUALS) {
            return GREATER_THAN;
        }
        if (this == MATCHES) {
            return DOES_NOT_MATCH;
        }
        if (this == DOES_NOT_MATCH) {
            return MATCHES;
        }
        if (this == IS_NULL) {
            return IS_NOT_NULL;
        }
        if (this == IS_NOT_NULL) {
            return IS_NULL;
        }
        if (this == CONTAINS) {
            return DOES_NOT_CONTAIN;
        }
        if (this == DOES_NOT_CONTAIN) {
            return CONTAINS;
        }
        if (this == IN) {
            return NOT_IN;
        }
        if (this == NOT_IN) {
            return IN;
        }
        if (this == AND) {
            return NAND;
        }
        if (this == NAND) {
            return AND;
        }
        if (this == OR) {
            return NOR;
        }
        if (this == NOR) {
            return OR;
        }
        throw new IllegalArgumentException("Unknown op");
    }

    public static ConstraintOp getConstraintOp(String operationCode) {
        if (operationCode == null) {
            return null;
        }
        String opCode = operationCode.trim().toUpperCase();
        for (ConstraintOp op : values) {
            if (!op.getName().equalsIgnoreCase(opCode)) continue;
            return op;
        }
        return null;
    }

    private String getName() {
        return this.name;
    }
}

