/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ConstraintTraverseAction;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.MultipleInBagConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SubqueryConstraint;

public final class ConstraintHelper {
    private ConstraintHelper() {
    }

    public static List<Constraint> createList(Query query) {
        ArrayList<Constraint> retval = new ArrayList<Constraint>();
        if (query != null) {
            ConstraintHelper.addToList(retval, query.getConstraint());
        }
        return retval;
    }

    public static List<Constraint> createList(Query query, FromElement fromElement) {
        return ConstraintHelper.filter(ConstraintHelper.createList(query), fromElement, false);
    }

    public static void traverseConstraints(Constraint c, ConstraintTraverseAction ca) {
        ca.apply(c);
        if (c instanceof ConstraintSet) {
            for (Constraint childConstraint : ((ConstraintSet)c).getConstraints()) {
                ConstraintHelper.traverseConstraints(childConstraint, ca);
            }
        }
    }

    public static List<Constraint> listRelatedConstraints(Query query, FromElement fromElement) {
        return ConstraintHelper.filter(ConstraintHelper.createList(query), fromElement, true);
    }

    public static List<Constraint> filter(List<Constraint> list, FromElement fromElement, boolean related) {
        ArrayList<Constraint> filtered = new ArrayList<Constraint>();
        if (related) {
            for (Constraint c : list) {
                if (fromElement != null) {
                    if (!ConstraintHelper.isRelatedTo(c, fromElement)) continue;
                    filtered.add(c);
                    continue;
                }
                if (!ConstraintHelper.isRelatedToNothing(c)) continue;
                filtered.add(c);
            }
        } else {
            for (Constraint c : list) {
                if (fromElement != null) {
                    if (!ConstraintHelper.isAssociatedWith(c, fromElement)) continue;
                    filtered.add(c);
                    continue;
                }
                if (!ConstraintHelper.isAssociatedWithNothing(c)) continue;
                filtered.add(c);
            }
        }
        return filtered;
    }

    public static void addToList(List<Constraint> list, Constraint constraint) {
        if (constraint != null) {
            if (constraint instanceof ConstraintSet) {
                if (((ConstraintSet)constraint).getOp() == ConstraintOp.AND) {
                    Set<Constraint> constraints = ((ConstraintSet)constraint).getConstraints();
                    for (Constraint con : constraints) {
                        ConstraintHelper.addToList(list, con);
                    }
                } else {
                    list.add(constraint);
                }
            } else {
                list.add(constraint);
            }
        }
    }

    public static boolean isAssociatedWith(Constraint constraint, FromElement fromElement) {
        Object left = ConstraintHelper.getLeftArgument(constraint);
        Object right = ConstraintHelper.getRightArgument(constraint);
        if (left instanceof QueryEvaluable && !ConstraintHelper.isCrossReference(constraint)) {
            QueryClass qc = null;
            if (ConstraintHelper.getQueryFields((QueryEvaluable)left).iterator().hasNext()) {
                QueryField qf = ConstraintHelper.getQueryFields((QueryEvaluable)left).iterator().next();
                qc = (QueryClass)qf.getFromElement();
            } else if (ConstraintHelper.getQueryFields((QueryEvaluable)right).iterator().hasNext()) {
                QueryField qf = ConstraintHelper.getQueryFields((QueryEvaluable)right).iterator().next();
                qc = (QueryClass)qf.getFromElement();
            } else {
                return false;
            }
            return fromElement == qc;
        }
        if (left instanceof QueryClass && right instanceof QueryClass) {
            return fromElement == left || fromElement == right;
        }
        if (left instanceof QueryClass) {
            return fromElement == left;
        }
        if (left instanceof QueryReference) {
            return fromElement == ((QueryReference)left).getQueryClass();
        }
        if (right instanceof Query) {
            return fromElement == right;
        }
        return false;
    }

    public static boolean isAssociatedWithNothing(Constraint c) {
        Object left = ConstraintHelper.getLeftArgument(c);
        Object right = ConstraintHelper.getRightArgument(c);
        if (ConstraintHelper.isCrossReference(c)) {
            return true;
        }
        if (left instanceof QueryEvaluable) {
            if (ConstraintHelper.getQueryFields((QueryEvaluable)left).size() > 0) {
                return false;
            }
            if (right instanceof QueryEvaluable) {
                return ConstraintHelper.getQueryFields((QueryEvaluable)left).size() > 0;
            }
        } else {
            if (left instanceof QueryClass) {
                return false;
            }
            if (left instanceof QueryReference) {
                return false;
            }
        }
        return true;
    }

    public static boolean isRelatedTo(Constraint constraint, FromElement fromElement) {
        if (ConstraintHelper.isAssociatedWith(constraint, fromElement)) {
            return true;
        }
        if (constraint instanceof ContainsConstraint) {
            if (fromElement == ((ContainsConstraint)constraint).getQueryClass()) {
                return true;
            }
        } else if (constraint instanceof SubqueryConstraint) {
            if (fromElement == ((SubqueryConstraint)constraint).getQuery()) {
                return true;
            }
        } else if (constraint instanceof SimpleConstraint) {
            SimpleConstraint sc = (SimpleConstraint)constraint;
            Set<QueryField> qFields = ConstraintHelper.getQueryFields(sc.getArg1());
            qFields.addAll(ConstraintHelper.getQueryFields(sc.getArg2()));
            for (QueryField qf : qFields) {
                if (fromElement != qf.getFromElement()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRelatedToNothing(Constraint c) {
        if (c instanceof SimpleConstraint) {
            SimpleConstraint sc = (SimpleConstraint)c;
            Set<QueryField> fields = ConstraintHelper.getQueryFields(sc.getArg1());
            fields.addAll(ConstraintHelper.getQueryFields(sc.getArg2()));
            if (fields.size() == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCrossReference(Constraint constraint) {
        if (constraint instanceof SimpleConstraint) {
            HashSet<FromElement> qcs = new HashSet<FromElement>();
            for (QueryField qf : ConstraintHelper.getQueryFields(((SimpleConstraint)constraint).getArg1())) {
                qcs.add(qf.getFromElement());
            }
            for (QueryField qf : ConstraintHelper.getQueryFields(((SimpleConstraint)constraint).getArg2())) {
                qcs.add(qf.getFromElement());
            }
            if (qcs.size() > 1) {
                return true;
            }
        }
        return false;
    }

    protected static Set<QueryField> getQueryFields(QueryEvaluable qe) {
        HashSet<QueryField> fields = new HashSet<QueryField>();
        if (qe instanceof QueryField) {
            fields.add((QueryField)qe);
        } else if (qe instanceof QueryFunction) {
            fields.addAll(ConstraintHelper.getQueryFields(((QueryFunction)qe).getParam()));
        } else if (qe instanceof QueryExpression) {
            fields.addAll(ConstraintHelper.getQueryFields(((QueryExpression)qe).getArg1()));
            fields.addAll(ConstraintHelper.getQueryFields(((QueryExpression)qe).getArg2()));
            fields.addAll(ConstraintHelper.getQueryFields(((QueryExpression)qe).getArg3()));
        }
        return fields;
    }

    public static Object getLeftArgument(Constraint constraint) {
        Object left;
        if (constraint instanceof ConstraintSet) {
            left = null;
        } else if (constraint instanceof ClassConstraint) {
            left = ((ClassConstraint)constraint).getArg1();
        } else if (constraint instanceof ContainsConstraint) {
            left = ((ContainsConstraint)constraint).getReference();
        } else if (constraint instanceof SimpleConstraint) {
            left = ((SimpleConstraint)constraint).getArg1();
        } else if (constraint instanceof BagConstraint) {
            left = ((BagConstraint)constraint).getQueryNode();
        } else if (constraint instanceof SubqueryConstraint) {
            left = ((SubqueryConstraint)constraint).getQueryEvaluable();
            if (left == null) {
                left = ((SubqueryConstraint)constraint).getQueryClass();
            }
        } else {
            if (constraint instanceof MultipleInBagConstraint) {
                return null;
            }
            throw new IllegalArgumentException("Unknown Constraint type: " + constraint.getClass().getName());
        }
        return left;
    }

    public static Object getRightArgument(Constraint constraint) {
        Collection<?> right;
        if (constraint instanceof ConstraintSet) {
            right = null;
        } else if (constraint instanceof ClassConstraint) {
            right = ((ClassConstraint)constraint).getArg2QueryClass();
            if (right == null) {
                right = ((ClassConstraint)constraint).getArg2Object();
            }
        } else if (constraint instanceof ContainsConstraint) {
            right = ((ContainsConstraint)constraint).getQueryClass();
        } else if (constraint instanceof SimpleConstraint) {
            right = ((SimpleConstraint)constraint).getArg2();
        } else if (constraint instanceof SubqueryConstraint) {
            right = ((SubqueryConstraint)constraint).getQuery();
        } else if (constraint instanceof BagConstraint) {
            right = ((BagConstraint)constraint).getBag();
            if (right == null) {
                right = ((BagConstraint)constraint).getOsb();
            }
        } else {
            if (constraint instanceof MultipleInBagConstraint) {
                return null;
            }
            throw new IllegalArgumentException("Unknown Constraint type: " + constraint.getClass().getName());
        }
        return right;
    }
}

