/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.proxy.Lazy;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.SingletonResults;

public class ClobAccess
implements CharSequence,
Lazy {
    protected ObjectStore os;
    protected SingletonResults results;
    protected Clob clob;
    protected int offset;
    protected int length;
    protected boolean subSequence;
    private static ThreadLocal<Map<String, ClobAccessSubclassFactory>> subclassFactoryCache = new ThreadLocal<Map<String, ClobAccessSubclassFactory>>(){

        @Override
        protected Map<String, ClobAccessSubclassFactory> initialValue() {
            return new HashMap<String, ClobAccessSubclassFactory>();
        }
    };

    protected ClobAccess() {
    }

    public ClobAccess(ObjectStore os, Clob clob) {
        this.os = os;
        this.clob = clob;
        this.offset = 0;
        this.subSequence = false;
    }

    private ClobAccess(SingletonResults results, Clob clob, int offset, int length) {
        this.results = results;
        this.clob = clob;
        this.offset = offset;
        this.length = length;
        this.os = results.getObjectStore();
        this.subSequence = true;
    }

    protected void init() {
        if (this.results == null) {
            Query q = new Query();
            q.addToSelect(this.clob);
            this.results = this.os.executeSingleton(q, 20, false, false, true);
            int pageCount = this.results.size();
            if (pageCount == 0) {
                this.length = 0;
            } else {
                String lastPage = (String)this.results.get(pageCount - 1);
                this.length = 7000 * (pageCount - 1) + lastPage.length();
            }
        }
    }

    public Clob getClob() {
        return this.clob;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public char charAt(int index) {
        this.init();
        if (index < 0) {
            throw new IndexOutOfBoundsException("index is less than zero");
        }
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("index is not less than length");
        }
        int page = index / 7000;
        String pageText = (String)this.results.get(page);
        return pageText.charAt(index - page * 7000);
    }

    @Override
    public int length() {
        this.init();
        return this.length;
    }

    @Override
    public ClobAccess subSequence(int start, int end) {
        this.init();
        if (start < 0) {
            throw new IndexOutOfBoundsException("start is less than zero");
        }
        if (end > this.length) {
            throw new IndexOutOfBoundsException("end is greater than the length of this Clob");
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("end is less than start");
        }
        if (start == 0 && end == this.length) {
            return this;
        }
        return new ClobAccess(this.results, this.clob, start + this.offset, end - start);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.os;
    }

    @Override
    public String toString() {
        this.init();
        StringBuilder retval = new StringBuilder();
        if (this.length > 0) {
            int lowestPage = this.offset / 7000;
            int highestPage = (this.offset + this.length - 1) / 7000;
            for (int page = lowestPage; page <= highestPage; ++page) {
                String pageText = (String)this.results.get(page);
                if (page == highestPage) {
                    pageText = pageText.substring(0, this.offset + this.length - page * 7000);
                }
                if (page == lowestPage) {
                    pageText = pageText.substring(this.offset - page * 7000, pageText.length());
                }
                retval.append(pageText);
            }
        }
        return retval.toString();
    }

    public void drainToPrintStream(PrintStream out) {
        this.init();
        int lowestPage = this.offset / 7000;
        int highestPage = (this.offset + this.length - 1) / 7000;
        for (int page = lowestPage; page <= highestPage; ++page) {
            String pageText = (String)this.results.get(page);
            if (page == highestPage) {
                pageText = pageText.substring(0, this.offset + this.length - page * 7000);
            }
            if (page == lowestPage) {
                pageText = pageText.substring(this.offset - page * 7000, pageText.length());
            }
            out.print(pageText);
        }
    }

    public String getDbDescription() {
        if (this.subSequence) {
            return this.clob.getClobId() + "," + this.offset + "," + this.length();
        }
        return this.clob.getClobId() + "";
    }

    public ObjectStore getOs() {
        return this.os;
    }

    public int getLengthWithoutInit() {
        return this.length;
    }

    public SingletonResults getResultsWithoutInit() {
        return this.results;
    }

    public boolean getSubSequence() {
        return this.subSequence;
    }

    public static ClobAccess decodeDbDescription(ObjectStore os, String description) {
        String[] parts = description.split(",");
        ClobAccess clob = new ClobAccess(os, new Clob(Integer.parseInt(parts[0])));
        if (parts.length >= 3) {
            int offset = Integer.parseInt(parts[1]);
            int length = Integer.parseInt(parts[2]);
            clob = clob.subSequence(offset, offset + length);
        }
        String className = null;
        if (parts.length == 2) {
            className = parts[1];
        } else if (parts.length == 4) {
            className = parts[3];
        }
        if (className != null) {
            Map<String, ClobAccessSubclassFactory> factoryCache = subclassFactoryCache.get();
            ClobAccessSubclassFactory factory = factoryCache.get(className);
            if (factory == null) {
                try {
                    Class<?> subclass = Class.forName(className);
                    Method subMethod = subclass.getMethod("getFactory", new Class[0]);
                    factory = (ClobAccessSubclassFactory)subMethod.invoke(null, new Object[0]);
                    factoryCache.put(className, factory);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Could not read Clob subclass " + className + " from database.", e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Could not read Clob subclass " + className + " from database.", e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Could not read Clob subclass " + className + " from database.", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Could not read Clob subclass " + className + " from database.", e);
                }
            }
            clob = factory.invokeConstructor(clob);
        }
        return clob;
    }

    public static abstract class ClobAccessSubclassFactory {
        public abstract ClobAccess invokeConstructor(ClobAccess var1);
    }
}

