/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.util.DynamicUtil;
import org.intermine.util.Util;

public class ClassConstraint
extends Constraint {
    protected QueryClass qc1;
    protected QueryClass qc2;
    protected InterMineObject obj;
    public static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.EQUALS, ConstraintOp.NOT_EQUALS);

    public ClassConstraint(QueryClass qc1, ConstraintOp op, QueryClass qc2) {
        if (qc1 == null) {
            throw new NullPointerException("qc1 cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new IllegalArgumentException("op cannot be " + op);
        }
        if (qc2 == null) {
            throw new NullPointerException("qc2 cannot be null");
        }
        Class<? extends FastPathObject> c1 = qc1.getType();
        Class<? extends FastPathObject> c2 = qc2.getType();
        Set<Class<?>> cs1 = DynamicUtil.decomposeClass(c1);
        Set<Class<?>> cs2 = DynamicUtil.decomposeClass(c2);
        if (!(cs1.size() != 1 || cs2.size() != 1 || c1.isInterface() || c2.isInterface() || c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1))) {
            throw new IllegalArgumentException("Invalid constraint: " + c1 + " " + op + " " + c2);
        }
        this.qc1 = qc1;
        this.op = op;
        this.qc2 = qc2;
    }

    public ClassConstraint(QueryClass qc, ConstraintOp op, InterMineObject obj) {
        if (qc == null) {
            throw new NullPointerException("qc cannot be null");
        }
        if (op == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(op)) {
            throw new NullPointerException("op cannot be " + op);
        }
        if (obj == null) {
            throw new NullPointerException("obj cannot be null");
        }
        if (!qc.getType().isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Invalid constraint: " + qc.getType() + " " + op + " " + obj.getClass());
        }
        this.qc1 = qc;
        this.op = op;
        this.obj = obj;
    }

    public QueryClass getArg1() {
        return this.qc1;
    }

    public QueryClass getArg2QueryClass() {
        return this.qc2;
    }

    public InterMineObject getArg2Object() {
        return this.obj;
    }

    public boolean equals(Object o) {
        if (o instanceof ClassConstraint) {
            ClassConstraint cc = (ClassConstraint)o;
            return this.qc1.equals(cc.qc1) && this.op == cc.op && Util.equals(cc.qc2, this.qc2) && Util.equals(cc.obj, this.obj);
        }
        return false;
    }

    public int hashCode() {
        return this.qc1.hashCode() + 3 * this.op.hashCode() + 5 * Util.hashCode(this.qc2) + 7 * Util.hashCode(this.obj);
    }
}

