/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintWithBag;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.util.Util;

public class BagConstraint
extends Constraint
implements ConstraintWithBag {
    protected QueryNode qn;
    protected Collection<?> bag;
    protected ObjectStoreBag osb;
    public static final List<ConstraintOp> VALID_OPS = Arrays.asList(ConstraintOp.IN, ConstraintOp.NOT_IN);

    public BagConstraint(QueryNode qn, ConstraintOp op, Collection<?> bag) {
        ConstraintOp translatedOp = this.getTranslatedOp(op);
        if (qn == null) {
            throw new NullPointerException("qe cannot be null");
        }
        if (translatedOp == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(translatedOp)) {
            throw new IllegalArgumentException("op cannot be " + translatedOp);
        }
        if (bag == null) {
            throw new NullPointerException("bag cannot be null");
        }
        this.qn = qn;
        this.op = translatedOp;
        this.bag = bag;
        this.osb = null;
    }

    public BagConstraint(QueryNode qn, ConstraintOp op, ObjectStoreBag osb) {
        ConstraintOp translatedOp = this.getTranslatedOp(op);
        if (qn == null) {
            throw new NullPointerException("qe cannot be null");
        }
        if (translatedOp == null) {
            throw new NullPointerException("op cannot be null");
        }
        if (!VALID_OPS.contains(translatedOp)) {
            throw new IllegalArgumentException("op cannot be " + translatedOp);
        }
        if (osb == null) {
            throw new NullPointerException("osb cannot be null");
        }
        this.qn = qn;
        this.op = translatedOp;
        this.osb = osb;
        this.bag = null;
    }

    private ConstraintOp getTranslatedOp(ConstraintOp op) {
        if (ConstraintOp.ONE_OF.equals(op)) {
            return ConstraintOp.IN;
        }
        if (ConstraintOp.NONE_OF.equals(op)) {
            return ConstraintOp.NOT_IN;
        }
        return op;
    }

    public QueryNode getQueryNode() {
        return this.qn;
    }

    @Override
    public Collection<?> getBag() {
        return this.bag;
    }

    public ObjectStoreBag getOsb() {
        return this.osb;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BagConstraint) {
            BagConstraint bc = (BagConstraint)obj;
            return Util.equals(this.bag, bc.bag) && this.qn.equals(bc.qn) && Util.equals(this.osb, bc.osb);
        }
        return false;
    }

    public int hashCode() {
        return (this.bag == null ? this.osb.hashCode() : ((Object)this.bag).hashCode()) + 5 * this.qn.hashCode();
    }
}

