/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.proxy;

import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.proxy.Lazy;
import org.intermine.objectstore.translating.ObjectStoreTranslatingImpl;
import org.intermine.objectstore.translating.Translator;
import org.intermine.util.StringConstructor;

public class ProxyReference
implements InterMineObject,
Lazy {
    private ObjectStore os;
    private Integer id;
    private Class<? extends InterMineObject> clazz;

    public ProxyReference(ObjectStore os, Integer id, Class<? extends InterMineObject> clazz) {
        this.os = os;
        this.id = id;
        this.clazz = clazz;
    }

    public InterMineObject getObject() {
        try {
            InterMineObject retval = this.os.getObjectById(this.id, this.clazz);
            if (retval == null) {
                if (this.os instanceof ObjectStoreTranslatingImpl) {
                    Translator trans = ((ObjectStoreTranslatingImpl)this.os).getTranslator();
                    Object identifier = trans.translateIdToIdentifier(this.id);
                    throw new NullPointerException("Error retrieving object from Items database with identifier " + identifier);
                }
                throw new NullPointerException("Error retrieving object from proxy with ID " + this.id + " for class " + this.clazz.getName() + " from ObjectStore " + this.os);
            }
            return retval;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException("ObjectStoreException while materialising proxy with ID " + this.id + " for class " + this.clazz.getName() + " from ObjectStore " + this.os + ": " + e.getMessage());
        }
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        throw new IllegalArgumentException("Cannot change the id of a ProxyReference");
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.os;
    }

    public String toString() {
        return "<ProxyReference os: " + this.os + ", id: " + this.id + ", proxied class: " + this.clazz + ">";
    }

    @Override
    public StringConstructor getoBJECT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setoBJECT(String notXml, ObjectStore os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setoBJECT(String[] notXml, ObjectStore os) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getFieldValue(String fieldName) {
        if ("id".equals(fieldName)) {
            return this.id;
        }
        throw new UnsupportedOperationException("Tried to get field " + fieldName + " from proxy");
    }

    @Override
    public Object getFieldProxy(String fieldName) {
        if ("id".equals(fieldName)) {
            return this.id;
        }
        throw new UnsupportedOperationException("Tried to get field " + fieldName + " from proxy");
    }

    @Override
    public void setFieldValue(String fieldName, Object value) {
        if ("id".equals(fieldName)) {
            throw new IllegalArgumentException("Cannot change the id of a ProxyReference");
        }
        throw new UnsupportedOperationException("Tried to set field " + fieldName + " to value " + value);
    }

    @Override
    public Class<?> getFieldType(String fieldName) {
        if ("id".equals(fieldName)) {
            return Integer.class;
        }
        throw new UnsupportedOperationException("Tried to get field type for field " + fieldName + " from proxy");
    }

    public Class<? extends FastPathObject> getElementType(String fieldName) {
        throw new UnsupportedOperationException("Tried to get element type for field " + fieldName + " from proxy");
    }
}

