/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.proxy;

import java.lang.ref.SoftReference;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.proxy.LazyCollection;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.objectstore.query.SingletonResults;

public class ProxyCollection<E>
extends AbstractSet<E>
implements LazyCollection<E> {
    private static final Logger LOG = Logger.getLogger(ProxyCollection.class);
    private ObjectStore os;
    private InterMineObject o;
    private String fieldName;
    private Class<?> clazz;
    private boolean noOptimise;
    private boolean noExplain;
    private SoftReference<Collection<E>> collectionRef = null;
    private int batchSize = 1000;
    private static int createdCount = 0;
    private static int usedCount = 0;
    private static int evaluateCount = 0;

    public ProxyCollection(ObjectStore os, InterMineObject o, String fieldName, Class<? extends E> clazz) {
        this.os = os;
        this.o = o;
        this.fieldName = fieldName;
        this.clazz = clazz;
        this.noOptimise = true;
        this.noExplain = true;
        ++createdCount;
        ProxyCollection.maybeLog();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.os;
    }

    @Override
    public int size() {
        return this.getCollection().size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.getCollection().iterator();
    }

    @Override
    public Query getQuery() {
        try {
            return ((SingletonResults)this.getCollection()).getQuery();
        }
        catch (ClassCastException e) {
            return this.internalGetQuery();
        }
    }

    @Override
    public ResultsInfo getInfo() throws ObjectStoreException {
        Collection<E> coll = this.getCollection();
        try {
            return ((SingletonResults)coll).getInfo();
        }
        catch (ClassCastException e) {
            return new ResultsInfo(0L, 0L, coll.size());
        }
    }

    @Override
    public synchronized void setNoOptimise() {
        Collection<E> collection;
        this.noOptimise = true;
        if (this.collectionRef != null && (collection = this.collectionRef.get()) != null && collection instanceof SingletonResults) {
            ((SingletonResults)collection).setNoOptimise();
        }
    }

    @Override
    public synchronized void setNoExplain() {
        Collection<E> collection;
        this.noExplain = true;
        if (this.collectionRef != null && (collection = this.collectionRef.get()) != null && collection instanceof SingletonResults) {
            ((SingletonResults)collection).setNoExplain();
        }
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
        this.collectionRef = new SoftReference<Object>(null);
    }

    private synchronized Collection<E> getCollection() {
        Collection<E> collection = null;
        if (this.collectionRef == null) {
            ++usedCount;
            ProxyCollection.maybeLog();
        }
        if (this.collectionRef != null) {
            collection = this.collectionRef.get();
        }
        if (collection == null) {
            ++evaluateCount;
            ProxyCollection.maybeLog();
            Query q = this.internalGetQuery();
            collection = this.executeCollection(q);
            this.collectionRef = new SoftReference<Collection<E>>(collection);
        }
        return collection;
    }

    private Collection<E> executeCollection(Query q) {
        return this.os.executeSingleton(q, this.batchSize, !this.noOptimise, !this.noExplain, true);
    }

    @Override
    public List<E> asList() {
        Collection<E> collection = this.getCollection();
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<E>(collection);
    }

    public synchronized Collection<E> getMaterialisedCollection() {
        Collection<E> collection;
        if (this.collectionRef != null && (collection = this.collectionRef.get()) != null && !(collection instanceof SingletonResults)) {
            return collection;
        }
        return null;
    }

    public synchronized void setMaterialisedCollection(Collection<E> coll) {
        this.collectionRef = new SoftReference<Collection<E>>(coll);
    }

    private Query internalGetQuery() {
        Query q = new Query();
        QueryClass qc1 = new QueryClass(new Class[]{this.clazz});
        q.addFrom(qc1);
        q.addToSelect(qc1);
        q.setConstraint(new ContainsConstraint((QueryReference)new QueryCollectionReference(this.o, this.fieldName), ConstraintOp.CONTAINS, qc1));
        q.setDistinct(false);
        return q;
    }

    private static void maybeLog() {
        if ((createdCount + usedCount + evaluateCount) % 1000000 == 0) {
            LOG.info((Object)("Created: " + createdCount + ", Used: " + usedCount + ", Evaluated: " + evaluateCount));
        }
    }

    @Override
    public String toString() {
        return "ProxyCollection";
    }
}

