/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.DatabaseSchema;
import org.intermine.objectstore.intermine.TorqueModelOutput;
import org.intermine.util.PropertiesUtil;

public class TorqueModelOutputTask
extends Task {
    protected File destFile;
    protected DatabaseSchema schema;

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setOsName(String osName) {
        try {
            Properties props = PropertiesUtil.getPropertiesStartingWith(osName);
            props = PropertiesUtil.stripStart(osName, props);
            String missingTablesString = props.getProperty("missingTables");
            String truncatedClassesString = props.getProperty("truncatedClasses");
            String noNotXmlString = props.getProperty("noNotXml");
            String modelName = props.getProperty("model");
            Model osModel = Model.getInstanceByName(modelName);
            ArrayList<ClassDescriptor> truncatedClasses = new ArrayList<ClassDescriptor>();
            if (truncatedClassesString != null) {
                String[] classes = truncatedClassesString.split(",");
                for (int i = 0; i < classes.length; ++i) {
                    ClassDescriptor truncatedClassDescriptor = osModel.getClassDescriptorByName(classes[i]);
                    if (truncatedClassDescriptor == null) {
                        throw new ObjectStoreException("Truncated class " + classes[i] + " does not exist in the model");
                    }
                    truncatedClasses.add(truncatedClassDescriptor);
                }
            }
            boolean noNotXml = false;
            if ("true".equals(noNotXmlString) || noNotXmlString == null) {
                noNotXml = true;
            } else if ("false".equals(noNotXmlString)) {
                noNotXml = false;
            } else {
                throw new ObjectStoreException("Invalid value for property noNotXml: " + noNotXmlString);
            }
            HashSet<String> missingTables = new HashSet<String>();
            if (missingTablesString != null) {
                String[] tables = missingTablesString.split(",");
                for (int i = 0; i < tables.length; ++i) {
                    missingTables.add(tables[i].toLowerCase());
                }
            }
            this.schema = new DatabaseSchema(osModel, truncatedClasses, noNotXml, missingTables, 1, false);
        }
        catch (ClassCastException e) {
            throw new BuildException("Objectstore " + osName + " is not an ObjectStoreInterMineImpl", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new BuildException((Throwable)e);
        }
        catch (Error e) {
            e.printStackTrace(System.out);
            throw e;
        }
    }

    public void execute() {
        if (this.destFile == null) {
            throw new BuildException("destFile attribute is not set");
        }
        if (this.schema == null) {
            throw new BuildException("osName attribute is not set");
        }
        TorqueModelOutput mo = new TorqueModelOutput(this.schema, this.destFile);
        mo.process();
    }
}

