/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.DatabaseSchema;
import org.intermine.sql.DatabaseUtil;

public class TorqueModelOutput {
    private static final Logger LOG = Logger.getLogger(TorqueModelOutput.class);
    public static final int FORMAT_VERSION = 1;
    protected static final String INDENT = "    ";
    protected static final String ENDL = System.getProperty("line.separator");
    protected DatabaseSchema schema;
    protected File file;
    protected Set<CollectionDescriptor> indirections = new HashSet<CollectionDescriptor>();
    protected String className = "";
    private static final String LONG_VAR_BINARY_TYPE = "LONGVARBINARY";

    public TorqueModelOutput(DatabaseSchema schema, File file) {
        this.schema = schema;
        this.file = file;
    }

    public void process() {
        LOG.info((Object)("Generating " + this.file.getPath()));
        BufferedWriter fos = null;
        try {
            fos = new BufferedWriter(new FileWriter(this.file, false));
            fos.write(this.generate());
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to output torque data to file " + this.file.getPath()));
            throw new RuntimeException("Failed to output torque data to file " + this.file.getPath());
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)("Schema invalid while writing to file " + this.file.getPath()), (Throwable)e);
            throw new RuntimeException("Schema invalid while writing to file " + this.file.getPath(), e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to close file " + this.file.getPath()));
            }
        }
    }

    protected String generate() throws ObjectStoreException {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\" ?>" + ENDL).append("<database name=\"\">" + ENDL);
        for (ClassDescriptor cld : this.schema.getModel().getClassDescriptors()) {
            ClassDescriptor tableMaster;
            if (cld == (tableMaster = this.schema.getTableMaster(cld))) {
                sb.append(this.generate(cld));
            }
            for (CollectionDescriptor collection : cld.getCollectionDescriptors()) {
                if (4 != collection.relationType() || this.indirections.contains(collection.getReverseReferenceDescriptor())) continue;
                this.indirections.add(collection);
            }
        }
        for (CollectionDescriptor collection : this.indirections) {
            sb.append(this.generateIndirectionTable(collection));
        }
        sb.append("    <table name=\"intermine_metadata\">" + ENDL).append(this.generateColumn("key", "java.lang.String")).append(this.generateColumn("value", "java.lang.String")).append(this.generateColumn("blob_value", LONG_VAR_BINARY_TYPE)).append("    <unique name=\"intermine_metadata_key\">" + ENDL).append("        <unique-column name=\"key\"/>" + ENDL).append("    </unique>" + ENDL).append("    </table>" + ENDL);
        sb.append("    <table name=\"osbag_int\">" + ENDL).append(this.generateColumn("bagid", "java.lang.Integer")).append(this.generateColumn("value", "java.lang.Integer")).append("        <unique name=\"osbag_int_index1\">" + ENDL).append("            <unique-column name=\"bagid\"/>" + ENDL).append("            <unique-column name=\"value\"/>" + ENDL).append("        </unique>" + ENDL).append("        <index name=\"osbag_int_index2\">" + ENDL).append("            <index-column name=\"value\"/>" + ENDL).append("            <index-column name=\"bagid\"/>" + ENDL).append("        </index>" + ENDL).append("    </table>" + ENDL);
        sb.append("    <table name=\"clob\">" + ENDL).append(this.generateColumn("clobid", "java.lang.Integer")).append(this.generateColumn("clobpage", "java.lang.Integer")).append(this.generateColumn("value", "java.lang.String")).append("        <unique name=\"clob_index\">" + ENDL).append("            <unique-column name=\"clobid\"/>" + ENDL).append("            <unique-column name=\"clobpage\"/>" + ENDL).append("        </unique>" + ENDL).append("    </table>" + ENDL);
        sb.append("</database>" + ENDL);
        return sb.toString();
    }

    protected String generate(ClassDescriptor cld) throws ObjectStoreException {
        StringBuffer sb = new StringBuffer();
        this.className = DatabaseUtil.getTableName(cld);
        if (!this.schema.getMissingTables().contains(this.className.toLowerCase())) {
            sb.append("    <table name=\"" + this.className + "\">" + ENDL);
            if (!this.schema.isMissingNotXml() && !this.schema.isFlatMode(cld.getType()) || InterMineObject.class.equals(cld.getType())) {
                sb.append(this.generateColumn("OBJECT", "java.lang.String"));
            }
            DatabaseSchema.Fields fields = this.schema.getTableFields(cld);
            for (AttributeDescriptor attributeDescriptor : fields.getAttributes()) {
                sb.append(this.generateColumn(DatabaseUtil.getColumnName(attributeDescriptor), attributeDescriptor.getType()));
            }
            for (ReferenceDescriptor referenceDescriptor : fields.getReferences()) {
                sb.append(this.generateColumn(DatabaseUtil.getColumnName(referenceDescriptor), "java.lang.Integer"));
            }
            if (cld.getFieldDescriptorByName("id") != null) {
                if (this.schema.isTruncated(cld)) {
                    sb.append(this.generateColumn("class", "java.lang.String"));
                    sb.append(this.generateColumn("tableclass", "java.lang.String"));
                    sb.append("        <unique name=\"" + this.className + "_pkey\">" + ENDL + INDENT + INDENT + INDENT + "<unique-column name=\"id\"/>" + ENDL + INDENT + INDENT + INDENT + "<unique-column name=\"tableclass\"/>" + ENDL + INDENT + INDENT + "</unique>" + ENDL);
                } else {
                    if (!this.schema.isFlatMode(cld.getType())) {
                        sb.append(this.generateColumn("class", "java.lang.String"));
                    }
                    sb.append("        <unique name=\"" + this.className + "_pkey\">" + ENDL + INDENT + INDENT + INDENT + "<unique-column name=\"id\"/>" + ENDL + INDENT + INDENT + "</unique>" + ENDL);
                }
            }
            sb.append("    </table>" + ENDL);
            return sb.toString();
        }
        return "";
    }

    private String generateColumn(String name, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append("        <column name=\"").append(name).append("\" type=\"").append(TorqueModelOutput.generateJdbcType(type)).append("\"");
        if (type.indexOf(".") == -1 && !type.equals(LONG_VAR_BINARY_TYPE) || "id".equals(name)) {
            sb.append(" required=\"true\"");
        }
        sb.append("/>" + ENDL);
        return sb.toString();
    }

    protected String generateIndirectionTable(CollectionDescriptor col) {
        StringBuffer sb = new StringBuffer();
        String table = DatabaseUtil.getIndirectionTableName(col);
        String column1 = DatabaseUtil.getInwardIndirectionColumnName(col, this.schema.getVersion());
        String column2 = DatabaseUtil.getOutwardIndirectionColumnName(col, this.schema.getVersion());
        sb.append("    <table name=\"").append(table).append("\">" + ENDL).append(this.generateColumn(column1, "int")).append(this.generateColumn(column2, "int")).append("    </table>" + ENDL);
        return sb.toString();
    }

    public static String generateJdbcType(String type) {
        if ("short".equals(type) || "java.lang.Short".equals(type)) {
            return "SMALLINT";
        }
        if ("int".equals(type) || "java.lang.Integer".equals(type)) {
            return "INTEGER";
        }
        if ("long".equals(type) || "java.lang.Long".equals(type)) {
            return "BIGINT";
        }
        if ("java.lang.String".equals(type)) {
            return "LONGVARCHAR";
        }
        if ("boolean".equals(type) || "java.lang.Boolean".equals(type)) {
            return "BIT";
        }
        if ("float".equals(type) || "java.lang.Float".equals(type)) {
            return "REAL";
        }
        if ("double".equals(type) || "java.lang.Double".equals(type)) {
            return "DOUBLE";
        }
        if ("java.util.Date".equals(type)) {
            return "BIGINT";
        }
        if ("java.math.BigDecimal".equals(type)) {
            return "NUMERIC";
        }
        if ("org.intermine.objectstore.query.ClobAccess".equals(type)) {
            return "LONGVARCHAR";
        }
        if (LONG_VAR_BINARY_TYPE.equals(type)) {
            return LONG_VAR_BINARY_TYPE;
        }
        throw new IllegalArgumentException("Invalid type \"" + type + "\"");
    }
}

