/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.apache.torque.engine.database.model.Domain;
import org.apache.torque.engine.database.model.SchemaType;
import org.apache.torque.engine.platform.Platform;
import org.apache.torque.engine.platform.PlatformFactory;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.CheckForIsNotNullConstraint;
import org.intermine.objectstore.intermine.CompletelyFalseException;
import org.intermine.objectstore.intermine.DatabaseSchema;
import org.intermine.objectstore.intermine.TorqueModelOutput;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClassConstraint;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintHelper;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.MultipleInBagConstraint;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.ObjectStoreBagCombination;
import org.intermine.objectstore.query.ObjectStoreBagsForObject;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.OverlapConstraint;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCast;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryEvaluable;
import org.intermine.objectstore.query.QueryExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QueryPathExpression;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SubqueryConstraint;
import org.intermine.objectstore.query.SubqueryExistsConstraint;
import org.intermine.objectstore.query.UnknownTypeValue;
import org.intermine.objectstore.query.iql.IqlQuery;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseUtil;
import org.intermine.util.AlwaysMap;
import org.intermine.util.CombinedIterator;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public final class SqlGenerator {
    private static final Logger LOG = Logger.getLogger(SqlGenerator.class);
    protected static final int QUERY_NORMAL = 0;
    protected static final int QUERY_SUBQUERY_FROM = 1;
    protected static final int QUERY_SUBQUERY_CONSTRAINT = 2;
    protected static final int ID_ONLY = 2;
    protected static final int NO_ALIASES_ALL_FIELDS = 3;
    protected static final int QUERY_FOR_PRECOMP = 4;
    protected static final int QUERY_SUBQUERY_EXISTS = 5;
    protected static final int QUERY_FOR_GOFASTER = 6;
    protected static Map<DatabaseSchema, Map<Query, CacheEntry>> sqlCache = new WeakHashMap<DatabaseSchema, Map<Query, CacheEntry>>();
    protected static Map<DatabaseSchema, Map<Query, Set<Object>>> tablenamesCache = new WeakHashMap<DatabaseSchema, Map<Query, Set<Object>>>();
    public static final int SAFENESS_SAFE = 1;
    public static final int SAFENESS_ANTISAFE = -1;
    public static final int SAFENESS_UNSAFE = 0;
    public static final int MAX_BAG_INLINE_SIZE = 2;

    private SqlGenerator() {
    }

    public static String generateQueryForId(Integer id, Class<?> clazz, DatabaseSchema schema) throws ObjectStoreException {
        ClassDescriptor tableMaster;
        if (schema.isMissingNotXml()) {
            tableMaster = schema.getModel().getClassDescriptorByName(InterMineObject.class.getName());
        } else {
            ClassDescriptor cld = schema.getModel().getClassDescriptorByName(clazz.getName());
            if (cld == null) {
                throw new ObjectStoreException(clazz.toString() + " is not in the model");
            }
            tableMaster = schema.getTableMaster(cld);
        }
        if (schema.isTruncated(tableMaster)) {
            return "SELECT a1_.OBJECT AS a1_ FROM " + DatabaseUtil.getTableName(tableMaster) + " AS a1_ WHERE a1_.id = " + id.toString() + " AND a1_.tableclass = '" + clazz.getName() + "' LIMIT 2";
        }
        return "SELECT a1_.OBJECT AS a1_ FROM " + DatabaseUtil.getTableName(tableMaster) + " AS a1_ WHERE a1_.id = " + id.toString() + " LIMIT 2";
    }

    public static String tableNameForId(Class<?> clazz, DatabaseSchema schema) throws ObjectStoreException {
        ClassDescriptor tableMaster;
        if (schema.isMissingNotXml()) {
            tableMaster = schema.getModel().getClassDescriptorByName(InterMineObject.class.getName());
        } else {
            ClassDescriptor cld = schema.getModel().getClassDescriptorByName(clazz.getName());
            if (cld == null) {
                throw new ObjectStoreException(clazz.toString() + " is not in the model");
            }
            tableMaster = schema.getTableMaster(cld);
        }
        return DatabaseUtil.getTableName(tableMaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerOffset(Query q, int start, DatabaseSchema schema, Database db, Object value, Map<Object, String> bagTableNames) {
        LOG.debug((Object)("registerOffset() called with offset: " + start));
        try {
            if (value.getClass().equals(Boolean.class)) {
                return;
            }
            QueryOrderable firstOrderByO = null;
            firstOrderByO = (QueryOrderable)q.getEffectiveOrderBy().iterator().next();
            if (firstOrderByO instanceof QueryClass && !InterMineObject.class.isAssignableFrom(((QueryClass)firstOrderByO).getType())) {
                return;
            }
            Query query = q;
            synchronized (query) {
                Map<Query, CacheEntry> schemaCache = SqlGenerator.getCacheForSchema(schema);
                CacheEntry cacheEntry = schemaCache.get(q);
                if (cacheEntry != null) {
                    int offset;
                    if (cacheEntry.getLastOffset() - start >= 100000 || start - cacheEntry.getLastOffset() >= 10000) {
                        QueryNode firstOrderBy = null;
                        firstOrderBy = (QueryNode)q.getEffectiveOrderBy().iterator().next();
                        if (firstOrderBy instanceof QueryFunction) {
                            return;
                        }
                        if (firstOrderBy instanceof QueryClass) {
                            firstOrderBy = new QueryField((QueryClass)firstOrderBy, "id");
                        }
                        Constraint c = SqlGenerator.getOffsetConstraint(q, firstOrderBy, value, schema);
                        String sql = SqlGenerator.generate(q, schema, db, c, 0, bagTableNames);
                        cacheEntry.setLast(start, sql);
                    }
                    SortedMap<Integer, String> headMap = cacheEntry.getCached().headMap(new Integer(start + 1));
                    Integer lastKey = null;
                    try {
                        lastKey = headMap.lastKey();
                    }
                    catch (NoSuchElementException e) {
                        // empty catch block
                    }
                    if (lastKey != null && start - (offset = lastKey.intValue()) < 100000) {
                        return;
                    }
                }
                Constraint offsetConstraint = SqlGenerator.getOffsetConstraint(q, firstOrderByO, value, schema);
                String sql = SqlGenerator.generate(q, schema, db, offsetConstraint, 0, bagTableNames);
                if (cacheEntry == null) {
                    cacheEntry = new CacheEntry(start, sql);
                    schemaCache.put(q, cacheEntry);
                }
                cacheEntry.getCached().put(new Integer(start), sql);
            }
        }
        catch (ObjectStoreException e) {
            LOG.warn((Object)("Error while registering offset for query " + q + ": " + e));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    protected static Constraint getOffsetConstraint(Query q, QueryOrderable firstOrderBy, Object value, DatabaseSchema schema) {
        FromElement qc;
        boolean reverse = false;
        if (firstOrderBy instanceof OrderDescending) {
            firstOrderBy = ((OrderDescending)firstOrderBy).getQueryOrderable();
            reverse = true;
        }
        if (firstOrderBy instanceof QueryClass) {
            firstOrderBy = new QueryField((QueryClass)firstOrderBy, "id");
        }
        boolean hasNulls = true;
        if (firstOrderBy instanceof QueryField && !reverse && (qc = ((QueryField)firstOrderBy).getFromElement()) instanceof QueryClass) {
            if ("id".equals(((QueryField)firstOrderBy).getFieldName())) {
                hasNulls = false;
            } else if ("class".equals(((QueryField)firstOrderBy).getFieldName())) {
                hasNulls = false;
            } else {
                AttributeDescriptor desc = (AttributeDescriptor)schema.getModel().getFieldDescriptorsForClass(((QueryClass)qc).getType()).get(((QueryField)firstOrderBy).getFieldName());
                if (desc.isPrimitive()) {
                    hasNulls = false;
                }
            }
        }
        if (reverse) {
            return new SimpleConstraint((QueryEvaluable)firstOrderBy, ConstraintOp.LESS_THAN, new QueryValue(value));
        }
        SimpleConstraint sc = new SimpleConstraint((QueryEvaluable)firstOrderBy, ConstraintOp.GREATER_THAN, new QueryValue(value));
        if (hasNulls) {
            CheckForIsNotNullConstraint check = new CheckForIsNotNullConstraint((QueryNode)firstOrderBy);
            ConstraintHelper.traverseConstraints(q.getConstraint(), check);
            if (!check.exists()) {
                ConstraintSet cs = new ConstraintSet(ConstraintOp.OR);
                cs.addConstraint(sc);
                cs.addConstraint(new SimpleConstraint((QueryEvaluable)firstOrderBy, ConstraintOp.IS_NULL));
                return cs;
            }
        }
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate(Query q, int start, int limit, DatabaseSchema schema, Database db, Map<Object, String> bagTableNames) throws ObjectStoreException {
        Query query = q;
        synchronized (query) {
            if (q.getSelect().size() == 1 && q.getSelect().get(0) instanceof Clob) {
                Clob clob = (Clob)q.getSelect().get(0);
                return "SELECT value AS a1_ FROM clob WHERE clobid = " + clob.getClobId() + " AND " + "clobpage" + " >= " + start + " AND " + "clobpage" + " < " + (start + limit) + " ORDER BY " + "clobpage";
            }
            Map<Query, CacheEntry> schemaCache = SqlGenerator.getCacheForSchema(schema);
            CacheEntry cacheEntry = schemaCache.get(q);
            if (cacheEntry != null) {
                SortedMap<Integer, String> headMap = cacheEntry.getCached().headMap(new Integer(start + 1));
                Integer lastKey = null;
                try {
                    lastKey = headMap.lastKey();
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                if (lastKey != null) {
                    int offset = lastKey;
                    if (offset > cacheEntry.getLastOffset() || cacheEntry.getLastOffset() > start) {
                        return cacheEntry.getCached().get(lastKey) + (limit == Integer.MAX_VALUE ? "" : " LIMIT " + limit) + (start == offset ? "" : " OFFSET " + (start - offset));
                    }
                    return cacheEntry.getLastSQL() + (limit == Integer.MAX_VALUE ? "" : " LIMIT " + limit) + (start == cacheEntry.getLastOffset() ? "" : " OFFSET " + (start - cacheEntry.getLastOffset()));
                }
            }
            String sql = SqlGenerator.generate(q, schema, db, null, 0, bagTableNames);
            return sql + (limit == Integer.MAX_VALUE ? "" : " LIMIT " + limit) + (start == 0 ? "" : " OFFSET " + start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Query, CacheEntry> getCacheForSchema(DatabaseSchema schema) {
        Map<DatabaseSchema, Map<Query, CacheEntry>> map = sqlCache;
        synchronized (map) {
            Map<Query, CacheEntry> retval = sqlCache.get(schema);
            if (retval == null) {
                retval = Collections.synchronizedMap(new WeakHashMap());
                sqlCache.put(schema, retval);
            }
            return retval;
        }
    }

    public static String generate(Query q, DatabaseSchema schema, Database db, Constraint offsetCon, int kind, Map<Object, String> bagTableNames) throws ObjectStoreException {
        State state = new State();
        List<QuerySelectable> selectList = q.getSelect();
        if (selectList.size() == 1 && selectList.get(0) instanceof ObjectStoreBag) {
            return "SELECT value AS a1_ FROM osbag_int WHERE bagid = " + ((ObjectStoreBag)selectList.get(0)).getBagId() + " ORDER BY " + "value";
        }
        if (selectList.size() == 1 && selectList.get(0) instanceof ObjectStoreBagCombination) {
            ObjectStoreBagCombination osbc = (ObjectStoreBagCombination)selectList.get(0);
            if (osbc.getOp() == 879234) {
                StringBuffer retval = new StringBuffer("SELECT DISTINCT value AS a1_ FROM osbag_int WHERE bagid IN (");
                boolean needComma = false;
                for (ObjectStoreBag osb : osbc.getBags()) {
                    if (needComma) {
                        retval.append(", ");
                    }
                    needComma = true;
                    retval.append(osb.getBagId() + "");
                }
                retval.append(") ORDER BY value");
                return retval.toString();
            }
            if (osbc.getOp() == 853915) {
                StringBuffer retval = new StringBuffer("SELECT value AS a1_ FROM osbag_int WHERE bagid IN (");
                boolean needComma = false;
                for (ObjectStoreBag osb : osbc.getBags()) {
                    if (needComma) {
                        retval.append(", ");
                    }
                    needComma = true;
                    retval.append(osb.getBagId() + "");
                }
                retval.append(") GROUP BY value HAVING COUNT(*) < " + osbc.getBags().size() + " ORDER BY " + "value");
                return retval.toString();
            }
            StringBuffer retval = new StringBuffer();
            boolean needComma = false;
            for (ObjectStoreBag osb : osbc.getBags()) {
                if (needComma) {
                    retval.append(osbc.getOp() == 519552 ? " INTERSECT " : " EXCEPT ");
                }
                needComma = true;
                retval.append("SELECT value AS a1_ FROM osbag_int WHERE bagid = " + osb.getBagId());
            }
            retval.append(" ORDER BY a1_");
            return retval.toString();
        }
        if (selectList.size() == 1 && selectList.get(0) instanceof ObjectStoreBagsForObject) {
            ObjectStoreBagsForObject osbfo = (ObjectStoreBagsForObject)selectList.get(0);
            StringBuffer retval = new StringBuffer("SELECT bagid AS a1_ FROM osbag_int WHERE value = " + osbfo.getValue());
            Collection<ObjectStoreBag> bags = osbfo.getBags();
            if (bags != null && !bags.isEmpty()) {
                retval.append(" AND bagid IN (");
                boolean needComma = false;
                for (ObjectStoreBag osb : osbfo.getBags()) {
                    if (needComma) {
                        retval.append(", ");
                    }
                    needComma = true;
                    retval.append("" + osb.getBagId());
                }
                retval.append(")");
            }
            retval.append(" ORDER BY bagid");
            return retval.toString();
        }
        state.setDb(db);
        state.setBagTableNames(bagTableNames);
        SqlGenerator.buildFromComponent(state, q, schema, bagTableNames);
        SqlGenerator.buildWhereClause(state, q, q.getConstraint(), schema);
        SqlGenerator.buildWhereClause(state, q, offsetCon, schema);
        String orderBy = "";
        if (kind == 0 || kind == 4 || kind == 6) {
            boolean haveOrderBy = true;
            if (q.getGroupBy().isEmpty()) {
                for (QuerySelectable selectable : q.getSelect()) {
                    if (!(selectable instanceof QueryFunction)) continue;
                    haveOrderBy = false;
                }
            }
            if (haveOrderBy) {
                orderBy = SqlGenerator.buildOrderBy(state, q, schema, kind);
            }
        }
        StringBuffer retval = new StringBuffer("SELECT ").append(SqlGenerator.needsDistinct(q) ? "DISTINCT " : "").append(SqlGenerator.buildSelectComponent(state, q, schema, kind)).append(state.getFrom()).append(state.getWhere()).append(SqlGenerator.buildGroupBy(q, schema, state)).append(state.getHaving()).append(orderBy);
        if (q.getLimit() != Integer.MAX_VALUE && kind == 1) {
            retval.append(" LIMIT " + q.getLimit());
        }
        return retval.toString();
    }

    protected static boolean needsDistinct(Query q) {
        if (!q.isDistinct()) {
            return false;
        }
        HashSet<QueryClass> selectClasses = new HashSet<QueryClass>();
        for (QuerySelectable n : q.getSelect()) {
            FromElement qc;
            QueryField f;
            if (n instanceof QueryClass) {
                selectClasses.add((QueryClass)n);
                continue;
            }
            if (!(n instanceof QueryField) || !"id".equals((f = (QueryField)n).getFieldName()) || !((qc = f.getFromElement()) instanceof QueryClass)) continue;
            selectClasses.add((QueryClass)qc);
        }
        boolean allPresent = true;
        Iterator<FromElement> fromIter = q.getFrom().iterator();
        while (fromIter.hasNext() && allPresent) {
            FromElement qc = fromIter.next();
            allPresent = selectClasses.contains(qc);
        }
        return !allPresent;
    }

    public static Set<String> findTableNames(Query q, DatabaseSchema schema) throws ObjectStoreException {
        Set<Object> retvalO;
        Set<Object> retval = retvalO = SqlGenerator.findTableNames(q, schema, false);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Object> findTableNames(Query q, DatabaseSchema schema, boolean individualOsbs) throws ObjectStoreException {
        Map<Query, Set<Object>> schemaCache = SqlGenerator.getTablenamesCacheForSchema(schema);
        Query query = q;
        synchronized (query) {
            Set<Object> tablenames = schemaCache.get(q);
            if (tablenames == null) {
                tablenames = new HashSet<Object>();
                SqlGenerator.findTableNames(tablenames, q, schema, true, individualOsbs);
                schemaCache.put(q, tablenames);
            }
            return tablenames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Query, Set<Object>> getTablenamesCacheForSchema(DatabaseSchema schema) {
        Map<DatabaseSchema, Map<Query, Set<Object>>> map = tablenamesCache;
        synchronized (map) {
            Map<Query, Set<Object>> retval = tablenamesCache.get(schema);
            if (retval == null) {
                retval = Collections.synchronizedMap(new WeakHashMap());
                tablenamesCache.put(schema, retval);
            }
            return retval;
        }
    }

    private static void findTableNames(Set<Object> tablenames, Query q, DatabaseSchema schema, boolean addInterMineObject, boolean individualOsbs) throws ObjectStoreException {
        if (SqlGenerator.completelyFalse(q.getConstraint())) {
            return;
        }
        SqlGenerator.findTableNamesInConstraint(tablenames, q.getConstraint(), schema, individualOsbs);
        for (FromElement fromElement : q.getFrom()) {
            if (fromElement instanceof QueryClass) {
                for (Class<?> cls : DynamicUtil.decomposeClass(((QueryClass)fromElement).getType())) {
                    ClassDescriptor cld = schema.getModel().getClassDescriptorByName(cls.getName());
                    if (cld == null) {
                        throw new ObjectStoreException(cls + " is not in the model");
                    }
                    ClassDescriptor tableMaster = schema.getTableMaster(cld);
                    tablenames.add(DatabaseUtil.getTableName(tableMaster));
                }
                continue;
            }
            if (fromElement instanceof Query) {
                Query subQ = (Query)fromElement;
                SqlGenerator.findTableNames(tablenames, subQ, schema, false, individualOsbs);
                continue;
            }
            if (fromElement instanceof QueryClassBag) continue;
            throw new ObjectStoreException("Unknown FromElement: " + fromElement.getClass());
        }
        String interMineObject = DatabaseUtil.getTableName(schema.getModel().getClassDescriptorByName(InterMineObject.class.getName()));
        for (QuerySelectable selectable : q.getSelect()) {
            Set<Object> empty;
            if (selectable instanceof QueryClass) {
                if (!addInterMineObject || !schema.isMissingNotXml()) continue;
                tablenames.add(interMineObject);
                continue;
            }
            if (selectable instanceof QueryEvaluable || selectable instanceof QueryForeignKey) continue;
            if (selectable instanceof ObjectStoreBag) {
                if (individualOsbs) {
                    tablenames.add(selectable);
                    continue;
                }
                tablenames.add("osbag_int");
                continue;
            }
            if (selectable instanceof ObjectStoreBagCombination) {
                if (individualOsbs) {
                    tablenames.addAll(((ObjectStoreBagCombination)selectable).getBags());
                    continue;
                }
                tablenames.add("osbag_int");
                continue;
            }
            if (selectable instanceof ObjectStoreBagsForObject) {
                tablenames.add("osbag_int");
                continue;
            }
            if (selectable instanceof Clob) {
                if (individualOsbs) {
                    tablenames.add(selectable);
                    continue;
                }
                tablenames.add("clob");
                continue;
            }
            if (selectable instanceof QueryCollectionPathExpression) {
                empty = Collections.singleton(new ProxyReference(null, new Integer(1), InterMineObject.class));
                SqlGenerator.findTableNames(tablenames, ((QueryCollectionPathExpression)selectable).getQuery(empty), schema, addInterMineObject, individualOsbs);
                continue;
            }
            if (selectable instanceof QueryObjectPathExpression) {
                empty = Collections.singleton(new Integer(1));
                SqlGenerator.findTableNames(tablenames, ((QueryObjectPathExpression)selectable).getQuery(empty, schema.isMissingNotXml()), schema, addInterMineObject, individualOsbs);
                continue;
            }
            if (selectable instanceof PathExpressionField) {
                empty = Collections.singleton(new Integer(1));
                SqlGenerator.findTableNames(tablenames, ((PathExpressionField)selectable).getQope().getQuery(empty, schema.isMissingNotXml()), schema, addInterMineObject, individualOsbs);
                continue;
            }
            throw new ObjectStoreException("Illegal entry in SELECT list: " + selectable.getClass());
        }
    }

    private static void findTableNamesInConstraint(Set<Object> tablenames, Constraint c, DatabaseSchema schema, boolean individualOsbs) throws ObjectStoreException {
        if (c instanceof ConstraintSet) {
            for (Constraint subC : ((ConstraintSet)c).getConstraints()) {
                SqlGenerator.findTableNamesInConstraint(tablenames, subC, schema, individualOsbs);
            }
        } else if (c instanceof SubqueryConstraint) {
            SqlGenerator.findTableNames(tablenames, ((SubqueryConstraint)c).getQuery(), schema, false, individualOsbs);
        } else if (c instanceof SubqueryExistsConstraint) {
            SqlGenerator.findTableNames(tablenames, ((SubqueryExistsConstraint)c).getQuery(), schema, false, individualOsbs);
        } else if (c instanceof ContainsConstraint) {
            ContainsConstraint cc = (ContainsConstraint)c;
            QueryReference ref = cc.getReference();
            if (ref instanceof QueryCollectionReference) {
                ReferenceDescriptor refDesc = (ReferenceDescriptor)schema.getModel().getFieldDescriptorsForClass(ref.getQcType()).get(ref.getFieldName());
                if (refDesc.relationType() == 4) {
                    tablenames.add(DatabaseUtil.getIndirectionTableName((CollectionDescriptor)refDesc));
                } else if (cc.getQueryClass() == null) {
                    tablenames.add(DatabaseUtil.getTableName(schema.getTableMaster(refDesc.getReferencedClassDescriptor())));
                }
            }
        } else if (c instanceof BagConstraint) {
            if (((BagConstraint)c).getOsb() != null) {
                if (individualOsbs) {
                    tablenames.add(((BagConstraint)c).getOsb());
                } else {
                    tablenames.add("osbag_int");
                }
            }
        } else if (!(c == null || c instanceof SimpleConstraint || c instanceof ClassConstraint || c instanceof OverlapConstraint || c instanceof MultipleInBagConstraint)) {
            throw new ObjectStoreException("Unknown constraint type: " + c.getClass());
        }
    }

    protected static void buildFromComponent(State state, Query q, DatabaseSchema schema, Map<Object, String> bagTableNames) throws ObjectStoreException {
        for (FromElement fromElement : q.getFrom()) {
            if (fromElement instanceof QueryClass) {
                QueryClass qc = (QueryClass)fromElement;
                String baseAlias = DatabaseUtil.generateSqlCompatibleName(q.getAliases().get(qc));
                Set<Class<?>> classes = DynamicUtil.decomposeClass(qc.getType());
                ArrayList<ClassDescriptorAndAlias> aliases = new ArrayList<ClassDescriptorAndAlias>();
                int sequence = 0;
                String lastAlias = "";
                for (Class<?> cls : classes) {
                    ClassDescriptor cld = schema.getModel().getClassDescriptorByName(cls.getName());
                    if (cld == null) {
                        throw new ObjectStoreException(cls.toString() + " is not in the model");
                    }
                    ClassDescriptor tableMaster = schema.getTableMaster(cld);
                    if (sequence == 0) {
                        aliases.add(new ClassDescriptorAndAlias(cld, baseAlias));
                        state.addToFrom(DatabaseUtil.getTableName(tableMaster) + " AS " + baseAlias);
                        if (schema.isTruncated(tableMaster)) {
                            if (state.getWhereBuffer().length() > 0) {
                                state.addToWhere(" AND ");
                            }
                            state.addToWhere(baseAlias + ".tableclass = '" + cls.getName() + "'");
                        }
                    } else {
                        aliases.add(new ClassDescriptorAndAlias(cld, baseAlias + "_" + sequence));
                        state.addToFrom(DatabaseUtil.getTableName(tableMaster) + " AS " + baseAlias + "_" + sequence);
                        if (state.getWhereBuffer().length() > 0) {
                            state.addToWhere(" AND ");
                        }
                        state.addToWhere(baseAlias + lastAlias + ".id = " + baseAlias + "_" + sequence + ".id");
                        lastAlias = "_" + sequence;
                        if (schema.isTruncated(tableMaster)) {
                            state.addToWhere(" AND " + baseAlias + "_" + sequence + ".tableclass = '" + cls.getName() + "'");
                        }
                    }
                    ++sequence;
                }
                Map<String, FieldDescriptor> fields = schema.getModel().getFieldDescriptorsForClass(qc.getType());
                Map<String, String> fieldToAlias = state.getFieldToAlias(qc);
                Iterator<FieldDescriptor> fieldIter = null;
                if (schema.isFlatMode(qc.getType())) {
                    ArrayList<Iterator<Iterator<FieldDescriptor>>> iterators = new ArrayList<Iterator<Iterator<FieldDescriptor>>>();
                    ClassDescriptor cld = schema.getTableMaster(schema.getModel().getClassDescriptorsForClass(qc.getType()).iterator().next());
                    DatabaseSchema.Fields dbsFields = schema.getTableFields(schema.getTableMaster(cld));
                    iterators.add(dbsFields.getAttributes().iterator());
                    iterators.add(dbsFields.getReferences().iterator());
                    fieldIter = new CombinedIterator<FieldDescriptor>(iterators);
                } else {
                    fieldIter = fields.values().iterator();
                }
                block2: while (fieldIter.hasNext()) {
                    FieldDescriptor field = fieldIter.next();
                    String name = field.getName();
                    for (ClassDescriptorAndAlias aliasEntry : aliases) {
                        ClassDescriptor cld = aliasEntry.getClassDescriptor();
                        String alias = aliasEntry.getAlias();
                        if (!cld.getAllFieldDescriptors().contains(field) && !schema.isFlatMode(qc.getType())) continue;
                        fieldToAlias.put(name, alias + "." + DatabaseUtil.getColumnName(field));
                        continue block2;
                    }
                }
                if (schema.isMissingNotXml()) {
                    for (ClassDescriptorAndAlias aliasEntry : aliases) {
                        ClassDescriptor cld = aliasEntry.getClassDescriptor();
                        String alias = aliasEntry.getAlias();
                        ClassDescriptor tableMaster = schema.getTableMaster(cld);
                        if (!InterMineObject.class.equals(tableMaster.getType())) continue;
                        fieldToAlias.put("OBJECT", alias + ".OBJECT");
                        break;
                    }
                } else if (!schema.isFlatMode(qc.getType())) {
                    fieldToAlias.put("OBJECT", baseAlias + ".OBJECT");
                }
                fieldToAlias.put("class", baseAlias + ".class");
                continue;
            }
            if (fromElement instanceof Query) {
                state.addToFrom("(" + SqlGenerator.generate((Query)fromElement, schema, state.getDb(), null, 1, bagTableNames) + ") AS " + DatabaseUtil.generateSqlCompatibleName(q.getAliases().get(fromElement)));
                state.setFieldToAlias(fromElement, new AlwaysMap<String, String>(DatabaseUtil.generateSqlCompatibleName(q.getAliases().get(fromElement))));
                continue;
            }
            if (fromElement instanceof QueryClassBag) continue;
            throw new ObjectStoreException("Unknown FromElement: " + fromElement.getClass());
        }
    }

    protected static void buildWhereClause(State state, Query q, Constraint c, DatabaseSchema schema) throws ObjectStoreException {
        if (c != null) {
            if (SqlGenerator.completelyFalse(c)) {
                throw new CompletelyFalseException();
            }
            if (SqlGenerator.completelyTrue(c)) {
                return;
            }
            LinkedList<Constraint> constraints = new LinkedList<Constraint>();
            boolean needWhereComma = state.getWhereBuffer().length() > 0;
            boolean needHavingComma = state.getHavingBuffer().length() > 0;
            boolean usingHaving = !q.getGroupBy().isEmpty();
            constraints.add(c);
            while (!constraints.isEmpty()) {
                StringBuffer buffer;
                Constraint con = (Constraint)constraints.removeFirst();
                if (con instanceof ConstraintSet && ((ConstraintSet)con).getOp().equals(ConstraintOp.AND)) {
                    constraints.addAll(0, ((ConstraintSet)con).getConstraints());
                    continue;
                }
                boolean[] whs = SqlGenerator.whereHavingSafe(con, q);
                if (whs[1] && usingHaving) {
                    buffer = state.getHavingBuffer();
                    if (needHavingComma) {
                        buffer.append(" AND ");
                    }
                    needHavingComma = true;
                    SqlGenerator.constraintToString(state, buffer, con, q, schema, 1, true);
                    continue;
                }
                if (whs[0]) {
                    buffer = state.getWhereBuffer();
                    if (needWhereComma) {
                        buffer.append(" AND ");
                    }
                    needWhereComma = true;
                    SqlGenerator.constraintToString(state, buffer, con, q, schema, 1, true);
                    continue;
                }
                throw new ObjectStoreException("Constraint " + con + " mixes WHERE" + " and HAVING components");
            }
        }
    }

    protected static boolean[] whereHavingSafe(Object o, Query q) throws ObjectStoreException {
        if (o instanceof QueryField) {
            return new boolean[]{true, q.getGroupBy().contains(o) || q.getGroupBy().contains(((QueryField)o).getFromElement())};
        }
        if (o instanceof QueryClass) {
            return new boolean[]{true, q.getGroupBy().contains(o)};
        }
        if (o instanceof QueryValue) {
            return new boolean[]{true, true};
        }
        if (o instanceof QueryFunction) {
            return new boolean[]{false, true};
        }
        if (o instanceof QueryCast) {
            return SqlGenerator.whereHavingSafe(((QueryCast)o).getValue(), q);
        }
        if (o instanceof QueryExpression) {
            QueryExpression qe = (QueryExpression)o;
            QueryEvaluable arg1 = qe.getArg1();
            QueryEvaluable arg2 = qe.getArg2();
            QueryEvaluable queryEvaluable = qe.getArg3();
            boolean[] s = SqlGenerator.whereHavingSafe(arg1, q);
            boolean whereSafe = s[0];
            boolean havingSafe = s[1];
            if (arg2 != null) {
                s = SqlGenerator.whereHavingSafe(arg2, q);
                whereSafe = whereSafe && s[0];
                boolean bl = havingSafe = havingSafe && s[1];
            }
            if (queryEvaluable != null) {
                s = SqlGenerator.whereHavingSafe(queryEvaluable, q);
                whereSafe = whereSafe && s[0];
                havingSafe = havingSafe && s[1];
            }
            return new boolean[]{whereSafe, havingSafe};
        }
        if (o instanceof QueryForeignKey) {
            return new boolean[]{true, q.getGroupBy().contains(o) || q.getGroupBy().contains(((QueryForeignKey)o).getQueryClass())};
        }
        if (o instanceof QueryReference) {
            QueryClass qc = ((QueryReference)o).getQueryClass();
            if (qc == null) {
                return new boolean[]{true, true};
            }
            return SqlGenerator.whereHavingSafe(qc, q);
        }
        if (o instanceof SimpleConstraint) {
            SimpleConstraint c = (SimpleConstraint)o;
            QueryEvaluable arg1 = c.getArg1();
            QueryEvaluable arg2 = c.getArg2();
            if (arg2 == null) {
                return SqlGenerator.whereHavingSafe(arg1, q);
            }
            boolean[] blArray = SqlGenerator.whereHavingSafe(arg1, q);
            boolean[] s2 = SqlGenerator.whereHavingSafe(arg2, q);
            return new boolean[]{blArray[0] && s2[0], blArray[1] && s2[1]};
        }
        if (o instanceof ConstraintSet) {
            boolean whereSafe = true;
            boolean havingSafe = true;
            for (Constraint constraint : ((ConstraintSet)o).getConstraints()) {
                boolean[] s = SqlGenerator.whereHavingSafe(constraint, q);
                whereSafe = whereSafe && s[0];
                havingSafe = havingSafe && s[1];
            }
            return new boolean[]{whereSafe, havingSafe};
        }
        if (o instanceof BagConstraint) {
            return SqlGenerator.whereHavingSafe(((BagConstraint)o).getQueryNode(), q);
        }
        if (o instanceof MultipleInBagConstraint) {
            boolean whereSafe = true;
            boolean havingSafe = true;
            for (QueryEvaluable queryEvaluable : ((MultipleInBagConstraint)o).getEvaluables()) {
                boolean[] s = SqlGenerator.whereHavingSafe(queryEvaluable, q);
                whereSafe = whereSafe && s[0];
                havingSafe = havingSafe && s[1];
            }
            return new boolean[]{whereSafe, havingSafe};
        }
        if (o instanceof ClassConstraint) {
            ClassConstraint cc = (ClassConstraint)o;
            QueryClass arg1 = cc.getArg1();
            QueryClass arg2 = cc.getArg2QueryClass();
            boolean[] blArray = SqlGenerator.whereHavingSafe(arg1, q);
            boolean whereSafe = blArray[0];
            boolean havingSafe = blArray[1];
            if (arg2 != null) {
                boolean[] blArray2 = SqlGenerator.whereHavingSafe(arg2, q);
                whereSafe = whereSafe && blArray2[0];
                havingSafe = havingSafe && blArray2[1];
            }
            return new boolean[]{whereSafe, havingSafe};
        }
        if (o instanceof ContainsConstraint) {
            ContainsConstraint c = (ContainsConstraint)o;
            QueryReference arg1 = c.getReference();
            QueryClass arg2 = c.getQueryClass();
            boolean[] blArray = SqlGenerator.whereHavingSafe(arg1, q);
            boolean whereSafe = blArray[0];
            boolean havingSafe = blArray[1];
            if (arg2 != null) {
                boolean[] blArray3 = SqlGenerator.whereHavingSafe(arg2, q);
                whereSafe = whereSafe && blArray3[0];
                havingSafe = havingSafe && blArray3[1];
            }
            return new boolean[]{whereSafe, havingSafe};
        }
        if (o instanceof SubqueryConstraint) {
            QueryClass qc = ((SubqueryConstraint)o).getQueryClass();
            QueryEvaluable qe = ((SubqueryConstraint)o).getQueryEvaluable();
            if (qc != null) {
                return SqlGenerator.whereHavingSafe(qc, q);
            }
            return SqlGenerator.whereHavingSafe(qe, q);
        }
        if (o instanceof SubqueryExistsConstraint) {
            return new boolean[]{true, true};
        }
        if (o instanceof OverlapConstraint) {
            OverlapConstraint oc = (OverlapConstraint)o;
            boolean[] s1 = SqlGenerator.whereHavingSafe(oc.getLeft().getStart(), q);
            boolean[] s2 = SqlGenerator.whereHavingSafe(oc.getLeft().getEnd(), q);
            boolean[] blArray = SqlGenerator.whereHavingSafe(oc.getLeft().getParent(), q);
            boolean[] s4 = SqlGenerator.whereHavingSafe(oc.getRight().getStart(), q);
            boolean[] s5 = SqlGenerator.whereHavingSafe(oc.getRight().getEnd(), q);
            boolean[] s6 = SqlGenerator.whereHavingSafe(oc.getRight().getParent(), q);
            return new boolean[]{s1[0] && s2[0] && blArray[0] && s4[0] && s5[0] && s6[0], s1[1], s2[1], blArray[1], s4[1], s5[1], s6[1]};
        }
        throw new ObjectStoreException("Unrecognised object " + o);
    }

    protected static boolean completelyTrue(Constraint con) throws ObjectStoreException {
        BagConstraint bc;
        if (con instanceof ConstraintSet) {
            ConstraintSet cs = (ConstraintSet)con;
            if (cs.getOp() == ConstraintOp.AND) {
                boolean retval = true;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && retval) {
                    Constraint c = csIter.next();
                    retval = retval && SqlGenerator.completelyTrue(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.OR) {
                boolean retval = false;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && !retval) {
                    Constraint c = csIter.next();
                    retval = retval || SqlGenerator.completelyTrue(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.NOR) {
                boolean retval = true;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && retval) {
                    Constraint c = csIter.next();
                    retval = retval && SqlGenerator.completelyFalse(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.NAND) {
                boolean retval = false;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && retval) {
                    Constraint c = csIter.next();
                    retval = retval || SqlGenerator.completelyFalse(c);
                }
                return retval;
            }
            throw new IllegalArgumentException("Invalid operation " + cs.getOp());
        }
        if (con instanceof BagConstraint && (bc = (BagConstraint)con).getBag() != null && bc.getOp() == ConstraintOp.NOT_IN) {
            boolean empty = true;
            Class<?> type = bc.getQueryNode().getType();
            for (Object bagItem : bc.getBag()) {
                if (!ProxyReference.class.equals(bagItem.getClass()) && !DynamicUtil.isInstance(bagItem, type)) {
                    throw new ObjectStoreException("Bag<" + DynamicUtil.getFriendlyName(type) + "> contains element of wrong type (" + DynamicUtil.getFriendlyName(bagItem.getClass()) + ")");
                }
                empty = false;
            }
            return empty;
        }
        return false;
    }

    protected static boolean completelyFalse(Constraint con) throws ObjectStoreException {
        BagConstraint bc;
        if (con instanceof ConstraintSet) {
            ConstraintSet cs = (ConstraintSet)con;
            if (cs.getOp() == ConstraintOp.AND) {
                boolean retval = false;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && !retval) {
                    Constraint c = csIter.next();
                    retval = retval || SqlGenerator.completelyFalse(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.OR) {
                boolean retval = true;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && retval) {
                    Constraint c = csIter.next();
                    retval = retval && SqlGenerator.completelyFalse(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.NOR) {
                boolean retval = false;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && !retval) {
                    Constraint c = csIter.next();
                    retval = retval || SqlGenerator.completelyTrue(c);
                }
                return retval;
            }
            if (cs.getOp() == ConstraintOp.NAND) {
                boolean retval = true;
                Iterator<Constraint> csIter = cs.getConstraints().iterator();
                while (csIter.hasNext() && retval) {
                    Constraint c = csIter.next();
                    retval = retval && SqlGenerator.completelyTrue(c);
                }
                return retval;
            }
            throw new IllegalArgumentException("Invalid operation " + cs.getOp());
        }
        if (con instanceof BagConstraint && (bc = (BagConstraint)con).getBag() != null && bc.getOp() == ConstraintOp.IN) {
            boolean empty = true;
            Class<?> type = bc.getQueryNode().getType();
            for (Object bagItem : bc.getBag()) {
                if (!ProxyReference.class.equals(bagItem.getClass()) && !DynamicUtil.isInstance(bagItem, type)) {
                    throw new ObjectStoreException("Bag<" + DynamicUtil.getFriendlyName(type) + "> contains element of wrong type (" + DynamicUtil.getFriendlyName(bagItem.getClass()) + ")");
                }
                empty = false;
            }
            return empty;
        }
        return false;
    }

    protected static void constraintToString(State state, StringBuffer buffer, Constraint c, Query q, DatabaseSchema schema, int safeness, boolean loseBrackets) throws ObjectStoreException {
        if (safeness != 1 && safeness != -1 && safeness != 0) {
            throw new ObjectStoreException("Unknown ContainsConstraint safeness: " + safeness);
        }
        if (c instanceof ConstraintSet) {
            SqlGenerator.constraintSetToString(state, buffer, (ConstraintSet)c, q, schema, safeness, loseBrackets);
        } else if (c instanceof SimpleConstraint) {
            SqlGenerator.simpleConstraintToString(state, buffer, (SimpleConstraint)c, q);
        } else if (c instanceof SubqueryConstraint) {
            SqlGenerator.subqueryConstraintToString(state, buffer, (SubqueryConstraint)c, q, schema);
        } else if (c instanceof SubqueryExistsConstraint) {
            SqlGenerator.subqueryExistsConstraintToString(state, buffer, (SubqueryExistsConstraint)c, schema);
        } else if (c instanceof ClassConstraint) {
            SqlGenerator.classConstraintToString(state, buffer, (ClassConstraint)c, q, schema);
        } else if (c instanceof ContainsConstraint) {
            SqlGenerator.containsConstraintToString(state, buffer, (ContainsConstraint)c, q, schema, safeness, loseBrackets);
        } else if (c instanceof BagConstraint) {
            SqlGenerator.bagConstraintToString(state, buffer, (BagConstraint)c, q, schema, safeness);
        } else if (c instanceof MultipleInBagConstraint) {
            SqlGenerator.multipleInBagConstraintToString(state, buffer, (MultipleInBagConstraint)c, q, safeness);
        } else if (c instanceof OverlapConstraint) {
            SqlGenerator.overlapConstraintToString(state, buffer, (OverlapConstraint)c, q, schema, safeness);
        } else {
            throw new ObjectStoreException("Unknown constraint type: " + c);
        }
    }

    protected static void constraintSetToString(State state, StringBuffer buffer, ConstraintSet c, Query q, DatabaseSchema schema, int safeness, boolean loseBrackets) throws ObjectStoreException {
        boolean andOrNor;
        if (safeness != 1 && safeness != -1 && safeness != 0) {
            throw new ObjectStoreException("Unknown ContainsConstraint safeness: " + safeness);
        }
        ConstraintOp op = c.getOp();
        boolean negate = op == ConstraintOp.NAND || op == ConstraintOp.NOR;
        boolean disjunctive = op == ConstraintOp.OR || op == ConstraintOp.NOR;
        boolean bl = andOrNor = op == ConstraintOp.AND || op == ConstraintOp.NOR;
        int newSafeness = safeness == 0 ? 0 : (c.getConstraints().size() == 1 ? (negate ? -safeness : safeness) : (safeness == (andOrNor ? 1 : -1) ? (negate ? -safeness : safeness) : 0));
        if (c.getConstraints().isEmpty()) {
            buffer.append((disjunctive ? negate : !negate) ? "true" : "false");
        } else {
            buffer.append(negate ? "(NOT (" : (loseBrackets && !disjunctive ? "" : "("));
            boolean needComma = false;
            HashMap<String, StringBuffer> subqueryConstraints = new HashMap<String, StringBuffer>();
            for (Constraint constraint : c.getConstraints()) {
                if (disjunctive && constraint instanceof SubqueryConstraint) {
                    SubqueryConstraint subQC = (SubqueryConstraint)constraint;
                    Query subQCQuery = subQC.getQuery();
                    QueryEvaluable subQCEval = subQC.getQueryEvaluable();
                    QueryClass subQCClass = subQC.getQueryClass();
                    StringBuffer left = new StringBuffer();
                    if (subQCEval != null) {
                        SqlGenerator.queryEvaluableToString(left, subQCEval, q, state);
                    } else {
                        SqlGenerator.queryClassToString(left, subQCClass, q, schema, 2, state);
                    }
                    left.append(" " + subQC.getOp().toString() + " (");
                    StringBuffer existing = (StringBuffer)subqueryConstraints.get(left.toString());
                    if (existing == null) {
                        existing = new StringBuffer();
                        subqueryConstraints.put(left.toString(), existing);
                    } else {
                        existing.append(" UNION ");
                    }
                    existing.append(SqlGenerator.generate(subQCQuery, schema, state.getDb(), null, 2, state.getBagTableNames()));
                    continue;
                }
                if (disjunctive && SqlGenerator.completelyFalse(constraint) || !disjunctive && SqlGenerator.completelyTrue(constraint)) continue;
                if (needComma) {
                    buffer.append(disjunctive ? " OR " : " AND ");
                }
                needComma = true;
                SqlGenerator.constraintToString(state, buffer, constraint, q, schema, newSafeness, !negate && !disjunctive);
            }
            for (Map.Entry entry : subqueryConstraints.entrySet()) {
                String left = (String)entry.getKey();
                String right = ((StringBuffer)entry.getValue()).toString();
                if (needComma) {
                    buffer.append(" OR ");
                }
                needComma = true;
                buffer.append(left);
                buffer.append(right);
                buffer.append(")");
            }
            buffer.append(negate ? "))" : (loseBrackets && !disjunctive ? "" : ")"));
        }
    }

    protected static void simpleConstraintToString(State state, StringBuffer buffer, SimpleConstraint c, Query q) throws ObjectStoreException {
        SqlGenerator.queryEvaluableToString(buffer, c.getArg1(), q, state);
        buffer.append(" " + c.getOp().toString());
        if (c.getArg2() != null) {
            buffer.append(" ");
            SqlGenerator.queryEvaluableToString(buffer, c.getArg2(), q, state);
        }
    }

    protected static void subqueryConstraintToString(State state, StringBuffer buffer, SubqueryConstraint c, Query q, DatabaseSchema schema) throws ObjectStoreException {
        Query subQ = c.getQuery();
        QueryEvaluable qe = c.getQueryEvaluable();
        QueryClass cls = c.getQueryClass();
        if (qe != null) {
            SqlGenerator.queryEvaluableToString(buffer, qe, q, state);
        } else {
            SqlGenerator.queryClassToString(buffer, cls, q, schema, 2, state);
        }
        buffer.append(" " + c.getOp().toString() + " (" + SqlGenerator.generate(subQ, schema, state.getDb(), null, 2, state.getBagTableNames()) + ")");
    }

    protected static void subqueryExistsConstraintToString(State state, StringBuffer buffer, SubqueryExistsConstraint c, DatabaseSchema schema) throws ObjectStoreException {
        Query subQ = c.getQuery();
        buffer.append((c.getOp() == ConstraintOp.EXISTS ? "EXISTS(" : "(NOT EXISTS(") + SqlGenerator.generate(subQ, schema, state.getDb(), null, 5, state.getBagTableNames()) + (c.getOp() == ConstraintOp.EXISTS ? ")" : "))"));
    }

    protected static void classConstraintToString(State state, StringBuffer buffer, ClassConstraint c, Query q, DatabaseSchema schema) throws ObjectStoreException {
        QueryClass arg1 = c.getArg1();
        QueryClass arg2QC = c.getArg2QueryClass();
        InterMineObject arg2O = c.getArg2Object();
        SqlGenerator.queryClassToString(buffer, arg1, q, schema, 2, state);
        buffer.append(" " + c.getOp().toString() + " ");
        if (arg2QC != null) {
            SqlGenerator.queryClassToString(buffer, arg2QC, q, schema, 2, state);
        } else if (arg2O.getId() != null) {
            SqlGenerator.objectToString(buffer, arg2O);
        } else {
            throw new ObjectStoreException("ClassConstraint cannot contain an InterMineObject without an ID set");
        }
    }

    protected static void containsConstraintToString(State state, StringBuffer buffer, ContainsConstraint c, Query q, DatabaseSchema schema, int safeness, boolean loseBrackets) throws ObjectStoreException {
        if (safeness != 1 && safeness != -1 && safeness != 0) {
            throw new ObjectStoreException("Unknown ContainsConstraint safeness: " + safeness);
        }
        QueryReference arg1 = c.getReference();
        QueryClass arg2 = c.getQueryClass();
        InterMineObject arg2Obj = c.getObject();
        Map<String, FieldDescriptor> fieldNameToFieldDescriptor = schema.getModel().getFieldDescriptorsForClass(arg1.getQcType());
        ReferenceDescriptor arg1Desc = (ReferenceDescriptor)fieldNameToFieldDescriptor.get(arg1.getFieldName());
        if (arg1Desc == null) {
            throw new ObjectStoreException("Reference " + IqlQuery.queryReferenceToString(q, arg1, new ArrayList<Object>()) + "." + arg1.getFieldName() + " is not in the model - fields available in " + arg1.getQcType() + " are " + fieldNameToFieldDescriptor.keySet());
        }
        if (arg1 instanceof QueryObjectReference) {
            String arg1Alias = state.getFieldToAlias(arg1.getQueryClass()).get(arg1Desc.getName());
            if (c.getOp().equals(ConstraintOp.IS_NULL) || c.getOp().equals(ConstraintOp.IS_NOT_NULL)) {
                buffer.append(arg1Alias + " " + c.getOp().toString());
            } else {
                buffer.append(arg1Alias + (c.getOp() == ConstraintOp.CONTAINS ? " = " : " != "));
                if (arg2 == null) {
                    SqlGenerator.objectToString(buffer, arg2Obj);
                } else {
                    SqlGenerator.queryClassToString(buffer, arg2, q, schema, 2, state);
                }
            }
        } else if (arg1 instanceof QueryCollectionReference) {
            InterMineObject arg1Obj = ((QueryCollectionReference)arg1).getQcObject();
            QueryClass arg1Qc = arg1.getQueryClass();
            QueryClassBag arg1Qcb = ((QueryCollectionReference)arg1).getQcb();
            if (arg1Qcb != null && safeness != (c.getOp().equals(ConstraintOp.CONTAINS) ? 1 : -1)) {
                throw new ObjectStoreException(safeness == 0 ? "Invalid constraint: QueryClassBag ContainsConstraint cannot be inside an OR ConstraintSet" : "Invalid constraint: DOES NOT CONTAINS cannot be applied to a QueryClassBag");
            }
            if (arg1Desc.relationType() == 2) {
                if (arg2 == null) {
                    ReferenceDescriptor reverse = arg1Desc.getReverseReferenceDescriptor();
                    String indirectTableAlias = state.getIndirectAlias();
                    String arg2Alias = indirectTableAlias + "." + DatabaseUtil.getColumnName(reverse);
                    ClassDescriptor tableMaster = schema.getTableMaster(reverse.getClassDescriptor());
                    state.addToFrom(DatabaseUtil.getTableName(tableMaster) + " AS " + indirectTableAlias);
                    buffer.append(loseBrackets ? "" : "(");
                    if (schema.isTruncated(tableMaster)) {
                        buffer.append(indirectTableAlias + ".tableclass = '" + reverse.getClassDescriptor().getType().getName() + "' AND ");
                    }
                    if (arg1Qc != null) {
                        SqlGenerator.queryClassToString(buffer, arg1Qc, q, schema, 2, state);
                        buffer.append((c.getOp() == ConstraintOp.CONTAINS ? " = " : " != ") + arg2Alias + " AND ");
                    } else if (arg1Qcb != null) {
                        Map<String, String> fieldToAlias = state.getFieldToAlias(arg1Qcb);
                        if (fieldToAlias.containsKey("id")) {
                            buffer.append(arg2Alias + " = " + fieldToAlias.get("id") + " AND ");
                        } else {
                            fieldToAlias.put("id", arg2Alias);
                            if (arg1Qcb.getOsb() != null) {
                                SqlGenerator.bagConstraintToString(state, buffer, new BagConstraint((QueryNode)new QueryField(arg1Qcb), ConstraintOp.IN, arg1Qcb.getOsb()), q, schema, 0);
                                buffer.append(" AND ");
                            } else if (arg1Qcb.getIds() != null) {
                                BagConstraint bagCon = new BagConstraint((QueryNode)new QueryField(arg1Qcb), c.getOp() == ConstraintOp.CONTAINS ? ConstraintOp.IN : ConstraintOp.NOT_IN, arg1Qcb.getIds());
                                state.getBagTableNames().put(bagCon, state.getBagTableNames().get(arg1Qcb));
                                SqlGenerator.bagConstraintToString(state, buffer, bagCon, q, schema, safeness == 1 && c.getOp() == ConstraintOp.CONTAINS ? 1 : 0);
                                buffer.append(" AND ");
                            }
                        }
                    } else {
                        buffer.append(arg1Obj.getId() + (c.getOp() == ConstraintOp.CONTAINS ? " = " : " != ") + arg2Alias + " AND ");
                    }
                    buffer.append(indirectTableAlias + ".id = " + arg2Obj.getId());
                    buffer.append(loseBrackets ? "" : ")");
                } else {
                    String arg2Alias = state.getFieldToAlias(arg2).get(arg1Desc.getReverseReferenceDescriptor().getName());
                    if (arg1Qc != null) {
                        SqlGenerator.queryClassToString(buffer, arg1Qc, q, schema, 2, state);
                        buffer.append((c.getOp() == ConstraintOp.CONTAINS ? " = " : " != ") + arg2Alias);
                    } else if (arg1Qcb != null) {
                        Map<String, String> fieldToAlias = state.getFieldToAlias(arg1Qcb);
                        if (fieldToAlias.containsKey("id")) {
                            buffer.append(arg2Alias + " = " + fieldToAlias.get("id"));
                        } else {
                            fieldToAlias.put("id", arg2Alias);
                            if (arg1Qcb.getOsb() != null) {
                                SqlGenerator.bagConstraintToString(state, buffer, new BagConstraint((QueryNode)new QueryField(arg1Qcb), ConstraintOp.IN, arg1Qcb.getOsb()), q, schema, 0);
                            } else if (arg1Qcb.getIds() != null) {
                                BagConstraint bagCon = new BagConstraint((QueryNode)new QueryField(arg1Qcb), c.getOp() == ConstraintOp.CONTAINS ? ConstraintOp.IN : ConstraintOp.NOT_IN, arg1Qcb.getIds());
                                state.getBagTableNames().put(bagCon, state.getBagTableNames().get(arg1Qcb));
                                SqlGenerator.bagConstraintToString(state, buffer, bagCon, q, schema, safeness == 1 && c.getOp() == ConstraintOp.CONTAINS ? 1 : 0);
                            }
                        }
                    } else {
                        buffer.append("" + arg1Obj.getId() + (c.getOp() == ConstraintOp.CONTAINS ? " = " : " != ") + arg2Alias);
                    }
                }
            } else {
                if (safeness != (c.getOp().equals(ConstraintOp.CONTAINS) ? 1 : -1)) {
                    throw new ObjectStoreException(safeness == 0 ? "Cannot represent a many-to-many collection inside an OR ConstraintSet in SQL" : "Cannot represent many-to-many collection DOES NOT CONTAIN in SQL");
                }
                CollectionDescriptor arg1ColDesc = (CollectionDescriptor)arg1Desc;
                String indirectTableAlias = state.getIndirectAlias();
                String arg2Alias = indirectTableAlias + "." + DatabaseUtil.getInwardIndirectionColumnName(arg1ColDesc, schema.getVersion());
                state.addToFrom(DatabaseUtil.getIndirectionTableName(arg1ColDesc) + " AS " + indirectTableAlias);
                buffer.append(loseBrackets ? "" : "(");
                if (arg1Qc != null) {
                    SqlGenerator.queryClassToString(buffer, arg1Qc, q, schema, 2, state);
                    buffer.append(" = " + arg2Alias);
                    buffer.append(" AND ");
                } else if (arg1Qcb != null) {
                    Map<String, String> fieldToAlias = state.getFieldToAlias(arg1Qcb);
                    if (fieldToAlias.containsKey("id")) {
                        buffer.append(arg2Alias + " = " + fieldToAlias.get("id"));
                        buffer.append(" AND ");
                    } else {
                        fieldToAlias.put("id", arg2Alias);
                        if (arg1Qcb.getOsb() != null) {
                            SqlGenerator.bagConstraintToString(state, buffer, new BagConstraint((QueryNode)new QueryField(arg1Qcb), ConstraintOp.IN, arg1Qcb.getOsb()), q, schema, 0);
                            buffer.append(" AND ");
                        } else if (arg1Qcb.getIds() != null) {
                            BagConstraint bagCon = new BagConstraint((QueryNode)new QueryField(arg1Qcb), c.getOp() == ConstraintOp.CONTAINS ? ConstraintOp.IN : ConstraintOp.NOT_IN, arg1Qcb.getIds());
                            state.getBagTableNames().put(bagCon, state.getBagTableNames().get(arg1Qcb));
                            SqlGenerator.bagConstraintToString(state, buffer, bagCon, q, schema, safeness == 1 && c.getOp() == ConstraintOp.CONTAINS ? 1 : 0);
                            buffer.append(" AND ");
                        }
                    }
                } else {
                    buffer.append(arg1Obj.getId() + " = " + arg2Alias);
                    buffer.append(" AND ");
                }
                buffer.append(indirectTableAlias + "." + DatabaseUtil.getOutwardIndirectionColumnName(arg1ColDesc, schema.getVersion()) + " = ");
                if (arg2 == null) {
                    buffer.append("" + arg2Obj.getId());
                } else {
                    SqlGenerator.queryClassToString(buffer, arg2, q, schema, 2, state);
                }
                buffer.append(loseBrackets ? "" : ")");
            }
        }
    }

    protected static void bagConstraintToString(State state, StringBuffer buffer, BagConstraint c, Query q, DatabaseSchema schema, int safeness) throws ObjectStoreException {
        String leftHandSide;
        StringBuffer lhsBuffer;
        Class<?> type = c.getQueryNode().getType();
        if (c.getQueryNode() instanceof QueryEvaluable) {
            lhsBuffer = new StringBuffer();
            SqlGenerator.queryEvaluableToString(lhsBuffer, (QueryEvaluable)c.getQueryNode(), q, state);
            leftHandSide = lhsBuffer.toString();
        } else {
            lhsBuffer = new StringBuffer();
            SqlGenerator.queryClassToString(lhsBuffer, (QueryClass)c.getQueryNode(), q, schema, 2, state);
            leftHandSide = lhsBuffer.toString();
        }
        TreeSet<Object> filteredBag = new TreeSet<Object>();
        Collection<?> bagColl = c.getBag();
        if (bagColl == null) {
            ObjectStoreBag osb = c.getOsb();
            if (c.getOp() == ConstraintOp.IN) {
                buffer.append(leftHandSide);
            } else {
                buffer.append("(NOT (");
                buffer.append(leftHandSide);
            }
            if (safeness == 1 && c.getOp() == ConstraintOp.IN || safeness == -1 && c.getOp() == ConstraintOp.NOT_IN) {
                String indirectTableAlias = state.getIndirectAlias();
                state.addToFrom("osbag_int AS " + indirectTableAlias);
                buffer.append(" = " + indirectTableAlias + "." + "value");
                buffer.append(" AND " + indirectTableAlias + "." + "bagid" + " = " + osb.getBagId());
            } else {
                buffer.append(" IN (SELECT value FROM ");
                buffer.append("osbag_int");
                buffer.append(" WHERE bagid = " + osb.getBagId() + ")");
            }
            if (c.getOp() == ConstraintOp.NOT_IN) {
                buffer.append("))");
            }
        } else {
            for (Object bagItem : bagColl) {
                if (ProxyReference.class.equals(bagItem.getClass()) || DynamicUtil.isInstance(bagItem, type)) {
                    if (bagItem instanceof InterMineObject) {
                        Integer bagValue = ((InterMineObject)bagItem).getId();
                        filteredBag.add(bagValue);
                        continue;
                    }
                    if (bagItem instanceof Class) {
                        filteredBag.add(((Class)bagItem).getName());
                        continue;
                    }
                    filteredBag.add(bagItem);
                    continue;
                }
                throw new ObjectStoreException("Bag<" + type.getName() + "> contains element " + "of wrong type (" + bagItem.getClass().getName() + ")");
            }
            if (filteredBag.isEmpty()) {
                buffer.append(c.getOp() == ConstraintOp.IN ? "false" : "true");
            } else {
                String bagTableName = state.getBagTableNames().get(c);
                if (filteredBag.size() < 2 || bagTableName == null) {
                    int needComma = 0;
                    buffer.append(c.getOp() == ConstraintOp.IN ? "" : "(NOT (");
                    boolean limitRange = false;
                    boolean parenthesesForGroups = filteredBag.size() > 9000 && (c.getOp() == ConstraintOp.IN || limitRange);
                    for (Object e : filteredBag) {
                        if (needComma == 0) {
                            buffer.append((parenthesesForGroups ? "(" : "") + leftHandSide + " IN (");
                        } else if (needComma % 9000 == 0) {
                            buffer.append(") OR " + leftHandSide + " IN (");
                        } else {
                            buffer.append(", ");
                        }
                        ++needComma;
                        SqlGenerator.objectToString(buffer, e);
                    }
                    buffer.append(")");
                    if (parenthesesForGroups) {
                        buffer.append(")");
                    }
                    if (c.getOp() != ConstraintOp.IN) {
                        buffer.append("))");
                    }
                } else {
                    if (c.getOp() == ConstraintOp.IN) {
                        buffer.append(leftHandSide);
                    } else {
                        buffer.append("(NOT (");
                        buffer.append(leftHandSide);
                    }
                    if (safeness == 1 && c.getOp() == ConstraintOp.IN || safeness == -1 && c.getOp() == ConstraintOp.NOT_IN) {
                        String indirectTableAlias = state.getIndirectAlias();
                        state.addToFrom(bagTableName + " AS " + indirectTableAlias);
                        buffer.append(" = " + indirectTableAlias + ".value");
                    } else {
                        buffer.append(" IN (SELECT value FROM ");
                        buffer.append(bagTableName);
                        buffer.append(")");
                    }
                    if (c.getOp() == ConstraintOp.NOT_IN) {
                        buffer.append("))");
                    }
                }
            }
        }
    }

    protected static void multipleInBagConstraintToString(State state, StringBuffer buffer, MultipleInBagConstraint c, Query q, int safeness) throws ObjectStoreException {
        Class<?> type = null;
        for (QueryEvaluable queryEvaluable : c.getEvaluables()) {
            if (type == null) {
                type = queryEvaluable.getType();
                continue;
            }
            if (type.equals(queryEvaluable.getType())) continue;
            throw new IllegalArgumentException("MultipleInBagConstraint evaluables do not match type");
        }
        ArrayList<String> leftHandSide = new ArrayList<String>();
        for (QueryEvaluable queryEvaluable : c.getEvaluables()) {
            StringBuffer lhsBuffer = new StringBuffer();
            SqlGenerator.queryEvaluableToString(lhsBuffer, queryEvaluable, q, state);
            leftHandSide.add(lhsBuffer.toString());
        }
        TreeSet treeSet = new TreeSet();
        Collection<?> collection = c.getBag();
        for (Object bagItem : collection) {
            if (type.isInstance(bagItem)) {
                treeSet.add(bagItem);
                continue;
            }
            throw new ObjectStoreException("Bag<" + type.getName() + "> contains element " + "of wrong type (" + bagItem.getClass().getName() + ")");
        }
        if (treeSet.isEmpty()) {
            buffer.append("false");
        } else {
            String bagTableName = state.getBagTableNames().get(c);
            if (treeSet.size() < 2 || bagTableName == null) {
                buffer.append("(");
                boolean needOrComma = false;
                for (String lhs : leftHandSide) {
                    if (needOrComma) {
                        buffer.append(" OR ");
                    }
                    needOrComma = true;
                    int needComma = 0;
                    buffer.append(c.getOp() == ConstraintOp.IN ? "" : "(NOT (");
                    for (Object orNext : treeSet) {
                        if (needComma == 0) {
                            buffer.append(lhs + " IN (");
                        } else if (needComma % 9000 == 0) {
                            buffer.append(") OR " + lhs + " IN (");
                        } else {
                            buffer.append(", ");
                        }
                        ++needComma;
                        SqlGenerator.objectToString(buffer, orNext);
                    }
                    buffer.append(")");
                }
                buffer.append(")");
            } else if (safeness == 1) {
                String indirectTableAlias = state.getIndirectAlias();
                state.addToFrom(bagTableName + " AS " + indirectTableAlias);
                buffer.append("(");
                boolean needOrComma = false;
                for (String lhs : leftHandSide) {
                    if (needOrComma) {
                        buffer.append(" OR ");
                    }
                    needOrComma = true;
                    buffer.append(lhs + " = " + indirectTableAlias + ".value");
                }
                buffer.append(")");
            } else {
                buffer.append("(");
                boolean needOrComma = false;
                for (String lhs : leftHandSide) {
                    if (needOrComma) {
                        buffer.append(" OR ");
                    }
                    needOrComma = true;
                    buffer.append(lhs + " IN (SELECT value FROM " + bagTableName + ")");
                }
                buffer.append(")");
            }
        }
    }

    protected static void overlapConstraintToString(State state, StringBuffer buffer, OverlapConstraint c, Query q, DatabaseSchema schema, int safeness) throws ObjectStoreException {
        boolean not;
        if (safeness != 1 && safeness != -1 && safeness != 0) {
            throw new ObjectStoreException("Unknown constraint safeness: " + safeness);
        }
        boolean bl = not = ConstraintOp.DOES_NOT_CONTAIN == c.getOp() || ConstraintOp.NOT_IN == c.getOp() || ConstraintOp.DOES_NOT_OVERLAP == c.getOp();
        if (not) {
            buffer.append("(NOT (");
        } else if (safeness != 1) {
            buffer.append("(");
        }
        QueryObjectReference leftParent = c.getLeft().getParent();
        QueryObjectReference rightParent = c.getRight().getParent();
        buffer.append(state.getFieldToAlias(leftParent.getQueryClass()).get(leftParent.getFieldName())).append(" = ").append(state.getFieldToAlias(rightParent.getQueryClass()).get(rightParent.getFieldName())).append(" AND ");
        if (schema.hasBioSeg()) {
            buffer.append("bioseg_create(");
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getStart(), q, state);
            buffer.append(", ");
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getEnd(), q, state);
            buffer.append(") ");
            if (ConstraintOp.CONTAINS == c.getOp() || ConstraintOp.DOES_NOT_CONTAIN == c.getOp()) {
                buffer.append("@>");
            } else if (ConstraintOp.IN == c.getOp() || ConstraintOp.NOT_IN == c.getOp()) {
                buffer.append("<@");
            } else if (ConstraintOp.OVERLAPS == c.getOp() || ConstraintOp.DOES_NOT_OVERLAP == c.getOp()) {
                buffer.append("&&");
            } else {
                throw new IllegalArgumentException("Illegal constraint op " + c.getOp() + " for range");
            }
            buffer.append(" bioseg_create(");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getStart(), q, state);
            buffer.append(", ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getEnd(), q, state);
            buffer.append(")");
        } else if (ConstraintOp.CONTAINS == c.getOp() || ConstraintOp.DOES_NOT_CONTAIN == c.getOp()) {
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getStart(), q, state);
            buffer.append(" <= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getStart(), q, state);
            buffer.append(" AND ");
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getEnd(), q, state);
            buffer.append(" >= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getEnd(), q, state);
        } else if (ConstraintOp.IN == c.getOp() || ConstraintOp.NOT_IN == c.getOp()) {
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getStart(), q, state);
            buffer.append(" >= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getStart(), q, state);
            buffer.append(" AND ");
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getEnd(), q, state);
            buffer.append(" <= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getEnd(), q, state);
        } else if (ConstraintOp.OVERLAPS == c.getOp() || ConstraintOp.DOES_NOT_OVERLAP == c.getOp()) {
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getStart(), q, state);
            buffer.append(" <= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getEnd(), q, state);
            buffer.append(" AND ");
            SqlGenerator.queryEvaluableToString(buffer, c.getLeft().getEnd(), q, state);
            buffer.append(" >= ");
            SqlGenerator.queryEvaluableToString(buffer, c.getRight().getStart(), q, state);
        } else {
            throw new IllegalArgumentException("Illegal constraint op " + c.getOp() + " for range");
        }
        if (not) {
            buffer.append("))");
        } else if (safeness != 1) {
            buffer.append(")");
        }
    }

    public static void objectToString(StringBuffer buffer, Object value) throws ObjectStoreException {
        if (value instanceof UnknownTypeValue) {
            buffer.append(value.toString());
        } else if (value instanceof InterMineObject) {
            Integer id = ((InterMineObject)value).getId();
            if (id == null) {
                throw new ObjectStoreException("InterMineObject found without an ID set");
            }
            buffer.append(id.toString());
        } else if (value instanceof Date) {
            buffer.append(DatabaseUtil.objectToString(new Long(((Date)value).getTime())));
        } else {
            buffer.append(DatabaseUtil.objectToString(value));
        }
    }

    protected static void queryClassToString(StringBuffer buffer, QueryClass qc, Query q, DatabaseSchema schema, int kind, State state) throws ObjectStoreException {
        if (kind == 2 && !InterMineObject.class.isAssignableFrom(qc.getType())) {
            throw new ObjectStoreException("QueryClass for non-InterMineObject class does not have an ID");
        }
        String alias = q.getAliases().get(qc);
        Map<String, String> fieldToAlias = state.getFieldToAlias(qc);
        if (alias == null) {
            throw new NullPointerException("A QueryClass is referenced by elements of a query, but the QueryClass is not in the FROM list of that query. QueryClass: " + qc + ", aliases: " + q.getAliases());
        }
        if (kind == 5) {
            if (InterMineObject.class.isAssignableFrom(qc.getType())) {
                SqlGenerator.queryClassToString(buffer, qc, q, schema, 2, state);
            } else {
                SqlGenerator.queryClassToString(buffer, qc, q, schema, 3, state);
            }
        } else if (kind == 2) {
            buffer.append(DatabaseUtil.generateSqlCompatibleName(alias)).append(".id");
        } else {
            boolean needComma = false;
            String objectAlias = state.getFieldToAlias(qc).get("OBJECT");
            if (kind != 1 && objectAlias != null) {
                buffer.append(objectAlias);
                if (kind == 0 || kind == 4 || kind == 6) {
                    buffer.append(" AS ").append(alias.equals(alias.toLowerCase()) ? DatabaseUtil.generateSqlCompatibleName(alias) : "\"" + DatabaseUtil.generateSqlCompatibleName(alias) + "\"");
                }
                needComma = true;
            }
            if (kind == 1 || kind == 3 || (kind == 0 || kind == 6) && schema.isFlatMode(qc.getType()) || kind == 4) {
                Iterator<FieldDescriptor> fieldIter = null;
                ClassDescriptor cld = schema.getModel().getClassDescriptorByName(qc.getType().getName());
                if (schema.isFlatMode(qc.getType()) && (kind == 0 || kind == 6)) {
                    ArrayList<Iterator<Iterator<FieldDescriptor>>> iterators = new ArrayList<Iterator<Iterator<FieldDescriptor>>>();
                    DatabaseSchema.Fields fields = schema.getTableFields(schema.getTableMaster(cld));
                    iterators.add(fields.getAttributes().iterator());
                    iterators.add(fields.getReferences().iterator());
                    fieldIter = new CombinedIterator<FieldDescriptor>(iterators);
                } else {
                    fieldIter = cld.getAllFieldDescriptors().iterator();
                }
                TreeMap<String, FieldDescriptor> fieldMap = new TreeMap<String, FieldDescriptor>();
                while (fieldIter.hasNext()) {
                    FieldDescriptor field = fieldIter.next();
                    String columnName = DatabaseUtil.getColumnName(field);
                    if (columnName == null) continue;
                    fieldMap.put(columnName, field);
                }
                for (Map.Entry fieldEntry : fieldMap.entrySet()) {
                    FieldDescriptor field = (FieldDescriptor)fieldEntry.getValue();
                    String columnName = DatabaseUtil.getColumnName(field);
                    if (needComma) {
                        buffer.append(", ");
                    }
                    needComma = true;
                    buffer.append(fieldToAlias.get(field.getName()));
                    if (kind == 1) {
                        buffer.append(" AS ").append(DatabaseUtil.generateSqlCompatibleName(alias) + columnName);
                        continue;
                    }
                    if (kind != 0 && kind != 4 && kind != 6) continue;
                    buffer.append(" AS ").append(alias.equals(alias.toLowerCase()) ? DatabaseUtil.generateSqlCompatibleName(alias) + columnName : "\"" + DatabaseUtil.generateSqlCompatibleName(alias) + columnName.toLowerCase() + "\"");
                }
                if (schema.isFlatMode(qc.getType()) && schema.isTruncated(schema.getTableMaster(cld))) {
                    buffer.append(", ").append(fieldToAlias.get("class")).append(" AS ").append(alias.equals(alias.toLowerCase()) ? DatabaseUtil.generateSqlCompatibleName(alias) + "objectclass" : "\"" + DatabaseUtil.generateSqlCompatibleName(alias) + "objectclass\"");
                }
            } else {
                if (needComma) {
                    buffer.append(", ");
                }
                buffer.append(DatabaseUtil.generateSqlCompatibleName(alias)).append(".id AS ").append(alias.equals(alias.toLowerCase()) ? DatabaseUtil.generateSqlCompatibleName(alias) + "id" : "\"" + DatabaseUtil.generateSqlCompatibleName(alias) + "id" + "\"");
            }
        }
    }

    protected static void queryEvaluableToString(StringBuffer buffer, QueryEvaluable node, Query q, State state) throws ObjectStoreException {
        if (node instanceof QueryField) {
            QueryField nodeF = (QueryField)node;
            FromElement nodeClass = nodeF.getFromElement();
            if (state != null) {
                Map<String, String> aliasMap = state.getFieldToAlias(nodeClass);
                String classAlias = aliasMap.get(nodeF.getFieldName());
                buffer.append(classAlias);
                if (aliasMap instanceof AlwaysMap) {
                    buffer.append(".").append(DatabaseUtil.generateSqlCompatibleName(nodeF.getFieldName())).append(nodeF.getSecondFieldName() == null ? "" : DatabaseUtil.generateSqlCompatibleName(nodeF.getSecondFieldName()));
                }
            } else {
                buffer.append(DatabaseUtil.generateSqlCompatibleName(nodeF.getFieldName()));
            }
        } else if (node instanceof QueryExpression) {
            QueryExpression nodeE = (QueryExpression)node;
            if (nodeE.getOperation() == 4) {
                QueryEvaluable arg1 = nodeE.getArg1();
                QueryEvaluable arg2 = nodeE.getArg2();
                QueryEvaluable arg3 = nodeE.getArg3();
                buffer.append("SUBSTR(");
                SqlGenerator.queryEvaluableToString(buffer, arg1, q, state);
                buffer.append(", ");
                SqlGenerator.queryEvaluableToString(buffer, arg2, q, state);
                if (arg3 != null) {
                    buffer.append(", ");
                    SqlGenerator.queryEvaluableToString(buffer, arg3, q, state);
                }
                buffer.append(")");
            } else if (nodeE.getOperation() == 5) {
                QueryEvaluable arg1 = nodeE.getArg1();
                QueryEvaluable arg2 = nodeE.getArg2();
                buffer.append("STRPOS(");
                SqlGenerator.queryEvaluableToString(buffer, arg1, q, state);
                buffer.append(", ");
                SqlGenerator.queryEvaluableToString(buffer, arg2, q, state);
                buffer.append(")");
            } else if (nodeE.getOperation() == 6) {
                buffer.append("LOWER(");
                SqlGenerator.queryEvaluableToString(buffer, nodeE.getArg1(), q, state);
                buffer.append(")");
            } else if (nodeE.getOperation() == 7) {
                buffer.append("UPPER(");
                SqlGenerator.queryEvaluableToString(buffer, nodeE.getArg1(), q, state);
                buffer.append(")");
            } else {
                QueryEvaluable arg1 = nodeE.getArg1();
                QueryEvaluable arg2 = nodeE.getArg2();
                String op = null;
                switch (nodeE.getOperation()) {
                    case 0: {
                        op = " + ";
                        break;
                    }
                    case 1: {
                        op = " - ";
                        break;
                    }
                    case 2: {
                        op = " * ";
                        break;
                    }
                    case 3: {
                        op = " / ";
                        break;
                    }
                    default: {
                        throw new ObjectStoreException("Invalid QueryExpression operation: " + nodeE.getOperation());
                    }
                }
                buffer.append("(");
                SqlGenerator.queryEvaluableToString(buffer, arg1, q, state);
                buffer.append(op);
                SqlGenerator.queryEvaluableToString(buffer, arg2, q, state);
                buffer.append(")");
            }
        } else if (node instanceof QueryFunction) {
            QueryFunction nodeF = (QueryFunction)node;
            switch (nodeF.getOperation()) {
                case 4: {
                    buffer.append("COUNT(*)");
                    break;
                }
                case 0: {
                    buffer.append("SUM(");
                    SqlGenerator.queryEvaluableToString(buffer, nodeF.getParam(), q, state);
                    buffer.append(")");
                    break;
                }
                case 1: {
                    buffer.append("AVG(");
                    SqlGenerator.queryEvaluableToString(buffer, nodeF.getParam(), q, state);
                    buffer.append(")");
                    break;
                }
                case 2: {
                    buffer.append("MIN(");
                    SqlGenerator.queryEvaluableToString(buffer, nodeF.getParam(), q, state);
                    buffer.append(")");
                    break;
                }
                case 3: {
                    buffer.append("MAX(");
                    SqlGenerator.queryEvaluableToString(buffer, nodeF.getParam(), q, state);
                    buffer.append(")");
                    break;
                }
                case 5: {
                    buffer.append("STDDEV(");
                    SqlGenerator.queryEvaluableToString(buffer, nodeF.getParam(), q, state);
                    buffer.append(")");
                    break;
                }
                default: {
                    throw new ObjectStoreException("Invalid QueryFunction operation: " + nodeF.getOperation());
                }
            }
        } else if (node instanceof QueryValue) {
            QueryValue nodeV = (QueryValue)node;
            Object value = nodeV.getValue();
            SqlGenerator.objectToString(buffer, value);
        } else if (node instanceof QueryCast) {
            buffer.append("(");
            SqlGenerator.queryEvaluableToString(buffer, ((QueryCast)node).getValue(), q, state);
            buffer.append(")::");
            String torqueTypeName = TorqueModelOutput.generateJdbcType(node.getType().getName());
            SchemaType torqueType = SchemaType.getEnum((String)torqueTypeName);
            Platform torquePlatform = PlatformFactory.getPlatformFor((String)state.getDb().getPlatform().toLowerCase());
            Domain torqueDomain = torquePlatform.getDomainForSchemaType(torqueType);
            buffer.append(torqueDomain.getSqlType());
        } else if (node instanceof QueryForeignKey) {
            QueryForeignKey qor = (QueryForeignKey)node;
            buffer.append(state.getFieldToAlias(qor.getQueryClass()).get(qor.getFieldName()));
        } else {
            throw new ObjectStoreException("Invalid QueryEvaluable: " + node);
        }
    }

    protected static String buildSelectComponent(State state, Query q, DatabaseSchema schema, int kind) throws ObjectStoreException {
        boolean needComma = false;
        StringBuffer retval = new StringBuffer();
        Iterator<QuerySelectable> iter = q.getSelect().iterator();
        if (!iter.hasNext()) {
            throw new ObjectStoreException("SELECT list is empty in Query");
        }
        while (iter.hasNext()) {
            QuerySelectable node = iter.next();
            String alias = q.getAliases().get(node);
            if (node instanceof QueryClass) {
                if (needComma) {
                    retval.append(", ");
                }
                needComma = true;
                SqlGenerator.queryClassToString(retval, (QueryClass)node, q, schema, kind, state);
                continue;
            }
            if (node instanceof QueryEvaluable) {
                if (needComma) {
                    retval.append(", ");
                }
                needComma = true;
                SqlGenerator.queryEvaluableToString(retval, (QueryEvaluable)node, q, state);
                if (kind == 0 || kind == 4 || kind == 6) {
                    retval.append(" AS " + (alias.equals(alias.toLowerCase()) ? DatabaseUtil.generateSqlCompatibleName(alias) : "\"" + DatabaseUtil.generateSqlCompatibleName(alias) + "\""));
                    continue;
                }
                if (kind != 1) continue;
                retval.append(" AS " + DatabaseUtil.generateSqlCompatibleName(alias));
                continue;
            }
            if (node instanceof QueryPathExpression) continue;
            throw new ObjectStoreException("Unknown object in SELECT list: " + node.getClass());
        }
        for (Map.Entry<String, String> entry : state.getOrderBy().entrySet()) {
            if (needComma) {
                retval.append(", ");
            }
            needComma = true;
            retval.append(entry.getKey()).append(" AS ").append(entry.getValue());
        }
        return retval.toString();
    }

    protected static String buildGroupBy(Query q, DatabaseSchema schema, State state) throws ObjectStoreException {
        StringBuffer retval = new StringBuffer();
        boolean needComma = false;
        for (QueryNode node : q.getGroupBy()) {
            retval.append(needComma ? ", " : " GROUP BY ");
            needComma = true;
            if (node instanceof QueryClass) {
                SqlGenerator.queryClassToString(retval, (QueryClass)node, q, schema, 3, state);
                continue;
            }
            SqlGenerator.queryEvaluableToString(retval, (QueryEvaluable)node, q, state);
        }
        return retval.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static String buildOrderBy(State state, Query q, DatabaseSchema schema, int kind) throws ObjectStoreException {
        StringBuffer retval = new StringBuffer();
        HashSet<String> seen = new HashSet<String>();
        boolean needComma = false;
        Iterator<Object> i$ = q.getEffectiveOrderBy().iterator();
        while (true) {
            boolean desc;
            block18: {
                StringBuffer buffer;
                Object node;
                block21: {
                    block19: {
                        QueryObjectReference ref;
                        block20: {
                            block17: {
                                if (!i$.hasNext()) {
                                    return retval.toString();
                                }
                                node = i$.next();
                                desc = false;
                                if (node instanceof OrderDescending) {
                                    desc = true;
                                    node = ((OrderDescending)node).getQueryOrderable();
                                }
                                if (node instanceof QueryValue || node instanceof QueryPathExpression) continue;
                                buffer = new StringBuffer();
                                if (!(node instanceof QueryClass)) break block17;
                                if (TypeUtil.getFieldInfo(((QueryClass)node).getType(), "id") != null) {
                                    SqlGenerator.queryClassToString(buffer, (QueryClass)node, q, schema, 2, state);
                                } else {
                                    SqlGenerator.queryClassToString(buffer, (QueryClass)node, q, schema, 3, state);
                                }
                                if (seen.contains(buffer.toString())) break block18;
                                retval.append(needComma ? ", " : " ORDER BY ");
                                needComma = true;
                                retval.append(buffer.toString());
                                seen.add(buffer.toString());
                                if (!q.getSelect().contains(node) && !q.getSelect().contains(new QueryField((QueryClass)node, "id"))) {
                                    if (q.isDistinct()) {
                                        throw new ObjectStoreException("Class " + q.getAliases().get(node) + " in the ORDER BY list must be in the SELECT list, or its" + " id, or the query made non-distinct");
                                    }
                                    if (kind == 4 || kind == 6) {
                                        state.addToOrderBy(buffer.toString());
                                    }
                                }
                                break block18;
                            }
                            if (!(node instanceof QueryObjectReference)) break block19;
                            ref = (QueryObjectReference)node;
                            buffer.append(state.getFieldToAlias(ref.getQueryClass()).get(ref.getFieldName()));
                            if (seen.contains(buffer.toString())) break block18;
                            retval.append(needComma ? ", " : " ORDER BY ");
                            needComma = true;
                            retval.append(buffer.toString());
                            seen.add(buffer.toString());
                            if (!q.isDistinct()) break block20;
                            if (!q.getSelect().contains(ref)) {
                                if (!q.getSelect().contains(ref.getQueryClass())) {
                                    throw new ObjectStoreException("Reference " + buffer.toString() + " in the ORDER BY list must be in the SELECT list, or the" + " whole QueryClass must be in the SELECT list, or the" + " query made non-distinct");
                                }
                                if (!schema.isFlatMode(ref.getQueryClass().getType())) {
                                    state.addToOrderBy(buffer.toString());
                                }
                            }
                            break block18;
                        }
                        if (!(q.getSelect().contains(ref) || kind != 4 && kind != 6 || schema.isFlatMode(ref.getQueryClass().getType()))) {
                            state.addToOrderBy(buffer.toString());
                        }
                        break block18;
                    }
                    SqlGenerator.queryEvaluableToString(buffer, (QueryEvaluable)node, q, state);
                    if (seen.contains(buffer.toString())) break block18;
                    retval.append(needComma ? ", " : " ORDER BY ");
                    needComma = true;
                    retval.append(buffer.toString());
                    seen.add(buffer.toString());
                    if (q.getSelect().contains(node) || !q.isDistinct() || !(node instanceof QueryField)) break block21;
                    FromElement fe = ((QueryField)node).getFromElement();
                    if (q.getSelect().contains(fe)) {
                        if (!schema.isFlatMode(InterMineObject.class)) {
                            state.addToOrderBy(buffer.toString());
                        }
                        break block18;
                    } else {
                        if (fe instanceof QueryClass) {
                            throw new ObjectStoreException("Field " + buffer.toString() + " in the ORDER BY list must be in the SELECT list, or the" + " whole QueryClass " + fe.toString() + " must be in the" + " SELECT list, or the query made non-distinct");
                        }
                        throw new ObjectStoreException("Field " + buffer.toString() + " in the ORDER BY list must be in the SELECT list, or the" + " query made non-distinct");
                    }
                }
                if (!(q.getSelect().contains(node) || q.isDistinct() || kind != 4 && kind != 6 || schema.isFlatMode(InterMineObject.class))) {
                    state.addToOrderBy(buffer.toString());
                }
            }
            if (!desc) continue;
            retval.append(" DESC");
        }
    }

    private static class ClassDescriptorAndAlias {
        private ClassDescriptor cld;
        private String alias;

        public ClassDescriptorAndAlias(ClassDescriptor cld, String alias) {
            this.cld = cld;
            this.alias = alias;
        }

        public ClassDescriptor getClassDescriptor() {
            return this.cld;
        }

        public String getAlias() {
            return this.alias;
        }
    }

    private static class CacheEntry {
        private TreeMap<Integer, String> cached = new TreeMap();
        private int lastOffset;
        private String lastSQL;

        public CacheEntry(int lastOffset, String lastSQL) {
            this.lastOffset = lastOffset;
            this.lastSQL = lastSQL;
        }

        public TreeMap<Integer, String> getCached() {
            return this.cached;
        }

        public void setLast(int lastOffset, String lastSQL) {
            this.lastOffset = lastOffset;
            this.lastSQL = lastSQL;
        }

        public int getLastOffset() {
            return this.lastOffset;
        }

        public String getLastSQL() {
            return this.lastSQL;
        }
    }

    protected static class State {
        private StringBuffer whereText = new StringBuffer();
        private StringBuffer havingText = new StringBuffer();
        private StringBuffer fromText = new StringBuffer();
        private Map<String, String> orderBy = new LinkedHashMap<String, String>();
        private int number = 0;
        private Map<FromElement, Map<String, String>> fromToFieldToAlias = new HashMap<FromElement, Map<String, String>>();
        private Database db;
        private Map<Object, String> bagTableNames = new HashMap<Object, String>();

        public String getWhere() {
            String where = this.whereText.toString();
            return where.length() == 0 ? "" : " WHERE " + where;
        }

        public StringBuffer getWhereBuffer() {
            return this.whereText;
        }

        public String getHaving() {
            String having = this.havingText.toString();
            return having.length() == 0 ? "" : " HAVING " + having;
        }

        public StringBuffer getHavingBuffer() {
            return this.havingText;
        }

        public String getFrom() {
            return this.fromText.toString();
        }

        public void addToWhere(String text) {
            this.whereText.append(text);
        }

        public void addToFrom(String text) {
            if (this.fromText.length() == 0) {
                this.fromText.append(" FROM ").append(text);
            } else {
                this.fromText.append(", ").append(text);
            }
        }

        public String getIndirectAlias() {
            return "indirect" + this.number++;
        }

        public String getOrderByAlias() {
            return "orderbyfield" + this.number++;
        }

        public void addToOrderBy(String s) {
            this.orderBy.put(s, this.getOrderByAlias());
        }

        public Map<String, String> getOrderBy() {
            return this.orderBy;
        }

        public Map<String, String> getFieldToAlias(FromElement from) {
            Map<String, String> retval = this.fromToFieldToAlias.get(from);
            if (retval == null) {
                retval = new HashMap<String, String>();
                this.fromToFieldToAlias.put(from, retval);
            }
            return retval;
        }

        public void setFieldToAlias(FromElement from, Map<String, String> map) {
            this.fromToFieldToAlias.put(from, map);
        }

        public void setBagTableNames(Map<Object, String> bagTableNames) {
            if (bagTableNames != null) {
                this.bagTableNames = bagTableNames;
            }
        }

        public Map<Object, String> getBagTableNames() {
            return this.bagTableNames;
        }

        public void setDb(Database db) {
            this.db = db;
        }

        public Database getDb() {
            return this.db;
        }
    }
}

