/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ExtraQueryTime;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.PathExpressionField;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryPathExpression;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.sql.DatabaseUtil;
import org.intermine.sql.precompute.OptimiserCache;
import org.intermine.sql.precompute.PrecomputedTable;
import org.intermine.util.DynamicUtil;

public final class ResultsConverter {
    private ResultsConverter() {
    }

    public static List<ResultsRow<Object>> convert(ResultSet sqlResults, Query q, ObjectStoreInterMineImpl os, Connection c, Map<Object, Integer> sequence, boolean optimise, ExtraQueryTime extra, Set<PrecomputedTable> goFasterTables, OptimiserCache goFasterCache) throws ObjectStoreException {
        Class<FastPathObject> currentColumn = null;
        HashSet<QuerySelectable> noObjectColumns = new HashSet<QuerySelectable>();
        HashSet<String> noObjectClassColumns = new HashSet<String>();
        boolean needPathExpressions = false;
        try {
            ArrayList<ResultsRow<Object>> retval = new ArrayList<ResultsRow<Object>>();
            HashSet<Integer> idsToFetch = new HashSet<Integer>();
            IdentityHashMap<QuerySelectable, String> aliases = new IdentityHashMap<QuerySelectable, String>();
            for (QuerySelectable node : q.getSelect()) {
                aliases.put(node, DatabaseUtil.generateSqlCompatibleName(q.getAliases().get(node)));
            }
            while (sqlResults.next()) {
                ResultsRow<Object> row = new ResultsRow<Object>();
                for (QuerySelectable querySelectable : q.getSelect()) {
                    String alias = (String)aliases.get(querySelectable);
                    if (querySelectable instanceof QueryClass) {
                        Object obj;
                        block38: {
                            Integer idField = null;
                            obj = null;
                            if (InterMineObject.class.isAssignableFrom(((QueryClass)querySelectable).getType())) {
                                idField = new Integer(sqlResults.getInt(alias + "id"));
                                obj = os.pilferObjectById(idField);
                            }
                            if (obj == null) {
                                String objectField = null;
                                if (noObjectColumns.contains(querySelectable)) {
                                    if (obj == null) {
                                        obj = new ProxyReference(os, idField, InterMineObject.class);
                                        idsToFetch.add(idField);
                                    }
                                } else if (os.getSchema().isFlatMode(((QueryClass)querySelectable).getType())) {
                                    obj = ResultsConverter.buildObject(sqlResults, alias, os, ((QueryClass)querySelectable).getType(), noObjectClassColumns);
                                    if (idField != null) {
                                        os.cacheObjectById(idField, (InterMineObject)obj);
                                    }
                                } else {
                                    try {
                                        objectField = sqlResults.getString(alias);
                                        if (objectField != null) {
                                            currentColumn = objectField;
                                            obj = NotXmlParser.parse(objectField, os);
                                            os.cacheObjectById(((InterMineObject)obj).getId(), (InterMineObject)obj);
                                        }
                                    }
                                    catch (SQLException e) {
                                        noObjectColumns.add(querySelectable);
                                        if (obj != null) break block38;
                                        obj = new ProxyReference(os, idField, InterMineObject.class);
                                        idsToFetch.add(idField);
                                    }
                                }
                            }
                        }
                        row.add(obj);
                        continue;
                    }
                    if (querySelectable instanceof QueryPathExpression) {
                        row.add(null);
                        needPathExpressions = true;
                        continue;
                    }
                    currentColumn = sqlResults.getObject(alias);
                    if (Date.class.equals(querySelectable.getType())) {
                        currentColumn = new Date((Long)((Object)currentColumn));
                    } else if (Class.class.equals(querySelectable.getType())) {
                        HashSet classes = new HashSet();
                        try {
                            String[] b = ((String)((Object)currentColumn)).split(" ");
                            for (int i = 0; i < b.length; ++i) {
                                classes.add(Class.forName(b[i]));
                            }
                        }
                        catch (ClassNotFoundException e) {
                            SQLException e2 = new SQLException("Invalid entry in class column");
                            e2.initCause(e);
                            throw e2;
                        }
                        currentColumn = classes.size() == 1 ? classes.iterator().next() : DynamicUtil.composeClass(classes);
                    } else if (Short.class.equals(querySelectable.getType()) && currentColumn instanceof Integer) {
                        int i = (Integer)((Object)currentColumn);
                        currentColumn = new Short((short)i);
                    } else if (ClobAccess.class.equals(querySelectable.getType()) && currentColumn != null) {
                        currentColumn = ClobAccess.decodeDbDescription(os, (String)((Object)currentColumn));
                    }
                    row.add(currentColumn);
                }
                retval.add(row);
            }
            if (!idsToFetch.isEmpty()) {
                Map<Integer, InterMineObject> fetched = ResultsConverter.fetchByIds(os, c, sequence, InterMineObject.class, idsToFetch, extra);
                for (ResultsRow resultsRow : retval) {
                    for (int i = 0; i < resultsRow.size(); ++i) {
                        Object obj = resultsRow.get(i);
                        if (!(obj instanceof ProxyReference)) continue;
                        Integer id = ((ProxyReference)obj).getId();
                        if ((obj = fetched.get(id)) == null) {
                            throw new ObjectStoreException("Error - could not fetch object with ID of " + id + " for query " + q);
                        }
                        resultsRow.set(i, obj);
                    }
                }
            }
            if (needPathExpressions) {
                HashSet<QuerySelectable> done = new HashSet<QuerySelectable>();
                for (QuerySelectable querySelectable : q.getSelect()) {
                    if (querySelectable instanceof QueryObjectPathExpression) {
                        if (done.contains(querySelectable)) continue;
                        ResultsConverter.fetchObjectPathExpression(os, c, sequence, q, (QueryObjectPathExpression)querySelectable, retval, optimise, extra, goFasterTables, goFasterCache);
                        done.add(querySelectable);
                        continue;
                    }
                    if (querySelectable instanceof QueryCollectionPathExpression) {
                        ResultsConverter.fetchCollectionPathExpression(os, c, sequence, q, (QueryCollectionPathExpression)querySelectable, retval, optimise, extra, goFasterTables, goFasterCache);
                        continue;
                    }
                    if (!(querySelectable instanceof PathExpressionField) || done.contains(((PathExpressionField)querySelectable).getQope())) continue;
                    ResultsConverter.fetchObjectPathExpression(os, c, sequence, q, ((PathExpressionField)querySelectable).getQope(), retval, optimise, extra, goFasterTables, goFasterCache);
                    done.add(((PathExpressionField)querySelectable).getQope());
                }
            }
            return retval;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error converting results: " + currentColumn, e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectStoreException("Unknown class mentioned in database OBJECT field while converting results: " + currentColumn, e);
        }
        catch (ClassCastException e) {
            throw new ObjectStoreException("Object is of wrong type while converting results: " + currentColumn, e);
        }
    }

    protected static Object buildObject(ResultSet sqlResults, String alias, ObjectStoreInterMineImpl os, Class<?> type, Set<String> noObjectClassColumns) throws SQLException {
        Set<Class<?>> classes = Collections.singleton(type);
        if (!noObjectClassColumns.contains(alias)) {
            String objectClass = null;
            try {
                objectClass = sqlResults.getString(alias + "objectclass");
            }
            catch (SQLException e) {
                noObjectClassColumns.add(alias);
            }
            if (objectClass != null) {
                classes = new HashSet();
                try {
                    String[] b = objectClass.split(" ");
                    for (int i = 0; i < b.length; ++i) {
                        classes.add(Class.forName(b[i]));
                    }
                }
                catch (ClassNotFoundException e) {
                    SQLException e2 = new SQLException("Invalid entry in objectclass column");
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
        FastPathObject retval = DynamicUtil.createObject(classes);
        Map<String, FieldDescriptor> fields = os.getModel().getFieldDescriptorsForClass(retval.getClass());
        for (Map.Entry<String, FieldDescriptor> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            FieldDescriptor fd = entry.getValue();
            if (fd instanceof AttributeDescriptor) {
                Object value = sqlResults.getObject(alias + DatabaseUtil.getColumnName(fd));
                Class<?> expectedType = retval.getFieldType(fieldName);
                if (value instanceof Long && Date.class.equals(expectedType)) {
                    value = new Date((Long)value);
                } else if (value instanceof Integer && (Short.class.equals(expectedType) || Short.TYPE.equals(expectedType))) {
                    value = new Short((short)((Integer)value).intValue());
                }
                try {
                    retval.setFieldValue(fieldName, value);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (fd instanceof CollectionDescriptor) {
                CollectionDescriptor cd = (CollectionDescriptor)fd;
                ProxyCollection<? extends FastPathObject> lazyColl = new ProxyCollection<FastPathObject>(os, (InterMineObject)retval, cd.getName(), cd.getReferencedClassDescriptor().getType());
                retval.setFieldValue(cd.getName(), lazyColl);
                continue;
            }
            if (!(fd instanceof ReferenceDescriptor)) continue;
            ReferenceDescriptor rd = (ReferenceDescriptor)fd;
            Integer id = (Integer)sqlResults.getObject(alias + DatabaseUtil.getColumnName(fd));
            Class<? extends FastPathObject> refType = rd.getReferencedClassDescriptor().getType();
            if (id == null) {
                retval.setFieldValue(fieldName, null);
                continue;
            }
            retval.setFieldValue(fieldName, new ProxyReference(os, id, refType));
        }
        return retval;
    }

    protected static void fetchObjectPathExpression(ObjectStoreInterMineImpl os, Connection c, Map<Object, Integer> sequence, Query q, QueryObjectPathExpression qope, List<ResultsRow<Object>> retval, boolean optimise, ExtraQueryTime extra, Set<PrecomputedTable> goFasterTables, OptimiserCache goFasterCache) throws ObjectStoreException {
        HashMap<Integer, Integer> objectIds = new HashMap<Integer, Integer>();
        HashSet<Integer> idsToFetch = new HashSet<Integer>();
        QueryClass qc = qope.getQueryClass();
        int startingPoint = q.getSelect().indexOf(qc);
        if (startingPoint == -1) {
            throw new ObjectStoreException("Path Expression " + qope + " needs QueryClass " + qc + " to be in the SELECT list");
        }
        for (ResultsRow<Object> row : retval) {
            InterMineObject o = (InterMineObject)row.get(startingPoint);
            Integer refId = null;
            try {
                InterMineObject ref = (InterMineObject)o.getFieldProxy(qope.getFieldName());
                if (ref == null) continue;
                refId = ref.getId();
                idsToFetch.add(refId);
                objectIds.put(o.getId(), refId);
            }
            catch (Exception e) {
                throw new ObjectStoreException("Shouldn't ever happen", e);
            }
        }
        Query qopeQuery = qope.getQuery(idsToFetch, os.getSchema().isMissingNotXml());
        long startTime = System.currentTimeMillis();
        List<ResultsRow<Object>> res = os.executeWithConnection(c, qopeQuery, 0, Integer.MAX_VALUE, optimise, false, sequence, goFasterTables, goFasterCache);
        extra.addTime(System.currentTimeMillis() - startTime);
        HashMap<Integer, ResultsRow<Object>> fetched = new HashMap<Integer, ResultsRow<Object>>();
        for (ResultsRow<Object> row : res) {
            fetched.put((Integer)row.get(0), row);
        }
        int columnCount = q.getSelect().size();
        for (ResultsRow<Object> row : retval) {
            Integer startingId = ((InterMineObject)row.get(startingPoint)).getId();
            ResultsRow pathRow = (ResultsRow)fetched.get(objectIds.get(startingId));
            if (pathRow == null) continue;
            for (int column = 0; column < columnCount; ++column) {
                QuerySelectable qs = q.getSelect().get(column);
                if (qs.equals(qope)) {
                    row.set(column, pathRow.get(1));
                    continue;
                }
                if (!(qs instanceof PathExpressionField)) continue;
                try {
                    if (!((PathExpressionField)qs).getQope().equals(qope)) continue;
                    row.set(column, pathRow.get(((PathExpressionField)qs).getFieldNumber() + 1));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ObjectStoreException("PathExpressionField index " + ((PathExpressionField)qs).getFieldNumber() + " is out of range - it is numbered from zero, up to " + (pathRow.size() - 2), e);
                }
            }
        }
    }

    protected static void fetchCollectionPathExpression(ObjectStoreInterMineImpl os, Connection c, Map<Object, Integer> sequence, Query q, QueryCollectionPathExpression qcpe, List<ResultsRow<Object>> retval, boolean optimise, ExtraQueryTime extra, Set<PrecomputedTable> goFasterTables, OptimiserCache goFasterCache) throws ObjectStoreException {
        HashMap idsToFetch = new HashMap();
        HashSet<InterMineObject> objectsToFetch = new HashSet<InterMineObject>();
        int columnToReplace = q.getSelect().indexOf(qcpe);
        QueryClass qc = qcpe.getQueryClass();
        int startingPoint = q.getSelect().indexOf(qc);
        if (startingPoint == -1) {
            throw new ObjectStoreException("Path Expression " + qcpe + " needs QueryClass " + qc + " to be in the SELECT list");
        }
        if (qcpe.isCollection()) {
            for (ResultsRow<Object> row : retval) {
                InterMineObject o = (InterMineObject)row.get(startingPoint);
                if (idsToFetch.containsKey(o.getId())) continue;
                idsToFetch.put(o.getId(), new ArrayList());
                objectsToFetch.add(o);
            }
            Query subQ = qcpe.getQuery(objectsToFetch);
            long startTime = System.currentTimeMillis();
            List<ResultsRow<Object>> results = os.executeWithConnection(c, subQ, 0, Integer.MAX_VALUE, optimise, false, sequence, goFasterTables, goFasterCache);
            extra.addTime(System.currentTimeMillis() - startTime);
            boolean singleton = qcpe.isSingleton();
            for (ResultsRow<Object> row : results) {
                Integer id = (Integer)row.get(0);
                List list = (List)idsToFetch.get(id);
                if (singleton) {
                    list.add(row.get(1));
                    continue;
                }
                ResultsRow newRow = new ResultsRow();
                Iterator iter = row.iterator();
                iter.next();
                while (iter.hasNext()) {
                    newRow.add(iter.next());
                }
                list.add(newRow);
            }
            for (ResultsRow<Object> row : retval) {
                InterMineObject o = (InterMineObject)row.get(startingPoint);
                row.set(columnToReplace, idsToFetch.get(o.getId()));
            }
        } else {
            HashMap<Integer, Integer> objectIds = new HashMap<Integer, Integer>();
            for (ResultsRow<Object> row : retval) {
                InterMineObject o = (InterMineObject)row.get(startingPoint);
                Integer refId = null;
                try {
                    InterMineObject ref = (InterMineObject)o.getFieldProxy(qcpe.getFieldName());
                    if (ref == null) continue;
                    refId = ref.getId();
                    idsToFetch.put(refId, new ArrayList());
                    objectIds.put(o.getId(), refId);
                    objectsToFetch.add(ref);
                }
                catch (Exception e) {
                    throw new ObjectStoreException("Shouldn't ever happen", e);
                }
            }
            Query subQ = qcpe.getQuery(objectsToFetch);
            long startTime = System.currentTimeMillis();
            List<ResultsRow<Object>> results = os.executeWithConnection(c, subQ, 0, Integer.MAX_VALUE, optimise, false, sequence, goFasterTables, goFasterCache);
            extra.addTime(System.currentTimeMillis() - startTime);
            boolean singleton = qcpe.isSingleton();
            for (ResultsRow<Object> row : results) {
                Integer id = (Integer)row.get(0);
                List list = (List)idsToFetch.get(id);
                if (singleton) {
                    list.add(row.get(1));
                    continue;
                }
                ResultsRow newRow = new ResultsRow();
                Iterator iter = row.iterator();
                iter.next();
                while (iter.hasNext()) {
                    newRow.add(iter.next());
                }
                list.add(newRow);
            }
            for (ResultsRow<Object> row : retval) {
                InterMineObject o = (InterMineObject)row.get(startingPoint);
                Integer referenceId = (Integer)objectIds.get(o.getId());
                row.set(columnToReplace, idsToFetch.get(referenceId));
            }
        }
    }

    protected static Map<Integer, InterMineObject> fetchByIds(ObjectStoreInterMineImpl os, Connection c, Map<Object, Integer> sequence, Class<?> clazz, Collection<Integer> idsToFetch, ExtraQueryTime extra) throws ObjectStoreException {
        try {
            if (idsToFetch.isEmpty()) {
                return Collections.emptyMap();
            }
            Query q = new Query();
            QueryClass qc = new QueryClass(new Class[]{clazz});
            q.addFrom(qc);
            q.addToSelect(qc);
            BagConstraint bc = new BagConstraint((QueryNode)new QueryField(qc, "id"), ConstraintOp.IN, idsToFetch);
            q.setConstraint(bc);
            q.setDistinct(false);
            ObjectStoreInterMineImpl.BagTableToRemove bttr = null;
            if (idsToFetch.size() >= os.getMinBagTableSize()) {
                bttr = os.createTempBagTable(c, bc, false, null);
            }
            long startTime = System.currentTimeMillis();
            Iterator<ResultsRow<Object>> iter = os.executeWithConnection(c, q, 0, Integer.MAX_VALUE, false, false, sequence).iterator();
            extra.addTime(System.currentTimeMillis() - startTime);
            if (bttr != null) {
                os.removeTempBagTable(c, bttr);
            }
            HashMap<Integer, InterMineObject> fetched = new HashMap<Integer, InterMineObject>();
            while (iter.hasNext()) {
                ResultsRow<Object> fetchedObjectRow = iter.next();
                InterMineObject fetchedObject = (InterMineObject)fetchedObjectRow.get(0);
                fetched.put(fetchedObject.getId(), fetchedObject);
            }
            return fetched;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error fetching additional objects", e);
        }
    }
}

