/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.util.SynchronisedIterator;

public class ParallelPrecomputer {
    private static final Logger LOG = Logger.getLogger(ParallelPrecomputer.class);
    private int threadCount;
    private ObjectStoreInterMineImpl os;
    private int minRows = -1;

    public ParallelPrecomputer(ObjectStoreInterMineImpl os, int threadCount) {
        this.os = os;
        this.threadCount = threadCount;
    }

    public void setMinRows(int minRows) {
        this.minRows = minRows;
    }

    public ObjectStoreInterMineImpl getObjectStore() {
        return this.os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void precompute(Collection<Job> jobs) throws ObjectStoreException {
        TreeSet<Job> todo = new TreeSet<Job>();
        for (Job job : jobs) {
            job.prepare(this);
            if (job.getInfo().getRows() < this.minRows) continue;
            todo.add(job);
        }
        SynchronisedIterator<Job> jobIter = new SynchronisedIterator<Job>(todo.iterator());
        TreeMap<Integer, String> threads = new TreeMap<Integer, String>();
        List<Exception> exceptions = Collections.synchronizedList(new ArrayList());
        TreeMap<Integer, String> treeMap = threads;
        synchronized (treeMap) {
            for (int i = 1; i < this.threadCount; ++i) {
                Thread worker = new Thread(new Worker(threads, jobIter, i, exceptions));
                threads.put(new Integer(i), "");
                worker.setName("PrecomputeTask extra thread " + i);
                worker.start();
            }
        }
        try {
            while (jobIter.hasNext()) {
                Job job = (Job)jobIter.next();
                TreeMap<Integer, String> i = threads;
                synchronized (i) {
                    threads.put(new Integer(0), job.getKey());
                    LOG.info((Object)("Threads doing: " + threads));
                }
                this.executeJob(job, 0);
                if (exceptions.isEmpty()) continue;
                throw new ObjectStoreException("Exception while executing in worker thread", exceptions.get(0));
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        LOG.info((Object)"Thread 0 finished");
        treeMap = threads;
        synchronized (treeMap) {
            threads.remove(new Integer(0));
            LOG.info((Object)("Threads doing: " + threads));
            while (threads.size() != 0) {
                LOG.info((Object)(threads.size() + " threads left"));
                try {
                    threads.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (!exceptions.isEmpty()) {
            throw new ObjectStoreException("Exception while executing in worker thread", exceptions.get(0));
        }
        LOG.info((Object)"All threads finished");
    }

    private void executeJob(Job job, int threadNo) throws ObjectStoreException {
        job.execute(this, threadNo);
    }

    protected void precomputeQuery(String key, Query query, Collection<? extends QueryNode> indexes, boolean allFields, String category, int threadNo) throws ObjectStoreException {
        LOG.info((Object)("Thread " + threadNo + " precomputing " + key + " - " + query + " with indexes " + indexes));
        long start = System.currentTimeMillis();
        try {
            this.os.precompute(query, indexes, allFields, category);
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)("Precompute failed for " + key), (Throwable)e);
            throw e;
        }
        LOG.info((Object)("Precompute took " + (System.currentTimeMillis() - start) + " ms for: " + key));
    }

    private class Worker
    implements Runnable {
        private Map<Integer, String> threads;
        private Iterator<Job> jobIter;
        private int threadNo;
        private List<Exception> exceptions;

        public Worker(Map<Integer, String> threads, Iterator<Job> jobIter, int threadNo, List<Exception> exceptions) {
            this.threads = threads;
            this.jobIter = jobIter;
            this.threadNo = threadNo;
            this.exceptions = exceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                Object job;
                block19: while (true) {
                    try {
                        while (this.jobIter.hasNext()) {
                            job = this.jobIter.next();
                            Map<Integer, String> map = this.threads;
                            synchronized (map) {
                                this.threads.put(new Integer(this.threadNo), ((Job)job).getKey());
                                LOG.info((Object)("Threads doing: " + this.threads));
                            }
                            try {
                                ParallelPrecomputer.this.executeJob((Job)job, this.threadNo);
                                continue block19;
                            }
                            catch (Exception e) {
                                this.exceptions.add(e);
                            }
                        }
                        break block21;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        LOG.info((Object)("Thread " + this.threadNo + " finished"));
                        Map<Integer, String> map = this.threads;
                        synchronized (map) {
                            this.threads.remove(new Integer(this.threadNo));
                            LOG.info((Object)("Threads doing: " + this.threads));
                            this.threads.notify();
                            break block21;
                        }
                    }
                }
                finally {
                    LOG.info((Object)("Thread " + this.threadNo + " finished"));
                    job = this.threads;
                    synchronized (job) {
                        this.threads.remove(new Integer(this.threadNo));
                        LOG.info((Object)("Threads doing: " + this.threads));
                        this.threads.notify();
                    }
                }
            }
        }
    }

    public static class Job
    implements Comparable<Job> {
        private String key;
        private Query query;
        private Collection<? extends QueryNode> indexes;
        private boolean allFields;
        private String category;
        private ResultsInfo info;

        public Job(String key, Query query, Collection<? extends QueryNode> indexes, boolean allFields, String category) {
            this.key = key;
            this.query = query;
            this.indexes = indexes;
            this.allFields = allFields;
            this.category = category;
            this.info = null;
        }

        private void prepare(ParallelPrecomputer pp) throws ObjectStoreException {
            this.info = pp.getObjectStore().estimate(this.query);
        }

        private ResultsInfo getInfo() {
            return this.info;
        }

        private void execute(ParallelPrecomputer pp, int threadNo) throws ObjectStoreException {
            LOG.info((Object)("Job with key " + this.key + " has expected time " + this.info.getComplete()));
            pp.precomputeQuery(this.key, this.query, this.indexes, this.allFields, this.category, threadNo);
        }

        private String getKey() {
            return this.key;
        }

        @Override
        public int compareTo(Job job) {
            long thisTime = this.info.getComplete();
            long otherTime = job.info.getComplete();
            return otherTime > thisTime ? 1 : (otherTime < thisTime ? -1 : this.query.toString().compareTo(job.query.toString()));
        }
    }
}

