/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.DataChangedException;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.DatabaseSchema;
import org.intermine.objectstore.intermine.NotXmlRenderer;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.intermine.SqlGenerator;
import org.intermine.objectstore.proxy.Lazy;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.PendingClob;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.sql.DatabaseUtil;
import org.intermine.sql.precompute.BestQuery;
import org.intermine.sql.precompute.OptimiserCache;
import org.intermine.sql.precompute.PrecomputedTable;
import org.intermine.sql.precompute.QueryOptimiser;
import org.intermine.sql.precompute.QueryOptimiserContext;
import org.intermine.sql.writebatch.Batch;
import org.intermine.sql.writebatch.BatchWriter;
import org.intermine.sql.writebatch.BatchWriterPostgresCopyImpl;
import org.intermine.util.DynamicUtil;
import org.intermine.util.ShutdownHook;
import org.intermine.util.Shutdownable;
import org.intermine.util.StringConstructor;
import org.intermine.util.TypeUtil;

public class ObjectStoreWriterInterMineImpl
extends ObjectStoreInterMineImpl
implements ObjectStoreWriter,
Shutdownable {
    private static final Logger LOG = Logger.getLogger(ObjectStoreWriterInterMineImpl.class);
    private static final String[] CLOB_COLUMNS = new String[]{"clobid", "clobpage", "value"};
    protected Connection conn = null;
    protected boolean connInUse = false;
    protected ObjectStoreInterMineImpl os;
    protected Batch batch;
    protected String createSituation;
    protected String closeSituation;
    protected Map<Integer, Boolean> recentSequences;
    protected Map<String, TableInfo> tableToInfo;
    protected Map<String, String[]> tableToColNameArray;
    protected Map<String, Set<CollectionDescriptor>> tableToCollections;
    protected String connectionTakenBy = null;
    protected Set<Object> tablesAltered = new HashSet<Object>();

    public ObjectStoreWriterInterMineImpl(ObjectStore os) throws ObjectStoreException {
        super(((ObjectStoreInterMineImpl)os).getModel());
        this.schema = ((ObjectStoreInterMineImpl)os).getSchema();
        this.limitedContext = ((ObjectStoreInterMineImpl)os).limitedContext;
        this.description = "Writer(" + ((ObjectStoreInterMineImpl)os).description + ")";
        if (os instanceof ObjectStoreWriter) {
            throw new ObjectStoreException("Cannot create an ObjectStoreWriterInterMineImpl from another ObjectStoreWriter. Call osw.getObjectStore() and construct from the ObjectStore instead.");
        }
        this.os = (ObjectStoreInterMineImpl)os;
        this.db = this.os.db;
        try {
            this.conn = this.os.getConnection();
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not obtain connection to database " + this.db.getURL() + "(user=" + this.db.getUser() + ")", e);
        }
        this.os.writers.add(this);
        ShutdownHook.registerObject(new WeakReference<ObjectStoreWriterInterMineImpl>(this));
        Exception e = new Exception();
        e.fillInStackTrace();
        StringWriter message = new StringWriter();
        PrintWriter pw = new PrintWriter(message);
        e.printStackTrace(pw);
        pw.close();
        this.createSituation = message.toString();
        int index = this.createSituation.indexOf("at junit.framework.TestCase.runBare");
        this.createSituation = index < 0 ? this.createSituation : this.createSituation.substring(0, index);
        this.recentSequences = Collections.synchronizedMap(new WeakHashMap());
        this.batch = new Batch(new BatchWriterPostgresCopyImpl());
        this.tableToInfo = new HashMap<String, TableInfo>();
        this.tableToColNameArray = new HashMap<String, String[]>();
        this.tableToCollections = new HashMap<String, Set<CollectionDescriptor>>();
    }

    @Override
    public ObjectStoreWriterInterMineImpl getNewWriter() throws ObjectStoreException {
        throw new UnsupportedOperationException("Cannot get an ObjectStoreWriter from an existing ObjectStoreWriter");
    }

    @Override
    public Results execute(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        if (this.tablesAltered.isEmpty()) {
            return super.execute(q, batchSize, optimise, explain, prefetch);
        }
        Results retval = new Results(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public SingletonResults executeSingleton(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        if (this.tablesAltered.isEmpty()) {
            return super.executeSingleton(q, batchSize, optimise, explain, prefetch);
        }
        SingletonResults retval = new SingletonResults(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public boolean everOptimise() {
        return this.tablesAltered.isEmpty();
    }

    @Override
    public Writer getLog() {
        return this.os.getLog();
    }

    @Override
    public void setLog(Writer log) {
        throw new UnsupportedOperationException("Cannot change the log on a writer");
    }

    @Override
    public void setLogTableName(String tableName) {
        throw new UnsupportedOperationException("Cannot change the log table name on a writer");
    }

    @Override
    protected void dbLog(long optimise, long estimated, long execute, long permitted, long convert, Query q, String sql) {
        this.os.dbLog(optimise, estimated, execute, permitted, convert, q, sql);
    }

    @Override
    public void setLogEverything(boolean logEverything) {
        throw new UnsupportedOperationException("Cannot change logEverything on a writer");
    }

    @Override
    public boolean getLogEverything() {
        return this.os.getLogEverything();
    }

    @Override
    public void setVerboseQueryLog(boolean verboseQueryLog) {
        throw new UnsupportedOperationException("Cannot change verboseQueryLog on a writer");
    }

    @Override
    public boolean getVerboseQueryLog() {
        return this.os.getVerboseQueryLog();
    }

    @Override
    public void setLogExplains(boolean logExplains) {
        throw new UnsupportedOperationException("Cannot change logExplains on a writer");
    }

    @Override
    public boolean getLogExplains() {
        return this.os.getLogExplains();
    }

    @Override
    public void setLogBeforeExecute(boolean logBeforeExecute) {
        throw new UnsupportedOperationException("Cannot change logBeforeExecute on a writer");
    }

    @Override
    public boolean getLogBeforeExecute() {
        return this.os.getLogBeforeExecute();
    }

    @Override
    public void setDisableResultsCache(boolean disableResultsCache) {
        throw new UnsupportedOperationException("Cannot change disableResultsCache on a writer");
    }

    @Override
    public boolean getDisableResultsCache() {
        return this.os.getDisableResultsCache();
    }

    public void setBatchWriter(BatchWriter batchWriter) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.batch.setBatchWriter(batchWriter);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public void setMinBagTableSize(int minBagTableSize) {
        this.os.setMinBagTableSize(minBagTableSize);
    }

    @Override
    public int getMinBagTableSize() {
        return this.os.getMinBagTableSize();
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        int loops = 0;
        while (this.connInUse || this.conn == null) {
            if (this.conn == null) {
                throw new SQLException("This ObjectStoreWriter is closed");
            }
            if (loops > 100) {
                LOG.error((Object)"Waited for connection for 100 seconds - probably a deadlock - throwing exception");
                throw new SQLException("This ObjectStoreWriter appears to be dead due to deadlock");
            }
            if (loops > 1) {
                LOG.info((Object)("Waited for connection for " + loops + " seconds - perhaps there's" + " a deadlock"));
            } else {
                LOG.debug((Object)"Connection in use - entering wait");
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.debug((Object)"Notified or timed out");
            ++loops;
        }
        this.connInUse = true;
        return this.conn;
    }

    @Override
    public synchronized void releaseConnection(Connection c) {
        if (this.conn == null && c != null) {
            try {
                if (this.isInTransactionWithConnection(c)) {
                    this.abortTransactionWithConnection(c);
                    LOG.error((Object)"ObjectStoreWriterInterMineImpl closed in unfinished transaction - transaction aborted");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception caught when destroying transaction while closing ObjectStoreWriter", (Throwable)e);
            }
            try {
                this.batch.close(c);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception caught when closing Batch while closing ObjectStoreWriter", (Throwable)e);
            }
            try {
                this.os.releaseConnection(c);
            }
            catch (Exception e) {}
        } else if (c == this.conn) {
            this.connInUse = false;
            this.notify();
        } else if (c != null) {
            Exception trace = new Exception();
            trace.fillInStackTrace();
            LOG.warn((Object)"Attempt made to release the wrong connection", (Throwable)trace);
        }
    }

    @Override
    protected synchronized void doFinalise() {
        if (this.conn != null) {
            LOG.error((Object)("Garbage collecting open ObjectStoreWriterInterMineImpl with sequence = " + this.sequenceNumber + " and Database " + this.os.getDatabase().getURL() + ", createSituation: " + this.createSituation));
            try {
                this.close();
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Exception while garbage-collecting ObjectStoreWriterInterMineImpl: " + e));
            }
        }
    }

    @Override
    public synchronized void close() throws ObjectStoreException {
        if (this.conn == null) {
            throw new ObjectStoreException("This ObjectStoreWriter is already closed in situation: " + this.closeSituation + ", present stack trace:");
        }
        Exception est = new Exception();
        est.fillInStackTrace();
        StringWriter message = new StringWriter();
        PrintWriter pw = new PrintWriter(message);
        est.printStackTrace(pw);
        pw.close();
        this.closeSituation = message.toString();
        int index = this.closeSituation.indexOf("at junit.framework.TestCase.runBare");
        String string = this.closeSituation = index < 0 ? this.closeSituation : this.closeSituation.substring(0, index);
        if (this.connInUse) {
            this.conn = null;
            throw new ObjectStoreException("Closed ObjectStoreWriter while it is being used. Note this writer will be automatically closed when the current operation finishes");
        }
        try {
            if (this.isInTransactionWithConnection(this.conn)) {
                this.abortTransactionWithConnection(this.conn);
                LOG.error((Object)"ObjectStoreWriterInterMineImpl closed in unfinished transaction - transaction aborted");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught when destroying transaction while closing ObjectStoreWriter", (Throwable)e);
        }
        try {
            this.batch.close(this.conn);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception caught when closing Batch while closing ObjectStoreWriter", (Throwable)e);
        }
        try {
            this.os.releaseConnection(this.conn);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.conn = null;
        this.connInUse = true;
        this.os.writers.remove(this);
        this.notifyAll();
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.os;
    }

    @Override
    public void store(Object o) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.storeWithConnection(c, o);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void storeWithConnection(Connection c, Object o) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        try {
            boolean doDeletes = o instanceof InterMineObject ? this.populateIds(c, (InterMineObject)o) : false;
            this.writePendingClobs(c, o);
            StringConstructor xml = null;
            String objectClass = null;
            Set<ClassDescriptor> classDescriptors = this.model.getClassDescriptorsForClass(o.getClass());
            if (doDeletes) {
                for (ClassDescriptor cld : classDescriptors) {
                    ClassDescriptor tableMaster = this.schema.getTableMaster(cld);
                    String tableName = DatabaseUtil.getTableName(tableMaster);
                    if (this.schema.getMissingTables().contains(tableName.toLowerCase())) continue;
                    this.batch.deleteRow(c, tableName, "id", ((InterMineObject)o).getId());
                    this.tablesAltered.add(tableName);
                }
            }
            int tablesWritten = 0;
            HashSet<String> validFieldNames = new HashSet<String>();
            for (Map.Entry<String, TypeUtil.FieldInfo> entry : TypeUtil.getFieldInfos(o.getClass()).entrySet()) {
                String fieldName = entry.getKey();
                TypeUtil.FieldInfo fieldInfo = entry.getValue();
                if (Collection.class.isAssignableFrom(fieldInfo.getType())) continue;
                validFieldNames.add(fieldName);
            }
            for (ClassDescriptor cld : classDescriptors) {
                ClassDescriptor tableMaster = this.schema.getTableMaster(cld);
                TableInfo tableInfo = this.getTableInfo(tableMaster);
                Set<CollectionDescriptor> collections = this.tableToCollections.get(cld.getName());
                if (collections == null) {
                    LOG.info((Object)("Generating cached metadata for ClassDescriptor " + cld.getName()));
                    collections = new HashSet<CollectionDescriptor>();
                    for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
                        if (!(field instanceof CollectionDescriptor)) continue;
                        collections.add((CollectionDescriptor)field);
                    }
                    this.tableToCollections.put(cld.getName(), collections);
                }
                if (!this.schema.getMissingTables().contains(tableInfo.tableName.toLowerCase())) {
                    Set<Class<?>> decomposed;
                    ++tablesWritten;
                    if (!(!this.schema.isFlatMode(cld.getType()) || this.schema.isTruncated(this.schema.getTableMaster(cld)) || cld.getType().equals(o.getClass()) || (decomposed = DynamicUtil.decomposeClass(o.getClass())).size() == 1 && cld.getType().equals(decomposed.iterator().next()))) {
                        throw new ObjectStoreException("Non-flat model heirarchy used in flat mode. Cannot store object with classes = " + decomposed);
                    }
                    Object[] values = new Object[tableInfo.colNames.length];
                    HashSet<String> fieldNamesWritten = new HashSet<String>();
                    for (int colNo = 0; colNo < tableInfo.colNames.length; ++colNo) {
                        Object value = null;
                        if ("tableclass".equals(tableInfo.colNames[colNo])) {
                            value = cld.getName();
                        } else if ("class".equals(tableInfo.colNames[colNo])) {
                            if (objectClass == null) {
                                StringBuffer sb = new StringBuffer();
                                boolean needComma = false;
                                for (Class<?> objectClazz : DynamicUtil.decomposeClass(o.getClass())) {
                                    if (needComma) {
                                        sb.append(" ");
                                    }
                                    needComma = true;
                                    sb.append(objectClazz.getName());
                                }
                                objectClass = sb.toString();
                            }
                            value = objectClass;
                        } else if ("OBJECT".equals(tableInfo.colNames[colNo])) {
                            if (xml == null) {
                                xml = o instanceof InterMineObject ? ((InterMineObject)o).getoBJECT() : NotXmlRenderer.render(o);
                            }
                            value = xml;
                        } else if (validFieldNames.contains(tableInfo.fieldNames[colNo])) {
                            value = o instanceof InterMineObject ? ((InterMineObject)o).getFieldProxy(tableInfo.fieldNames[colNo]) : TypeUtil.getFieldProxy(o, tableInfo.fieldNames[colNo]);
                            if (value instanceof Date) {
                                value = new Long(((Date)value).getTime());
                            }
                            if (value instanceof ClobAccess) {
                                value = ((ClobAccess)value).getDbDescription();
                            }
                            if (value instanceof InterMineObject && colNo >= tableInfo.referencesFrom) {
                                value = ((InterMineObject)value).getId();
                            } else if (value instanceof InterMineObject || colNo >= tableInfo.referencesFrom) {
                                value = null;
                            }
                            fieldNamesWritten.add(tableInfo.fieldNames[colNo]);
                        } else {
                            FieldDescriptor fieldDescriptor = tableInfo.fields[colNo];
                            if (fieldDescriptor instanceof AttributeDescriptor) {
                                String fieldType = ((AttributeDescriptor)fieldDescriptor).getType();
                                if ("boolean".equals(fieldType)) {
                                    value = Boolean.FALSE;
                                } else if ("short".equals(fieldType)) {
                                    value = new Short(0);
                                } else if ("int".equals(fieldType)) {
                                    value = new Integer(0);
                                } else if ("long".equals(fieldType)) {
                                    value = new Long(0L);
                                } else if ("float".equals(fieldType)) {
                                    value = new Float(0.0f);
                                } else if ("double".equals(fieldType)) {
                                    value = new Double(0.0);
                                }
                            }
                        }
                        values[colNo] = value;
                    }
                    if (this.schema.isFlatMode(cld.getType())) {
                        for (String validFieldName : validFieldNames) {
                            if (fieldNamesWritten.contains(validFieldName)) continue;
                            Set<Class<?>> decomposed2 = DynamicUtil.decomposeClass(o.getClass());
                            throw new ObjectStoreException("Cannot store object " + decomposed2 + " - no column for field " + validFieldName + " in table " + tableInfo.tableName);
                        }
                    }
                    this.batch.addRow(c, tableInfo.tableName, o instanceof InterMineObject ? ((InterMineObject)o).getId() : null, tableInfo.colNames, values);
                    this.tablesAltered.add(tableInfo.tableName);
                }
                this.writeCollections(c, o, collections);
            }
            if (tablesWritten < 1) {
                throw new ObjectStoreException("Object " + DynamicUtil.decomposeClass(o.getClass()) + " does not map onto any database table.");
            }
            if (o instanceof InterMineObject) {
                this.invalidateObjectById(((InterMineObject)o).getId());
            }
        }
        catch (SQLException e) {
            if (e.getNextException() == null) {
                throw new ObjectStoreException("Error while storing", e);
            }
            StringBuilder message = new StringBuilder();
            SQLException e2 = e;
            int messageNo = 1;
            while (e2 != null) {
                if (messageNo > 1) {
                    message.append(", ");
                }
                message.append("Error " + messageNo + ": \"").append(e2.getMessage()).append("\"");
                ++messageNo;
            }
            throw new ObjectStoreException("Error while storing. " + message, e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectStoreException("Illegal access to value while storing", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    private void writeCollections(Connection c, Object o, Set<CollectionDescriptor> collections) throws IllegalAccessException, SQLException {
        for (CollectionDescriptor collection : collections) {
            String outwardColumnName;
            Collection coll = (Collection)((InterMineObject)o).getFieldValue(collection.getName());
            boolean needToStoreCollection = true;
            if (coll instanceof Lazy) {
                ObjectStore testOS = ((Lazy)((Object)coll)).getObjectStore();
                if (testOS instanceof ObjectStoreWriter) {
                    testOS = ((ObjectStoreWriter)testOS).getObjectStore();
                }
                if (testOS.equals(this.getObjectStore())) {
                    needToStoreCollection = false;
                }
            }
            if (!needToStoreCollection || collection.relationType() != 4) continue;
            String indirectTableName = DatabaseUtil.getIndirectionTableName(collection);
            String inwardColumnName = DatabaseUtil.getInwardIndirectionColumnName(collection, this.schema.getVersion());
            boolean swap = inwardColumnName.compareTo(outwardColumnName = DatabaseUtil.getOutwardIndirectionColumnName(collection, this.schema.getVersion())) > 0;
            String[] indirColNames = this.tableToColNameArray.get(indirectTableName);
            if (indirColNames == null) {
                indirColNames = new String[]{swap ? inwardColumnName : outwardColumnName, swap ? outwardColumnName : inwardColumnName};
                this.tableToColNameArray.put(indirectTableName, indirColNames);
            }
            for (InterMineObject inCollection : coll) {
                this.batch.addRow(c, indirectTableName, indirColNames[0], indirColNames[1], swap ? ((InterMineObject)o).getId() : inCollection.getId(), swap ? inCollection.getId() : ((InterMineObject)o).getId());
                this.tablesAltered.add(indirectTableName);
            }
        }
    }

    @Override
    public void addToCollection(Integer hasId, Class<?> clazz, String fieldName, Integer hadId) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.addToCollectionWithConnection(c, hasId, clazz, fieldName, hadId);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void addToCollectionWithConnection(Connection c, Integer hasId, Class<?> clazz, String fieldName, Integer hadId) throws ObjectStoreException {
        block14: {
            boolean wasInTransaction = this.isInTransactionWithConnection(c);
            if (!wasInTransaction) {
                this.beginTransactionWithConnection(c);
            }
            try {
                FieldDescriptor field = this.model.getFieldDescriptorsForClass(clazz).get(fieldName);
                if (field == null) {
                    throw new ObjectStoreException("Field " + clazz.getName() + "." + fieldName + " does not exist in the model.");
                }
                if (field.relationType() == 4) {
                    this.invalidateObjectById(hasId);
                    this.invalidateObjectById(hadId);
                    CollectionDescriptor coll = (CollectionDescriptor)field;
                    String indirectTableName = DatabaseUtil.getIndirectionTableName(coll);
                    String inwardColumnName = DatabaseUtil.getInwardIndirectionColumnName(coll, this.schema.getVersion());
                    String outwardColumnName = DatabaseUtil.getOutwardIndirectionColumnName(coll, this.schema.getVersion());
                    boolean swap = inwardColumnName.compareTo(outwardColumnName) > 0;
                    String[] indirColNames = this.tableToColNameArray.get(indirectTableName);
                    if (indirColNames == null) {
                        indirColNames = new String[]{swap ? inwardColumnName : outwardColumnName, swap ? outwardColumnName : inwardColumnName};
                        this.tableToColNameArray.put(indirectTableName, indirColNames);
                    }
                    this.batch.addRow(c, indirectTableName, indirColNames[0], indirColNames[1], swap ? hasId : hadId, swap ? hadId : hasId);
                    this.tablesAltered.add(indirectTableName);
                    break block14;
                }
                throw new ObjectStoreException("Field " + clazz.getName() + "." + fieldName + " is not a many-to-many collection.");
            }
            catch (SQLException e) {
                throw new ObjectStoreException("Error while storing", e);
            }
            finally {
                if (!wasInTransaction) {
                    try {
                        this.commitTransactionWithConnection(c);
                    }
                    catch (ObjectStoreException e) {
                        this.abortTransactionWithConnection(c);
                        throw e;
                    }
                }
            }
        }
    }

    protected TableInfo getTableInfo(ClassDescriptor tableMaster) throws ObjectStoreException {
        String tableName = DatabaseUtil.getTableName(tableMaster);
        TableInfo retval = this.tableToInfo.get(tableName);
        if (retval == null) {
            boolean hasObject;
            retval = new TableInfo();
            retval.tableName = tableName;
            LOG.info((Object)("Generating cached metadata for table " + tableName));
            DatabaseSchema.Fields allColumns = this.schema.getTableFields(tableMaster);
            int colCount = allColumns.getAttributes().size() + allColumns.getReferences().size();
            boolean isTruncated = this.schema.isTruncated(tableMaster);
            boolean bl = hasObject = "InterMineObject".equals(tableName) || !this.schema.isMissingNotXml() && !this.schema.isFlatMode(tableMaster.getType());
            if (isTruncated) {
                colCount += 2;
            } else if (!this.schema.isFlatMode(tableMaster.getType())) {
                ++colCount;
            }
            if (hasObject) {
                ++colCount;
            }
            retval.colNames = new String[colCount];
            retval.fieldNames = new String[colCount];
            retval.fields = new FieldDescriptor[colCount];
            int colNo = 0;
            if (hasObject) {
                retval.colNames[colNo] = "OBJECT";
                ++colNo;
            }
            if (isTruncated) {
                retval.colNames[colNo] = "class";
                retval.colNames[++colNo] = "tableclass";
                ++colNo;
            } else if (!this.schema.isFlatMode(tableMaster.getType())) {
                retval.colNames[colNo] = "class";
                ++colNo;
            }
            for (AttributeDescriptor attributeDescriptor : allColumns.getAttributes()) {
                retval.colNames[colNo] = DatabaseUtil.getColumnName(attributeDescriptor);
                retval.fieldNames[colNo] = attributeDescriptor.getName();
                retval.fields[colNo] = attributeDescriptor;
                ++colNo;
            }
            retval.referencesFrom = colNo;
            for (ReferenceDescriptor referenceDescriptor : allColumns.getReferences()) {
                retval.colNames[colNo] = DatabaseUtil.getColumnName(referenceDescriptor);
                retval.fieldNames[colNo] = referenceDescriptor.getName();
                retval.fields[colNo] = referenceDescriptor;
                ++colNo;
            }
            this.tableToInfo.put(tableName, retval);
        }
        return retval;
    }

    protected boolean populateIds(Connection c, InterMineObject o) throws SQLException, IllegalAccessException {
        boolean doDeletes = true;
        if (o.getId() == null) {
            o.setId(this.getSerialWithConnection(c));
            doDeletes = false;
        } else {
            doDeletes = !this.recentSequences.containsKey(o.getId());
        }
        this.recentSequences.remove(o.getId());
        for (Map.Entry<String, TypeUtil.FieldInfo> fieldEntry : TypeUtil.getFieldInfos(o.getClass()).entrySet()) {
            Collection coll;
            TypeUtil.FieldInfo fieldInfo = fieldEntry.getValue();
            if (InterMineObject.class.isAssignableFrom(fieldInfo.getType())) {
                InterMineObject obj = (InterMineObject)TypeUtil.getFieldProxy(o, fieldInfo.getName());
                if (obj == null || obj.getId() != null) continue;
                obj.setId(this.getSerialWithConnection(c));
                continue;
            }
            if (!Collection.class.isAssignableFrom(fieldInfo.getType()) || (coll = (Collection)o.getFieldValue(fieldInfo.getName())) instanceof Lazy) continue;
            for (InterMineObject obj : coll) {
                if (obj.getId() != null) continue;
                obj.setId(this.getSerialWithConnection(c));
            }
        }
        return doDeletes;
    }

    protected void writePendingClobs(Connection c, Object o) throws ObjectStoreException, SQLException, IllegalAccessException {
        for (Map.Entry<String, TypeUtil.FieldInfo> fieldEntry : TypeUtil.getFieldInfos(o.getClass()).entrySet()) {
            ClobAccess ca;
            TypeUtil.FieldInfo fieldInfo = fieldEntry.getValue();
            if (!ClobAccess.class.isAssignableFrom(fieldInfo.getType()) || !((ca = (ClobAccess)TypeUtil.getFieldValue(o, fieldInfo.getName())) instanceof PendingClob)) continue;
            Clob clob = new Clob(this.getSerialWithConnection(c));
            this.replaceClobWithConnection(c, clob, ((PendingClob)ca).toString());
            TypeUtil.setFieldValue(o, fieldInfo.getName(), new ClobAccess(this, clob));
        }
    }

    @Override
    public void addToBag(ObjectStoreBag osb, Integer element) throws ObjectStoreException {
        this.addAllToBag(osb, Collections.singleton(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllToBag(ObjectStoreBag osb, Collection<Integer> coll) throws ObjectStoreException {
        try {
            Connection c = null;
            try {
                c = this.getConnection();
                this.addAllToBagWithConnection(c, osb, coll);
            }
            finally {
                this.releaseConnection(c);
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
    }

    protected void addAllToBagWithConnection(Connection c, ObjectStoreBag osb, Collection<Integer> coll) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        try {
            for (Integer element : coll) {
                this.batch.addRow(c, "osbag_int", "bagid", "value", osb.getBagId(), element);
                this.tablesAltered.add(osb);
                this.tablesAltered.add("osbag_int");
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error adding to bag", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    @Override
    public void removeFromBag(ObjectStoreBag osb, Integer element) throws ObjectStoreException {
        this.removeAllFromBag(osb, Collections.singleton(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromBag(ObjectStoreBag osb, Collection<Integer> coll) throws ObjectStoreException {
        try {
            Connection c = null;
            try {
                c = this.getConnection();
                this.removeAllFromBagWithConnection(c, osb, coll);
            }
            finally {
                this.releaseConnection(c);
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
    }

    protected void removeAllFromBagWithConnection(Connection c, ObjectStoreBag osb, Collection<Integer> coll) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        try {
            for (Integer element : coll) {
                this.batch.deleteRow(c, "osbag_int", "bagid", "value", osb.getBagId(), element);
                this.tablesAltered.add(osb);
                this.tablesAltered.add("osbag_int");
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error removing from bag", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToBagFromQuery(ObjectStoreBag osb, Query query) throws ObjectStoreException {
        List<QuerySelectable> select = query.getSelect();
        if (select.size() != 1) {
            throw new IllegalArgumentException("Query has incorrect number of SELECT elements.");
        }
        Class<?> type = select.get(0).getType();
        if (!Integer.class.equals(type) && !InterMineObject.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("The type of the result colum (" + type.getName() + ") is not an Integer or InterMineObject");
        }
        try {
            Connection c = null;
            try {
                c = this.getConnection();
                Set<String> readTables = SqlGenerator.findTableNames(query, this.getSchema());
                readTables.add("osbag_int");
                this.batch.flush(c, readTables);
                this.addToBagFromQueryWithConnection(c, osb, query);
            }
            finally {
                this.releaseConnection(c);
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToBagFromQueryWithConnection(Connection c, ObjectStoreBag osb, Query query) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        if (this.getMinBagTableSize() != -1) {
            this.createTempBagTables(c, query);
            this.flushOldTempBagTables(c);
        }
        int kind = query.getSelect().get(0) instanceof QueryClass ? 2 : 0;
        String sql = SqlGenerator.generate(query, this.schema, this.db, null, kind, (Map<Object, String>)this.bagConstraintTables);
        try {
            if (this.everOptimise()) {
                BestQuery bestQuery;
                PrecomputedTable pt = (PrecomputedTable)this.goFasterMap.get(query);
                if (pt != null) {
                    OptimiserCache oCache = (OptimiserCache)this.goFasterCacheMap.get(query);
                    bestQuery = QueryOptimiser.optimiseWith(sql, null, this.db, c, QueryOptimiserContext.DEFAULT, Collections.singleton(pt), oCache);
                } else {
                    bestQuery = QueryOptimiser.optimise(sql, null, this.db, c, QueryOptimiserContext.DEFAULT);
                }
                sql = bestQuery.getBestQueryString();
            }
            Statement s = c.createStatement();
            this.registerStatement(s);
            try {
                String alias = query.getAliases().get(query.getSelect().get(0));
                if (kind == 2) {
                    alias = "id";
                }
                sql = "INSERT INTO osbag_int (bagid, value) SELECT DISTINCT " + osb.getBagId() + ", sub." + alias + " FROM (" + sql + ") AS sub WHERE sub." + alias + " NOT IN (SELECT " + "value" + " FROM " + "osbag_int" + " WHERE " + "bagid" + " = " + osb.getBagId() + ")";
                s.execute(sql);
                this.tablesAltered.add(osb);
                this.tablesAltered.add("osbag_int");
            }
            finally {
                this.deregisterStatement(s);
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error running query: " + sql, e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceClob(Clob clob, String text) throws ObjectStoreException {
        try {
            Connection c = null;
            try {
                c = this.getConnection();
                this.replaceClobWithConnection(c, clob, text);
            }
            finally {
                this.releaseConnection(c);
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
    }

    public void replaceClobWithConnection(Connection c, Clob clob, String text) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        try {
            Integer clobId = new Integer(clob.getClobId());
            this.batch.deleteRow(c, "clob", "clobid", clobId);
            int length = text.length();
            for (int i = 0; i < length; i += 7000) {
                this.batch.addRow(c, "clob", clobId, CLOB_COLUMNS, new Object[]{clobId, new Integer(i / 7000), text.substring(i, Math.min(i + 7000, length))});
            }
            this.tablesAltered.add(clob);
            this.tablesAltered.add("clob");
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error adding to bag", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    @Override
    public void delete(InterMineObject o) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.deleteWithConnection(c, o);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void deleteWithConnection(Connection c, InterMineObject o) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(c);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(c);
        }
        try {
            if (o.getId() == null) {
                throw new IllegalArgumentException("Attempt to delete an object without an ID: " + o.toString());
            }
            for (ClassDescriptor cld : this.model.getClassDescriptorsForClass(o.getClass())) {
                ClassDescriptor tableMaster = this.schema.getTableMaster(cld);
                String tableName = DatabaseUtil.getTableName(tableMaster);
                if (this.schema.getMissingTables().contains(tableName.toLowerCase())) continue;
                this.batch.deleteRow(c, tableName, "id", o.getId());
                this.tablesAltered.add(tableName);
            }
            this.invalidateObjectById(o.getId());
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error while deleting", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(c);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(c);
                    throw e;
                }
            }
        }
    }

    @Override
    public void delete(QueryClass qc, Constraint c) throws ObjectStoreException {
        Connection con = null;
        try {
            con = this.getConnection();
            this.deleteWithConnection(con, qc, c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deleteWithConnection(Connection con, QueryClass qc, Constraint c) throws ObjectStoreException {
        boolean wasInTransaction = this.isInTransactionWithConnection(con);
        if (!wasInTransaction) {
            this.beginTransactionWithConnection(con);
        }
        try {
            if (InterMineObject.class.isAssignableFrom(qc.getType())) {
                throw new ObjectStoreException("Cannot delete by query from " + qc.getType());
            }
            String tableName = DatabaseUtil.getTableName(this.getSchema().getModel().getClassDescriptorByName(qc.getType().getName()));
            this.batch.flush(con, Collections.singleton(tableName));
            StringBuffer sql = new StringBuffer("DELETE FROM " + tableName);
            if (c != null) {
                sql.append(" WHERE ");
                SqlGenerator.constraintToString(null, sql, c, null, this.getSchema(), 1, true);
            }
            con.createStatement().execute(sql.toString());
            this.tablesAltered.add(tableName);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error while deleting", e);
        }
        finally {
            if (!wasInTransaction) {
                try {
                    this.commitTransactionWithConnection(con);
                }
                catch (ObjectStoreException e) {
                    this.abortTransactionWithConnection(con);
                    throw e;
                }
            }
        }
    }

    @Override
    public boolean isInTransaction() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            boolean bl = this.isInTransactionWithConnection(c);
            return bl;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected boolean isInTransactionWithConnection(Connection c) throws ObjectStoreException {
        try {
            return !c.getAutoCommit();
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error finding transaction status", e);
        }
    }

    @Override
    public void beginTransaction() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.beginTransactionWithConnection(c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void beginTransactionWithConnection(Connection c) throws ObjectStoreException {
        try {
            if (!c.getAutoCommit()) {
                throw new ObjectStoreException("beginTransaction called, but already in transaction");
            }
            c.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error beginning transaction", e);
        }
    }

    @Override
    public void commitTransaction() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.commitTransactionWithConnection(c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void commitTransactionWithConnection(Connection c) throws ObjectStoreException {
        try {
            this.batch.flush(c);
            if (c.getAutoCommit()) {
                throw new ObjectStoreException("commitTransaction called, but not in transaction");
            }
            c.commit();
            c.setAutoCommit(true);
            this.os.databaseAltered(this.tablesAltered);
            this.tablesAltered.clear();
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error committing transaction", e);
        }
    }

    @Override
    public void abortTransaction() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.abortTransactionWithConnection(c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public void abortTransactionWithConnection(Connection c) throws ObjectStoreException {
        try {
            this.batch.clear();
            if (c.getAutoCommit()) {
                throw new ObjectStoreException("abortTransaction called, but not in transaction");
            }
            c.rollback();
            c.setAutoCommit(true);
            this.os.flushObjectById();
            this.tablesAltered.clear();
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error aborting transaction", e);
        }
    }

    @Override
    public void batchCommitTransaction() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.batchCommitTransactionWithConnection(c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public void batchCommitTransactionWithConnection(Connection c) throws ObjectStoreException {
        try {
            this.batch.batchCommit(c);
            this.os.databaseAltered(this.tablesAltered);
            this.tablesAltered.clear();
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Error batch-committing transaction", e);
        }
    }

    @Override
    public void databaseAltered(Set<Object> tablesAltered) {
        throw new IllegalArgumentException("databaseAltered should never be called on an ObjectStoreWriter");
    }

    @Override
    public Map<Object, Integer> getSequence(Set<Object> tables) {
        return this.os.getSequence(tables);
    }

    @Override
    public void checkSequence(Map<Object, Integer> sequence, Query q, String message) throws DataChangedException {
        this.os.checkSequence(sequence, q, message);
    }

    @Override
    public List<ResultsRow<Object>> execute(Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            Set<String> readTables = SqlGenerator.findTableNames(q, this.getSchema());
            this.batch.flush(c, readTables);
            List<ResultsRow<Object>> list = this.executeWithConnection(c, q, start, limit, optimise, explain, sequence);
            return list;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    protected String generateSql(Connection c, Query q, int start, int limit) throws ObjectStoreException {
        return this.os.generateSql(c, q, start, limit);
    }

    @Override
    public int count(Query q, Map<Object, Integer> sequence) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            Set<String> readTables = SqlGenerator.findTableNames(q, this.getSchema());
            this.batch.flush(c, readTables);
            int n = this.countWithConnection(c, q, sequence);
            return n;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    protected InterMineObject internalGetObjectById(Integer id, Class<? extends InterMineObject> clazz) throws ObjectStoreException {
        if (this.schema.isFlatMode(clazz)) {
            return super.internalGetObjectById(id, clazz);
        }
        Connection c = null;
        try {
            c = this.getConnection();
            String readTable = SqlGenerator.tableNameForId(clazz, this.getSchema());
            this.batch.flush(c, Collections.singleton(readTable));
            InterMineObject interMineObject = this.internalGetObjectByIdWithConnection(c, id, clazz);
            return interMineObject;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.conn != null) {
            LOG.error((Object)("Shutting down open ObjectStoreWriterInterMineImpl with sequence = " + this.sequenceNumber + " and Database " + this.os.getDatabase().getURL() + ", createSituation = " + this.createSituation));
            try {
                this.close();
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Exception caught while shutting down ObjectStoreWriterInterMineImpl: " + e));
            }
        }
    }

    @Override
    public boolean isMultiConnection() {
        return false;
    }

    @Override
    protected Integer getSerialWithConnection(Connection c) throws SQLException {
        Integer retval = super.getSerialWithConnection(c);
        this.recentSequences.put(retval, Boolean.TRUE);
        return retval;
    }

    @Override
    public String toString() {
        return "Writer(" + this.os + ")";
    }

    private static class TableInfo {
        String tableName;
        String[] colNames;
        String[] fieldNames;
        FieldDescriptor[] fields;
        int referencesFrom;

        private TableInfo() {
        }
    }
}

