/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.DataChangedException;
import org.intermine.objectstore.ObjectStoreAbstractImpl;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreQueryDurationException;
import org.intermine.objectstore.intermine.CompletelyFalseException;
import org.intermine.objectstore.intermine.DatabaseSchema;
import org.intermine.objectstore.intermine.ExtraQueryTime;
import org.intermine.objectstore.intermine.NotXmlParser;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.objectstore.intermine.ResultsConverter;
import org.intermine.objectstore.intermine.SqlGenerator;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.Constraint;
import org.intermine.objectstore.query.ConstraintHelper;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ConstraintTraverseAction;
import org.intermine.objectstore.query.ConstraintWithBag;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.MultipleInBagConstraint;
import org.intermine.objectstore.query.OrderDescending;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryClassBag;
import org.intermine.objectstore.query.QueryCollectionPathExpression;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryObjectPathExpression;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryOrderable;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsBatches;
import org.intermine.objectstore.query.ResultsInfo;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.sql.Database;
import org.intermine.sql.DatabaseFactory;
import org.intermine.sql.DatabaseUtil;
import org.intermine.sql.precompute.BestQuery;
import org.intermine.sql.precompute.BestQueryExplainer;
import org.intermine.sql.precompute.OptimiserCache;
import org.intermine.sql.precompute.PrecomputedTable;
import org.intermine.sql.precompute.PrecomputedTableManager;
import org.intermine.sql.precompute.QueryOptimiser;
import org.intermine.sql.precompute.QueryOptimiserContext;
import org.intermine.sql.query.ExplainResult;
import org.intermine.sql.query.PostgresExplainResult;
import org.intermine.sql.writebatch.Batch;
import org.intermine.sql.writebatch.BatchWriterPostgresCopyImpl;
import org.intermine.util.CacheMap;
import org.intermine.util.ShutdownHook;
import org.intermine.util.Shutdownable;
import org.intermine.util.TypeUtil;

public class ObjectStoreInterMineImpl
extends ObjectStoreAbstractImpl
implements Shutdownable {
    private static final Logger LOG = Logger.getLogger(ObjectStoreInterMineImpl.class);
    private static final Logger SQLLOGGER = Logger.getLogger((String)"sqllogger");
    protected static final int CACHE_LARGEST_OBJECT = 5000000;
    protected static Map<String, ObjectStoreInterMineImpl> instances = new HashMap<String, ObjectStoreInterMineImpl>();
    protected Database db;
    protected Set<ObjectStoreWriterInterMineImpl> writers = new HashSet<ObjectStoreWriterInterMineImpl>();
    protected Writer log = null;
    protected DatabaseSchema schema;
    protected Connection logTableConnection = null;
    protected Batch logTableBatch = null;
    protected String logTableName = null;
    protected boolean logEverything = false;
    protected long statsBagTableTime = 0L;
    protected long statsGenTime = 0L;
    protected long statsOptTime = 0L;
    protected long statsEstTime = 0L;
    protected long statsExeTime = 0L;
    protected long statsConTime = 0L;
    protected QueryOptimiserContext limitedContext;
    protected boolean verboseQueryLog = false;
    protected boolean logBeforeExecute = false;
    protected int sequenceBase = 0;
    protected int sequenceOffset = 1000000;
    protected static final int SEQUENCE_MULTIPLE = 1000000;
    protected boolean logExplains = false;
    protected boolean disableResultsCache = false;
    protected int minBagTableSize = -1;
    protected Map<Object, String> bagConstraintTables = Collections.synchronizedMap(new WeakHashMap());
    protected Set<BagTableToRemove> bagTablesInDatabase = Collections.synchronizedSet(new HashSet());
    protected Map<Query, Set<PrecomputedTable>> goFasterMap = Collections.synchronizedMap(new IdentityHashMap());
    protected Map<Query, OptimiserCache> goFasterCacheMap = Collections.synchronizedMap(new IdentityHashMap());
    protected Map<Query, Integer> goFasterCountMap = new IdentityHashMap<Query, Integer>();
    protected ReferenceQueue<String> bagTablesToRemove = new ReferenceQueue();
    protected String description;
    protected Map<String, Results> resultsCache = new CacheMap<String, Results>();
    protected Map<String, SingletonResults> singletonResultsCache = new CacheMap<String, SingletonResults>();
    protected Map<String, Map<Integer, ResultsBatches>> batchesCache = new CacheMap<String, Map<Integer, ResultsBatches>>();
    private static final String[] LOG_TABLE_COLUMNS = new String[]{"timestamp", "optimise", "estimated", "execute", "permitted", "convert", "iql", "sql"};
    public static final String UNIQUE_INTEGER_SEQUENCE_NAME = "objectstore_unique_integer";
    public static final String INT_BAG_TABLE_NAME = "osbag_int";
    public static final String BAGID_COLUMN = "bagid";
    public static final String BAGVAL_COLUMN = "value";
    public static final String CLOB_TABLE_NAME = "clob";
    public static final String CLOBID_COLUMN = "clobid";
    public static final String CLOBPAGE_COLUMN = "clobpage";
    public static final String CLOBVAL_COLUMN = "value";
    private ThreadLocal<Object> requestId = new ThreadLocal();
    private WeakHashMap<Object, Object> cancelRegistry = new WeakHashMap();
    private static final String BLACKLISTED = "Blacklisted";

    protected ObjectStoreInterMineImpl(Model model) {
        super(model);
    }

    protected ObjectStoreInterMineImpl(Database db, DatabaseSchema schema) {
        super(schema.getModel());
        this.db = db;
        this.schema = schema;
        ShutdownHook.registerObject(new WeakReference<ObjectStoreInterMineImpl>(this));
        this.limitedContext = new QueryOptimiserContext();
        this.limitedContext.setTimeLimit(this.getMaxTime() / 10L);
        this.description = "ObjectStoreInterMineImpl(" + db + ")";
    }

    @Override
    public ObjectStoreWriterInterMineImpl getNewWriter() throws ObjectStoreException {
        return new ObjectStoreWriterInterMineImpl(this);
    }

    public DatabaseSchema getSchema() {
        return this.schema;
    }

    public Database getDatabase() {
        return this.db;
    }

    public boolean everOptimise() {
        return true;
    }

    public Connection getConnection() throws SQLException {
        Connection retval = this.db.getConnection();
        if (!retval.getAutoCommit()) {
            retval.setAutoCommit(true);
        }
        return retval;
    }

    public void releaseConnection(Connection c) {
        if (c != null) {
            try {
                if (!c.getAutoCommit()) {
                    Exception e = new Exception();
                    e.fillInStackTrace();
                    LOG.warn((Object)("releaseConnection called while in transaction - rolling back." + System.getProperty("line.separator")), (Throwable)e);
                    c.rollback();
                    c.setAutoCommit(true);
                }
                c.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Could not release SQL connection " + c), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectStoreInterMineImpl getInstance(String osAlias, Properties props) throws ObjectStoreException {
        String dbAlias = props.getProperty("db");
        if (dbAlias == null) {
            throw new ObjectStoreException("No 'db' property specified for InterMine objectstore (" + osAlias + ")." + "Check properties file");
        }
        String missingTablesString = props.getProperty("missingTables");
        String truncatedClassesString = props.getProperty("truncatedClasses");
        String noNotXmlString = props.getProperty("noNotXml");
        String logfile = props.getProperty("logfile");
        String logTable = props.getProperty("logTable");
        String minBagTableSizeString = props.getProperty("minBagTableSize");
        String logEverythingString = props.getProperty("logEverything");
        String verboseQueryLogString = props.getProperty("verboseQueryLog");
        String logExplainsString = props.getProperty("logExplains");
        String logBeforeExecuteString = props.getProperty("logBeforeExecute");
        String disableResultsCacheString = props.getProperty("disableResultsCache");
        Map<String, ObjectStoreInterMineImpl> map = instances;
        synchronized (map) {
            ObjectStoreInterMineImpl os = instances.get(osAlias);
            if (os == null) {
                Model osModel;
                Database database;
                try {
                    database = DatabaseFactory.getDatabase(dbAlias);
                }
                catch (Exception e) {
                    throw new ObjectStoreException("Unable to get database for InterMine ObjectStore", e);
                }
                String versionString = null;
                int formatVersion = Integer.MAX_VALUE;
                try {
                    versionString = MetadataManager.retrieve(database, "osversion");
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Error retrieving database format version number", (Throwable)e);
                }
                if (versionString == null) {
                    formatVersion = 0;
                } else {
                    try {
                        formatVersion = Integer.parseInt(versionString);
                    }
                    catch (NumberFormatException e) {
                        NumberFormatException e2 = new NumberFormatException("Cannot parse database format version \"" + versionString + "\"");
                        e2.initCause(e);
                        throw e2;
                    }
                }
                if (formatVersion > 1) {
                    throw new IllegalArgumentException("Database version is too new for this code. Please update to a newer version of InterMine. Database version: " + formatVersion + ", latest supported version: 1");
                }
                try {
                    osModel = ObjectStoreInterMineImpl.getModelFromClasspath(osAlias, props);
                }
                catch (MetaDataException e) {
                    throw new ObjectStoreException("Cannot load model", e);
                }
                if (formatVersion >= 1) {
                    try {
                        truncatedClassesString = MetadataManager.retrieve(database, "truncatedClasses");
                        missingTablesString = MetadataManager.retrieve(database, "missingTables");
                        noNotXmlString = MetadataManager.retrieve(database, "noNotXml");
                    }
                    catch (SQLException e) {
                        throw new IllegalArgumentException("Couldn't retrieve embedded config for ObjectStore " + osAlias);
                    }
                    if (noNotXmlString == null) {
                        throw new IllegalArgumentException("Missing embedded config for ObjectStore " + osAlias);
                    }
                }
                ArrayList<ClassDescriptor> truncatedClasses = new ArrayList<ClassDescriptor>();
                if (truncatedClassesString != null) {
                    String[] classes = truncatedClassesString.split(",");
                    for (int i = 0; i < classes.length; ++i) {
                        ClassDescriptor truncatedClassDescriptor = osModel.getClassDescriptorByName(classes[i]);
                        if (truncatedClassDescriptor == null) {
                            throw new ObjectStoreException("Truncated class " + classes[i] + " does not exist in the model");
                        }
                        truncatedClasses.add(truncatedClassDescriptor);
                    }
                }
                boolean noNotXml = false;
                if ("true".equals(noNotXmlString) || noNotXmlString == null) {
                    noNotXml = true;
                } else if ("false".equals(noNotXmlString)) {
                    noNotXml = false;
                } else {
                    throw new ObjectStoreException("Invalid value for property noNotXml: " + noNotXmlString);
                }
                HashSet<String> missingTables = new HashSet<String>();
                if (missingTablesString != null) {
                    String[] tables = missingTablesString.split(",");
                    for (int i = 0; i < tables.length; ++i) {
                        missingTables.add(tables[i].toLowerCase());
                    }
                }
                boolean hasBioSeg = false;
                Connection c = null;
                try {
                    c = database.getConnection();
                    Statement s = c.createStatement();
                    s.execute("SELECT bioseg_create(1, 2)");
                    hasBioSeg = true;
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Database " + osAlias + " doesn't have bioseg"), (Throwable)e);
                }
                finally {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (SQLException e) {}
                    }
                }
                DatabaseSchema schema = new DatabaseSchema(osModel, truncatedClasses, noNotXml, missingTables, formatVersion, hasBioSeg);
                os = new ObjectStoreInterMineImpl(database, schema);
                os.description = osAlias;
                if (logfile != null) {
                    try {
                        FileWriter fw = new FileWriter(logfile, true);
                        BufferedWriter logWriter = new BufferedWriter(fw);
                        ShutdownHook.registerObject(logWriter);
                        os.setLog(logWriter);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error setting up execute log in file " + logfile + ": " + e));
                    }
                }
                if (logTable != null) {
                    try {
                        os.setLogTableName(logTable);
                    }
                    catch (SQLException e) {
                        LOG.warn((Object)("Error setting up execute log in database table " + logTable + ":" + e));
                    }
                }
                if (minBagTableSizeString != null) {
                    try {
                        int minBagTableSizeInt = Integer.parseInt(minBagTableSizeString);
                        os.setMinBagTableSize(minBagTableSizeInt);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn((Object)("Error setting minBagTableSize: " + e));
                    }
                }
                if ("true".equals(logEverythingString)) {
                    os.setLogEverything(true);
                }
                if ("true".equals(verboseQueryLogString)) {
                    os.setVerboseQueryLog(true);
                }
                if ("true".equals(logExplainsString)) {
                    os.setLogExplains(true);
                }
                if ("true".equals(logBeforeExecuteString)) {
                    os.setLogBeforeExecute(true);
                }
                if ("true".equals(disableResultsCacheString)) {
                    os.setDisableResultsCache(true);
                }
                instances.put(osAlias, os);
            }
            return os;
        }
    }

    public synchronized Writer getLog() {
        return this.log;
    }

    public synchronized void setLog(Writer log) {
        LOG.info((Object)("Setting log to " + log));
        this.log = log;
    }

    public synchronized void setLogTableName(String tableName) throws SQLException {
        try {
            if (this.logTableName != null) {
                this.logTableBatch.close(this.logTableConnection);
                this.releaseConnection(this.logTableConnection);
                this.logTableConnection = null;
                this.logTableBatch = null;
                this.logTableName = null;
            }
            if (tableName != null) {
                this.logTableConnection = this.getConnection();
                if (!DatabaseUtil.tableExists(this.logTableConnection, tableName)) {
                    this.logTableConnection.createStatement().execute("CREATE TABLE " + tableName + "(timestamp bigint, optimise bigint, estimated bigint, " + "execute bigint, permitted bigint, convert bigint, iql text, sql text)");
                }
                this.logTableBatch = new Batch(new BatchWriterPostgresCopyImpl());
                this.logTableName = tableName;
            }
        }
        catch (SQLException e) {
            this.logTableConnection = null;
            this.logTableBatch = null;
            this.logTableName = null;
            throw e;
        }
    }

    public void setLogEverything(boolean logEverything) {
        this.logEverything = logEverything;
    }

    public boolean getLogEverything() {
        return this.logEverything;
    }

    public void setVerboseQueryLog(boolean verboseQueryLog) {
        this.verboseQueryLog = verboseQueryLog;
    }

    public boolean getVerboseQueryLog() {
        return this.verboseQueryLog;
    }

    public void setLogExplains(boolean logExplains) {
        this.logExplains = logExplains;
    }

    public boolean getLogExplains() {
        return this.logExplains;
    }

    public void setLogBeforeExecute(boolean logBeforeExecute) {
        this.logBeforeExecute = logBeforeExecute;
    }

    public boolean getLogBeforeExecute() {
        return this.logBeforeExecute;
    }

    public void setDisableResultsCache(boolean disableResultsCache) {
        this.disableResultsCache = disableResultsCache;
    }

    public boolean getDisableResultsCache() {
        return this.disableResultsCache;
    }

    public synchronized void flushLogTable() {
        if (this.logTableName != null) {
            try {
                this.logTableBatch.flush(this.logTableConnection);
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to flush log entries to log table: " + e));
            }
        }
    }

    protected synchronized void dbLog(long optimise, long estimated, long execute, long permitted, long convert, Query q, String sql) {
        if (this.logTableName != null) {
            try {
                this.logTableBatch.addRow(this.logTableConnection, this.logTableName, null, LOG_TABLE_COLUMNS, new Object[]{new Long(System.currentTimeMillis()), new Long(optimise), new Long(estimated), new Long(execute), new Long(permitted), new Long(convert), q.toString(), sql});
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to write to log table: " + e));
            }
        }
    }

    public void setMinBagTableSize(int minBagTableSize) {
        this.minBagTableSize = minBagTableSize;
    }

    public int getMinBagTableSize() {
        return this.minBagTableSize;
    }

    @Override
    public Results execute(Query q) {
        return this.execute(q, 1000, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Results execute(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        String cacheKey = "Batchsize: " + batchSize + ", optimise: " + optimise + ", explain: " + explain + ", prefetch: " + prefetch + ", query: " + q;
        Map<String, Results> map = this.resultsCache;
        synchronized (map) {
            Results retval = this.resultsCache.get(cacheKey);
            if (retval != null) {
                try {
                    this.checkSequence(retval.getSequence(), null, null);
                }
                catch (DataChangedException e) {
                    retval = null;
                }
            }
            if (retval == null) {
                String batchesKey = q.toString();
                Map<String, Map<Integer, ResultsBatches>> map2 = this.batchesCache;
                synchronized (map2) {
                    ResultsBatches batch;
                    Map<Integer, ResultsBatches> batches = this.batchesCache.get(batchesKey);
                    if (batches == null) {
                        batches = new CacheMap<Integer, ResultsBatches>();
                        this.batchesCache.put(batchesKey, batches);
                    }
                    if ((batch = this.getResultsBatches(batches, batchSize)) != null) {
                        retval = new Results(batch, optimise, explain, prefetch);
                    } else {
                        retval = super.execute(q, batchSize, optimise, explain, prefetch);
                        batches.put(new Integer(batchSize), retval.getResultsBatches());
                    }
                    this.resultsCache.put(cacheKey, retval);
                }
            }
            return retval;
        }
    }

    @Override
    public SingletonResults executeSingleton(Query q) {
        return this.executeSingleton(q, 1000, true, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SingletonResults executeSingleton(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        String cacheKey = "Batchsize: " + batchSize + ", optimise: " + optimise + ", explain: " + explain + ", prefetch: " + prefetch + ", query: " + q;
        Map<String, SingletonResults> map = this.singletonResultsCache;
        synchronized (map) {
            SingletonResults retval = this.singletonResultsCache.get(cacheKey);
            if (retval != null) {
                try {
                    this.checkSequence(retval.getSequence(), null, null);
                }
                catch (DataChangedException e) {
                    retval = null;
                }
            }
            if (retval == null) {
                String batchesKey = q.toString();
                Map<String, Map<Integer, ResultsBatches>> map2 = this.batchesCache;
                synchronized (map2) {
                    ResultsBatches batch;
                    Map<Integer, ResultsBatches> batches = this.batchesCache.get(batchesKey);
                    if (batches == null) {
                        batches = new CacheMap<Integer, ResultsBatches>();
                        this.batchesCache.put(batchesKey, batches);
                    }
                    if ((batch = this.getResultsBatches(batches, batchSize)) != null) {
                        retval = new SingletonResults(batch, optimise, explain, prefetch);
                    } else {
                        retval = super.executeSingleton(q, batchSize, optimise, explain, prefetch);
                        batches.put(new Integer(batchSize), retval.getResultsBatches());
                    }
                    this.singletonResultsCache.put(cacheKey, retval);
                }
            }
            return retval;
        }
    }

    private ResultsBatches getResultsBatches(Map<Integer, ResultsBatches> batches, int batchSize) {
        ResultsBatches batch = batches.get(new Integer(batchSize));
        if (batch != null) {
            try {
                this.checkSequence(batch.getSequence(), null, null);
            }
            catch (DataChangedException e) {
                batch = null;
            }
        }
        if (batch == null) {
            int largestSize = 0;
            List<Object> firstBatch = null;
            for (Integer candidateSizeObj : batches.keySet()) {
                ResultsBatches candidateBatch = batches.get(candidateSizeObj);
                if (candidateBatch != null) {
                    try {
                        this.checkSequence(candidateBatch.getSequence(), null, null);
                    }
                    catch (DataChangedException e) {
                        candidateBatch = null;
                    }
                }
                if (candidateBatch == null) continue;
                int candidateSize = candidateBatch.getBatchSize();
                firstBatch = candidateBatch.getBatchFromCache(0);
                if (firstBatch != null) {
                    candidateSize += 10000000;
                }
                if (largestSize >= candidateSize) continue;
                batch = candidateBatch;
                largestSize = candidateSize;
            }
            if (batch != null) {
                batch = batch.makeWithDifferentBatchSize(batchSize);
                batches.put(new Integer(batchSize), batch);
            }
        }
        return batch;
    }

    public void registerRequestId(Object id) throws ObjectStoreException {
        if (this.requestId.get() != null) {
            throw new ObjectStoreException("This Thread is already registered with a request ID");
        }
        this.requestId.set(id);
    }

    public void deregisterRequestId(Object id) throws ObjectStoreException {
        if (!id.equals(this.requestId.get())) {
            throw new ObjectStoreException("This Thread is not registered with ID " + id);
        }
        this.requestId.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerStatement(Statement s) throws ObjectStoreException {
        Object id = this.requestId.get();
        if (id != null) {
            WeakHashMap<Object, Object> weakHashMap = this.cancelRegistry;
            synchronized (weakHashMap) {
                Object statement = this.cancelRegistry.get(id);
                if (statement == BLACKLISTED) {
                    throw new ObjectStoreException("Request id " + id + " is cancelled");
                }
                if (statement != null) {
                    throw new ObjectStoreException("Request id " + id + " is currently being" + " serviced in another thread. Don't share request IDs over multiple" + " threads!");
                }
                this.cancelRegistry.put(id, s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(Object id) throws ObjectStoreException {
        WeakHashMap<Object, Object> weakHashMap = this.cancelRegistry;
        synchronized (weakHashMap) {
            try {
                Object statement = this.cancelRegistry.get(id);
                if (statement instanceof Statement) {
                    ((Statement)statement).cancel();
                }
            }
            catch (SQLException e) {
                throw new ObjectStoreException("Statement cancel failed", e);
            }
            finally {
                this.cancelRegistry.put(id, BLACKLISTED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterStatement(Statement s) throws ObjectStoreException {
        Object id = this.requestId.get();
        if (id != null) {
            WeakHashMap<Object, Object> weakHashMap = this.cancelRegistry;
            synchronized (weakHashMap) {
                Object statement = this.cancelRegistry.get(id);
                if (statement != BLACKLISTED && statement != s) {
                    throw new ObjectStoreException("The current thread does not have this statement registered");
                }
                if (statement == s) {
                    this.cancelRegistry.remove(id);
                }
            }
        }
    }

    @Override
    public List<ResultsRow<Object>> execute(Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        ConstraintSet where2;
        Constraint where = q.getConstraint();
        if (where instanceof ConstraintSet && (where2 = (ConstraintSet)where).getConstraints().isEmpty() && (ConstraintOp.NAND.equals(where2.getOp()) || ConstraintOp.OR.equals(where2.getOp()))) {
            return Collections.emptyList();
        }
        Connection c = null;
        try {
            c = this.getConnection();
            List<ResultsRow<Object>> list = this.executeWithConnection(c, q, start, limit, optimise, explain, sequence);
            return list;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.doFinalise();
    }

    protected synchronized void doFinalise() {
        LOG.error((Object)("Garbage collecting ObjectStoreInterMineImpl with sequence = " + this.sequenceNumber + " and Database " + this.getDatabase().getURL()));
        try {
            this.close();
        }
        catch (ObjectStoreException e) {
            LOG.error((Object)("Exception while garbage-collecting ObjectStoreInterMineImpl: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws ObjectStoreException {
        LOG.info((Object)("Close called on ObjectStoreInterMineImpl with sequence = " + this.sequenceNumber + ", time spent: Bag Tables: " + this.statsBagTableTime + ", SQL Gen: " + this.statsGenTime + ", SQL Optimise: " + this.statsOptTime + ", Estimate: " + this.statsEstTime + ", Execute: " + this.statsExeTime + ", Results Convert: " + this.statsConTime));
        this.flushLogTable();
        Connection c = null;
        try {
            c = this.getConnection();
            LOG.info((Object)("Temporary tables to drop: " + this.bagTablesInDatabase));
            Iterator<BagTableToRemove> iter = this.bagTablesInDatabase.iterator();
            while (iter.hasNext()) {
                BagTableToRemove bttr = iter.next();
                try {
                    c.createStatement().execute(bttr.getDropSql());
                    LOG.info((Object)("Closing objectstore - dropped temporary table: " + bttr.getDropSql()));
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Failed to drop temporary bag table: " + bttr.getDropSql() + ", continuing"));
                }
                iter.remove();
            }
            this.flushOldTempBagTables(c);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to drop temporary bag tables: " + e));
        }
        finally {
            if (c != null) {
                this.releaseConnection(c);
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        LOG.info((Object)("Shutting down open ObjectStoreInterMineImpl with sequence = " + this.sequenceNumber + " and Database " + this.getDatabase().getURL()));
        try {
            this.close();
        }
        catch (ObjectStoreException e) {
            LOG.warn((Object)("Exception caught while shutting down ObjectStoreInterMineImpl: " + e));
        }
    }

    protected List<ResultsRow<Object>> executeWithConnection(Connection c, Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        return this.executeWithConnection(c, q, start, limit, optimise, explain, sequence, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ResultsRow<Object>> executeWithConnection(Connection c, Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence, Set<PrecomputedTable> goFasterTables, OptimiserCache goFasterCache) throws ObjectStoreException {
        String sql;
        if (explain) {
            this.checkStartLimit(start, limit, q);
        }
        this.checkSequence(sequence, q, "Execute (START " + start + " LIMIT " + limit + ") ");
        long preBagTableTime = System.currentTimeMillis();
        if (this.getMinBagTableSize() != -1) {
            this.createTempBagTables(c, q);
            this.flushOldTempBagTables(c);
        }
        long preGenTime = System.currentTimeMillis();
        try {
            sql = SqlGenerator.generate(q, start, limit, this.schema, this.db, this.bagConstraintTables);
        }
        catch (CompletelyFalseException e) {
            return Collections.emptyList();
        }
        String generatedSql = sql;
        try {
            Object firstOrderByObject;
            ResultSet sqlResults;
            long estimatedTime = 0L;
            long startOptimiseTime = System.currentTimeMillis();
            ExplainResult explainResult = null;
            if (optimise && this.everOptimise()) {
                BestQuery bestQuery;
                if (goFasterTables == null) {
                    goFasterTables = this.goFasterMap.get(q);
                    goFasterCache = this.goFasterCacheMap.get(q);
                }
                if (goFasterTables != null) {
                    bestQuery = QueryOptimiser.optimiseWith(sql, null, this.db, c, QueryOptimiserContext.DEFAULT, goFasterTables, goFasterCache);
                    if (sql.equals(bestQuery.getBestQueryString())) {
                        LOG.warn((Object)("Query with goFaster failed to optimise: original = " + sql + ", goFasterTables = " + goFasterTables));
                    }
                } else {
                    bestQuery = QueryOptimiser.optimise(sql, null, this.db, c, explain ? this.limitedContext : QueryOptimiserContext.DEFAULT);
                }
                sql = bestQuery.getBestQueryString();
                if (bestQuery instanceof BestQueryExplainer) {
                    explainResult = ((BestQueryExplainer)bestQuery).getBestExplainResult();
                }
            }
            long endOptimiseTime = System.currentTimeMillis();
            if (explain) {
                if (explainResult == null) {
                    explainResult = ExplainResult.getInstance(sql, c);
                }
                estimatedTime = explainResult.getTime();
                if (explainResult.getTime() > this.getMaxTime()) {
                    throw new ObjectStoreQueryDurationException("Estimated time to run query(" + explainResult.getTime() + ") greater than permitted maximum (" + this.getMaxTime() + "): IQL query: " + q + ", SQL query: " + sql);
                }
            }
            if (this.getLogBeforeExecute()) {
                SQLLOGGER.info((Object)("(BEFORE EXECUTE) iql: " + q + "\n" + "generated sql: " + generatedSql + "\n" + "optimised sql: " + sql));
            }
            long preExecute = System.currentTimeMillis();
            Statement s = c.createStatement();
            this.registerStatement(s);
            try {
                sqlResults = s.executeQuery(sql);
            }
            finally {
                this.deregisterStatement(s);
            }
            long postExecute = System.currentTimeMillis();
            ExtraQueryTime extra = new ExtraQueryTime();
            List<ResultsRow<Object>> objResults = ResultsConverter.convert(sqlResults, q, this, c, sequence, optimise, extra, goFasterTables, goFasterCache);
            long postConvert = System.currentTimeMillis();
            long permittedTime = objResults.size() * 2 + start + 150 * q.getFrom().size() + sql.length() / 20 - (q.getFrom().size() == 0 ? 0 : 100);
            boolean doneExplainLog = false;
            if (postExecute - preExecute > permittedTime) {
                LOG.debug((Object)(this.getModel().getName() + ": Executed SQL (time = " + (postExecute - preExecute) + " > " + permittedTime + ", rows = " + objResults.size() + "): " + sql));
                if (this.getLogExplains()) {
                    doneExplainLog = true;
                    if (explainResult == null) {
                        explainResult = ExplainResult.getInstance(sql, c);
                    }
                    if (explainResult instanceof PostgresExplainResult) {
                        LOG.debug((Object)("EXPLAIN result: " + ((PostgresExplainResult)explainResult).getExplainText()));
                    }
                }
            }
            if (estimatedTime > 0L || this.getLogEverything()) {
                Writer executeLog = this.getLog();
                if (executeLog != null) {
                    try {
                        executeLog.write("EXECUTE\toptimise: " + (endOptimiseTime - startOptimiseTime) + "\testimated: " + estimatedTime + "\texecute: " + (postExecute - preExecute) + "\tpermitted: " + permittedTime + "\tconvert: " + (postConvert - postExecute) + "\t" + q + "\t" + sql + "\n");
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Error writing to execute log " + e));
                    }
                }
                this.dbLog(endOptimiseTime - startOptimiseTime, estimatedTime, postExecute - preExecute, permittedTime, postConvert - postExecute, q, sql);
            }
            long bagTableTime = preGenTime - preBagTableTime;
            this.statsBagTableTime += bagTableTime;
            long genTime = startOptimiseTime - preGenTime;
            this.statsGenTime += genTime;
            long optTime = endOptimiseTime - startOptimiseTime;
            this.statsOptTime += optTime;
            long estTime = preExecute - endOptimiseTime;
            this.statsEstTime += estTime;
            long exeTime = postExecute - preExecute;
            this.statsExeTime += exeTime;
            long conTime = postConvert - postExecute - extra.getQueryTime();
            this.statsConTime += conTime;
            if (this.getVerboseQueryLog()) {
                SQLLOGGER.info((Object)("(VERBOSE) iql: " + q + "\n" + "generated sql: " + generatedSql + "\n" + "optimised sql: " + sql + "\n" + "bag tables: " + bagTableTime + " ms, generate: " + genTime + " ms, optimise: " + optTime + " ms, " + " ms,  estimate: " + estTime + " ms, " + "execute: " + exeTime + " ms, convert results: " + conTime + " ms, extra queries: " + extra.getQueryTime() + " ms, total: " + (postConvert - preBagTableTime) + " ms" + ", rows: " + objResults.size()));
                if (this.getLogExplains() && !doneExplainLog) {
                    if (explainResult == null) {
                        explainResult = ExplainResult.getInstance(sql, c);
                    }
                    if (explainResult instanceof PostgresExplainResult) {
                        SQLLOGGER.info((Object)("EXPLAIN result: " + ((PostgresExplainResult)explainResult).getExplainText()));
                    }
                }
            }
            if ((firstOrderByObject = q.getEffectiveOrderBy().iterator().next()) instanceof QueryOrderable && !(firstOrderByObject instanceof QueryObjectReference)) {
                QueryOrderable firstOrderBy = (QueryOrderable)firstOrderByObject;
                if (firstOrderBy instanceof OrderDescending) {
                    firstOrderBy = ((OrderDescending)firstOrderBy).getQueryOrderable();
                }
                if (q.getSelect().contains(firstOrderBy) && objResults.size() > 1) {
                    int colNo = q.getSelect().indexOf(firstOrderBy);
                    int rowNo = objResults.size() - 1;
                    Object lastObj = objResults.get(rowNo).get(colNo);
                    --rowNo;
                    boolean done = false;
                    while (!done && rowNo >= 0) {
                        Object thisObj = objResults.get(rowNo).get(colNo);
                        if (lastObj != null && thisObj != null && !lastObj.equals(thisObj)) {
                            done = true;
                            Object value = thisObj instanceof InterMineObject ? ((InterMineObject)thisObj).getId() : thisObj;
                            SqlGenerator.registerOffset(q, start + rowNo + 1, this.schema, this.db, value, this.bagConstraintTables);
                        }
                        --rowNo;
                    }
                }
            }
            return objResults;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Problem running SQL statement \"" + sql + "\" while executing query \"" + q + "\"", e);
        }
        catch (RuntimeException e) {
            throw new ObjectStoreException("Problem executing query \"" + q + "\"", e);
        }
    }

    public String generateSql(Query q) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            String string = this.generateSql(c, q, 0, Integer.MAX_VALUE);
            return string;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Failed to get connection", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected String generateSql(Connection c, Query q, int start, int limit) throws ObjectStoreException {
        if (this.getMinBagTableSize() != -1) {
            this.createTempBagTables(c, q);
            this.flushOldTempBagTables(c);
        }
        return SqlGenerator.generate(q, start, limit, this.schema, this.db, this.bagConstraintTables);
    }

    protected void createTempBagTables(Connection c, Query q) throws ObjectStoreException {
        final ArrayList bagConstraints = new ArrayList();
        ConstraintHelper.traverseConstraints(q.getConstraint(), new ConstraintTraverseAction(){

            @Override
            public void apply(Constraint constraint) {
                if (constraint instanceof BagConstraint) {
                    BagConstraint bagConstraint = (BagConstraint)constraint;
                    if (bagConstraint.getBag() != null) {
                        bagConstraints.add(bagConstraint);
                    }
                } else if (constraint instanceof MultipleInBagConstraint) {
                    bagConstraints.add((ConstraintWithBag)((Object)constraint));
                }
            }
        });
        boolean wasNotInTransaction = false;
        try {
            wasNotInTransaction = c.getAutoCommit();
            if (wasNotInTransaction) {
                c.setAutoCommit(false);
            }
            String queryString = null;
            for (ConstraintWithBag bagConstraint : bagConstraints) {
                Collection<?> bag;
                if (this.bagConstraintTables.containsKey(bagConstraint) || (bag = bagConstraint.getBag()).size() < this.getMinBagTableSize()) continue;
                if (queryString == null) {
                    queryString = q.getIqlQuery().getQueryString();
                }
                this.createTempBagTable(c, bagConstraint, true, queryString);
            }
            for (FromElement fe : q.getFrom()) {
                Set<Integer> bag;
                QueryClassBag qcb;
                if (!(fe instanceof QueryClassBag) || this.bagConstraintTables.containsKey(qcb = (QueryClassBag)fe) || (bag = qcb.getIds()) == null || bag.size() < this.getMinBagTableSize()) continue;
                if (queryString == null) {
                    queryString = q.getIqlQuery().getQueryString();
                }
                this.createTempBagTable(c, qcb, true, queryString);
            }
            if (wasNotInTransaction) {
                c.commit();
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException("database error while creating temporary table for bag", e);
        }
        finally {
            try {
                if (wasNotInTransaction) {
                    c.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                throw new ObjectStoreException("database error while creating temporary table for bag", e);
            }
        }
    }

    public void createTempBagTable(ConstraintWithBag bagConstraint) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.createTempBagTable(c, bagConstraint, false, null);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected BagTableToRemove createTempBagTable(Connection c, ConstraintWithBag bagConstraint, boolean log, String text) throws SQLException {
        Class<?> type = bagConstraint instanceof BagConstraint ? ((BagConstraint)bagConstraint).getQueryNode().getType() : ((MultipleInBagConstraint)bagConstraint).getEvaluables().iterator().next().getType();
        String tableName = TypeUtil.unqualifiedName(type.getName()) + "_bag_" + this.getUniqueInteger(c);
        if (log) {
            LOG.info((Object)("Creating temporary table " + tableName + " of size " + bagConstraint.getBag().size() + " for " + text));
        }
        DatabaseUtil.createBagTable(this.db, c, tableName, bagConstraint.getBag(), type);
        this.bagConstraintTables.put(bagConstraint, tableName);
        BagTableToRemove bagTableToRemove = new BagTableToRemove(tableName, this.bagTablesToRemove);
        this.bagTablesInDatabase.add(bagTableToRemove);
        return bagTableToRemove;
    }

    protected BagTableToRemove createTempBagTable(Connection c, QueryClassBag qcb, boolean log, String text) throws SQLException {
        String tableName = "Integer_bag_" + this.getUniqueInteger(c);
        if (log) {
            LOG.info((Object)("Creating temporary table " + tableName + " of size " + qcb.getIds().size() + " for " + text));
        }
        DatabaseUtil.createBagTable(this.db, c, tableName, qcb.getIds(), Integer.class);
        this.bagConstraintTables.put(qcb, tableName);
        BagTableToRemove bagTableToRemove = new BagTableToRemove(tableName, this.bagTablesToRemove);
        this.bagTablesInDatabase.add(bagTableToRemove);
        return bagTableToRemove;
    }

    public synchronized void flushOldTempBagTables(Connection c) {
        BagTableToRemove bttr = (BagTableToRemove)this.bagTablesToRemove.poll();
        while (bttr != null) {
            if (this.bagTablesInDatabase.contains(bttr)) {
                this.removeTempBagTable(c, bttr);
                LOG.info((Object)("Dropped unreachable temporary table: " + bttr.getDropSql()));
            }
            bttr = (BagTableToRemove)this.bagTablesToRemove.poll();
        }
    }

    protected synchronized void removeTempBagTable(Connection c, BagTableToRemove bttr) {
        if (this.bagTablesInDatabase.contains(bttr)) {
            try {
                c.createStatement().execute(bttr.getDropSql());
            }
            catch (SQLException e) {
                LOG.warn((Object)("Failed to drop temporary bag table: " + bttr.getDropSql() + ", continuing"));
            }
            this.bagTablesInDatabase.remove(bttr);
        }
    }

    @Override
    public ResultsInfo estimate(Query q) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            ResultsInfo resultsInfo = this.estimateWithConnection(c, q);
            return resultsInfo;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    protected ResultsInfo estimateWithConnection(Connection c, Query q) throws ObjectStoreException {
        String sql;
        try {
            sql = this.generateSql(c, q, 0, Integer.MAX_VALUE);
        }
        catch (CompletelyFalseException e) {
            return new ResultsInfo(0L, 0L, 0, 0, 0);
        }
        try {
            if (this.everOptimise()) {
                sql = QueryOptimiser.optimise(sql, null, this.db, c, QueryOptimiserContext.DEFAULT).getBestQueryString();
            }
            ExplainResult explain = ExplainResult.getInstance(sql, c);
            return new ResultsInfo(explain.getStart(), explain.getComplete(), (int)explain.getEstimatedRows());
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Problem explaining SQL statement \"" + sql + "\" for query \"" + q + "\"", e);
        }
    }

    @Override
    public int count(Query q, Map<Object, Integer> sequence) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            int n = this.countWithConnection(c, q, sequence);
            return n;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int countWithConnection(Connection c, Query q, Map<Object, Integer> sequence) throws ObjectStoreException {
        this.checkSequence(sequence, q, "COUNT ");
        String sql = null;
        try {
            ResultSet sqlResults;
            if (q.getSelect().size() == 1 && q.getSelect().get(0) instanceof Clob) {
                Clob clob = (Clob)q.getSelect().get(0);
                sql = "SELECT MAX(clobpage) + 1 AS a1_ FROM clob WHERE clobid = " + clob.getClobId();
            } else {
                sql = this.generateSql(c, q, 0, Integer.MAX_VALUE);
                if (this.everOptimise()) {
                    sql = QueryOptimiser.optimise(sql, null, this.db, c, QueryOptimiserContext.DEFAULT).getBestQueryString();
                }
                sql = "SELECT COUNT(*) FROM (" + sql + ") as fake_table";
            }
            Statement s = c.createStatement();
            this.registerStatement(s);
            try {
                sqlResults = s.executeQuery(sql);
            }
            finally {
                this.deregisterStatement(s);
            }
            sqlResults.next();
            return sqlResults.getInt(1);
        }
        catch (CompletelyFalseException e) {
            return 0;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Problem counting SQL statement \"" + sql + "\"", e);
        }
    }

    public void databaseAltered(Set<Object> tablesAltered) {
        if (tablesAltered.size() > 0) {
            this.changeSequence(tablesAltered);
            HashSet<String> tableNames = new HashSet<String>();
            for (Object o : tablesAltered) {
                if (!(o instanceof String)) continue;
                tableNames.add((String)o);
            }
            if (tablesAltered.size() > 1 || !tablesAltered.contains(INT_BAG_TABLE_NAME)) {
                this.flushObjectById();
            }
            try {
                PrecomputedTableManager ptm = PrecomputedTableManager.getInstance(this.db);
                ptm.dropAffected(tableNames);
            }
            catch (SQLException e) {
                throw new Error("Problem with precomputed tables", e);
            }
        }
    }

    @Override
    public void flushObjectById() {
        super.flushObjectById();
        for (ObjectStoreWriterInterMineImpl writer : this.writers) {
            if (writer == this) continue;
            writer.flushObjectById();
        }
    }

    @Override
    protected InterMineObject internalGetObjectById(Integer id, Class<? extends InterMineObject> clazz) throws ObjectStoreException {
        if (this.schema.isFlatMode(clazz)) {
            return super.internalGetObjectById(id, clazz);
        }
        Connection c = null;
        try {
            c = this.getConnection();
            InterMineObject interMineObject = this.internalGetObjectByIdWithConnection(c, id, clazz);
            return interMineObject;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InterMineObject internalGetObjectByIdWithConnection(Connection c, Integer id, Class<?> clazz) throws ObjectStoreException {
        String sql = SqlGenerator.generateQueryForId(id, clazz, this.schema);
        String currentColumn = null;
        try {
            ResultSet sqlResults;
            Statement s = c.createStatement();
            this.registerStatement(s);
            try {
                sqlResults = s.executeQuery(sql);
            }
            finally {
                this.deregisterStatement(s);
            }
            if (sqlResults.next()) {
                currentColumn = sqlResults.getString("a1_");
                if (sqlResults.next()) {
                    throw new ObjectStoreException("More than one object in the database has this primary key");
                }
                InterMineObject retval = NotXmlParser.parse(currentColumn, this);
                this.cacheObjectById(retval.getId(), retval);
                return retval;
            }
            return null;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Problem running SQL statement \"" + sql + "\"", e);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectStoreException("Unknown class mentioned in database OBJECT field while converting results: " + currentColumn, e);
        }
    }

    @Override
    public boolean isMultiConnection() {
        return true;
    }

    public List<String> precompute(Query q, String category) throws ObjectStoreException {
        return this.precompute(q, null, false, category);
    }

    public List<String> precompute(Query q, boolean allFields, String category) throws ObjectStoreException {
        return this.precompute(q, null, allFields, category);
    }

    public List<String> precompute(Query q, Collection<? extends QueryNode> indexes, String category) throws ObjectStoreException {
        return this.precompute(q, indexes, false, category);
    }

    public List<String> precompute(Query q, Collection<? extends QueryNode> indexes, boolean allFields, String category) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            List<String> list = this.precomputeWithConnection(c, q, indexes, allFields, category);
            return list;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public List<String> precomputeWithConnection(Connection c, Query q, Collection<? extends QueryNode> indexes, boolean allFields, String category) throws ObjectStoreException {
        QueryOrderable qn = null;
        String sql = null;
        try {
            int tableNumber = this.getUniqueInteger(c);
            if (this.getMinBagTableSize() != -1) {
                this.createTempBagTables(c, q);
                this.flushOldTempBagTables(c);
            }
            Map<Object, String> empty = Collections.emptyMap();
            sql = allFields ? SqlGenerator.generate(q, this.schema, this.db, null, 4, empty) : SqlGenerator.generate(q, this.schema, this.db, null, 6, empty);
            PrecomputedTable pt = new PrecomputedTable(new org.intermine.sql.query.Query(sql), sql, "precomp_" + tableNumber, category, c);
            HashSet<String> stringIndexes = new HashSet<String>();
            Map<Object, String> aliases = q.getAliases();
            if (indexes != null && !indexes.isEmpty()) {
                String all = null;
                try {
                    Iterator<? extends QueryNode> i$ = indexes.iterator();
                    while (i$.hasNext()) {
                        QueryNode qNode;
                        qn = qNode = i$.next();
                        String alias = DatabaseUtil.generateSqlCompatibleName(aliases.get(qn));
                        if (qn instanceof QueryClass) {
                            alias = alias + "id";
                        } else if (qn instanceof QueryField && String.class.equals(((QueryField)qn).getType())) {
                            alias = "lower(" + alias + ")";
                        }
                        if (all == null) {
                            all = alias;
                            continue;
                        }
                        stringIndexes.add(alias);
                        all = all + ", " + alias;
                    }
                }
                catch (NullPointerException e) {
                    throw new ObjectStoreException("QueryNode " + qn + " (to be indexed) is not" + " present in the SELECT list of query " + q + " - note that the exact same object needs to be present, not just an " + "equivalent object, as the Aliases Map of Query is an " + "IdentityHashMap", e);
                }
                stringIndexes.add(all);
            } else if (allFields && indexes == null) {
                for (QuerySelectable qs : q.getSelect()) {
                    String alias = DatabaseUtil.generateSqlCompatibleName(q.getAliases().get(qs).toLowerCase());
                    if (qs instanceof QueryClass) {
                        Collection<FieldDescriptor> fields = this.model.getFieldDescriptorsForClass(qs.getType()).values();
                        Map<String, TypeUtil.FieldInfo> fieldInfos = TypeUtil.getFieldInfos(qs.getType());
                        for (FieldDescriptor field : fields) {
                            String fieldAlias;
                            String fieldName = field.getName();
                            Class<?> fieldType = fieldInfos.get(fieldName).getType();
                            if (InterMineObject.class.isAssignableFrom(fieldType)) {
                                fieldAlias = DatabaseUtil.getColumnName(field).toLowerCase();
                                stringIndexes.add(alias + fieldAlias);
                                continue;
                            }
                            if (String.class.isAssignableFrom(fieldType)) {
                                fieldAlias = DatabaseUtil.getColumnName(field).toLowerCase();
                                stringIndexes.add(alias + fieldAlias);
                                stringIndexes.add("lower(" + alias + fieldAlias + ")");
                                continue;
                            }
                            if (Collection.class.isAssignableFrom(fieldType)) continue;
                            fieldAlias = DatabaseUtil.getColumnName(field).toLowerCase();
                            stringIndexes.add(alias + fieldAlias);
                        }
                        continue;
                    }
                    stringIndexes.add(alias);
                    if (!String.class.equals(qs.getType())) continue;
                    stringIndexes.add("lower(" + alias + ")");
                }
            }
            StringBuilder orderIndex = new StringBuilder();
            boolean needComma = false;
            for (QueryOrderable orderElement : q.getOrderBy()) {
                if (orderElement instanceof OrderDescending) {
                    orderElement = ((OrderDescending)orderElement).getQueryOrderable();
                }
                qn = orderElement;
                String alias = aliases.get(orderElement);
                if (alias == null) {
                    throw new ObjectStoreException("QueryNode " + qn + " (to be indexed) is not" + " present in the SELECT list of query " + q + " - note that the exact same object needs to be present, not just an " + "equivalent object, as the Aliases Map of Query is an " + "IdentityHashMap");
                }
                alias = DatabaseUtil.generateSqlCompatibleName(alias);
                if (orderElement instanceof QueryClass) {
                    alias = alias + "id";
                } else if (orderElement instanceof QueryField && String.class.equals(((QueryField)orderElement).getType())) {
                    alias = "lower(" + alias + ")";
                }
                if (needComma) {
                    orderIndex.append(", ");
                }
                needComma = true;
                orderIndex.append(alias);
            }
            if (needComma) {
                stringIndexes.add(orderIndex.toString());
            }
            LOG.info((Object)("Creating precomputed table for query " + q + " with indexes " + stringIndexes));
            PrecomputedTableManager ptm = PrecomputedTableManager.getInstance(this.db);
            ArrayList<String> retval = new ArrayList<String>();
            try {
                ptm.add(pt, stringIndexes);
                retval.add(pt.getName());
            }
            catch (IllegalArgumentException e) {
                LOG.info((Object)("Precomputed table for " + sql + " already exists"));
            }
            for (QuerySelectable qs : q.getSelect()) {
                Query subQ;
                if (qs instanceof QueryCollectionPathExpression) {
                    subQ = ((QueryCollectionPathExpression)qs).getQuery(null);
                    if (subQ.getConstraint() == null) continue;
                    retval.addAll(this.precomputeWithConnection(c, subQ, Collections.singleton((QueryNode)subQ.getSelect().get(0)), allFields, category));
                    continue;
                }
                if (!(qs instanceof QueryObjectPathExpression) || (subQ = ((QueryObjectPathExpression)qs).getQuery(null, this.getSchema().isMissingNotXml())).getConstraint() == null) continue;
                retval.addAll(this.precomputeWithConnection(c, subQ, Collections.singleton((QueryNode)subQ.getSelect().get(0)), allFields, category));
            }
            return retval;
        }
        catch (SQLException e) {
            throw new ObjectStoreException(e);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error", (Throwable)e);
            throw new ObjectStoreException("Query SQL cannot be parsed, so cannot be precomputed: " + sql + ", IQL: " + q, e);
        }
    }

    public boolean isPrecomputed(Query query, String type) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            boolean bl = this.isPrecomputedWithConnection(c, query, type);
            return bl;
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    public boolean isPrecomputedWithConnection(Connection c, Query query, String type) throws ObjectStoreException, SQLException {
        String sqlQuery;
        PrecomputedTableManager ptm = PrecomputedTableManager.getInstance(this.db);
        return ptm.lookupSql(type, sqlQuery = this.generateSql(c, query, 0, Integer.MAX_VALUE)) != null;
    }

    public void goFaster(Query q) throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            this.goFasterWithConnection(q, c);
        }
        catch (SQLException e) {
            throw new ObjectStoreException("Could not get connection to database", e);
        }
        finally {
            this.releaseConnection(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goFasterWithConnection(Query q, Connection c) throws ObjectStoreException {
        Query query = q;
        synchronized (query) {
            Map<Query, Set<PrecomputedTable>> map = this.goFasterMap;
            synchronized (map) {
                if (this.goFasterMap.containsKey(q)) {
                    int goFasterCount = this.goFasterCountMap.get(q);
                    this.goFasterCountMap.put(q, new Integer(++goFasterCount));
                    return;
                }
            }
            PrecomputedTableManager ptm = null;
            try {
                ptm = PrecomputedTableManager.getInstance(this.db);
            }
            catch (SQLException e) {
                throw new ObjectStoreException(e);
            }
            ArrayList<String> tablesToDrop = new ArrayList<String>();
            try {
                try {
                    String sql;
                    PrecomputedTable pt;
                    if (this.getMinBagTableSize() != -1) {
                        this.createTempBagTables(c, q);
                        this.flushOldTempBagTables(c);
                    }
                    if ((pt = ptm.lookupSql(sql = SqlGenerator.generate(q, this.schema, this.db, null, 6, this.bagConstraintTables))) == null) {
                        pt = new PrecomputedTable(new org.intermine.sql.query.Query(sql), sql, "temporary_precomp_" + this.getUniqueInteger(c), "goFaster", c);
                        ptm.addTableToDatabase(pt, new HashSet<String>(), false);
                        tablesToDrop.add(pt.getName());
                    }
                    HashSet<PrecomputedTable> pts = new HashSet<PrecomputedTable>();
                    pts.add(pt);
                    for (QuerySelectable qs : q.getSelect()) {
                        PrecomputedTable subPt;
                        Query subQ;
                        if (qs instanceof QueryCollectionPathExpression) {
                            subQ = ((QueryCollectionPathExpression)qs).getQuery(null);
                            if (subQ.getFrom().size() > 1 && subQ.getConstraint() == null) {
                                LOG.error((Object)("Software bug - we are being asked to precompute a cross join for query " + q + ". Cross join: " + subQ));
                                continue;
                            }
                            if (subQ.getConstraint() == null) continue;
                            sql = SqlGenerator.generate(subQ, this.schema, this.db, null, 6, this.bagConstraintTables);
                            subPt = ptm.lookupSql(sql);
                            if (subPt == null) {
                                subPt = new PrecomputedTable(new org.intermine.sql.query.Query(sql), sql, "temporary_precomp_" + this.getUniqueInteger(c), "goFaster", c);
                                ptm.addTableToDatabase(subPt, new HashSet<String>(), false);
                                tablesToDrop.add(subPt.getName());
                            }
                            pts.add(subPt);
                            continue;
                        }
                        if (!(qs instanceof QueryObjectPathExpression)) continue;
                        subQ = ((QueryObjectPathExpression)qs).getQuery(null, this.getSchema().isMissingNotXml());
                        if (subQ.getFrom().size() > 1 && subQ.getConstraint() == null) {
                            LOG.error((Object)("Software bug - we are being asked to precompute a cross join for query " + q + ". Cross join: " + subQ));
                            continue;
                        }
                        if (subQ.getConstraint() == null) continue;
                        sql = SqlGenerator.generate(subQ, this.schema, this.db, null, 6, this.bagConstraintTables);
                        subPt = ptm.lookupSql(sql);
                        if (subPt == null) {
                            subPt = new PrecomputedTable(new org.intermine.sql.query.Query(sql), sql, "temporary_precomp_" + this.getUniqueInteger(c), "goFaster", c);
                            ptm.addTableToDatabase(subPt, new HashSet<String>(), false);
                            tablesToDrop.add(subPt.getName());
                        }
                        pts.add(subPt);
                    }
                    Map<Query, Set<PrecomputedTable>> i$ = this.goFasterMap;
                    synchronized (i$) {
                        this.goFasterMap.put(q, pts);
                        this.goFasterCacheMap.put(q, new OptimiserCache());
                        this.goFasterCountMap.put(q, new Integer(1));
                    }
                }
                catch (SQLException e) {
                    throw new ObjectStoreException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new ObjectStoreException(e);
                }
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Error creating goFaster tables - dropping tables " + tablesToDrop), (Throwable)e);
                for (String tableToDrop : tablesToDrop) {
                    try {
                        ptm.deleteTableFromDatabase(tableToDrop);
                    }
                    catch (SQLException e2) {
                        LOG.error((Object)("Error deleting partially-created goFaster table " + tableToDrop), (Throwable)e2);
                    }
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseGoFaster(Query q) throws ObjectStoreException {
        try {
            Map<Query, Set<PrecomputedTable>> map = this.goFasterMap;
            synchronized (map) {
                if (this.goFasterMap.containsKey(q)) {
                    int goFasterCount = this.goFasterCountMap.get(q);
                    if (--goFasterCount == 0) {
                        Set<PrecomputedTable> pts = this.goFasterMap.remove(q);
                        this.goFasterCacheMap.remove(q);
                        this.goFasterCountMap.remove(q);
                        if (pts != null) {
                            PrecomputedTableManager ptm = PrecomputedTableManager.getInstance(this.db);
                            for (PrecomputedTable pt : pts) {
                                if (pt == null) {
                                    LOG.warn((Object)("Null PrecomputedTable in GoFaster Map " + pts));
                                    continue;
                                }
                                if (!"goFaster".equals(pt.getCategory())) continue;
                                ptm.deleteTableFromDatabase(pt.getName());
                            }
                        }
                    } else {
                        this.goFasterCountMap.put(q, new Integer(goFasterCount));
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new ObjectStoreException(e);
        }
    }

    public int getUniqueInteger(Connection c) throws SQLException {
        Statement s = c.createStatement();
        ResultSet r = s.executeQuery("SELECT nextval('objectstore_unique_integer')");
        if (!r.next()) {
            throw new RuntimeException("No result while attempting to get a unique integer from objectstore_unique_integer");
        }
        return r.getInt(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getSerial() throws ObjectStoreException {
        Connection c = null;
        try {
            c = this.getConnection();
            Integer n = this.getSerialWithConnection(c);
            this.releaseConnection(c);
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.releaseConnection(c);
                throw throwable;
            }
            catch (SQLException e) {
                throw new ObjectStoreException("Error generating serial number", e);
            }
        }
    }

    protected Integer getSerialWithConnection(Connection c) throws SQLException {
        if (this.sequenceOffset >= 1000000) {
            long start = System.currentTimeMillis();
            this.sequenceOffset = 0;
            Statement s = c.createStatement();
            ResultSet r = s.executeQuery("SELECT nextval('serial');");
            if (!r.next()) {
                throw new SQLException("No result while attempting to get a unique id");
            }
            long nextSequence = r.getLong(1);
            this.sequenceBase = (int)(nextSequence * 1000000L);
            long end = System.currentTimeMillis();
            LOG.info((Object)("Got new set of serial numbers - took " + (end - start) + " ms"));
        }
        return new Integer(this.sequenceBase + this.sequenceOffset++);
    }

    @Override
    public Set<Object> getComponentsForQuery(Query q) {
        try {
            Set<Object> retval = SqlGenerator.findTableNames(q, this.getSchema(), true);
            return retval;
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.description;
    }

    protected final class BagTableToRemove
    extends WeakReference<String> {
        String dropSql;

        private BagTableToRemove(String tableName, ReferenceQueue<String> refQueue) {
            super(tableName, refQueue);
            this.dropSql = "DROP TABLE " + tableName;
        }

        private String getDropSql() {
            return this.dropSql;
        }

        public String toString() {
            return this.dropSql;
        }
    }
}

