/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.util.DynamicUtil;
import org.intermine.util.StringConstructor;
import org.intermine.util.TypeUtil;

public final class NotXmlRenderer {
    private NotXmlRenderer() {
    }

    public static StringConstructor render(Object obj) {
        try {
            StringConstructor sb = new StringConstructor();
            sb.append("$_^");
            boolean needComma = false;
            for (Class<?> clazz : DynamicUtil.decomposeClass(obj.getClass())) {
                if (needComma) {
                    sb.append(" ");
                }
                needComma = true;
                sb.append(clazz.getName());
            }
            Map<String, TypeUtil.FieldInfo> infos = TypeUtil.getFieldInfos(obj.getClass());
            for (String fieldName : infos.keySet()) {
                Object value = TypeUtil.getFieldProxy(obj, fieldName);
                if (value == null || Collection.class.isAssignableFrom(value.getClass())) continue;
                if (value instanceof InterMineObject) {
                    Integer id = ((InterMineObject)value).getId();
                    sb.append("$_^");
                    sb.append("r");
                    sb.append(fieldName);
                    sb.append("$_^");
                    sb.append(id.toString());
                    continue;
                }
                sb.append("$_^");
                sb.append("a");
                sb.append(fieldName);
                sb.append("$_^");
                if (value instanceof Date) {
                    sb.append(Long.toString(((Date)value).getTime()));
                    continue;
                }
                if (value instanceof String) {
                    String string = (String)value;
                    while (string != null) {
                        int delimPosition = string.indexOf("$_^");
                        if (delimPosition == -1) {
                            sb.append(string);
                            string = null;
                            continue;
                        }
                        sb.append(string.substring(0, delimPosition + 3));
                        sb.append("d");
                        string = string.substring(delimPosition + 3);
                    }
                    continue;
                }
                if (value instanceof ClobAccess) {
                    sb.append(((ClobAccess)value).getDbDescription());
                    continue;
                }
                sb.append(value.toString());
            }
            return sb;
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException e2 = new IllegalArgumentException();
            e2.initCause(e);
            throw e2;
        }
    }
}

