/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.cglib.proxy.Factory;
import org.apache.log4j.Logger;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.intermine.ObjectStoreInterMineImpl;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.proxy.ProxyReference;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.util.DynamicBean;
import org.intermine.util.DynamicUtil;
import org.intermine.util.TypeUtil;

public final class NotXmlParser {
    private static final Logger LOG = Logger.getLogger(NotXmlParser.class);
    public static final String DELIM = "$_^";
    public static final String ENCODED_DELIM = "d";
    public static final Pattern SPLITTER = Pattern.compile("$_^", 16);
    private static final Pattern SPACE_SPLITTER = Pattern.compile(" ", 16);
    private static int opCount = 0;
    private static long splitTime = 0L;
    private static long classTime = 0L;
    private static long createTime = 0L;
    private static long parseTime = 0L;
    private static Map<String, Class<? extends FastPathObject>> classCache = Collections.synchronizedMap(new HashMap());

    private NotXmlParser() {
    }

    public static InterMineObject parse(String xml, ObjectStoreInterMineImpl os) throws ClassNotFoundException {
        InterMineObject retval;
        if (xml == null || "null".equals(xml)) {
            Exception e = new Exception();
            e.fillInStackTrace();
            LOG.warn((Object)("Parsing " + xml), (Throwable)e);
        }
        long time1 = System.currentTimeMillis();
        String[] a = SPLITTER.split(xml);
        long time2 = System.currentTimeMillis();
        splitTime += time2 - time1;
        Class<FastPathObject> clazz = classCache.get(a[1]);
        if (clazz == null) {
            HashSet classes = new HashSet();
            if (!"".equals(a[1])) {
                String[] b = SPACE_SPLITTER.split(a[1]);
                for (int i = 0; i < b.length; ++i) {
                    classes.add(Class.forName(b[i]));
                }
            }
            time1 = System.currentTimeMillis();
            classTime += time1 - time2;
            retval = (InterMineObject)DynamicUtil.createObject(classes);
            clazz = retval.getClass();
            classCache.put(a[1], clazz);
        } else {
            time1 = System.currentTimeMillis();
            classTime += time1 - time2;
            retval = (InterMineObject)DynamicUtil.createObject(clazz);
        }
        time2 = System.currentTimeMillis();
        createTime += time2 - time1;
        if (retval instanceof Factory) {
            DynamicBean bean = (DynamicBean)((Factory)retval).getCallback(0);
            Map<String, Object> valueMap = bean.getMap();
            Map<String, FieldDescriptor> fields = os.getModel().getFieldDescriptorsForClass(retval.getClass());
            Map<String, TypeUtil.FieldInfo> fieldInfos = TypeUtil.getFieldInfos(clazz);
            boolean fetchFromInterMineObject = os.getSchema().isFetchFromInterMineObject();
            for (int i = 2; i < a.length; i += 2) {
                String fieldName;
                if (a[i].startsWith("a")) {
                    fieldName = a[i].substring(1).intern();
                    Class<?> fieldClass = fieldInfos.get(fieldName).getType();
                    String firstString = i + 1 == a.length ? "" : a[i + 1];
                    StringBuffer string = null;
                    while (i + 2 < a.length && a[i + 2].startsWith(ENCODED_DELIM)) {
                        ++i;
                        if (string == null) {
                            string = new StringBuffer(firstString);
                        }
                        string.append(DELIM).append(a[i + 1].substring(1));
                    }
                    if (ClobAccess.class.equals(fieldClass)) {
                        valueMap.put(fieldName, ClobAccess.decodeDbDescription(os, string == null ? firstString : string.toString()));
                        continue;
                    }
                    valueMap.put(fieldName, TypeUtil.stringToObject(fieldClass, string == null ? firstString : string.toString()));
                    continue;
                }
                if (!a[i].startsWith("r")) continue;
                fieldName = a[i].substring(1).intern();
                Integer id = Integer.valueOf(a[i + 1]);
                if (fetchFromInterMineObject) {
                    valueMap.put(fieldName, new ProxyReference(os, id, InterMineObject.class));
                    continue;
                }
                ReferenceDescriptor ref = (ReferenceDescriptor)fields.get(fieldName);
                if (ref == null) {
                    throw new RuntimeException("failed to get field " + fieldName + " for object from XML: " + xml);
                }
                Class<? extends FastPathObject> tmpType = ref.getReferencedClassDescriptor().getType();
                valueMap.put(fieldName, new ProxyReference(os, id, tmpType));
            }
            for (Map.Entry<String, Class<?>> collEntry : os.getModel().getCollectionsForClass(clazz).entrySet()) {
                ProxyCollection lazyColl = new ProxyCollection(os, retval, collEntry.getKey(), collEntry.getValue());
                valueMap.put(collEntry.getKey(), lazyColl);
            }
            time1 = System.currentTimeMillis();
            parseTime += time1 - time2;
            if (++opCount >= 100000) {
                LOG.info((Object)("(Fast Factory) Split: " + splitTime + " ms, Class: " + classTime + " ms, Create: " + createTime + " ms, Parse: " + parseTime + " ms"));
                opCount = 0;
            }
            return retval;
        }
        try {
            retval.setoBJECT(a, (ObjectStore)os);
            time1 = System.currentTimeMillis();
            parseTime += time1 - time2;
            if (++opCount >= 100000) {
                LOG.info((Object)("(Fast Class) Split: " + splitTime + " ms, Class: " + classTime + " ms, Create: " + createTime + " ms, Parse: " + parseTime + " ms"));
                opCount = 0;
            }
            return retval;
        }
        catch (IllegalStateException e) {
            Map<String, FieldDescriptor> fields = os.getModel().getFieldDescriptorsForClass(retval.getClass());
            Map<String, TypeUtil.FieldInfo> fieldInfos = TypeUtil.getFieldInfos(clazz);
            for (int i = 2; i < a.length; i += 2) {
                String fieldName;
                if (a[i].startsWith("a")) {
                    fieldName = a[i].substring(1);
                    Class<?> fieldClass = fieldInfos.get(fieldName).getType();
                    String firstString = i + 1 == a.length ? "" : a[i + 1];
                    StringBuffer string = null;
                    if (firstString.length() * 10 < xml.length() * 9) {
                        string = new StringBuffer(firstString);
                    }
                    while (i + 2 < a.length && a[i + 2].startsWith(ENCODED_DELIM)) {
                        ++i;
                        if (string == null) {
                            string = new StringBuffer(firstString);
                        }
                        string.append(DELIM).append(a[i + 1].substring(1));
                    }
                    if (ClobAccess.class.equals(fieldClass)) {
                        retval.setFieldValue(fieldName, ClobAccess.decodeDbDescription(os, string == null ? firstString : string.toString()));
                        continue;
                    }
                    retval.setFieldValue(fieldName, TypeUtil.stringToObject(fieldClass, string == null ? firstString : string.toString()));
                    continue;
                }
                if (!a[i].startsWith("r")) continue;
                fieldName = a[i].substring(1);
                Integer id = Integer.valueOf(a[i + 1]);
                ReferenceDescriptor ref = (ReferenceDescriptor)fields.get(fieldName);
                if (ref == null) {
                    throw new RuntimeException("failed to get field " + fieldName + " for object from XML: " + xml);
                }
                Class<? extends FastPathObject> tmpType = ref.getReferencedClassDescriptor().getType();
                retval.setFieldValue(fieldName, new ProxyReference(os, id, tmpType));
            }
            for (Map.Entry<String, FieldDescriptor> collEntry : fields.entrySet()) {
                FieldDescriptor maybeColl = collEntry.getValue();
                if (!(maybeColl instanceof CollectionDescriptor)) continue;
                CollectionDescriptor coll = (CollectionDescriptor)maybeColl;
                ProxyCollection<? extends FastPathObject> lazyColl = new ProxyCollection<FastPathObject>(os, retval, coll.getName(), coll.getReferencedClassDescriptor().getType());
                retval.setFieldValue(coll.getName(), lazyColl);
            }
            time1 = System.currentTimeMillis();
            parseTime += time1 - time2;
            if (++opCount >= 100000) {
                LOG.info((Object)("(Fallback) Split: " + splitTime + " ms, Class: " + classTime + " ms, Create: " + createTime + " ms, Parse: " + parseTime + " ms"));
                opCount = 0;
            }
            return retval;
        }
    }
}

