/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.intermine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;

public class DatabaseSchema {
    private static final Logger LOG = Logger.getLogger(DatabaseSchema.class);
    private Model model;
    private List<ClassDescriptor> truncated;
    private boolean noNotXml;
    private boolean flatMode;
    private Set<String> missingTables;
    private boolean fetchFromInterMineObject;
    private int version;
    private boolean hasBioSeg;
    private Set<ClassDescriptor> truncatedSet;
    private Map<ClassDescriptor, Fields> tableMasterToFieldDescriptors = new IdentityHashMap<ClassDescriptor, Fields>();
    private Map<ClassDescriptor, ClassDescriptor> classDescriptorToTableClassDescriptor = new IdentityHashMap<ClassDescriptor, ClassDescriptor>();

    public DatabaseSchema(Model model, List<ClassDescriptor> truncated, boolean noNotXml, Set<String> missingTables, int version, boolean hasBioSeg) {
        this.model = model;
        this.truncated = truncated;
        this.missingTables = missingTables;
        this.noNotXml = noNotXml && !missingTables.contains("intermineobject");
        this.flatMode = noNotXml && missingTables.contains("intermineobject");
        this.fetchFromInterMineObject = !missingTables.contains("intermineobject");
        this.version = version;
        this.hasBioSeg = hasBioSeg;
        for (int i = 0; i < truncated.size(); ++i) {
            Class<? extends FastPathObject> cA = truncated.get(i).getType();
            for (int o = 0; o < i; ++o) {
                Class<? extends FastPathObject> cB = truncated.get(o).getType();
                if (!cB.isAssignableFrom(cA)) continue;
                throw new IllegalArgumentException("Truncated class " + cB.getName() + " is completely overridden by truncated class " + cA.getName());
            }
        }
        this.truncatedSet = new HashSet<ClassDescriptor>(truncated);
    }

    public synchronized ClassDescriptor getTableMaster(ClassDescriptor cld) {
        ClassDescriptor retval = this.classDescriptorToTableClassDescriptor.get(cld);
        if (retval == null) {
            Iterator<ClassDescriptor> truncIter = this.truncated.iterator();
            while (truncIter.hasNext() && retval == null) {
                ClassDescriptor truncCld = truncIter.next();
                if (!truncCld.getType().isAssignableFrom(cld.getType())) continue;
                retval = truncCld;
            }
            if (retval == null) {
                retval = cld;
            }
            this.classDescriptorToTableClassDescriptor.put(cld, retval);
        }
        return retval;
    }

    public boolean isTruncated(ClassDescriptor cld) {
        return this.truncatedSet.contains(cld);
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isMissingNotXml() {
        return this.noNotXml;
    }

    public boolean isFlatMode(Class<?> c) {
        return this.flatMode || !InterMineObject.class.isAssignableFrom(c);
    }

    public boolean isFetchFromInterMineObject() {
        return this.fetchFromInterMineObject;
    }

    public int getVersion() {
        return this.version;
    }

    public Set<String> getMissingTables() {
        return this.missingTables;
    }

    public boolean hasBioSeg() {
        return this.hasBioSeg;
    }

    public synchronized Fields getTableFields(ClassDescriptor cld) throws ObjectStoreException {
        Fields retval = this.tableMasterToFieldDescriptors.get(cld);
        if (retval == null) {
            if (this.isTruncated(cld)) {
                HashMap<String, AttributeDescriptor> attributeMap = new HashMap<String, AttributeDescriptor>();
                HashMap<String, ReferenceDescriptor> referenceMap = new HashMap<String, ReferenceDescriptor>();
                HashSet<ClassDescriptor> added = new HashSet<ClassDescriptor>();
                Stack<ClassDescriptor> todo = new Stack<ClassDescriptor>();
                todo.push(cld);
                added.add(cld);
                while (!todo.empty()) {
                    ClassDescriptor subCld = (ClassDescriptor)todo.pop();
                    for (ClassDescriptor subSubCld : subCld.getSubDescriptors()) {
                        if (added.contains(subSubCld)) continue;
                        todo.push(subSubCld);
                        added.add(subSubCld);
                    }
                }
                for (ClassDescriptor subCld : added) {
                    ClassDescriptor subsMaster = this.getTableMaster(subCld);
                    if (subsMaster != cld && !this.isFlatMode(cld.getType())) continue;
                    for (FieldDescriptor field : subCld.getAllFieldDescriptors()) {
                        if (field instanceof AttributeDescriptor) {
                            String origType;
                            String type;
                            AttributeDescriptor origField = (AttributeDescriptor)attributeMap.get(field.getName());
                            if (origField == null) {
                                attributeMap.put(field.getName(), (AttributeDescriptor)field);
                            } else if (origField != field && !DatabaseSchema.compatible(type = ((AttributeDescriptor)field).getType(), origType = origField.getType())) {
                                throw new ObjectStoreException("Fields " + field.getClassDescriptor().getName() + "." + field.getName() + " (a " + type + ") and " + origField.getClassDescriptor().getName() + "." + origField.getName() + " (a " + origType + ") in truncated class " + cld.getName() + " are of different types");
                            }
                        } else if (!field.isCollection()) {
                            referenceMap.put(field.getName(), (ReferenceDescriptor)field);
                        }
                        if (added.contains(field.getClassDescriptor()) || cld.getSuperDescriptors().contains(field.getClassDescriptor())) continue;
                        LOG.warn((Object)("Field included in truncated class " + cld.getName() + " " + field.getClassDescriptor().getName() + "." + field.getName() + " is from" + " outside the class. This may result in a table" + " with lots of columns - consider changing the" + " truncated class config"));
                    }
                }
                retval = new Fields(new HashSet(attributeMap.values()), new HashSet(referenceMap.values()));
            } else {
                HashSet<AttributeDescriptor> attributes = new HashSet<AttributeDescriptor>();
                HashSet<ReferenceDescriptor> references = new HashSet<ReferenceDescriptor>();
                for (FieldDescriptor f : cld.getAllFieldDescriptors()) {
                    if (f instanceof AttributeDescriptor) {
                        attributes.add((AttributeDescriptor)f);
                        continue;
                    }
                    if (f.isCollection()) continue;
                    references.add((ReferenceDescriptor)f);
                }
                retval = new Fields(attributes, references);
            }
            this.tableMasterToFieldDescriptors.put(cld, retval);
        }
        return retval;
    }

    private static boolean compatible(String type1, String type2) {
        return "int".equals(type1) || "java.lang.Integer".equals(type1) || "reference".equals(type1) ? "int".equals(type2) || "java.lang.Integer".equals(type2) || "reference".equals(type2) : ("short".equals(type1) || "java.lang.Short".equals(type1) ? "short".equals(type2) || "java.lang.Short".equals(type2) : ("long".equals(type1) || "java.lang.Long".equals(type1) ? "long".equals(type2) || "java.lang.Long".equals(type2) : ("float".equals(type1) || "java.lang.Float".equals(type1) ? "float".equals(type2) || "java.lang.Float".equals(type2) : ("double".equals(type1) || "java.lang.Double".equals(type1) ? "double".equals(type2) || "java.lang.Double".equals(type2) : ("boolean".equals(type1) || "java.lang.Boolean".equals(type1) ? "boolean".equals(type2) || "java.lang.Boolean".equals(type2) : ("java.lang.String".equals(type1) ? "java.lang.String".equals(type2) : ("java.math.BigDecimal".equals(type1) ? "java.math.BigDecimal".equals(type2) : "java.util.Date".equals(type1) && "java.util.Date".equals(type2))))))));
    }

    public static final class Fields {
        private Set<AttributeDescriptor> attributes;
        private Set<ReferenceDescriptor> references;

        private Fields(Set<AttributeDescriptor> attributes, Set<ReferenceDescriptor> references) {
            this.attributes = attributes;
            this.references = references;
        }

        public Set<AttributeDescriptor> getAttributes() {
            return this.attributes;
        }

        public Set<ReferenceDescriptor> getReferences() {
            return this.references;
        }
    }
}

