/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore.fastcollections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.ObjectStorePassthruImpl;
import org.intermine.objectstore.proxy.ProxyCollection;
import org.intermine.objectstore.query.BagConstraint;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryForeignKey;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SimpleConstraint;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.util.CacheHoldingArrayList;

public class ObjectStoreFastCollectionsImpl
extends ObjectStorePassthruImpl {
    private static final Logger LOG = Logger.getLogger(ObjectStoreFastCollectionsImpl.class);
    private boolean fetchAllFields = true;
    private Set<FieldDescriptor> fieldExceptions = Collections.emptySet();
    private long timeSpentExecute = 0L;
    private long timeSpentInspect = 0L;
    private long timeSpentPrepare = 0L;
    private long timeSpentQuery = 0L;
    private long timeSpentSubExecute = 0L;
    private long timeSpentProcess = 0L;
    private int queryCount = 0;

    public ObjectStoreFastCollectionsImpl(ObjectStore os) {
        super(os);
    }

    public static ObjectStoreFastCollectionsImpl getInstance(String osAlias, Properties props) throws ObjectStoreException {
        ObjectStore objectStore;
        String underlyingOsAlias = props.getProperty("os");
        if (underlyingOsAlias == null) {
            throw new IllegalArgumentException("No 'os' property specified for FastCollections objectstore");
        }
        try {
            objectStore = ObjectStoreFactory.getObjectStore(underlyingOsAlias);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("ObjectStore '" + underlyingOsAlias + "' not found in properties");
        }
        return new ObjectStoreFastCollectionsImpl(objectStore);
    }

    public void setFetchFields(boolean fetchAllFields, Set<FieldDescriptor> fieldExceptions) {
        this.fetchAllFields = fetchAllFields;
        this.fieldExceptions = fieldExceptions;
    }

    private boolean doThisField(FieldDescriptor field) {
        return this.fetchAllFields != this.fieldExceptions.contains(field);
    }

    @Override
    public Results execute(Query q) {
        return new Results(q, this, SEQUENCE_IGNORE);
    }

    @Override
    public Results execute(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        Results retval = new Results(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public SingletonResults executeSingleton(Query q) {
        return new SingletonResults(q, this, SEQUENCE_IGNORE);
    }

    @Override
    public SingletonResults executeSingleton(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        SingletonResults retval = new SingletonResults(q, this, this.getSequence(this.getComponentsForQuery(q)));
        if (batchSize != 0) {
            retval.setBatchSize(batchSize);
        }
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public List<ResultsRow<Object>> execute(Query q, int start, int limit, boolean optimise, boolean explain, Map<Object, Integer> sequence) throws ObjectStoreException {
        try {
            QuerySelectable node;
            long time1 = System.currentTimeMillis();
            List<ResultsRow<Object>> results = this.os.execute(q, start, limit, optimise, explain, sequence);
            CacheHoldingArrayList<ResultsRow<Object>> retval = results instanceof CacheHoldingArrayList ? (CacheHoldingArrayList<ResultsRow<Object>>)results : new CacheHoldingArrayList<ResultsRow<Object>>((Collection<ResultsRow<Object>>)results);
            long time2 = System.currentTimeMillis();
            this.timeSpentExecute += time2 - time1;
            if (retval.size() > 1 && (node = q.getSelect().get(0)) instanceof QueryClass) {
                HashMap<Integer, InterMineObject> bagMap = new HashMap<Integer, InterMineObject>();
                int lowestId = Integer.MAX_VALUE;
                int highestId = Integer.MIN_VALUE;
                for (ResultsRow resultsRow : retval) {
                    InterMineObject o = (InterMineObject)resultsRow.get(0);
                    bagMap.put(o.getId(), o);
                    int id = o.getId();
                    lowestId = lowestId < id ? lowestId : id;
                    highestId = highestId > id ? highestId : id;
                }
                Class<? extends FastPathObject> clazz = ((QueryClass)node).getType();
                Map<String, FieldDescriptor> map = this.getModel().getFieldDescriptorsForClass(clazz);
                time1 = System.currentTimeMillis();
                this.timeSpentInspect += time1 - time2;
                for (Map.Entry<String, FieldDescriptor> fieldEntry : map.entrySet()) {
                    String fieldName = fieldEntry.getKey();
                    FieldDescriptor field = fieldEntry.getValue();
                    HashMap<Integer, Collection<Object>> collections = new HashMap<Integer, Collection<Object>>();
                    if (!this.doThisField(field) || !(field instanceof CollectionDescriptor)) continue;
                    CollectionDescriptor coll = (CollectionDescriptor)field;
                    time1 = System.currentTimeMillis();
                    for (Map.Entry entry : bagMap.entrySet()) {
                        Integer id = (Integer)entry.getKey();
                        InterMineObject o = (InterMineObject)entry.getValue();
                        ProxyCollection pc = (ProxyCollection)o.getFieldValue(fieldName);
                        Collection materialisedCollection = pc.getMaterialisedCollection();
                        if (!(materialisedCollection instanceof HashSet)) {
                            materialisedCollection = new HashSet();
                            collections.put(id, materialisedCollection);
                        }
                        retval.addToHolder(materialisedCollection);
                    }
                    time2 = System.currentTimeMillis();
                    this.timeSpentPrepare += time2 - time1;
                    Set bag = collections.keySet();
                    if (q.getConstraint() == null && q.getOrderBy().isEmpty() && q.getGroupBy().isEmpty()) {
                        ConstraintSet cs;
                        Query subQ = new Query();
                        subQ.setDistinct(false);
                        if (coll.relationType() == 2) {
                            QueryClass qc = new QueryClass(coll.getReferencedClassDescriptor().getType());
                            subQ.addFrom(qc);
                            QueryForeignKey qfk = new QueryForeignKey(qc, coll.getReverseReferenceFieldName());
                            subQ.addToSelect(qfk);
                            subQ.addToSelect(qc);
                            cs = new ConstraintSet(ConstraintOp.AND);
                            subQ.setConstraint(cs);
                            cs.addConstraint(new SimpleConstraint(qfk, ConstraintOp.GREATER_THAN_EQUALS, new QueryValue(new Integer(lowestId))));
                            cs.addConstraint(new SimpleConstraint(qfk, ConstraintOp.LESS_THAN_EQUALS, new QueryValue(new Integer(highestId))));
                        } else {
                            QueryClass qc1 = new QueryClass(new Class[]{clazz});
                            QueryClass qc2 = new QueryClass(coll.getReferencedClassDescriptor().getType());
                            subQ.addFrom(qc1);
                            subQ.addFrom(qc2);
                            subQ.addToSelect(new QueryField(qc1, "id"));
                            subQ.addToSelect(qc2);
                            cs = new ConstraintSet(ConstraintOp.AND);
                            subQ.setConstraint(cs);
                            QueryCollectionReference qcr = new QueryCollectionReference(qc1, fieldName);
                            cs.addConstraint(new ContainsConstraint((QueryReference)qcr, ConstraintOp.CONTAINS, qc2));
                            QueryField idField = new QueryField(qc1, "id");
                            cs.addConstraint(new SimpleConstraint(idField, ConstraintOp.GREATER_THAN_EQUALS, new QueryValue(new Integer(lowestId))));
                            cs.addConstraint(new SimpleConstraint(idField, ConstraintOp.LESS_THAN_EQUALS, new QueryValue(new Integer(highestId))));
                            if (coll.relationType() == 2) {
                                QueryForeignKey reverseIdField = new QueryForeignKey(qc2, coll.getReverseReferenceFieldName());
                                cs.addConstraint(new SimpleConstraint(reverseIdField, ConstraintOp.GREATER_THAN_EQUALS, new QueryValue(new Integer(lowestId))));
                                cs.addConstraint(new SimpleConstraint(reverseIdField, ConstraintOp.LESS_THAN_EQUALS, new QueryValue(new Integer(highestId))));
                            }
                        }
                        Results l = new Results(subQ, this.os, sequence);
                        if (!optimise) {
                            l.setNoOptimise();
                        }
                        if (!explain) {
                            l.setNoExplain();
                        }
                        l.setBatchSize(limit * 20);
                        time1 = System.currentTimeMillis();
                        this.timeSpentQuery += time1 - time2;
                        this.insertResults(collections, l);
                        time2 = System.currentTimeMillis();
                        this.timeSpentSubExecute += time2 - time1;
                    } else {
                        ArrayList bagList = new ArrayList(bag);
                        for (int i = 0; i < bagList.size(); i += 1000) {
                            Query subQ = new Query();
                            subQ.setDistinct(false);
                            QueryClass qc1 = new QueryClass(new Class[]{clazz});
                            QueryClass qc2 = new QueryClass(coll.getReferencedClassDescriptor().getType());
                            subQ.addFrom(qc1);
                            subQ.addFrom(qc2);
                            subQ.addToSelect(new QueryField(qc1, "id"));
                            subQ.addToSelect(qc2);
                            ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
                            subQ.setConstraint(cs);
                            QueryCollectionReference qcr = new QueryCollectionReference(qc1, fieldName);
                            cs.addConstraint(new ContainsConstraint((QueryReference)qcr, ConstraintOp.CONTAINS, qc2));
                            cs.addConstraint(new BagConstraint((QueryNode)new QueryField(qc1, "id"), ConstraintOp.IN, bagList.subList(i, i + 1000 < bagList.size() ? i + 1000 : bagList.size())));
                            Results l = new Results(subQ, this.os, sequence);
                            if (!optimise) {
                                l.setNoOptimise();
                            }
                            if (!explain) {
                                l.setNoExplain();
                            }
                            l.setBatchSize(limit * 20);
                            time1 = System.currentTimeMillis();
                            this.timeSpentQuery += time1 - time2;
                            this.insertResults(collections, l);
                            time2 = System.currentTimeMillis();
                            this.timeSpentSubExecute += time2 - time1;
                        }
                    }
                    for (Map.Entry entry : collections.entrySet()) {
                        Integer id = (Integer)entry.getKey();
                        Collection materialisedCollection = (Collection)entry.getValue();
                        InterMineObject fromObj = (InterMineObject)bagMap.get(id);
                        ProxyCollection pc = (ProxyCollection)fromObj.getFieldValue(fieldName);
                        pc.setMaterialisedCollection(materialisedCollection);
                    }
                    time1 = System.currentTimeMillis();
                    this.timeSpentProcess += time1 - time2;
                }
            }
            ++this.queryCount;
            if (this.queryCount % 10000 == 0) {
                LOG.info((Object)("Time spent: Execute: " + this.timeSpentExecute + ", Inspect: " + this.timeSpentInspect + ", Prepare: " + this.timeSpentPrepare + ", Generate query: " + this.timeSpentQuery + ", Execute query: " + this.timeSpentSubExecute + ", Process: " + this.timeSpentProcess));
            }
            return retval;
        }
        catch (IllegalAccessException e) {
            throw new ObjectStoreException(e);
        }
    }

    private void insertResults(Map<Integer, Collection<Object>> collections, Results l) throws IllegalAccessException {
        Results res = l;
        for (ResultsRow row : res) {
            Collection<Object> fromCollection = collections.get(row.get(0));
            if (fromCollection == null) continue;
            Object toObj = row.get(1);
            fromCollection.add(toObj);
        }
    }

    public String toString() {
        return "FastCollections(" + this.os + ")";
    }
}

