/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreFactory;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl;
import org.intermine.sql.writebatch.BatchWriter;
import org.intermine.util.PropertiesUtil;

public final class ObjectStoreWriterFactory {
    private static final Logger LOG = Logger.getLogger(ObjectStoreWriterFactory.class);

    private ObjectStoreWriterFactory() {
    }

    public static ObjectStoreWriter getObjectStoreWriter(String alias) throws ObjectStoreException {
        String batchWriterClass;
        ObjectStore os;
        if (alias == null) {
            throw new NullPointerException("ObjectStoreWriter alias cannot be null");
        }
        if ("".equals(alias)) {
            throw new IllegalArgumentException("ObjectStoreWriter alias cannot be empty");
        }
        Properties props = PropertiesUtil.getPropertiesStartingWith(alias);
        if (props.size() == 0) {
            throw new ObjectStoreException("No ObjectStoreWriter properties were found for '" + alias + "'");
        }
        String clsName = (props = PropertiesUtil.stripStart(alias, props)).getProperty("class");
        if (clsName == null) {
            throw new ObjectStoreException(alias + " does not have an ObjectStoreWriter class " + "specified (check properties file)");
        }
        String osAlias = props.getProperty("os");
        if (osAlias == null) {
            throw new ObjectStoreException(alias + " does not have an os alias specified" + " (check properties file)");
        }
        try {
            os = ObjectStoreFactory.getObjectStore(osAlias);
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
        ObjectStoreWriter osw = null;
        try {
            Class<?> cls = Class.forName(clsName);
            Constructor<?> c = cls.getConstructor(ObjectStore.class);
            osw = (ObjectStoreWriter)c.newInstance(os);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectStoreException("Cannot find specified ObjectStoreWriter class '" + clsName + "' for " + alias + " (check properties file) " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new ObjectStoreException("Cannot find appropriate constructor for ObjectStoreWriter: " + clsName + " (ObjectStore.class)" + " - check properties file, " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new ObjectStoreException("Failed to instantiate ObjectStoreWriter class: " + clsName + ", osAlias: " + osAlias + " - " + e.getCause().toString(), e.getCause());
        }
        catch (Exception e) {
            throw new ObjectStoreException("Failed to instantiate ObjectStoreWriter class: " + clsName + ", " + e.toString());
        }
        if ("org.intermine.objectstore.intermine.ObjectStoreWriterInterMineImpl".equals(clsName) && (batchWriterClass = props.getProperty("batchWriter")) != null) {
            try {
                Class<?> cls = Class.forName(batchWriterClass);
                Constructor<?> c = cls.getConstructor(new Class[0]);
                BatchWriter batchWriter = (BatchWriter)c.newInstance(new Object[0]);
                ((ObjectStoreWriterInterMineImpl)osw).setBatchWriter(batchWriter);
            }
            catch (Exception e) {
                LOG.warn((Object)("Could not find requested BatchWriter " + batchWriterClass));
            }
        }
        return osw;
    }
}

