/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.ConstraintOp;
import org.intermine.objectstore.query.ConstraintSet;
import org.intermine.objectstore.query.ContainsConstraint;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryCollectionReference;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryObjectReference;
import org.intermine.objectstore.query.QueryReference;
import org.intermine.objectstore.query.QueryValue;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SubqueryExistsConstraint;
import org.intermine.util.StringUtil;

public class ObjectStoreSummary {
    private static final Logger LOG = Logger.getLogger(ObjectStoreSummary.class);
    private final Map<String, Integer> classCountsMap = new HashMap<String, Integer>();
    private final Map<String, List<Object>> fieldValuesMap = new HashMap<String, List<Object>>();
    protected final Map<String, Set<String>> emptyFieldsMap = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> emptyAttributesMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> nonEmptyFieldsMap = new HashMap<String, Set<String>>();
    protected int maxValues = 200;
    static final String NULL_FIELDS_SUFFIX = ".nullFields";
    static final String CLASS_COUNTS_SUFFIX = ".classCount";
    static final String FIELDS_SUFFIX = ".fieldValues";
    static final String EMPTY_ATTRIBUTES_SUFFIX = ".emptyAttributes";
    static final String NULL_MARKER = "___NULL___";
    static final String FIELD_DELIM = "$_^";
    static final String MAX_FIELD_VALUES = "max.field.values";
    public static final int DEFAULT_MAX_VALUES = 200;

    public ObjectStoreSummary(ObjectStore os, Properties configuration) throws ClassNotFoundException, ObjectStoreException {
        Model model = os.getModel();
        LOG.info((Object)"Collecting class counts...");
        for (ClassDescriptor cld : model.getTopDownLevelTraversal()) {
            this.nonEmptyFieldsMap.put(cld.getName(), new HashSet());
            if (this.classCountsMap.containsKey(cld.getName())) continue;
            int classCount = this.countClass(os, cld.getType());
            LOG.info((Object)("Adding class count: " + cld.getUnqualifiedName() + " = " + classCount));
            this.classCountsMap.put(cld.getName(), new Integer(classCount));
            if (classCount != 0) continue;
            for (ClassDescriptor subCld : model.getAllSubs(cld)) {
                if (this.classCountsMap.containsKey(subCld.getName())) continue;
                this.classCountsMap.put(subCld.getName(), new Integer(classCount));
            }
        }
        LOG.info((Object)"Summarising field values...");
        String maxValuesString = (String)configuration.get(MAX_FIELD_VALUES);
        this.maxValues = maxValuesString == null ? 200 : Integer.parseInt(maxValuesString);
        HashSet<String> doneFields = new HashSet<String>();
        for (ClassDescriptor cld : model.getBottomUpLevelTraversal()) {
            int classCount = this.classCountsMap.get(cld.getName());
            if (classCount == 0) continue;
            for (AttributeDescriptor att : cld.getAllAttributeDescriptors()) {
                String clsFieldName;
                String fieldName = att.getName();
                if ("id".equals(fieldName) || doneFields.contains(clsFieldName = cld.getName() + "." + fieldName)) continue;
                Results results = this.getFieldSummary(cld, fieldName, os);
                if (results.size() <= this.maxValues) {
                    ArrayList<String> fieldValues = new ArrayList<String>();
                    for (Object resRow : results) {
                        Object fieldValue = ((ResultsRow)resRow).get(0);
                        fieldValues.add(fieldValue == null ? null : fieldValue.toString());
                    }
                    if (fieldValues.size() == 1 && fieldValues.get(0) == null) {
                        Set<String> emptyAttributes = this.emptyAttributesMap.get(cld.getName());
                        if (emptyAttributes == null) {
                            emptyAttributes = new HashSet<String>();
                            this.emptyAttributesMap.put(cld.getName(), emptyAttributes);
                        }
                        emptyAttributes.add(fieldName);
                    }
                    Collections.sort(fieldValues, new Comparator<Object>(){

                        @Override
                        public int compare(Object arg0, Object arg1) {
                            if (arg0 == null) {
                                return arg1 == null ? 0 : 1;
                            }
                            if (arg1 == null) {
                                return arg0 == null ? 0 : -1;
                            }
                            return arg0.toString().compareTo(arg1.toString());
                        }
                    });
                    this.fieldValuesMap.put(clsFieldName, fieldValues);
                    LOG.info((Object)("Adding " + fieldValues.size() + " values for " + cld.getUnqualifiedName() + "." + fieldName));
                    continue;
                }
                LOG.info((Object)("Too many values for " + cld.getUnqualifiedName() + "." + fieldName));
                for (ClassDescriptor superCld : cld.getAllSuperDescriptors()) {
                    String superClsField;
                    if (cld.equals(superCld) || superCld.getType().equals(InterMineObject.class) || doneFields.contains(superClsField = superCld.getName() + "." + fieldName) || superCld.getAttributeDescriptorByName(fieldName, true) == null) continue;
                    LOG.info((Object)("Pushing too many values from " + cld.getUnqualifiedName() + "." + fieldName + " to " + superCld.getUnqualifiedName()));
                    doneFields.add(superClsField);
                }
            }
        }
        LOG.info((Object)"Looking for empty collections and references...");
        Set<String> ignoreFields = ObjectStoreSummary.getIgnoreFields((String)configuration.get("ignore.counts"));
        if (ignoreFields.size() > 0) {
            LOG.warn((Object)("Not counting ignored fields: " + ignoreFields));
        }
        HashSet<String> notEmptyFields = new HashSet<String>();
        for (ClassDescriptor cld : model.getBottomUpLevelTraversal()) {
            int classCount = this.classCountsMap.get(cld.getName());
            if (classCount == 0) continue;
            HashSet<ReferenceDescriptor> refsAndCols = new HashSet<ReferenceDescriptor>();
            refsAndCols.addAll(cld.getAllReferenceDescriptors());
            refsAndCols.addAll(cld.getAllCollectionDescriptors());
            for (ReferenceDescriptor ref : refsAndCols) {
                String fieldName = ref.getName();
                String clsFieldName = cld.getName() + "." + fieldName;
                if (ignoreFields.contains(fieldName)) continue;
                if (notEmptyFields.contains(clsFieldName)) {
                    LOG.info((Object)("Skipping " + clsFieldName + " - already know it's not empty"));
                    continue;
                }
                boolean refIsEmpty = this.isReferenceEmpty(cld, ref, os);
                if (refIsEmpty) {
                    this.addToEmptyFields(cld.getName(), ref.getName());
                    LOG.info((Object)("Adding empty field " + cld.getUnqualifiedName() + "." + fieldName));
                    continue;
                }
                for (ClassDescriptor superCld : cld.getAllSuperDescriptors()) {
                    String superClsField;
                    if (cld.equals(superCld) || superCld.getType().equals(InterMineObject.class) || notEmptyFields.contains(superClsField = superCld.getName() + "." + fieldName) || superCld.getReferenceDescriptorByName(fieldName, true) == null && superCld.getCollectionDescriptorByName(fieldName, true) == null) continue;
                    LOG.info((Object)("Pushing not empty ref/col from " + cld.getUnqualifiedName() + "." + fieldName + " to " + superCld.getUnqualifiedName()));
                    notEmptyFields.add(superClsField);
                }
            }
        }
    }

    public ObjectStoreSummary(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String className;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith(CLASS_COUNTS_SUFFIX)) {
                className = key.substring(0, key.lastIndexOf("."));
                this.classCountsMap.put(className, Integer.valueOf(value));
                continue;
            }
            if (key.endsWith(FIELDS_SUFFIX)) {
                String classAndFieldName = key.substring(0, key.lastIndexOf("."));
                ArrayList<String> fieldValues = new ArrayList<String>(Arrays.asList(StringUtil.split(value, FIELD_DELIM)));
                for (int j = 0; j < fieldValues.size(); ++j) {
                    if (!fieldValues.get(j).equals(NULL_MARKER)) continue;
                    fieldValues.set(j, null);
                }
                this.fieldValuesMap.put(classAndFieldName, fieldValues);
                continue;
            }
            if (key.endsWith(NULL_FIELDS_SUFFIX)) {
                className = key.substring(0, key.lastIndexOf("."));
                List<String> fieldNames = Arrays.asList(StringUtil.split(value, FIELD_DELIM));
                this.emptyFieldsMap.put(className, new TreeSet<String>(fieldNames));
                continue;
            }
            if (key.endsWith(EMPTY_ATTRIBUTES_SUFFIX)) {
                className = key.substring(0, key.lastIndexOf("."));
                List<String> attributeNames = Arrays.asList(StringUtil.split(value, FIELD_DELIM));
                this.emptyAttributesMap.put(className, new TreeSet<String>(attributeNames));
                continue;
            }
            if (!key.equals(MAX_FIELD_VALUES)) continue;
            this.maxValues = Integer.parseInt(value);
        }
    }

    public int getMaxValues() {
        return this.maxValues;
    }

    public int getClassCount(String className) {
        Integer countInteger = this.classCountsMap.get(className);
        if (countInteger == null) {
            throw new RuntimeException("cannot find class count for: " + className);
        }
        return countInteger;
    }

    public List<Object> getFieldValues(String className, String fieldName) {
        return this.fieldValuesMap.get(className + "." + fieldName);
    }

    public Set<String> getNullReferencesAndCollections(String className) {
        if (this.emptyFieldsMap.containsKey(className)) {
            return Collections.unmodifiableSet(this.emptyFieldsMap.get(className));
        }
        return Collections.emptySet();
    }

    public Map<String, Set<String>> getAllNullReferencesAndCollections() {
        return Collections.unmodifiableMap(this.emptyFieldsMap);
    }

    public Set<String> getNullAttributes(String className) {
        if (this.emptyAttributesMap.containsKey(className)) {
            return Collections.unmodifiableSet(this.emptyAttributesMap.get(className));
        }
        return Collections.emptySet();
    }

    public Map<String, Set<String>> getAllNullAttributes() {
        return Collections.unmodifiableMap(this.emptyAttributesMap);
    }

    public Properties toProperties() {
        Object value;
        String key;
        Properties properties = new Properties();
        properties.put(MAX_FIELD_VALUES, "" + this.maxValues);
        for (Map.Entry<String, Integer> entry : this.classCountsMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            properties.put(key + CLASS_COUNTS_SUFFIX, ((Integer)value).toString());
        }
        for (Map.Entry<String, Object> entry : this.fieldValuesMap.entrySet()) {
            key = entry.getKey();
            value = (List)entry.getValue();
            StringBuffer sb = new StringBuffer();
            Iterator j = value.iterator();
            while (j.hasNext()) {
                String s = (String)j.next();
                if (s == null) {
                    sb.append(NULL_MARKER);
                } else {
                    sb.append(s);
                }
                if (!j.hasNext()) continue;
                sb.append(FIELD_DELIM);
            }
            properties.put(key + FIELDS_SUFFIX, sb.toString());
        }
        this.writeEmptyMapToProperties(properties, NULL_FIELDS_SUFFIX, this.emptyFieldsMap);
        this.writeEmptyMapToProperties(properties, EMPTY_ATTRIBUTES_SUFFIX, this.emptyAttributesMap);
        return properties;
    }

    private void writeEmptyMapToProperties(Properties properties, String keySuffix, Map<String, Set<String>> emptyMap) {
        for (Map.Entry<String, Set<String>> entry : emptyMap.entrySet()) {
            String key = entry.getKey();
            ArrayList value = new ArrayList(entry.getValue());
            Collections.sort(value, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    if (arg0 == null) {
                        return arg1 == null ? 0 : 1;
                    }
                    if (arg1 == null) {
                        return arg0 == null ? 0 : -1;
                    }
                    return arg0.toString().compareTo(arg1.toString());
                }
            });
            if (value.size() <= 0) continue;
            String fields = StringUtil.join(value, FIELD_DELIM);
            properties.put(key + keySuffix, fields);
        }
    }

    private Results getFieldSummary(ClassDescriptor cld, String fieldName, ObjectStore os) {
        Query q = new Query();
        q.setDistinct(true);
        QueryClass qc = new QueryClass(cld.getType());
        q.addToSelect(new QueryField(qc, fieldName));
        q.addFrom(qc);
        Results results = os.execute(q);
        return results;
    }

    private boolean isReferenceEmpty(ClassDescriptor cld, ReferenceDescriptor ref, ObjectStore os) {
        long startTime = System.currentTimeMillis();
        LOG.info((Object)("Querying for empty: " + cld.getUnqualifiedName() + "." + ref.getName()));
        Query q = new Query();
        q.setDistinct(false);
        QueryClass qc1 = new QueryClass(cld.getType());
        QueryClass qc2 = new QueryClass(ref.getReferencedClassDescriptor().getType());
        q.addFrom(qc1);
        q.addFrom(qc2);
        q.addToSelect(qc2);
        ConstraintSet cs = new ConstraintSet(ConstraintOp.AND);
        QueryReference qd = ref instanceof CollectionDescriptor ? new QueryCollectionReference(qc1, ref.getName()) : new QueryObjectReference(qc1, ref.getName());
        ContainsConstraint gdc = new ContainsConstraint(qd, ConstraintOp.CONTAINS, qc2);
        cs.addConstraint(gdc);
        q.setConstraint(cs);
        Query q2 = new Query();
        q2.setDistinct(false);
        q2.addToSelect(new QueryValue(new Integer(1)));
        ConstraintSet cs2 = new ConstraintSet(ConstraintOp.AND);
        cs2.addConstraint(new SubqueryExistsConstraint(ConstraintOp.EXISTS, q));
        q2.setConstraint(cs2);
        Results results = os.execute(q2, 1, false, false, false);
        boolean empty = !results.iterator().hasNext();
        LOG.info((Object)("Query for empty " + cld.getUnqualifiedName() + "." + ref.getName() + " took " + (System.currentTimeMillis() - startTime) + "ms."));
        return empty;
    }

    private void addToEmptyFields(String clsName, String fieldName) {
        Set<String> emptyFields = this.emptyFieldsMap.get(clsName);
        if (emptyFields == null) {
            emptyFields = new HashSet<String>();
            this.emptyFieldsMap.put(clsName, emptyFields);
        }
        emptyFields.add(fieldName);
    }

    private int countClass(ObjectStore os, Class<? extends FastPathObject> cls) throws ObjectStoreException {
        Query q = new Query();
        QueryClass qc = new QueryClass(cls);
        q.addToSelect(qc);
        q.addFrom(qc);
        return os.count(q, ObjectStore.SEQUENCE_IGNORE);
    }

    private static Set<String> getIgnoreFields(String config) {
        HashSet<String> retval = new HashSet<String>();
        if (config != null) {
            config = config.trim();
            for (String field : config.split(" ")) {
                retval.add(field);
            }
        }
        return retval;
    }
}

