/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore;

import java.lang.reflect.Method;
import java.util.Properties;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.util.PropertiesUtil;

public final class ObjectStoreFactory {
    private ObjectStoreFactory() {
    }

    public static ObjectStore getObjectStore(String alias) throws Exception {
        if (alias == null) {
            throw new NullPointerException("ObjectStore alias cannot be null");
        }
        if ("".equals(alias)) {
            throw new IllegalArgumentException("ObjectStore alias cannot be empty");
        }
        Properties props = PropertiesUtil.getPropertiesStartingWith(alias);
        if (0 == props.size()) {
            throw new ObjectStoreException("No ObjectStore properties were found for alias '" + alias + "'");
        }
        String clsName = (props = PropertiesUtil.stripStart(alias, props)).getProperty("class");
        if (clsName == null) {
            throw new ObjectStoreException(alias + " does not have an ObjectStore class specified" + " (check properties file)");
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(clsName);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectStoreException("Cannot find specified ObjectStore class '" + clsName + "' for " + alias + " (check properties file)", e);
        }
        Class[] parameterTypes = new Class[]{String.class, Properties.class};
        Method m = cls.getDeclaredMethod("getInstance", parameterTypes);
        return (ObjectStore)m.invoke(null, alias, props);
    }
}

