/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.objectstore;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.DataChangedException;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.ObjectStoreLimitReachedException;
import org.intermine.objectstore.ObjectStoreWriter;
import org.intermine.objectstore.query.Clob;
import org.intermine.objectstore.query.ObjectStoreBag;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryCreator;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.objectstore.query.SingletonResults;
import org.intermine.util.CacheMap;
import org.intermine.util.PropertiesUtil;

public abstract class ObjectStoreAbstractImpl
implements ObjectStore {
    private static final Logger LOG = Logger.getLogger(ObjectStoreAbstractImpl.class);
    protected static Random rand = new Random();
    protected Model model;
    protected int maxOffset = Integer.MAX_VALUE;
    protected int maxLimit = Integer.MAX_VALUE;
    protected long maxTime = Long.MAX_VALUE;
    protected CacheMap<Integer, InterMineObject> cache;
    protected int getObjectOps = 0;
    protected int getObjectHits = 0;
    protected int getObjectPrefetches = 0;
    protected Map<Object, Integer> sequenceNumber = new WeakHashMap<Object, Integer>();
    protected Map<Object, WeakReference<Object>> sequenceKeys = new WeakHashMap<Object, WeakReference<Object>>();

    protected ObjectStoreAbstractImpl() {
    }

    protected ObjectStoreAbstractImpl(Model model) {
        this.model = model;
        Properties props = PropertiesUtil.getPropertiesStartingWith("os.query");
        props = PropertiesUtil.stripStart("os.query", props);
        this.maxLimit = Integer.parseInt((String)props.get("max-limit"));
        this.maxOffset = Integer.parseInt((String)props.get("max-offset"));
        this.maxTime = Long.parseLong((String)props.get("max-time"));
        LOG.info((Object)("Creating new " + this.getClass().getName() + " with sequence = " + this.sequenceNumber + ", model = \"" + model.getName() + "\""));
        this.cache = new CacheMap(this.getClass().getName() + " with sequence = " + this.sequenceNumber + ", model = \"" + model.getName() + "\" getObjectById cache");
    }

    @Override
    public ObjectStoreWriter getNewWriter() throws ObjectStoreException {
        throw new UnsupportedOperationException("This ObjectStore does not have a writer");
    }

    @Override
    public Results execute(Query q) {
        Results retval = new Results(q, this, this.getSequence(this.getComponentsForQuery(q)));
        retval.setImmutable();
        return retval;
    }

    @Override
    public Results execute(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        Results retval = new Results(q, this, this.getSequence(this.getComponentsForQuery(q)));
        retval.setBatchSize(batchSize);
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public SingletonResults executeSingleton(Query q) {
        SingletonResults retval = new SingletonResults(q, this, this.getSequence(this.getComponentsForQuery(q)));
        retval.setImmutable();
        return retval;
    }

    @Override
    public SingletonResults executeSingleton(Query q, int batchSize, boolean optimise, boolean explain, boolean prefetch) {
        SingletonResults retval = new SingletonResults(q, this, this.getSequence(this.getComponentsForQuery(q)));
        retval.setBatchSize(batchSize);
        if (!optimise) {
            retval.setNoOptimise();
        }
        if (!explain) {
            retval.setNoExplain();
        }
        if (!prefetch) {
            retval.setNoPrefetch();
        }
        retval.setImmutable();
        return retval;
    }

    @Override
    public abstract Set<Object> getComponentsForQuery(Query var1);

    @Override
    public InterMineObject getObjectById(Integer id) throws ObjectStoreException {
        return this.getObjectById(id, InterMineObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterMineObject getObjectById(Integer id, Class<? extends InterMineObject> clazz) throws ObjectStoreException {
        ++this.getObjectOps;
        if (this.getObjectOps % 10000 == 0) {
            LOG.info((Object)("getObjectById called " + this.getObjectOps + " times. Cache hits: " + this.getObjectHits + ". Prefetches: " + this.getObjectPrefetches));
        }
        boolean contains = true;
        InterMineObject cached = null;
        CacheMap<Integer, InterMineObject> cacheMap = this.cache;
        synchronized (cacheMap) {
            cached = (InterMineObject)this.cache.get(id);
            if (cached == null) {
                contains = this.cache.containsKey(id);
            }
        }
        if (contains) {
            ++this.getObjectHits;
            return cached;
        }
        InterMineObject fromDb = this.internalGetObjectById(id, clazz);
        CacheMap<Integer, InterMineObject> cacheMap2 = this.cache;
        synchronized (cacheMap2) {
            cached = (InterMineObject)this.cache.get(id);
            if (cached == null) {
                contains = this.cache.containsKey(id);
            }
            if (contains) {
                fromDb = cached;
            } else {
                this.cacheObjectById(id, fromDb);
            }
        }
        return fromDb;
    }

    protected InterMineObject internalGetObjectById(Integer id, Class<? extends InterMineObject> clazz) throws ObjectStoreException {
        Results results = new Results(QueryCreator.createQueryForId(id, clazz), this, SEQUENCE_IGNORE);
        results.setBatchSize(2);
        results.setNoOptimise();
        results.setNoExplain();
        results.setNoPrefetch();
        if (results.size() > 1) {
            throw new IllegalArgumentException("More than one object in the database has this primary key");
        }
        if (results.size() == 1) {
            InterMineObject o = (InterMineObject)((ResultsRow)results.get(0)).get(0);
            return o;
        }
        return null;
    }

    @Override
    public List<InterMineObject> getObjectsByIds(Collection<Integer> ids) throws ObjectStoreException {
        SingletonResults results = this.executeSingleton(QueryCreator.createQueryForIds(ids, InterMineObject.class), 1000, false, false, false);
        return results;
    }

    protected static Model getModelFromClasspath(String osAlias, Properties properties) throws MetaDataException {
        String modelName = properties.getProperty("model");
        if (modelName == null) {
            throw new MetaDataException(osAlias + " does not have a model specified (" + modelName + ") - check properties");
        }
        Model classpathModel = Model.getInstanceByName(modelName);
        if (classpathModel == null) {
            throw new MetaDataException("Model is null despite load from classpath");
        }
        return classpathModel;
    }

    @Override
    public void prefetchObjectById(Integer id) {
        ++this.getObjectPrefetches;
        try {
            this.getObjectById(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateObjectById(Integer id) {
        CacheMap<Integer, InterMineObject> cacheMap = this.cache;
        synchronized (cacheMap) {
            this.cache.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object cacheObjectById(Integer id, InterMineObject obj) {
        CacheMap<Integer, InterMineObject> cacheMap = this.cache;
        synchronized (cacheMap) {
            this.cache.put(id, obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushObjectById() {
        CacheMap<Integer, InterMineObject> cacheMap = this.cache;
        synchronized (cacheMap) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterMineObject pilferObjectById(Integer id) {
        CacheMap<Integer, InterMineObject> cacheMap = this.cache;
        synchronized (cacheMap) {
            return (InterMineObject)this.cache.get(id);
        }
    }

    protected void checkStartLimit(int start, int limit, Query query) throws ObjectStoreLimitReachedException {
        if (start > this.maxOffset) {
            throw new ObjectStoreLimitReachedException("offset parameter (" + start + ") is greater than permitted maximum (" + this.maxOffset + ") for query " + query);
        }
        if (limit > this.maxLimit) {
            throw new ObjectStoreLimitReachedException("number of rows required (" + limit + ") is greater than permitted maximum (" + this.maxLimit + ") for query " + query);
        }
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public InterMineObject getObjectByExample(InterMineObject o, Set<String> fieldNames) throws ObjectStoreException {
        Query query = QueryCreator.createQueryForExampleObject(this.model, o, fieldNames);
        List<ResultsRow<Object>> results = this.execute(query, 0, 2, false, false, SEQUENCE_IGNORE);
        if (results.size() > 1) {
            throw new IllegalArgumentException("More than one object in the database has this primary key (" + results.size() + "): " + query.toString());
        }
        if (results.size() == 1) {
            InterMineObject j = (InterMineObject)results.get(0).get(0);
            return j;
        }
        return null;
    }

    public synchronized void checkSequence(Map<Object, Integer> sequence, Query q, String message) throws DataChangedException {
        for (Map.Entry<Object, Integer> entry : sequence.entrySet()) {
            Object key = entry.getKey();
            if (entry.getValue().equals(this.sequenceNumber.get(key))) continue;
            throw new DataChangedException("Sequence numbers do not match - was given " + key + " = " + entry.getValue() + " but needed " + key + " = " + this.sequenceNumber.get(key) + " for operation \"" + message + q + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map<Object, Integer> getSequence(Set<Object> tables) {
        HashMap<Object, Integer> retval = new HashMap<Object, Integer>();
        for (Object key : tables) {
            Object keyCandidate;
            WeakReference<Object> keyRef = this.sequenceKeys.get(key);
            Integer s = null;
            if (keyRef != null && (keyCandidate = keyRef.get()) != null) {
                key = keyCandidate;
                s = this.sequenceNumber.get(key);
            }
            if (s == null) {
                Random random = rand;
                synchronized (random) {
                    s = new Integer(rand.nextInt());
                }
                this.sequenceNumber.put(key, s);
                this.sequenceKeys.put(key, new WeakReference<Object>(key));
            }
            retval.put(key, s);
        }
        return retval;
    }

    public synchronized void changeSequence(Set<Object> tables) {
        for (Object key : tables) {
            WeakReference<Object> keyRef = this.sequenceKeys.get(key);
            if (keyRef == null) continue;
            Object realKey = keyRef.get();
            Integer value = this.sequenceNumber.get(key);
            if (realKey == null) continue;
            this.sequenceNumber.put(realKey, new Integer(value + 1));
        }
    }

    @Override
    public int getMaxLimit() {
        return this.maxLimit;
    }

    @Override
    public int getMaxOffset() {
        return this.maxOffset;
    }

    @Override
    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    public ObjectStoreBag createObjectStoreBag() throws ObjectStoreException {
        return new ObjectStoreBag(this.getSerial());
    }

    @Override
    public Clob createClob() throws ObjectStoreException {
        return new Clob(this.getSerial());
    }
}

