/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.modelproduction;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.modelproduction.ModelMergerException;
import org.intermine.util.StringUtil;

public final class ModelMerger {
    private static final Logger LOG = Logger.getLogger(ModelMerger.class);

    private ModelMerger() {
    }

    public static Model mergeModel(Model original, Set<ClassDescriptor> classes) throws ModelMergerException {
        Map<String, ClassDescriptor> newClasses = new HashMap<String, ClassDescriptor>();
        for (ClassDescriptor mergeClass : classes) {
            ClassDescriptor oldClass = original.getClassDescriptorByName(mergeClass.getName());
            ClassDescriptor newClass = oldClass != null ? ModelMerger.mergeClass(oldClass, mergeClass, original, classes) : ModelMerger.cloneClassDescriptor(mergeClass);
            newClasses.put(newClass.getName(), newClass);
        }
        for (ClassDescriptor oldClass : original.getClassDescriptors()) {
            if (newClasses.containsKey(oldClass.getName())) continue;
            newClasses.put(oldClass.getName(), ModelMerger.cloneClassDescriptor(oldClass));
        }
        newClasses = ModelMerger.removeRedundancy(newClasses);
        try {
            Model newModel = new Model(original.getName(), original.getPackageName(), new HashSet<ClassDescriptor>(newClasses.values()));
            return newModel;
        }
        catch (MetaDataException err) {
            throw new ModelMergerException(err);
        }
    }

    protected static Map<String, ClassDescriptor> removeRedundancy(Map<String, ClassDescriptor> classes) throws ModelMergerException {
        HashMap<String, ClassDescriptor> newSet = new HashMap<String, ClassDescriptor>();
        for (ClassDescriptor cd : classes.values()) {
            Set<CollectionDescriptor> cdescs = ModelMerger.cloneCollectionDescriptors(cd.getCollectionDescriptors());
            Set<AttributeDescriptor> adescs = ModelMerger.cloneAttributeDescriptors(cd.getAttributeDescriptors());
            Set<ReferenceDescriptor> rdescs = ModelMerger.cloneReferenceDescriptors(cd.getReferenceDescriptors());
            HashSet<String> supers = new HashSet<String>();
            ModelMerger.findAllSuperclasses(cd, classes, supers);
            for (String sup : supers) {
                String scdRevFieldName;
                String revName;
                ReferenceDescriptor scdDescriptor;
                ClassDescriptor scd = classes.get(sup);
                Iterator<AttributeDescriptor> aiter = adescs.iterator();
                while (aiter.hasNext()) {
                    AttributeDescriptor ad = aiter.next();
                    if (scd.getAttributeDescriptorByName(ad.getName()) == null) continue;
                    LOG.info((Object)("removing attribute " + ad.getName() + " redefinition in " + cd.getName() + " (is now defined in " + scd.getName() + ")"));
                    aiter.remove();
                }
                Iterator<ReferenceDescriptor> riter = rdescs.iterator();
                while (riter.hasNext()) {
                    ReferenceDescriptor rd = riter.next();
                    scdDescriptor = scd.getReferenceDescriptorByName(rd.getName());
                    if (scdDescriptor == null) continue;
                    LOG.info((Object)("removing reference " + rd.getName() + " redefinition in " + cd.getName() + " (is now defined in " + scd.getName() + ")"));
                    revName = rd.getReverseReferenceFieldName();
                    scdRevFieldName = scdDescriptor.getReverseReferenceFieldName();
                    if (StringUtils.equals((String)revName, (String)scdRevFieldName)) {
                        riter.remove();
                        continue;
                    }
                    String message = "replacing the \"" + sup + "." + rd.getName() + "\" reference with " + cd.getName() + "." + rd.getName() + " failed because the reverse references differ";
                    throw new ModelMergerException(message);
                }
                Iterator<CollectionDescriptor> citer = cdescs.iterator();
                while (citer.hasNext()) {
                    CollectionDescriptor cold = citer.next();
                    scdDescriptor = scd.getCollectionDescriptorByName(cold.getName());
                    if (scd.getCollectionDescriptorByName(cold.getName()) == null) continue;
                    LOG.info((Object)("removing collection " + cold.getName() + " redefinition in " + cd.getName() + " (is now defined in " + scd.getName() + ")"));
                    revName = cold.getReverseReferenceFieldName();
                    scdRevFieldName = scdDescriptor.getReverseReferenceFieldName();
                    if (StringUtils.equals((String)revName, (String)scdRevFieldName)) {
                        citer.remove();
                        continue;
                    }
                    String message = "replacing the \"" + sup + "." + cold.getName() + "\" collection with " + cd.getName() + "." + cold.getName() + " failed because the reverse references differ";
                    throw new ModelMergerException(message);
                }
            }
            String supersStr = ModelMerger.toSupersString(cd.getSuperclassNames());
            newSet.put(cd.getName(), new ClassDescriptor(cd.getName(), supersStr, cd.isInterface(), ModelMerger.cloneAttributeDescriptors(adescs), ModelMerger.cloneReferenceDescriptors(rdescs), ModelMerger.cloneCollectionDescriptors(cdescs)));
        }
        return newSet;
    }

    private static String toSupersString(Set<String> supers) {
        String supersStr = StringUtil.join(supers, " ");
        if (supersStr != null && "".equals(supersStr)) {
            supersStr = null;
        }
        return supersStr;
    }

    private static void findAllSuperclasses(ClassDescriptor cd, Map<String, ClassDescriptor> classes, Set<String> names) throws ModelMergerException {
        Set<String> supers = cd.getSuperclassNames();
        for (String superClassName : supers) {
            if ("java.lang.Object".equals(superClassName)) continue;
            names.add(superClassName);
            ClassDescriptor cld = classes.get(superClassName);
            if (cld == null) {
                throw new ModelMergerException("cannot find superclass \"" + superClassName + "\" of " + cd + " in the model");
            }
            ModelMerger.findAllSuperclasses(cld, classes, names);
        }
    }

    public static ClassDescriptor mergeClass(ClassDescriptor original, ClassDescriptor merge, Model originalModel, Set<ClassDescriptor> mergeClasses) throws ModelMergerException {
        String supersStr;
        if (merge.isInterface() != original.isInterface()) {
            throw new ModelMergerException(original.getName() + ".isInterface/" + original.isInterface() + " != " + merge.getName() + ".isInterface/" + merge.isInterface());
        }
        Set<AttributeDescriptor> attrs = ModelMerger.mergeAttributes(original, merge);
        Set<CollectionDescriptor> cols = ModelMerger.mergeCollections(original, merge);
        Set<ReferenceDescriptor> refs = ModelMerger.mergeReferences(original, merge);
        TreeSet<String> supers = new TreeSet<String>();
        boolean replacingSuperclass = false;
        if (original.getSuperclassDescriptor() != null) {
            Set<String> superNames = merge.getSuperclassNames();
            for (String clsName : superNames) {
                ClassDescriptor cld = originalModel.getClassDescriptorByName(clsName);
                if (cld != null && !cld.isInterface()) {
                    replacingSuperclass = true;
                    break;
                }
                cld = ModelMerger.descriptorByName(mergeClasses, clsName);
                if (cld == null || cld.isInterface()) continue;
                replacingSuperclass = true;
                break;
            }
        }
        supers.addAll(original.getSuperclassNames());
        supers.addAll(merge.getSuperclassNames());
        if (replacingSuperclass) {
            supers.remove(original.getSuperclassDescriptor().getName());
        }
        if ((supersStr = StringUtil.join(supers, " ")) != null && "".equals(supersStr)) {
            supersStr = null;
        }
        return new ClassDescriptor(original.getName(), supersStr, merge.isInterface(), attrs, refs, cols);
    }

    public static Set<AttributeDescriptor> mergeAttributes(ClassDescriptor original, ClassDescriptor merge) throws ModelMergerException {
        for (AttributeDescriptor merg : merge.getAttributeDescriptors()) {
            AttributeDescriptor orig = original.getAttributeDescriptorByName(merg.getName());
            if (orig == null || merg.getType().equals(orig.getType())) continue;
            String fldName = original.getName() + "." + orig.getName();
            throw new ModelMergerException("type mismatch between attributes: " + fldName + ":" + merg.getType() + " != " + fldName + ":" + orig.getType());
        }
        HashSet<AttributeDescriptor> newSet = new HashSet<AttributeDescriptor>();
        newSet.addAll(ModelMerger.cloneAttributeDescriptors(original.getAttributeDescriptors()));
        newSet.addAll(ModelMerger.cloneAttributeDescriptors(merge.getAttributeDescriptors()));
        return newSet;
    }

    public static Set<CollectionDescriptor> mergeCollections(ClassDescriptor original, ClassDescriptor merge) throws ModelMergerException {
        HashSet<CollectionDescriptor> newSet = new HashSet<CollectionDescriptor>();
        newSet.addAll(ModelMerger.cloneCollectionDescriptors(original.getCollectionDescriptors()));
        for (CollectionDescriptor merg : merge.getCollectionDescriptors()) {
            CollectionDescriptor orig = original.getCollectionDescriptorByName(merg.getName());
            if (orig != null) {
                if (merg.getReverseReferenceFieldName() != null && orig.getReverseReferenceFieldName() == null) {
                    ModelMerger.removeFieldDescriptor(newSet, orig.getName());
                    newSet.add(ModelMerger.cloneCollectionDescriptor(merg));
                    continue;
                }
                if (!StringUtils.equals((String)merg.getReverseReferenceFieldName(), (String)orig.getReverseReferenceFieldName())) {
                    String fldName = original.getName() + "." + orig.getName();
                    throw new ModelMergerException("mismatch between reverse reference field name: " + fldName + "<-" + merg.getReverseReferenceFieldName() + " != " + fldName + "<-" + orig.getReverseReferenceFieldName());
                }
                if (!merg.getReferencedClassName().equals(orig.getReferencedClassName())) {
                    String fldName = original.getName() + "." + orig.getName();
                    throw new ModelMergerException("type mismatch between collection types: " + fldName + ":" + merg.getReferencedClassName() + " != " + fldName + ":" + orig.getReferencedClassName());
                }
            }
            newSet.add(ModelMerger.cloneCollectionDescriptor(merg));
        }
        return newSet;
    }

    public static Set<ReferenceDescriptor> mergeReferences(ClassDescriptor original, ClassDescriptor merge) throws ModelMergerException {
        HashSet<ReferenceDescriptor> newSet = new HashSet<ReferenceDescriptor>();
        newSet.addAll(ModelMerger.cloneReferenceDescriptors(original.getReferenceDescriptors()));
        for (ReferenceDescriptor merg : merge.getReferenceDescriptors()) {
            ReferenceDescriptor orig = original.getReferenceDescriptorByName(merg.getName());
            if (orig != null) {
                if (merg.getReverseReferenceFieldName() != null && orig.getReverseReferenceFieldName() == null) {
                    ModelMerger.removeFieldDescriptor(newSet, orig.getName());
                    newSet.add(ModelMerger.cloneReferenceDescriptor(merg));
                    continue;
                }
                if (!merg.getReferencedClassName().equals(orig.getReferencedClassName())) {
                    String fldName = original.getName() + "." + orig.getName();
                    throw new ModelMergerException("type mismatch between reference types: " + fldName + ":" + merg.getReferencedClassName() + " != " + fldName + ":" + orig.getReferencedClassName());
                }
                if (!StringUtils.equals((String)merg.getReverseReferenceFieldName(), (String)orig.getReverseReferenceFieldName())) {
                    String fldName = original.getName() + "." + orig.getName();
                    throw new ModelMergerException("mismatch between reverse reference field name: " + fldName + "<-" + merg.getReverseReferenceFieldName() + " != " + fldName + "<-" + orig.getReverseReferenceFieldName());
                }
            }
            newSet.add(ModelMerger.cloneReferenceDescriptor(merg));
        }
        return newSet;
    }

    protected static Set<ReferenceDescriptor> cloneReferenceDescriptors(Set<ReferenceDescriptor> refs) {
        HashSet<ReferenceDescriptor> copy = new HashSet<ReferenceDescriptor>();
        for (ReferenceDescriptor ref : refs) {
            copy.add(ModelMerger.cloneReferenceDescriptor(ref));
        }
        return copy;
    }

    private static ReferenceDescriptor cloneReferenceDescriptor(ReferenceDescriptor ref) {
        return new ReferenceDescriptor(ref.getName(), ref.getReferencedClassName(), ref.getReverseReferenceFieldName());
    }

    protected static Set<CollectionDescriptor> cloneCollectionDescriptors(Set<CollectionDescriptor> refs) {
        LinkedHashSet<CollectionDescriptor> copy = new LinkedHashSet<CollectionDescriptor>();
        for (CollectionDescriptor ref : refs) {
            copy.add(ModelMerger.cloneCollectionDescriptor(ref));
        }
        return copy;
    }

    private static CollectionDescriptor cloneCollectionDescriptor(CollectionDescriptor ref) {
        return new CollectionDescriptor(ref.getName(), ref.getReferencedClassName(), ref.getReverseReferenceFieldName());
    }

    protected static void removeFieldDescriptor(Set<? extends FieldDescriptor> fields, String name) {
        Iterator<? extends FieldDescriptor> iter = fields.iterator();
        while (iter.hasNext()) {
            FieldDescriptor desc = iter.next();
            if (!desc.getName().equals(name)) continue;
            iter.remove();
            return;
        }
    }

    protected static Set<AttributeDescriptor> cloneAttributeDescriptors(Set<AttributeDescriptor> refs) {
        HashSet<AttributeDescriptor> copy = new HashSet<AttributeDescriptor>();
        for (AttributeDescriptor ref : refs) {
            copy.add(new AttributeDescriptor(ref.getName(), ref.getType()));
        }
        return copy;
    }

    protected static ClassDescriptor cloneClassDescriptor(ClassDescriptor cld) {
        String supers = StringUtil.join(cld.getSuperclassNames(), " ");
        if (supers != null && "".equals(supers)) {
            supers = null;
        }
        return new ClassDescriptor(cld.getName(), supers, cld.isInterface(), ModelMerger.cloneAttributeDescriptors(cld.getAttributeDescriptors()), ModelMerger.cloneReferenceDescriptors(cld.getReferenceDescriptors()), ModelMerger.cloneCollectionDescriptors(cld.getCollectionDescriptors()));
    }

    private static ClassDescriptor descriptorByName(Set<ClassDescriptor> clds, String name) {
        for (ClassDescriptor cld : clds) {
            if (!cld.getName().equals(name)) continue;
            return cld;
        }
        return null;
    }
}

