/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.modelproduction;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.List;
import java.util.Set;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.ModelMerger;
import org.intermine.modelproduction.ModelMergerException;
import org.intermine.modelproduction.ModelParser;
import org.intermine.modelproduction.ModelParserException;

public class ModelFileMerger {
    public static Model mergeModelFromFiles(File inputModelFile, List<File> additionsFiles, ModelParser parser) throws MetaDataException {
        Model mergedModel = null;
        try {
            FileReader reader = new FileReader(inputModelFile);
            mergedModel = parser.process(reader);
            reader.close();
        }
        catch (Exception e) {
            throw new MetaDataException("failed to read model file: " + inputModelFile, e);
        }
        if (additionsFiles.size() == 0) {
            throw new MetaDataException("no addition files set");
        }
        for (File additionsFile : additionsFiles) {
            try {
                mergedModel = ModelFileMerger.processFile(mergedModel, additionsFile, parser);
            }
            catch (Exception e) {
                throw new MetaDataException("Exception while merging " + additionsFile + " into " + inputModelFile, e);
            }
        }
        return mergedModel;
    }

    private static Model processFile(Model mergedModel, File newAdditionsFile, ModelParser parser) throws ModelParserException, ModelMergerException, FileNotFoundException {
        Set<ClassDescriptor> additionClds = parser.generateClassDescriptors(new FileReader(newAdditionsFile), mergedModel.getPackageName());
        System.err.println("merging model additions from: " + newAdditionsFile);
        Model newMergedModel = ModelMerger.mergeModel(mergedModel, additionClds);
        return newMergedModel;
    }
}

