/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.modelproduction;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.intermine.metadata.Model;
import org.intermine.modelproduction.xml.InterMineModelParser;
import org.intermine.sql.Database;
import org.intermine.util.PropertiesUtil;
import org.intermine.util.StringUtil;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public final class MetadataManager {
    public static final String METADATA_TABLE = "intermine_metadata";
    public static final String MODEL = "model";
    public static final String KEY_DEFINITIONS = "keyDefs";
    public static final String CLASS_KEYS = "class_keys";
    public static final String OS_SUMMARY = "objectStoreSummary";
    public static final String AUTOCOMPLETE_INDEX = "autocomplete";
    public static final String SEARCH_INDEX = "search";
    public static final String SEARCH_INDEX_DIRECTORY = "search_directory";
    public static final String OS_FORMAT_VERSION = "osversion";
    public static final String PROFILE_FORMAT_VERSION = "profileversion";
    public static final String TRUNCATED_CLASSES = "truncatedClasses";
    public static final String MISSING_TABLES = "missingTables";
    public static final String NO_NOTXML = "noNotXml";
    public static final String MODMINE_METADATA_CACHE = "modMine_metadata_cache";
    public static final String SERIAL_NUMBER = "serialNumber";

    private MetadataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Database database, String key, String value) throws SQLException {
        Connection connection = database.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(true);
            connection.createStatement().execute("DELETE FROM intermine_metadata where key = '" + key + "'");
            if (value != null) {
                connection.createStatement().execute("INSERT INTO intermine_metadata (key, value) VALUES('" + key + "', '" + StringUtil.duplicateQuotes(value) + "')");
            }
        }
        finally {
            connection.setAutoCommit(autoCommit);
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeBinary(Database database, String key, byte[] value) throws SQLException {
        Connection connection = database.getConnection();
        boolean autoCommit = connection.getAutoCommit();
        try {
            connection.setAutoCommit(false);
            ResultSet rs = connection.createStatement().executeQuery("SELECT * FROM intermine_metadata");
            ResultSetMetaData meta = rs.getMetaData();
            if (meta.getColumnCount() != 3) {
                connection.createStatement().execute("ALTER TABLE intermine_metadata ADD blob_value BYTEA");
            }
            connection.createStatement().execute("DELETE FROM intermine_metadata where key = '" + key + "'");
            PreparedStatement pstmt = connection.prepareStatement("INSERT INTO intermine_metadata (key, blob_value) VALUES('" + key + "', ?)");
            pstmt.setBytes(1, value);
            pstmt.executeUpdate();
            connection.commit();
            pstmt.close();
        }
        finally {
            connection.setAutoCommit(autoCommit);
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String retrieve(Database database, String key) throws SQLException {
        String value = null;
        Connection connection = database.getConnection();
        try {
            String sql = "SELECT value FROM intermine_metadata WHERE key='" + key + "'";
            ResultSet rs = connection.createStatement().executeQuery(sql);
            if (!rs.next()) {
                String string = null;
                return string;
            }
            value = rs.getString(1);
        }
        finally {
            connection.close();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream retrieveBLOBInputStream(Database database, String key) throws SQLException {
        InputStream value = null;
        Connection connection = database.getConnection();
        try {
            String sql = "SELECT blob_value FROM intermine_metadata WHERE key ='" + key + "'";
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery(sql);
            if (rs.next()) {
                InputStream inputStream = value = rs.getBinaryStream("blob_value");
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            connection.close();
        }
    }

    public static LargeObjectOutputStream storeLargeBinary(Database database, String key) throws SQLException {
        Connection con = database.getConnection();
        try {
            String blobValue;
            con.setAutoCommit(false);
            Statement s = con.createStatement();
            ResultSet r = s.executeQuery("SELECT value FROM intermine_metadata WHERE key = '" + key + "'");
            long blob = 0L;
            boolean needNewBlob = true;
            if (r.next() && (blobValue = r.getString(1)) != null && MetadataManager.isLargeObject(blobValue)) {
                blob = MetadataManager.getBlobId(blobValue);
                needNewBlob = false;
            }
            LargeObjectManager lom = ((PGConnection)con).getLargeObjectAPI();
            if (needNewBlob) {
                blob = lom.createLO(393216);
                s.execute("DELETE FROM intermine_metadata WHERE key = '" + key + "'");
                s.execute("INSERT INTO intermine_metadata (key, value) VALUES('" + key + "', 'BLOB: " + blob + "')");
            }
            LargeObject obj = lom.open(blob, 131072);
            obj.truncate(0);
            return new LargeObjectOutputStream(con, obj);
        }
        catch (SQLException e) {
            try {
                con.setAutoCommit(true);
                con.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteLargeBinary(Database database, String key) throws SQLException {
        Connection con = database.getConnection();
        boolean foundBlob = false;
        try {
            con.setAutoCommit(false);
            Statement s = con.createStatement();
            ResultSet r = s.executeQuery("SELECT value FROM intermine_metadata WHERE key = '" + key + "'");
            long blob = 0L;
            if (r.next()) {
                String blobValue = r.getString(1);
                if (blobValue != null && MetadataManager.isLargeObject(blobValue)) {
                    blob = MetadataManager.getBlobId(blobValue);
                    foundBlob = true;
                    LargeObjectManager lom = ((PGConnection)con).getLargeObjectAPI();
                    lom.delete(blob);
                }
                s.execute("DELETE FROM intermine_metadata WHERE key = '" + key + "'");
            }
        }
        finally {
            con.setAutoCommit(true);
            con.close();
        }
        return foundBlob;
    }

    private static boolean isLargeObject(String value) {
        return value.startsWith("BLOB: ");
    }

    private static long getBlobId(String value) {
        return Long.parseLong(value.substring("BLOB: ".length()));
    }

    public static LargeObjectInputStream readLargeBinary(Database database, String key) throws SQLException {
        Connection con = database.getConnection();
        try {
            con.setAutoCommit(false);
            Statement s = con.createStatement();
            ResultSet r = s.executeQuery("SELECT value FROM intermine_metadata WHERE key = '" + key + "'");
            long blob = 0L;
            if (r.next()) {
                String blobValue = r.getString(1);
                if (blobValue != null && blobValue.startsWith("BLOB: ")) {
                    blob = Long.parseLong(blobValue.substring(6));
                    LargeObjectManager lom = ((PGConnection)con).getLargeObjectAPI();
                    LargeObject obj = lom.open(blob, 262144);
                    return new LargeObjectInputStream(con, obj);
                }
                throw new SQLException("Value is not a large object");
            }
            con.setAutoCommit(true);
            con.close();
            return null;
        }
        catch (SQLException e) {
            try {
                con.setAutoCommit(true);
                con.close();
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    public static Model loadModel(String name) {
        String filename = MetadataManager.getFilename(MODEL, name);
        InputStream is = Model.class.getClassLoader().getResourceAsStream(filename);
        if (is == null) {
            throw new IllegalArgumentException("Model definition file '" + filename + "' cannot be found");
        }
        Model model = null;
        try {
            model = new InterMineModelParser().process(new InputStreamReader(is));
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing model definition file '" + filename + "'", e);
        }
        return model;
    }

    public static void saveModel(Model model, File destDir) throws IOException {
        MetadataManager.write(model.toString(), new File(destDir, MetadataManager.getFilename(MODEL, model.getName())));
    }

    public static Properties loadKeyDefinitions(String modelName) {
        return PropertiesUtil.loadProperties(MetadataManager.getFilename(KEY_DEFINITIONS, modelName));
    }

    public static Properties loadClassKeyDefinitions() {
        return PropertiesUtil.loadProperties(MetadataManager.getFilename(CLASS_KEYS, null));
    }

    public static void saveKeyDefinitions(String properties, File destDir, String modelName) throws IOException {
        MetadataManager.write(properties, new File(destDir, MetadataManager.getFilename(KEY_DEFINITIONS, modelName)));
    }

    public static void saveClassKeys(String properties, File destDir) throws IOException {
        MetadataManager.write(properties, new File(destDir, MetadataManager.getFilename(CLASS_KEYS, null)));
    }

    public static void saveProperties(String properties, File destDir, String fileName) throws IOException {
        MetadataManager.write(properties, new File(destDir, fileName));
    }

    public static String getFilename(String key, String modelName) {
        String filename = modelName == null ? key : modelName + "_" + key;
        if (MODEL.equals(key)) {
            return filename + ".xml";
        }
        if (KEY_DEFINITIONS.equals(key) || CLASS_KEYS.equals(key)) {
            return filename + ".properties";
        }
        throw new IllegalArgumentException("Unrecognised key '" + key + "'");
    }

    private static void write(String string, File file) throws IOException {
        if (file.exists() && IOUtils.contentEquals((Reader)new FileReader(file), (Reader)new StringReader(string))) {
            System.err.println("Not writing \"" + file.getName() + "\" as version in database is identical to local copy");
            return;
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(string);
        writer.close();
    }

    public static class LargeObjectInputStream
    extends InputStream {
        private Connection con;
        private LargeObject obj;

        public LargeObjectInputStream(Connection con, LargeObject obj) {
            this.con = con;
            this.obj = obj;
        }

        @Override
        public int read() throws IOException {
            try {
                byte[] array = new byte[1];
                int c = this.obj.read(array, 0, 1);
                if (c == 1) {
                    return array[0] & 0xFF;
                }
                if (c == 0) {
                    return -1;
                }
                throw new IOException("Wrong data returned");
            }
            catch (SQLException e) {
                IOException e2 = new IOException("Error reading from database");
                e2.initCause(e);
                throw e2;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.obj.read(b, off, len);
            }
            catch (SQLException e) {
                IOException e2 = new IOException("Error reading from database");
                e2.initCause(e);
                throw e2;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.con != null) {
                try {
                    this.obj.close();
                    this.con.commit();
                    this.con.setAutoCommit(true);
                    this.con.close();
                    this.obj = null;
                    this.con = null;
                }
                catch (SQLException e) {
                    IOException e2 = new IOException("Error closing large object");
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
    }

    public static class LargeObjectOutputStream
    extends OutputStream {
        Connection con;
        LargeObject obj;

        public LargeObjectOutputStream(Connection con, LargeObject obj) {
            this.con = con;
            this.obj = obj;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] array = new byte[]{(byte)b};
            this.write(array, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.obj.write(b, off, len);
            }
            catch (SQLException e) {
                IOException e2 = new IOException("Error writing to large object");
                e2.initCause(e);
                throw e2;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.con != null) {
                try {
                    this.obj.close();
                    this.con.commit();
                    this.con.setAutoCommit(true);
                    this.con.close();
                    this.obj = null;
                    this.con = null;
                }
                catch (SQLException e) {
                    IOException e2 = new IOException("Error closing large object");
                    e2.initCause(e);
                    throw e2;
                }
            }
        }
    }
}

