/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.util.Util;

public class ReferenceDescriptor
extends FieldDescriptor {
    protected final String referencedType;
    protected ClassDescriptor referencedClassDesc;
    protected final String reverseRefName;
    protected ReferenceDescriptor reverseRefDesc;
    private boolean modelSet = false;

    public ReferenceDescriptor(String name, String referencedType, String reverseRefName) {
        super(name);
        if (referencedType == null || "".equals(referencedType)) {
            throw new IllegalArgumentException("A value must be provided for the referenced type");
        }
        this.reverseRefName = reverseRefName;
        this.referencedType = referencedType;
    }

    public ClassDescriptor getReferencedClassDescriptor() {
        if (!this.modelSet) {
            throw new IllegalStateException("This ReferenceDescriptor (" + this.getName() + ") is not yet part of a metadata Model");
        }
        return this.referencedClassDesc;
    }

    public String getReverseReferenceFieldName() {
        return this.reverseRefName;
    }

    public String getReferencedClassName() {
        return this.referencedType;
    }

    public ReferenceDescriptor getReverseReferenceDescriptor() {
        if (!this.modelSet) {
            throw new IllegalStateException("This ReferenceDescriptor (" + this.getName() + ") is not yet part of a metadata Model");
        }
        return this.reverseRefDesc;
    }

    protected void findReferencedDescriptor() throws MetaDataException {
        if (!this.cld.getModel().hasClassDescriptor(this.referencedType)) {
            throw new MetaDataException("Unable to find ClassDescriptor for '" + this.referencedType + "' in model while processing: " + this.cld.getName() + "." + this.name);
        }
        this.referencedClassDesc = this.cld.getModel().getClassDescriptorByName(this.referencedType);
        if (this.reverseRefName != null && !"".equals(this.reverseRefName)) {
            this.reverseRefDesc = this.referencedClassDesc.getReferenceDescriptorByName(this.reverseRefName);
            if (this.reverseRefDesc == null) {
                this.reverseRefDesc = this.referencedClassDesc.getCollectionDescriptorByName(this.reverseRefName);
            }
            if (this.reverseRefDesc == null) {
                throw new MetaDataException("Unable to find named reverse reference '" + this.reverseRefName + "' in class " + this.referencedClassDesc.getName() + " while processing: " + this.getClassDescriptor().getName() + "." + this.getName());
            }
        }
        this.modelSet = true;
    }

    @Override
    public int relationType() {
        ReferenceDescriptor rd = this.getReverseReferenceDescriptor();
        if (rd == null || rd instanceof CollectionDescriptor) {
            return 3;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferenceDescriptor) {
            ReferenceDescriptor ref = (ReferenceDescriptor)obj;
            return this.name.equals(ref.name) && this.referencedType.equals(ref.referencedType) && Util.equals(this.reverseRefName, ref.reverseRefName);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.name.hashCode() + 7 * this.referencedType.hashCode() + 11 * Util.hashCode(this.reverseRefName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<reference name=\"" + this.name + "\" referenced-type=\"" + this.referencedType.substring(this.referencedType.lastIndexOf(".") + 1) + "\"").append(this.reverseRefName != null ? " reverse-reference=\"" + this.reverseRefName + "\"" : "").append("/>");
        return sb.toString();
    }

    @Override
    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\"name\":\"" + this.name + "\"," + "\"referencedType\":\"" + this.referencedType.substring(this.referencedType.lastIndexOf(".") + 1) + "\"");
        if (this.reverseRefName != null) {
            sb.append(",\"reverseReference\":\"" + this.reverseRefName + "\"");
        }
        sb.append("}");
        return sb.toString();
    }
}

