/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.LinkedHashSet;
import java.util.Set;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;

public class PrimaryKey {
    String name;
    Set<String> fieldNames = new LinkedHashSet<String>();
    ClassDescriptor cld;

    public PrimaryKey(String name, String fields, ClassDescriptor cld) {
        this.name = name;
        this.cld = cld;
        if (fields == null) {
            throw new NullPointerException("fields parameter cannot be null");
        }
        String[] tokens = fields.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            FieldDescriptor field = cld.getFieldDescriptorByName(token);
            if (field == null) {
                throw new IllegalArgumentException("No such field name " + token + " in class " + cld.getName() + " for primary key " + name);
            }
            if (field instanceof CollectionDescriptor) {
                throw new IllegalArgumentException("Field " + token + " in primary key " + cld.getName() + "." + name + " is a collection - must be an attribute " + "or a reference");
            }
            this.fieldNames.add(token);
        }
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public boolean equals(Object o) {
        if (o instanceof PrimaryKey) {
            return ((Object)this.fieldNames).equals(((PrimaryKey)o).fieldNames) && this.cld.equals(((PrimaryKey)o).cld);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fieldNames).hashCode() + this.cld.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<fields=\"");
        boolean needComma = false;
        for (String fieldName : this.getFieldNames()) {
            if (needComma) {
                sb.append(",");
            }
            sb.append(fieldName);
        }
        sb.append("\">");
        return sb.toString();
    }
}

