/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.InterMineObject;
import org.intermine.modelproduction.MetadataManager;
import org.intermine.objectstore.query.ClobAccess;
import org.intermine.util.TypeUtil;

public class Model {
    private static Map<String, Model> models = new HashMap<String, Model>();
    protected static final String ENDL = System.getProperty("line.separator");
    private final String modelName;
    private final String packageName;
    private final Map<String, ClassDescriptor> cldMap = new LinkedHashMap<String, ClassDescriptor>();
    private final Map<ClassDescriptor, Set<ClassDescriptor>> subMap = new LinkedHashMap<ClassDescriptor, Set<ClassDescriptor>>();
    private final Map<Class<?>, Set<ClassDescriptor>> classToClassDescriptorSet = new HashMap();
    private final Map<Class<?>, Map<String, FieldDescriptor>> classToFieldDescriptorMap = new HashMap();
    private final Map<Class<?>, Map<String, Class<?>>> classToCollectionsMap = new HashMap();
    private final ClassDescriptor rootCld;
    private List<ClassDescriptor> topDownOrderClasses = null;
    private List<ClassDescriptor> bottomUpOrderClasses = null;
    private boolean generatedClassesAvailable = true;

    public static Model getInstanceByName(String name) {
        if (!models.containsKey(name)) {
            models.put(name, MetadataManager.loadModel(name));
        }
        return models.get(name);
    }

    public static void addModel(String name, Model model) {
        models.put(name, model);
    }

    public Model(String name, String packageName, Set<ClassDescriptor> clds) throws MetaDataException {
        if (name == null) {
            throw new NullPointerException("Model name cannot be null");
        }
        if ("".equals(name)) {
            throw new IllegalArgumentException("Model name cannot be empty");
        }
        if (packageName == null) {
            throw new NullPointerException("Package name cannot be null");
        }
        if (clds == null) {
            throw new NullPointerException("Model ClassDescriptors list cannot be null");
        }
        this.modelName = name;
        this.packageName = packageName;
        LinkedHashSet<ClassDescriptor> orderedClds = new LinkedHashSet<ClassDescriptor>(clds);
        Set<ReferenceDescriptor> emptyRefs = Collections.emptySet();
        Set<CollectionDescriptor> emptyCols = Collections.emptySet();
        ClassDescriptor intermineObject = new ClassDescriptor("org.intermine.model.InterMineObject", null, true, Collections.singleton(new AttributeDescriptor("id", "java.lang.Integer")), emptyRefs, emptyCols);
        orderedClds.add(intermineObject);
        this.rootCld = intermineObject;
        for (ClassDescriptor cld : orderedClds) {
            String cldPackage;
            String cldName = cld.getName();
            int lastDotPos = cldName.lastIndexOf(".");
            String string = cldPackage = lastDotPos == -1 ? "" : cldName.substring(0, lastDotPos);
            if (!"org.intermine.model.InterMineObject".equals(cldName) && !packageName.equals(cldPackage)) {
                throw new IllegalArgumentException("Class \"" + cldName + "\" is not in model " + "package \"" + packageName + "\"");
            }
            this.cldMap.put(cld.getName(), cld);
            this.subMap.put(cld, new LinkedHashSet());
        }
        for (ClassDescriptor cld : orderedClds) {
            cld.setModel(this);
        }
        for (ClassDescriptor cld : orderedClds) {
            Set<ClassDescriptor> supers = cld.getSuperDescriptors();
            for (ClassDescriptor iCld : supers) {
                Set<ClassDescriptor> subs = this.subMap.get(iCld);
                subs.add(cld);
            }
        }
        for (ClassDescriptor cld : orderedClds) {
            cld.setAllFieldDescriptors();
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Set<ClassDescriptor> getDirectSubs(ClassDescriptor cld) {
        return this.subMap.get(cld);
    }

    public Set<ClassDescriptor> getAllSubs(ClassDescriptor cld) {
        TreeSet<ClassDescriptor> returnSubs = new TreeSet<ClassDescriptor>();
        Set<ClassDescriptor> directSubs = this.getDirectSubs(cld);
        returnSubs.addAll(directSubs);
        for (ClassDescriptor sub : directSubs) {
            returnSubs.addAll(this.getAllSubs(sub));
        }
        return returnSubs;
    }

    public ClassDescriptor getClassDescriptorByName(String name) {
        ClassDescriptor cd = this.cldMap.get(name);
        if (cd == null) {
            return this.cldMap.get(this.getPackageName() + "." + name);
        }
        return cd;
    }

    public Set<ClassDescriptor> getClassDescriptors() {
        return new LinkedHashSet<ClassDescriptor>(this.cldMap.values());
    }

    public boolean hasClassDescriptor(String name) {
        boolean found = this.cldMap.containsKey(name);
        if (!found) {
            found = this.cldMap.containsKey(this.getPackageName() + "." + name);
        }
        return found;
    }

    public Set<String> getClassNames() {
        return this.cldMap.keySet();
    }

    public String getName() {
        return this.modelName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Model) {
            Model model = (Model)obj;
            return this.modelName.equals(model.modelName) && ((Object)this.cldMap).equals(model.cldMap);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.modelName.hashCode() + 5 * ((Object)this.cldMap).hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<model name=\"" + this.modelName + "\" package=\"" + this.packageName + "\">" + ENDL);
        for (ClassDescriptor cld : this.getClassDescriptors()) {
            if ("org.intermine.model.InterMineObject".equals(cld.getName())) continue;
            sb.append(cld.toString());
        }
        sb.append("</model>");
        return sb.toString();
    }

    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\"name\":\"" + this.modelName + "\",\"classes\":{");
        boolean needsComma = false;
        for (ClassDescriptor cld : this.getClassDescriptors()) {
            if ("org.intermine.model.InterMineObject".equals(cld.getName())) continue;
            if (needsComma) {
                sb.append(",");
            }
            sb.append(cld.toJSONString());
            needsComma = true;
        }
        sb.append("}");
        return sb.toString();
    }

    public String toAdditionsXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\"?>" + ENDL + "<classes>" + ENDL);
        for (ClassDescriptor cld : this.getClassDescriptors()) {
            if ("org.intermine.model.InterMineObject".equals(cld.getName())) continue;
            sb.append(cld.toString());
        }
        sb.append("</classes>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClassDescriptor> getClassDescriptorsForClass(Class<?> c) {
        Map<Class<?>, Set<ClassDescriptor>> map = this.classToClassDescriptorSet;
        synchronized (map) {
            Set<ClassDescriptor> retval = this.classToClassDescriptorSet.get(c);
            if (retval == null) {
                retval = new LinkedHashSet<ClassDescriptor>();
                Stack todo = new Stack();
                HashSet<Class> done = new HashSet<Class>();
                todo.push(c);
                while (!todo.empty()) {
                    Class superClass;
                    Class toAdd = (Class)todo.pop();
                    if (done.contains(toAdd)) continue;
                    ClassDescriptor cld = this.getClassDescriptorByName(toAdd.getName());
                    if (cld != null) {
                        retval.add(cld);
                    }
                    if ((superClass = toAdd.getSuperclass()) != null && InterMineObject.class.isAssignableFrom(superClass)) {
                        todo.push(superClass);
                    }
                    Class<?>[] interfaces = toAdd.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        if (!InterMineObject.class.isAssignableFrom(interfaces[i])) continue;
                        todo.push(interfaces[i]);
                    }
                    done.add(toAdd);
                }
                this.classToClassDescriptorSet.put(c, retval);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, FieldDescriptor> getFieldDescriptorsForClass(Class<?> c) {
        Map<Class<?>, Map<String, FieldDescriptor>> map = this.classToFieldDescriptorMap;
        synchronized (map) {
            Map<String, FieldDescriptor> retval = this.classToFieldDescriptorMap.get(c);
            if (retval == null) {
                retval = new LinkedHashMap<String, FieldDescriptor>();
                for (ClassDescriptor cld : this.getClassDescriptorsForClass(c)) {
                    for (FieldDescriptor fd : cld.getFieldDescriptors()) {
                        retval.put(fd.getName(), fd);
                    }
                }
                this.classToFieldDescriptorMap.put(c, retval);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Class<?>> getCollectionsForClass(Class<?> c) {
        Map<Class<?>, Map<String, Class<?>>> map = this.classToCollectionsMap;
        synchronized (map) {
            Map<String, Class<?>> retval = this.classToCollectionsMap.get(c);
            if (retval == null) {
                retval = new LinkedHashMap();
                for (FieldDescriptor fd : this.getFieldDescriptorsForClass(c).values()) {
                    if (!(fd instanceof CollectionDescriptor)) continue;
                    CollectionDescriptor cd = (CollectionDescriptor)fd;
                    retval.put(cd.getName(), cd.getReferencedClassDescriptor().getType());
                }
                this.classToCollectionsMap.put(c, retval);
            }
            return retval;
        }
    }

    public String getQualifiedTypeName(String className) throws ClassNotFoundException {
        if (className.indexOf(".") != -1) {
            throw new IllegalArgumentException("Expected an unqualified class name: " + className);
        }
        if (TypeUtil.instantiate(className) != null) {
            return className;
        }
        if ("InterMineObject".equals(className)) {
            return "org.intermine.model.InterMineObject";
        }
        try {
            return Class.forName(this.getPackageName() + "." + className).getName();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if ("Date".equals(className)) {
                return Date.class.getName();
            }
            if ("BigDecimal".equals(className)) {
                return BigDecimal.class.getName();
            }
            if ("ClobAccess".equals(className)) {
                return ClobAccess.class.getName();
            }
            return Class.forName("java.lang." + className).getName();
        }
    }

    public synchronized List<ClassDescriptor> getTopDownLevelTraversal() {
        if (this.topDownOrderClasses == null) {
            this.topDownOrderClasses = new ArrayList<ClassDescriptor>();
            LinkedList<ClassDescriptor> queue = new LinkedList<ClassDescriptor>();
            queue.addAll(this.getSimpleObjectClassDescriptors());
            queue.add(this.rootCld);
            while (!queue.isEmpty()) {
                ClassDescriptor node = (ClassDescriptor)queue.remove();
                if (!this.topDownOrderClasses.contains(node)) {
                    this.topDownOrderClasses.add(node);
                }
                if (node.getSubDescriptors() == null) continue;
                queue.addAll(node.getSubDescriptors());
            }
        }
        return this.topDownOrderClasses;
    }

    public synchronized List<ClassDescriptor> getBottomUpLevelTraversal() {
        if (this.bottomUpOrderClasses == null) {
            this.bottomUpOrderClasses = new ArrayList<ClassDescriptor>();
            List<ClassDescriptor> topDown = this.getTopDownLevelTraversal();
            for (int i = topDown.size() - 1; i >= 0; --i) {
                this.bottomUpOrderClasses.add(topDown.get(i));
            }
        }
        return this.bottomUpOrderClasses;
    }

    protected Set<ClassDescriptor> getSimpleObjectClassDescriptors() {
        HashSet<ClassDescriptor> simpleObjectClds = new HashSet<ClassDescriptor>();
        for (ClassDescriptor cld : this.getClassDescriptors()) {
            Set<String> superNames = cld.getSuperclassNames();
            if (superNames.size() != 1 || !superNames.contains("java.lang.Object")) continue;
            simpleObjectClds.add(cld);
        }
        return simpleObjectClds;
    }

    public boolean isGeneratedClassesAvailable() {
        return this.generatedClassesAvailable;
    }

    public void setGeneratedClassesAvailable(boolean available) {
        this.generatedClassesAvailable = available;
    }

    public boolean isGeneratedClassAvailable(String className) {
        try {
            this.getQualifiedTypeName(className);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

