/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.MetaDataException;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.util.StringUtil;
import org.intermine.util.TextTable;
import org.intermine.util.TypeUtil;
import org.intermine.util.Util;

public class ClassDescriptor
implements Comparable<ClassDescriptor> {
    private static final String INTERMINEOBJECT_NAME = "org.intermine.model.InterMineObject";
    protected static final String ENDL = System.getProperty("line.separator");
    private final String className;
    private Class<FastPathObject> type;
    private String origSuperNames;
    private final Set<String> superNames = new LinkedHashSet<String>();
    private final Set<ClassDescriptor> superDescriptors = new LinkedHashSet<ClassDescriptor>();
    private Set<ClassDescriptor> allSuperDescriptors = null;
    private ClassDescriptor superclassDescriptor;
    private final boolean isInterface;
    private final Set<AttributeDescriptor> attDescriptors;
    private final Set<ReferenceDescriptor> refDescriptors;
    private final Set<CollectionDescriptor> colDescriptors;
    private final Map<String, FieldDescriptor> fieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();
    private Map<String, FieldDescriptor> allFieldDescriptors = new LinkedHashMap<String, FieldDescriptor>();
    private Model model;
    private boolean modelSet = false;

    public ClassDescriptor(String name, String supers, boolean isInterface, Set<AttributeDescriptor> atts, Set<ReferenceDescriptor> refs, Set<CollectionDescriptor> cols) {
        if (name == null || "".equals(name) || !name.equals(name.trim())) {
            throw new IllegalArgumentException("'name' parameter must be a valid String");
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            throw new IllegalArgumentException("Java field names must start with a character, '$' or '_' but class name was: " + name);
        }
        String unqualified = name.substring(name.lastIndexOf(46) + 1);
        for (int i = 0; i < unqualified.length(); ++i) {
            if (Character.isJavaIdentifierPart(unqualified.charAt(i))) continue;
            throw new IllegalArgumentException("Java field names may not contain character: " + unqualified.charAt(i) + " but class name was: " + unqualified);
        }
        this.className = name.intern();
        if (supers != null && ("".equals(supers) || !supers.equals(supers.trim()))) {
            throw new IllegalArgumentException("'supers' parameter for `" + name + "` must be " + "null or a valid list of interface or superclass names but was :'" + supers + "'");
        }
        this.origSuperNames = supers == null ? "" : supers;
        if (supers != null) {
            this.superNames.addAll(StringUtil.tokenize(supers));
        } else if (!INTERMINEOBJECT_NAME.equals(name)) {
            this.superNames.add(INTERMINEOBJECT_NAME);
        }
        this.isInterface = isInterface;
        this.attDescriptors = new LinkedHashSet<AttributeDescriptor>(atts);
        this.refDescriptors = new LinkedHashSet<ReferenceDescriptor>(refs);
        this.colDescriptors = new LinkedHashSet<CollectionDescriptor>(cols);
        ArrayList<FieldDescriptor> fieldDescriptorList = new ArrayList<FieldDescriptor>();
        fieldDescriptorList.addAll(atts);
        fieldDescriptorList.addAll(refs);
        fieldDescriptorList.addAll(cols);
        for (FieldDescriptor fieldDescriptor : fieldDescriptorList) {
            try {
                fieldDescriptor.setClassDescriptor(this);
                this.fieldDescriptors.put(fieldDescriptor.getName(), fieldDescriptor);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("FieldDescriptor '" + fieldDescriptor.getName() + "' has already had ClassDescriptor set");
            }
        }
    }

    public String getName() {
        return this.className;
    }

    public String getSimpleName() {
        int index = this.className.lastIndexOf(".");
        return this.className.substring(index + 1);
    }

    public synchronized Class<? extends FastPathObject> getType() {
        if (this.type == null) {
            try {
                Class<?> tmpType = Class.forName(this.className);
                if (!FastPathObject.class.isAssignableFrom(tmpType)) {
                    throw new RuntimeException("Class " + this.className + " is not a FastPathObject");
                }
                this.type = tmpType;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can't find class for class descriptor", e);
            }
        }
        return this.type;
    }

    public Set<String> getSuperclassNames() {
        LinkedHashSet<String> copy = new LinkedHashSet<String>(this.superNames);
        copy.remove(INTERMINEOBJECT_NAME);
        return copy;
    }

    public String getUnqualifiedName() {
        return TypeUtil.unqualifiedName(this.className);
    }

    public Set<FieldDescriptor> getFieldDescriptors() {
        return new LinkedHashSet<FieldDescriptor>(this.fieldDescriptors.values());
    }

    public Set<FieldDescriptor> getAllFieldDescriptors() {
        return new LinkedHashSet<FieldDescriptor>(this.allFieldDescriptors.values());
    }

    protected void setAllFieldDescriptors() throws MetaDataException {
        this.allFieldDescriptors = this.findAllFieldDescriptors();
    }

    private LinkedHashMap<String, FieldDescriptor> findAllFieldDescriptors() throws MetaDataException {
        LinkedHashMap<String, FieldDescriptor> map = new LinkedHashMap<String, FieldDescriptor>(this.fieldDescriptors);
        for (ClassDescriptor superDesc : this.superDescriptors) {
            LinkedHashMap<String, FieldDescriptor> toAdd = superDesc.findAllFieldDescriptors();
            for (FieldDescriptor fd : toAdd.values()) {
                FieldDescriptor fdAlready = map.get(fd.getName());
                if (fdAlready != null && fd != fdAlready) {
                    if (fd.relationType() != fdAlready.relationType()) {
                        throw new MetaDataException("Incompatible similarly named fields (" + fd.getName() + ") inherited" + " from multiple superclasses and interfaces in " + this.getName());
                    }
                    if (fd instanceof AttributeDescriptor) {
                        AttributeDescriptor ad = (AttributeDescriptor)fd;
                        if (ad.getType().equals(((AttributeDescriptor)fdAlready).getType())) continue;
                        throw new MetaDataException("Incompatible similarly named fields (" + fd.getName() + ") inherited" + " from multiple superclasses and interfaces in " + this.getName());
                    }
                    if (fd instanceof ReferenceDescriptor) {
                        ReferenceDescriptor rd = (ReferenceDescriptor)fd;
                        ReferenceDescriptor rdAlready = (ReferenceDescriptor)fdAlready;
                        String referencedClassName = rd.getReferencedClassName();
                        String reverseFieldName = rd.getReverseReferenceFieldName();
                        String alreadyRevFieldName = rdAlready.getReverseReferenceFieldName();
                        if (referencedClassName.equals(rdAlready.getReferencedClassName()) && Util.equals(reverseFieldName, alreadyRevFieldName)) continue;
                        throw new MetaDataException("Incompatible similarly named fields (" + fd.getName() + ") inherited" + " from multiple superclasses and interfaces [" + alreadyRevFieldName + " instead of " + reverseFieldName + "] in " + this.getName());
                    }
                    throw new IllegalArgumentException("Descriptor has unknown type: " + fd);
                }
                map.put(fd.getName(), fd);
            }
        }
        return map;
    }

    public FieldDescriptor getFieldDescriptorByName(String name) {
        if (name == null) {
            throw new NullPointerException("Argument 'name' cannot be null");
        }
        return this.allFieldDescriptors.get(name);
    }

    public Set<AttributeDescriptor> getAttributeDescriptors() {
        return this.attDescriptors;
    }

    public Set<AttributeDescriptor> getAllAttributeDescriptors() {
        LinkedHashSet<AttributeDescriptor> set = new LinkedHashSet<AttributeDescriptor>();
        for (FieldDescriptor fd : this.getAllFieldDescriptors()) {
            if (!(fd instanceof AttributeDescriptor)) continue;
            set.add((AttributeDescriptor)fd);
        }
        return set;
    }

    public Set<ReferenceDescriptor> getReferenceDescriptors() {
        return this.refDescriptors;
    }

    public Set<ReferenceDescriptor> getAllReferenceDescriptors() {
        LinkedHashSet<ReferenceDescriptor> set = new LinkedHashSet<ReferenceDescriptor>();
        for (FieldDescriptor fd : this.getAllFieldDescriptors()) {
            if (!fd.isReference()) continue;
            set.add((ReferenceDescriptor)fd);
        }
        return set;
    }

    public ReferenceDescriptor getReferenceDescriptorByName(String name) {
        return this.getReferenceDescriptorByName(name, false);
    }

    public ReferenceDescriptor getReferenceDescriptorByName(String name, boolean ascend) {
        if (name == null) {
            throw new NullPointerException("Argument 'name' cannot be null");
        }
        Map<String, FieldDescriptor> map = null;
        map = ascend ? this.allFieldDescriptors : this.fieldDescriptors;
        FieldDescriptor fd = map.get(name);
        if (fd != null && fd instanceof ReferenceDescriptor && !(fd instanceof CollectionDescriptor)) {
            return (ReferenceDescriptor)fd;
        }
        return null;
    }

    public AttributeDescriptor getAttributeDescriptorByName(String name) {
        return this.getAttributeDescriptorByName(name, false);
    }

    public AttributeDescriptor getAttributeDescriptorByName(String name, boolean ascend) {
        if (name == null) {
            throw new NullPointerException("Argument 'name' cannot be null");
        }
        Map<String, FieldDescriptor> map = null;
        map = ascend ? this.allFieldDescriptors : this.fieldDescriptors;
        FieldDescriptor fd = map.get(name);
        if (fd != null && fd instanceof AttributeDescriptor) {
            return (AttributeDescriptor)fd;
        }
        return null;
    }

    private void configureReferenceDescriptors() throws MetaDataException {
        for (ReferenceDescriptor rfd : this.refDescriptors) {
            rfd.findReferencedDescriptor();
        }
        for (CollectionDescriptor cod : this.colDescriptors) {
            cod.findReferencedDescriptor();
        }
    }

    public Set<CollectionDescriptor> getAllCollectionDescriptors() {
        LinkedHashSet<CollectionDescriptor> set = new LinkedHashSet<CollectionDescriptor>();
        for (FieldDescriptor fd : this.getAllFieldDescriptors()) {
            if (!(fd instanceof CollectionDescriptor)) continue;
            set.add((CollectionDescriptor)fd);
        }
        return set;
    }

    public Set<CollectionDescriptor> getCollectionDescriptors() {
        return this.colDescriptors;
    }

    public CollectionDescriptor getCollectionDescriptorByName(String name) {
        return this.getCollectionDescriptorByName(name, false);
    }

    public CollectionDescriptor getCollectionDescriptorByName(String name, boolean ascend) {
        if (name == null) {
            throw new NullPointerException("Argument 'name' cannot be null");
        }
        Map<String, FieldDescriptor> map = null;
        map = ascend ? this.allFieldDescriptors : this.fieldDescriptors;
        FieldDescriptor fd = map.get(name);
        if (fd instanceof CollectionDescriptor) {
            return (CollectionDescriptor)fd;
        }
        return null;
    }

    public ClassDescriptor getSuperclassDescriptor() {
        this.checkModel();
        return this.superclassDescriptor;
    }

    private void findSuperclassDescriptor() throws MetaDataException {
        for (ClassDescriptor cld : this.superDescriptors) {
            if (cld.isInterface()) continue;
            if (this.isInterface()) {
                throw new MetaDataException("An interface (" + this + " may not have a superclass (" + cld + ")");
            }
            if (this.superclassDescriptor != null) {
                throw new MetaDataException("Cannot have multiple superclasses for: " + this);
            }
            this.superclassDescriptor = cld;
        }
    }

    public Set<ClassDescriptor> getSuperDescriptors() {
        this.checkModel();
        return this.superDescriptors;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    private void findSuperDescriptors() throws MetaDataException {
        if (this.superNames.size() > 0) {
            for (String superName : this.superNames) {
                if (!this.model.hasClassDescriptor(superName)) {
                    if ("java.lang.Object".equals(superName)) continue;
                    throw new MetaDataException("No ClassDescriptor for superclass or interface (" + superName + ") found in model.");
                }
                ClassDescriptor superDescriptor = this.model.getClassDescriptorByName(superName);
                this.superDescriptors.add(superDescriptor);
            }
        }
    }

    public Set<ClassDescriptor> getSubDescriptors() {
        this.checkModel();
        return this.model.getDirectSubs(this);
    }

    protected void setModel(Model model) throws MetaDataException {
        if (this.modelSet) {
            throw new IllegalStateException("Model has already been set and may not be changed.");
        }
        this.model = model;
        LinkedHashSet<String> allSupers = new LinkedHashSet<String>();
        ClassDescriptor.findSuperClassNames(model, this.className, allSupers);
        if (allSupers.contains(this.className)) {
            throw new MetaDataException("circular dependency: " + this.className + " is a super class of itself");
        }
        ArrayList<String> redundantSupers = new ArrayList<String>();
        if (this.superNames.size() > 0) {
            for (String superName : this.superNames) {
                for (String otherSuperName : this.superNames) {
                    int testResult;
                    if (superName.equals(otherSuperName) || (testResult = ClassDescriptor.classInheritanceCompare(model, superName, otherSuperName)) == 0) continue;
                    if (testResult == -1) {
                        redundantSupers.add(superName);
                        continue;
                    }
                    redundantSupers.add(otherSuperName);
                }
            }
        }
        this.superNames.removeAll(redundantSupers);
        this.findSuperDescriptors();
        this.findSuperclassDescriptor();
        this.configureReferenceDescriptors();
        this.modelSet = true;
    }

    static int classInheritanceCompare(Model model, String className1, String className2) throws MetaDataException {
        LinkedHashSet<String> class1Supers = new LinkedHashSet<String>();
        ClassDescriptor.findSuperClassNames(model, className1, class1Supers);
        LinkedHashSet<String> class2Supers = new LinkedHashSet<String>();
        ClassDescriptor.findSuperClassNames(model, className2, class2Supers);
        boolean class1InClass2Supers = class2Supers.contains(className1);
        boolean class2InClass1Supers = class1Supers.contains(className2);
        if (class1InClass2Supers) {
            if (class2InClass1Supers) {
                throw new MetaDataException("circular dependency: " + className1 + " is a super class of " + className2 + " and vice versa");
            }
            return -1;
        }
        if (class2InClass1Supers) {
            return 1;
        }
        return 0;
    }

    public static Set<String> findSuperClassNames(Model model, String className) throws MetaDataException {
        LinkedHashSet<String> superClassNames = new LinkedHashSet<String>();
        ClassDescriptor.findSuperClassNames(model, className, superClassNames);
        return superClassNames;
    }

    static void findSuperClassNames(Model model, String className, Set<String> superClassNames) throws MetaDataException {
        ClassDescriptor cd = model.getClassDescriptorByName(className);
        if (cd == null && !"java.lang.Object".equals(className)) {
            throw new MetaDataException("Model construction failed - class: " + className + " is not in the model but is used as a super class");
        }
        if (cd != null) {
            for (String superName : cd.getSuperclassNames()) {
                if (superClassNames.contains(superName)) continue;
                superClassNames.add(superName);
                ClassDescriptor.findSuperClassNames(model, superName, superClassNames);
            }
        }
    }

    public Model getModel() {
        return this.model;
    }

    private void checkModel() {
        if (!this.modelSet) {
            throw new IllegalArgumentException("ClassDescriptor '" + this.getName() + "' has not been added to a Model");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassDescriptor) {
            ClassDescriptor cld = (ClassDescriptor)obj;
            return this.className.equals(cld.className) && ((Object)this.superNames).equals(cld.superNames) && this.isInterface == cld.isInterface && ((Object)this.fieldDescriptors).equals(cld.fieldDescriptors);
        }
        return false;
    }

    public int hashCode() {
        return 3 * this.className.hashCode() + 7 * this.origSuperNames.hashCode() + 11 * (this.isInterface ? 1 : 0) + 13 * ((Object)this.fieldDescriptors).hashCode();
    }

    @Override
    public int compareTo(ClassDescriptor cld) {
        int retval = this.className.compareTo(cld.className);
        if (retval == 0) {
            retval = this.superNames.toString().compareTo(cld.superNames.toString());
        }
        if (retval == 0) {
            retval = (this.isInterface ? 1 : 0) - (cld.isInterface ? 1 : 0);
        }
        if (retval == 0) {
            retval = ((Object)this.fieldDescriptors).hashCode() - ((Object)cld.fieldDescriptors).hashCode();
        }
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> superClassNames = this.getSuperclassNames();
        sb.append("<class name=\"" + this.className.substring(this.className.lastIndexOf(".") + 1) + "\"");
        if (superClassNames.size() > 0) {
            sb.append(" extends=\"");
            boolean needComma = false;
            for (String superClassName : superClassNames) {
                if (needComma) {
                    sb.append(" ");
                }
                needComma = true;
                if ("java.lang.Object".equals(superClassName)) {
                    sb.append(superClassName);
                    continue;
                }
                sb.append(superClassName.substring(superClassName.lastIndexOf(".") + 1));
            }
            sb.append("\"");
        }
        sb.append(" is-interface=\"" + this.isInterface + "\">");
        LinkedHashSet<FieldDescriptor> l = new LinkedHashSet<FieldDescriptor>();
        l.addAll(this.getAttributeDescriptors());
        l.addAll(this.getReferenceDescriptors());
        l.addAll(this.getCollectionDescriptors());
        boolean firstClass = true;
        for (FieldDescriptor fd : l) {
            if (firstClass) {
                sb.append(ENDL);
                firstClass = false;
            }
            sb.append("\t" + fd.toString() + ENDL);
        }
        sb.append("</class>" + ENDL);
        return sb.toString();
    }

    public String toJSONString() {
        StringBuffer sb = new StringBuffer();
        Set<String> superClassNames = this.getSuperclassNames();
        String name = this.className.substring(this.className.lastIndexOf(".") + 1);
        sb.append("\"" + name + "\":{\"name\":\"" + name + "\",\"extends\":[");
        Iterator<String> supersIter = superClassNames.iterator();
        while (supersIter.hasNext()) {
            sb.append("\"");
            String superClassName = supersIter.next();
            if ("java.lang.Object".equals(superClassName)) {
                sb.append(superClassName);
            } else {
                sb.append(superClassName.substring(superClassName.lastIndexOf(".") + 1));
            }
            sb.append("\"");
            if (!supersIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("],\"isInterface\":" + this.isInterface + ",\"attributes\":{");
        Iterator<AttributeDescriptor> attrIter = this.getAllAttributeDescriptors().iterator();
        while (attrIter.hasNext()) {
            AttributeDescriptor ad = attrIter.next();
            sb.append("\"" + ad.getName() + "\":");
            sb.append(ad.toJSONString());
            if (!attrIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("},\"references\":{");
        Iterator<ReferenceDescriptor> refIter = this.getAllReferenceDescriptors().iterator();
        while (refIter.hasNext()) {
            ReferenceDescriptor rd = refIter.next();
            sb.append("\"" + rd.getName() + "\":");
            sb.append(rd.toJSONString());
            if (!refIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("},\"collections\":{");
        Iterator<CollectionDescriptor> colIter = this.getAllCollectionDescriptors().iterator();
        while (colIter.hasNext()) {
            CollectionDescriptor cd = colIter.next();
            sb.append("\"" + cd.getName() + "\":");
            sb.append(cd.toJSONString());
            if (!colIter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}}");
        return sb.toString();
    }

    public String getHumanReadableText() {
        ClassDescriptor cld;
        StringBuffer retval = new StringBuffer(this.isInterface ? "Interface " : "Class ").append(ClassDescriptor.terseClass(this.className));
        if (this.superNames != null) {
            retval.append(" extends ").append(StringUtil.join(ClassDescriptor.terseClasses(this.superNames), ", "));
        }
        retval.append("\n");
        TextTable table = new TextTable(true, true, true);
        table.addRow(TextTable.ROW_SEPARATOR);
        for (AttributeDescriptor attributeDescriptor : this.getAllAttributeDescriptors()) {
            cld = attributeDescriptor.getClassDescriptor();
            table.addRow(attributeDescriptor.getName(), ClassDescriptor.terseClass(attributeDescriptor.getType()), cld == this ? "" : "from " + ClassDescriptor.terseClass(cld.getName()));
        }
        table.addRow(TextTable.ROW_SEPARATOR);
        for (ReferenceDescriptor referenceDescriptor : this.getAllReferenceDescriptors()) {
            cld = referenceDescriptor.getClassDescriptor();
            table.addRow(referenceDescriptor.getName(), ClassDescriptor.terseClass(referenceDescriptor.getReferencedClassName()), cld == this ? "" : "from " + ClassDescriptor.terseClass(cld.getName()));
        }
        table.addRow(TextTable.ROW_SEPARATOR);
        for (CollectionDescriptor collectionDescriptor : this.getAllCollectionDescriptors()) {
            cld = collectionDescriptor.getClassDescriptor();
            table.addRow(collectionDescriptor.getName(), "collection of " + ClassDescriptor.terseClass(collectionDescriptor.getReferencedClassName()), cld == this ? "" : "from " + ClassDescriptor.terseClass(cld.getName()));
        }
        table.addRow(TextTable.ROW_SEPARATOR);
        retval.append(table.toString());
        return retval.toString();
    }

    public static String terseClass(String c) {
        int p = c.lastIndexOf(46);
        if (p != -1) {
            return c.substring(p + 1);
        }
        return c;
    }

    private static Set<String> terseClasses(Set<String> list) {
        LinkedHashSet<String> retList = new LinkedHashSet<String>();
        for (String name : list) {
            retList.add(ClassDescriptor.terseClass(name));
        }
        return retList;
    }

    public Set<String> getAllSuperclassNames() {
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        classNames.add(this.getName());
        classNames.addAll(this.getSuperclassNames());
        for (ClassDescriptor superCd : this.getSuperDescriptors()) {
            classNames.addAll(superCd.getAllSuperclassNames());
        }
        return classNames;
    }

    public Set<ClassDescriptor> getAllSuperDescriptors() {
        if (this.allSuperDescriptors == null) {
            this.allSuperDescriptors = this.findAllSuperDescriptors();
        }
        return new HashSet<ClassDescriptor>(this.allSuperDescriptors);
    }

    private Set<ClassDescriptor> findAllSuperDescriptors() {
        LinkedHashSet<ClassDescriptor> supers = new LinkedHashSet<ClassDescriptor>();
        for (ClassDescriptor superCld : this.getSuperDescriptors()) {
            if (superCld.getName().equals(INTERMINEOBJECT_NAME)) continue;
            supers.add(superCld);
            supers.addAll(superCld.getAllSuperDescriptors());
        }
        return supers;
    }
}

