/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.codegen;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.CollectionDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.util.StringUtil;
import org.intermine.util.TypeUtil;

public class JavaModelOutput {
    protected static final String INDENT = "    ";
    protected static final String ENDL = System.getProperty("line.separator");
    protected Model model;
    protected File file;

    public JavaModelOutput(Model model, File file) throws Exception {
        this.model = model;
        this.file = file;
    }

    public void process() {
        for (ClassDescriptor cld : this.model.getClassDescriptors()) {
            String cldName = cld.getName();
            if ("org.intermine.model.InterMineObject".equals(cldName)) continue;
            String pkg = TypeUtil.packageName(cldName);
            String cls = TypeUtil.unqualifiedName(cld.getName());
            String separator = File.separator;
            if ("\\".equals(separator)) {
                separator = "\\\\";
            }
            File dir = new File(this.file, pkg.replaceAll("[.]", separator));
            dir.mkdirs();
            File path = new File(dir, cls + ".java");
            try {
                path.delete();
                BufferedWriter fos = new BufferedWriter(new FileWriter(path, true));
                fos.write(this.generate(cld, false));
                fos.close();
                if (!cld.isInterface()) continue;
                path = new File(dir, cls + "Shadow.java");
                path.delete();
                fos = new BufferedWriter(new FileWriter(path, true));
                fos.write(this.generate(cld, true));
                fos.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error creating java", e);
            }
        }
    }

    protected String generate(ClassDescriptor cld, boolean shadow) {
        StringBuffer sb = new StringBuffer();
        String packageName = TypeUtil.packageName(cld.getName());
        if (packageName.length() > 0) {
            sb.append("package ").append(packageName).append(";" + ENDL + ENDL);
        }
        if (!cld.isInterface() || shadow) {
            boolean hasCollections = false;
            boolean hasReferences = false;
            for (FieldDescriptor fd : cld.getAllFieldDescriptors()) {
                if (fd instanceof CollectionDescriptor) {
                    hasCollections = true;
                    continue;
                }
                if (!(fd instanceof ReferenceDescriptor)) continue;
                hasReferences = true;
            }
            sb.append("import org.intermine.objectstore.ObjectStore;" + ENDL);
            sb.append("import org.intermine.objectstore.intermine.NotXmlParser;" + ENDL);
            sb.append("import org.intermine.objectstore.intermine.NotXmlRenderer;" + ENDL);
            if (hasCollections) {
                sb.append("import org.intermine.objectstore.proxy.ProxyCollection;" + ENDL);
            }
            if (hasReferences) {
                sb.append("import org.intermine.objectstore.proxy.ProxyReference;" + ENDL);
            }
            sb.append("import org.intermine.util.StringConstructor;" + ENDL);
            sb.append("import org.intermine.util.TypeUtil;" + ENDL);
            if (shadow) {
                sb.append("import org.intermine.model.ShadowClass;" + ENDL);
            }
            sb.append(ENDL);
        }
        sb.append("public ").append(cld.isInterface() && !shadow ? "interface " : "class ").append(TypeUtil.unqualifiedName(cld.getName())).append(shadow ? "Shadow" : "");
        if (shadow) {
            sb.append(" implements ").append(TypeUtil.unqualifiedName(cld.getName())).append(", ShadowClass");
        } else {
            if (!cld.isInterface() && cld.getSuperclassDescriptor() != null) {
                sb.append(" extends ").append(cld.getSuperclassDescriptor().getName());
            }
            boolean firstTime = true;
            if (cld.getSuperDescriptors().size() > 0) {
                for (ClassDescriptor superCld : cld.getSuperDescriptors()) {
                    if (!superCld.isInterface()) continue;
                    if (firstTime) {
                        sb.append(cld.isInterface() ? " extends " : " implements ");
                        firstTime = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(superCld.getName());
                }
            } else {
                sb.append(" implements org.intermine.model.FastPathObject");
            }
        }
        sb.append(ENDL).append("{" + ENDL);
        if (shadow) {
            sb.append(INDENT).append("public static final Class<").append(TypeUtil.unqualifiedName(cld.getName())).append("> shadowOf = ").append(TypeUtil.unqualifiedName(cld.getName())).append(".class;" + ENDL);
        }
        if (cld.isInterface() && !shadow) {
            sb.append(this.generateFieldDescriptors(cld, false));
        } else {
            sb.append(this.generateFieldDescriptors(cld, true)).append(this.generateEquals(cld)).append(this.generateHashCode(cld)).append(this.generateToString(cld)).append(this.generateGetFieldValue(cld, false)).append(this.generateGetFieldValue(cld, true)).append(this.generateSetFieldValue(cld)).append(this.generateGetFieldType(cld));
            if (cld.getSuperDescriptors().size() > 0) {
                sb.append(this.generateGetObject(cld)).append(this.generateSetObject(cld)).append(this.generateAddCollectionElement(cld)).append(this.generateGetElementType(cld));
            }
        }
        sb.append("}" + ENDL);
        return sb.toString();
    }

    protected String generateFieldDescriptors(ClassDescriptor cld, boolean supers) {
        Set<Object> superclassFields = Collections.emptySet();
        if (supers && cld.getSuperclassDescriptor() != null) {
            superclassFields = cld.getSuperclassDescriptor().getAllFieldDescriptors();
        }
        StringBuffer sb = new StringBuffer();
        Iterator<FieldDescriptor> iter = supers ? cld.getAllFieldDescriptors().iterator() : cld.getFieldDescriptors().iterator();
        while (iter.hasNext()) {
            FieldDescriptor fd = iter.next();
            if (superclassFields.contains(fd)) continue;
            if (fd instanceof AttributeDescriptor) {
                sb.append(this.generate((AttributeDescriptor)fd, supers));
                continue;
            }
            if (fd instanceof CollectionDescriptor) {
                sb.append(this.generate((CollectionDescriptor)fd, supers));
                continue;
            }
            if (!(fd instanceof ReferenceDescriptor)) continue;
            sb.append(this.generate((ReferenceDescriptor)fd, supers));
        }
        return sb.toString();
    }

    protected String generate(AttributeDescriptor attr, boolean field) {
        StringBuffer sb = new StringBuffer();
        if (field) {
            sb.append("    // Attr: " + attr.getClassDescriptor().getName() + "." + attr.getName() + ENDL).append("    protected ").append(attr.getType()).append(" ").append(attr.getName()).append(";" + ENDL);
        }
        sb.append(this.generateGetSet(attr, field)).append(ENDL);
        return sb.toString();
    }

    protected String generate(ReferenceDescriptor ref, boolean field) {
        StringBuffer sb = new StringBuffer();
        if (field) {
            sb.append("    // Ref: " + ref.getClassDescriptor().getName() + "." + ref.getName() + ENDL).append(INDENT).append("protected org.intermine.model.InterMineObject ").append(ref.getName()).append(";" + ENDL);
        }
        sb.append(this.generateGetSet(ref, field)).append(ENDL);
        return sb.toString();
    }

    protected String generate(CollectionDescriptor col, boolean field) {
        String type = "java.util.Set<" + col.getReferencedClassName() + ">";
        String impl = "java.util.HashSet<" + col.getReferencedClassName() + ">";
        StringBuffer sb = new StringBuffer();
        if (field) {
            sb.append("    // Col: " + col.getClassDescriptor().getName() + "." + col.getName() + ENDL).append(INDENT).append("protected ").append(type).append(" ").append(col.getName()).append(" = new ").append(impl).append("();" + ENDL);
        }
        sb.append(this.generateGetSet(col, field)).append(ENDL);
        return sb.toString();
    }

    protected String generateGetSet(FieldDescriptor field, boolean fieldPresent) {
        String name = field.getName();
        String type = this.getType(field);
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public ").append(type).append(" get").append(StringUtil.reverseCapitalisation(name)).append("()");
        if (!fieldPresent) {
            sb.append(";" + ENDL);
        } else {
            sb.append(" { ");
            if (field instanceof ReferenceDescriptor && !(field instanceof CollectionDescriptor)) {
                sb.append("if (").append(name).append(" instanceof org.intermine.objectstore.proxy.ProxyReference) { return ").append("((").append(type).append(") ((org.intermine.objectstore.proxy.ProxyReference) ").append(name).append(").getObject()); }; return (").append(type).append(") ").append(name).append("; }" + ENDL);
            } else {
                sb.append("return ").append(name).append("; }" + ENDL);
            }
        }
        sb.append(INDENT).append("public void ").append("set").append(StringUtil.reverseCapitalisation(name)).append("(final ").append(type).append(" ").append(name).append(")");
        if (!fieldPresent) {
            sb.append(";" + ENDL);
        } else {
            sb.append(" { ").append("this.").append(name).append(" = ").append(name).append("; }" + ENDL);
        }
        if (field instanceof ReferenceDescriptor) {
            if (field instanceof CollectionDescriptor) {
                sb.append(INDENT).append("public void add").append(StringUtil.reverseCapitalisation(name)).append("(final ").append(((CollectionDescriptor)field).getReferencedClassDescriptor().getName()).append(" arg)");
                if (fieldPresent) {
                    sb.append(" { ").append(name).append(".add(arg); }" + ENDL);
                } else {
                    sb.append(";" + ENDL);
                }
            } else {
                sb.append(INDENT).append("public void proxy").append(StringUtil.reverseCapitalisation(name)).append("(final org.intermine.objectstore.proxy.ProxyReference ").append(name).append(")");
                if (fieldPresent) {
                    sb.append(" { this.").append(name).append(" = ").append(name).append("; }" + ENDL);
                } else {
                    sb.append(";" + ENDL);
                }
                sb.append(INDENT).append("public org.intermine.model.InterMineObject proxGet").append(StringUtil.reverseCapitalisation(name)).append("()");
                if (fieldPresent) {
                    sb.append(" { return ").append(name).append("; }" + ENDL);
                } else {
                    sb.append(";" + ENDL);
                }
            }
        }
        return sb.toString();
    }

    protected String generateEquals(ClassDescriptor cld) {
        if (cld.getFieldDescriptorByName("id") != null) {
            String unqualifiedName = TypeUtil.unqualifiedName(cld.getName());
            StringBuffer sb = new StringBuffer();
            sb.append(INDENT).append("@Override public boolean equals(Object o) { return (o instanceof ").append(unqualifiedName).append(" && id != null) ? id.equals(((").append(unqualifiedName).append(")o).getId()) : this == o; }" + ENDL);
            return sb.toString();
        }
        return "";
    }

    protected String generateHashCode(ClassDescriptor cld) {
        if (cld.getFieldDescriptorByName("id") != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(INDENT).append("@Override public int hashCode() { ").append("return (id != null) ? id.hashCode() : super.hashCode(); ").append("}" + ENDL);
            return sb.toString();
        }
        return "";
    }

    protected String generateToString(ClassDescriptor cld) {
        String unqualifiedName = TypeUtil.unqualifiedName(cld.getName());
        StringBuilder sb = new StringBuilder();
        Set<FieldDescriptor> keyFields = cld.getAllFieldDescriptors();
        if (keyFields.size() > 0) {
            sb.append(INDENT).append("@Override public String toString() { ").append("return \"").append(unqualifiedName).append(" [");
            TreeMap<String, FieldDescriptor> sortedMap = new TreeMap<String, FieldDescriptor>();
            for (FieldDescriptor field : keyFields) {
                sortedMap.put(field.getName(), field);
            }
            boolean needComma = false;
            for (Map.Entry entry : sortedMap.entrySet()) {
                FieldDescriptor field = (FieldDescriptor)entry.getValue();
                if (field instanceof CollectionDescriptor) continue;
                if (needComma) {
                    sb.append(", ");
                }
                needComma = true;
                sb.append(field.getName());
                if (field instanceof AttributeDescriptor) {
                    sb.append("=\\\"\" + " + field.getName() + " + \"\\\"");
                    continue;
                }
                sb.append("=\" + (" + field.getName() + " == null ? \"null\" : (" + field.getName() + ".getId() == null ? \"no id\" : " + field.getName() + ".getId().toString())) + \"");
            }
            sb.append("]\"; }" + ENDL);
        }
        return sb.toString();
    }

    protected String getType(FieldDescriptor field) {
        String type = null;
        type = field instanceof AttributeDescriptor ? ((AttributeDescriptor)field).getType() : (field instanceof CollectionDescriptor ? "java.util.Set<" + ((CollectionDescriptor)field).getReferencedClassName() + ">" : ((ReferenceDescriptor)field).getReferencedClassDescriptor().getName());
        return type;
    }

    protected String generateGetObject(ClassDescriptor cld) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public StringConstructor getoBJECT() {\n").append("        ").append("if (!" + cld.getName() + (cld.isInterface() ? "Shadow" : "") + ".class.equals(getClass())) {\n").append("            ").append("return NotXmlRenderer.render(this);\n").append("        ").append("}\n").append("        ").append("StringConstructor sb = new StringConstructor();\n").append("        ").append("sb.append(\"$_^" + cld.getName() + "\");\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            if (field instanceof AttributeDescriptor) {
                AttributeDescriptor attribute = (AttributeDescriptor)field;
                if (attribute.getType().startsWith("java.")) {
                    sb.append("        ").append("if (" + attribute.getName() + " != null) {\n").append("            ").append("sb.append(\"$_^a" + field.getName() + "$_^" + "\")");
                    if ("java.util.Date".equals(attribute.getType())) {
                        sb.append(".append(" + attribute.getName() + ".getTime());\n");
                    } else if ("java.lang.String".equals(attribute.getType())) {
                        sb.append(";\n").append("            ").append("String string = " + attribute.getName() + ";\n").append("            ").append("while (string != null) {\n").append("                ").append("int delimPosition = string.indexOf(\"$_^\");\n").append("                ").append("if (delimPosition == -1) {\n").append("                    ").append("sb.append(string);\n").append("                    ").append("string = null;\n").append("                ").append("} else {\n").append("                    ").append("sb.append(string.substring(0, delimPosition + 3));\n").append("                    ").append("sb.append(\"d\");\n").append("                    ").append("string = string.substring(delimPosition + 3);\n").append("                ").append("}\n").append("            ").append("}\n");
                    } else {
                        sb.append(".append(" + attribute.getName() + ");\n");
                    }
                    sb.append("        ").append("}\n");
                    continue;
                }
                if ("org.intermine.objectstore.query.ClobAccess".equals(attribute.getType())) {
                    sb.append("        ").append("if (" + attribute.getName() + " != null) {\n").append("            ").append("sb.append(\"$_^a" + field.getName() + "$_^" + "\" + ").append(attribute.getName() + ".getDbDescription());\n").append("        ").append("}\n");
                    continue;
                }
                sb.append(INDENT).append(INDENT).append("sb.append(\"$_^a" + field.getName() + "$_^" + "\")").append(".append(" + field.getName() + ");\n");
                continue;
            }
            if (!field.isReference()) continue;
            sb.append("        ").append("if (" + field.getName() + " != null) {\n").append("            ").append("sb.append(\"$_^r" + field.getName() + "$_^" + "\")").append(".append(" + field.getName() + ".getId());\n").append("        ").append("}\n");
        }
        sb.append("        ").append("return sb;\n").append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateSetObject(ClassDescriptor cld) {
        String fieldName;
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public void setoBJECT(String notXml, ObjectStore os) {\n").append("        ").append("setoBJECT(NotXmlParser.SPLITTER.split(notXml), os);\n").append(INDENT).append("}\n").append(INDENT).append("public void setoBJECT(final String[] notXml, final ObjectStore os) {\n").append("        ").append("if (!" + cld.getName() + (cld.isInterface() ? "Shadow" : "") + ".class.equals(getClass())) {\n").append("            ").append("throw new IllegalStateException(\"Class \" + getClass().getName() + \" does not match code (" + cld.getName() + ")\");\n").append("        ").append("}\n").append("        ").append("for (int i = 2; i < notXml.length;) {\n").append("            ").append("int startI = i;\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            fieldName = field.getName();
            if ("notXml".equals(fieldName)) {
                fieldName = "this.notXml";
            } else if ("os".equals(fieldName)) {
                fieldName = "this.os";
            }
            if (field instanceof AttributeDescriptor) {
                AttributeDescriptor attribute = (AttributeDescriptor)field;
                sb.append("            ").append("if ((i < notXml.length) && \"a" + fieldName + "\".equals(notXml[i])) {\n").append("                ").append("i++;\n").append("                ");
                if ("boolean".equals(attribute.getType())) {
                    sb.append(fieldName + " = Boolean.parseBoolean(notXml[i]);\n");
                } else if ("short".equals(attribute.getType())) {
                    sb.append(fieldName + " = Short.parseShort(notXml[i]);\n");
                } else if ("int".equals(attribute.getType())) {
                    sb.append(fieldName + " = Integer.parseInt(notXml[i]);\n");
                } else if ("long".equals(attribute.getType())) {
                    sb.append(fieldName + " = Long.parseLong(notXml[i]);\n");
                } else if ("float".equals(attribute.getType())) {
                    sb.append(fieldName + " = Float.parseFloat(notXml[i]);\n");
                } else if ("double".equals(attribute.getType())) {
                    sb.append(fieldName + " = Double.parseDouble(notXml[i]);\n");
                } else if ("java.lang.Boolean".equals(attribute.getType())) {
                    sb.append(fieldName + " = Boolean.valueOf(notXml[i]);\n");
                } else if ("java.lang.Short".equals(attribute.getType())) {
                    sb.append(fieldName + " = Short.valueOf(notXml[i]);\n");
                } else if ("java.lang.Integer".equals(attribute.getType())) {
                    sb.append(fieldName + " = Integer.valueOf(notXml[i]);\n");
                } else if ("java.lang.Long".equals(attribute.getType())) {
                    sb.append(fieldName + " = Long.valueOf(notXml[i]);\n");
                } else if ("java.lang.Float".equals(attribute.getType())) {
                    sb.append(fieldName + " = Float.valueOf(notXml[i]);\n");
                } else if ("java.lang.Double".equals(attribute.getType())) {
                    sb.append(fieldName + " = Double.valueOf(notXml[i]);\n");
                } else if ("java.util.Date".equals(attribute.getType())) {
                    sb.append(fieldName + " = new java.util.Date(Long.parseLong(notXml[i]));\n");
                } else if ("java.math.BigDecimal".equals(attribute.getType())) {
                    sb.append(fieldName + " = new java.math.BigDecimal(notXml[i]);\n");
                } else if ("org.intermine.objectstore.query.ClobAccess".equals(attribute.getType())) {
                    sb.append(fieldName + " = org.intermine.objectstore.query.ClobAccess" + ".decodeDbDescription(os, notXml[i]);\n");
                } else if ("java.lang.String".equals(attribute.getType())) {
                    sb.append("StringBuilder string = null;\n").append("                ").append("while ((i + 1 < notXml.length) && (notXml[i + 1].charAt(0) == 'd')) {\n").append("                    ").append("if (string == null) string = new StringBuilder(notXml[i]);\n").append("                    ").append("i++;\n").append("                    ").append("string.append(\"$_^\").append(notXml[i].substring(1));\n").append("                ").append("}\n").append("                ").append(fieldName + " = string == null ? notXml[i] : string.toString();\n");
                } else {
                    throw new IllegalArgumentException("Unknown type " + attribute.getType());
                }
                sb.append("                ").append("i++;\n").append("            ").append("}\n");
                continue;
            }
            if (!field.isReference()) continue;
            ReferenceDescriptor reference = (ReferenceDescriptor)field;
            sb.append("            ").append("if ((i < notXml.length) &&\"r" + fieldName + "\".equals(notXml[i])) {\n").append("                ").append("i++;\n").append("                ").append(fieldName + " = new ProxyReference(os, Integer.valueOf(notXml[i])" + ", " + reference.getReferencedClassName() + ".class);\n").append("                ").append("i++;\n").append("            ").append("};\n");
        }
        sb.append("            ").append("if (startI == i) {\n").append("                ").append("throw new IllegalArgumentException(\"Unknown field \" + notXml[i]);\n").append("            ").append("}\n").append("        ").append("}\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            fieldName = field.getName();
            if ("notXml".equals(fieldName)) {
                fieldName = "this.notXml";
            } else if ("os".equals(fieldName)) {
                fieldName = "this.os";
            }
            if (!(field instanceof CollectionDescriptor)) continue;
            CollectionDescriptor coll = (CollectionDescriptor)field;
            sb.append("        ").append(fieldName + " = new ProxyCollection<" + coll.getReferencedClassName() + ">(os, this, \"" + fieldName + "\", " + coll.getReferencedClassName() + ".class);\n");
        }
        sb.append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateGetFieldValue(ClassDescriptor cld, boolean proxy) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public Object getField" + (proxy ? "Proxy" : "Value") + "(final String fieldName) throws IllegalAccessException {\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            sb.append("        ").append("if (\"" + field.getName() + "\".equals(fieldName)) {\n");
            String fieldName = field.getName();
            if ("fieldName".equals(fieldName)) {
                fieldName = "this.fieldName";
            }
            if (field instanceof AttributeDescriptor) {
                AttributeDescriptor attribute = (AttributeDescriptor)field;
                if ("boolean".equals(attribute.getType())) {
                    sb.append("            ").append("return Boolean.valueOf(" + fieldName + ");\n");
                } else if ("short".equals(attribute.getType())) {
                    sb.append("            ").append("return Short.valueOf(" + fieldName + ");\n");
                } else if ("int".equals(attribute.getType())) {
                    sb.append("            ").append("return Integer.valueOf(" + fieldName + ");\n");
                } else if ("long".equals(attribute.getType())) {
                    sb.append("            ").append("return Long.valueOf(" + fieldName + ");\n");
                } else if ("float".equals(attribute.getType())) {
                    sb.append("            ").append("return Float.valueOf(" + fieldName + ");\n");
                } else if ("double".equals(attribute.getType())) {
                    sb.append("            ").append("return Double.valueOf(" + fieldName + ");\n");
                } else {
                    sb.append("            ").append("return " + fieldName + ";\n");
                }
            } else if (field.isReference()) {
                sb.append("            ");
                if (proxy) {
                    sb.append("return " + fieldName + ";\n");
                } else {
                    sb.append("if (" + fieldName + " instanceof ProxyReference) {\n").append("                ").append("return ((ProxyReference) " + fieldName + ").getObject();\n").append("            ").append("} else {\n").append("                ").append("return " + fieldName + ";\n").append("            ").append("}\n");
                }
            } else {
                sb.append("            ").append("return " + fieldName + ";\n");
            }
            sb.append("        ").append("}\n");
        }
        sb.append("        ").append("if (!" + cld.getName() + ".class.equals(getClass())) {\n").append("            ").append("return TypeUtil.getField" + (proxy ? "Proxy" : "Value") + "(this, fieldName);\n").append("        ").append("}\n").append("        ").append("throw new IllegalArgumentException(\"Unknown field \" + fieldName);\n").append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateSetFieldValue(ClassDescriptor cld) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public void setFieldValue(final String fieldName, final Object value) {\n").append("        ");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            sb.append("if (\"" + field.getName() + "\".equals(fieldName)) {\n");
            String fieldName = field.getName();
            if ("value".equals(fieldName)) {
                fieldName = "this.value";
            } else if ("fieldName".equals(fieldName)) {
                fieldName = "this.fieldName";
            }
            if (field instanceof AttributeDescriptor) {
                AttributeDescriptor attribute = (AttributeDescriptor)field;
                if ("boolean".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Boolean) value).booleanValue();\n");
                } else if ("short".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Short) value).shortValue();\n");
                } else if ("int".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Integer) value).intValue();\n");
                } else if ("long".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Long) value).longValue();\n");
                } else if ("float".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Float) value).floatValue();\n");
                } else if ("double".equals(attribute.getType())) {
                    sb.append("            ").append(fieldName + " = ((Double) value).doubleValue();\n");
                } else {
                    sb.append("            ").append(fieldName + " = (" + attribute.getType() + ") value;\n");
                }
            } else if (field.isReference()) {
                sb.append("            ").append(fieldName + " = (org.intermine.model.InterMineObject) value;\n");
            } else {
                sb.append("            ").append(fieldName + " = (java.util.Set) value;\n");
            }
            sb.append("        ").append("} else ");
        }
        sb.append("{\n").append("            ").append("if (!" + cld.getName() + ".class.equals(getClass())) {\n").append("                ").append("TypeUtil.setFieldValue(this, fieldName, value);\n").append("                ").append("return;\n").append("            ").append("}\n").append("            ").append("throw new IllegalArgumentException(\"Unknown field \" + fieldName);\n").append("        ").append("}\n").append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateAddCollectionElement(ClassDescriptor cld) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public void addCollectionElement(final String fieldName,").append(" final org.intermine.model.InterMineObject element) {\n").append("        ");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            if (!field.isCollection()) continue;
            String fieldName = field.getName();
            if ("fieldName".equals(fieldName)) {
                fieldName = "this.fieldName";
            } else if ("element".equals(fieldName)) {
                fieldName = "this.element";
            }
            sb.append("if (\"" + field.getName() + "\".equals(fieldName)) {\n").append("            ").append(fieldName + ".add((" + ((CollectionDescriptor)field).getReferencedClassName() + ") element);\n").append("        ").append("} else ");
        }
        sb.append("{\n").append("            ").append("if (!" + cld.getName() + ".class.equals(getClass())) {\n").append("                ").append("TypeUtil.addCollectionElement(this, fieldName, element);\n").append("                ").append("return;\n").append("            ").append("}\n").append("            ").append("throw new IllegalArgumentException(\"Unknown collection \" + fieldName);\n").append("        ").append("}\n").append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateGetFieldType(ClassDescriptor cld) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public Class<?> getFieldType(final String fieldName) {\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            sb.append("        ").append("if (\"" + field.getName() + "\".equals(fieldName)) {\n").append("            ");
            if (field instanceof AttributeDescriptor) {
                AttributeDescriptor attribute = (AttributeDescriptor)field;
                if ("boolean".equals(attribute.getType())) {
                    sb.append("return Boolean.TYPE;\n");
                } else if ("short".equals(attribute.getType())) {
                    sb.append("return Short.TYPE;\n");
                } else if ("int".equals(attribute.getType())) {
                    sb.append("return Integer.TYPE;\n");
                } else if ("long".equals(attribute.getType())) {
                    sb.append("return Long.TYPE;\n");
                } else if ("float".equals(attribute.getType())) {
                    sb.append("return Float.TYPE;\n");
                } else if ("double".equals(attribute.getType())) {
                    sb.append("return Double.TYPE;\n");
                } else {
                    sb.append("return " + attribute.getType() + ".class;\n");
                }
            } else if (field.isReference()) {
                sb.append("return " + ((ReferenceDescriptor)field).getReferencedClassName() + ".class;\n");
            } else {
                sb.append("return java.util.Set.class;\n");
            }
            sb.append("        ").append("}\n");
        }
        sb.append("        ").append("if (!" + cld.getName() + ".class.equals(getClass())) {\n").append("            ").append("return TypeUtil.getFieldType(" + cld.getName() + ".class, fieldName);\n").append("        ").append("}\n").append("        ").append("throw new IllegalArgumentException(\"Unknown field \" + fieldName);\n").append(INDENT).append("}\n");
        return sb.toString();
    }

    public String generateGetElementType(ClassDescriptor cld) {
        StringBuffer sb = new StringBuffer();
        sb.append(INDENT).append("public Class<?> getElementType(final String fieldName) {\n");
        for (FieldDescriptor field : cld.getAllFieldDescriptors()) {
            if (!field.isCollection()) continue;
            sb.append("        ").append("if (\"" + field.getName() + "\".equals(fieldName)) {\n").append("            ").append("return " + ((CollectionDescriptor)field).getReferencedClassName() + ".class;\n").append("        ").append("}\n");
        }
        sb.append("        ").append("if (!" + cld.getName() + ".class.equals(getClass())) {\n").append("            ").append("return TypeUtil.getElementType(" + cld.getName() + ".class, fieldName);\n").append("        ").append("}\n").append("        ").append("throw new IllegalArgumentException(\"Unknown field \" + fieldName);\n").append(INDENT).append("}\n");
        return sb.toString();
    }
}

