/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.logic.BitType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType1BitUnsignedInteger
extends AbstractContextual
implements DataType<BitType> {
    private final BitType type = new BitType();

    @Override
    public BitType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "1-bit uint";
    }

    @Override
    public String longName() {
        return "1-bit unsigned integer";
    }

    @Override
    public String description() {
        return "A integer data type ranging between 0 and 1";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(BitType dest) {
        dest.set(false);
    }

    @Override
    public void upperBound(BitType dest) {
        dest.set(true);
    }

    @Override
    public int bitCount() {
        return 1;
    }

    @Override
    public BitType createVariable() {
        return new BitType();
    }

    @Override
    public void cast(BitType val, BigComplex dest) {
        dest.setReal(val.get() ? 1L : 0L);
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, BitType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return true;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(BitType val) {
        return val.get() ? 1.0 : 0.0;
    }

    @Override
    public long asLong(BitType val) {
        return val.get() ? 1L : 0L;
    }

    @Override
    public void setDouble(BitType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(BitType val, long v) {
        if (v == 0L) {
            val.set(false);
        } else {
            val.set(true);
        }
    }
}

