/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

public class DataPoint {
    int _ind;
    double[] _x;
    int _D;

    public DataPoint() {
        this._D = 1;
        this._ind = -1;
    }

    public DataPoint(int D, int ind, double[] x) {
        this._D = D;
        this._ind = ind;
        this._x = (double[])x.clone();
    }

    public String toString() {
        String xStr = "";
        for (int i = 0; i < Math.min(20, this._x.length); ++i) {
            xStr = xStr + this._x[i] + ", ";
        }
        return "DataPoint (index=" + this._ind + ", Dim=" + this._D + ", point=" + xStr + ")";
    }

    public int index() {
        return this._ind;
    }

    int dimensionality() {
        return this._D;
    }

    double x(int d) {
        return this._x[d];
    }

    public double euclidean_distance(DataPoint t1) {
        double dd = 0.0;
        double[] x1 = t1._x;
        double[] x2 = this._x;
        for (int d = 0; d < t1._D; ++d) {
            double diff = x1[d] - x2[d];
            dd += diff * diff;
        }
        return Math.sqrt(dd);
    }

    public static double euclidean_distance(DataPoint t1, DataPoint t2) {
        double dd = 0.0;
        double[] x1 = t1._x;
        double[] x2 = t2._x;
        for (int d = 0; d < t1._D; ++d) {
            double diff = x1[d] - x2[d];
            dd += diff * diff;
        }
        return Math.sqrt(dd);
    }
}

