/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import java.net.URL;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;
import org.rhwlab.modern.ViewBase;

public class ViewByTF
extends ViewBase
implements Serializable {
    TreeMap<String, URL> trackHubUrlsMap = new TreeMap();

    public void setService(OrthologService service) throws Exception {
        this.service = service;
        this.buildTree();
    }

    public void buildTree() throws Exception {
        this.assembly = this.choosenAssembly();
        this.root = this.service.createTree(this.species, this.assembly);
        this.peaksUrlsMap.clear();
        this.addPeaksURLs(this.root, this.peaksUrlsMap);
        this.addTrackHUBFileURLs(this.root, this.trackHubUrlsMap);
    }

    public TreeMap<String, URL> getTrackHubUrls() {
        return this.trackHubUrlsMap;
    }

    public TreeNode getRoot() throws Exception {
        String choosen = this.choosenAssembly();
        if (!choosen.equals(this.assembly)) {
            this.buildTree();
        }
        return this.root;
    }

    @Override
    public String getZipFileName() {
        return String.format("%sByTF.zip", this.species);
    }
}

