/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileView;
import org.rhwlab.modern.RecordBase;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TreeNodeRecord;

public abstract class ViewBase
implements FileView {
    public TreeNode root;
    public TreeNode[] selectedNodes;
    public OrthologService service;
    public TreeMap<String, URL> urlsMap = new TreeMap();
    TreeMap<String, URL> peaksUrlsMap = new TreeMap();
    public ReferenceGenome genomes;
    String assembly;
    public String species;

    public void setGenomes(ReferenceGenome gen) {
        this.genomes = gen;
    }

    public void setSpecies(String sp) {
        this.species = sp;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public Map<String, URL> getURLs() {
        return this.urlsMap;
    }

    @Override
    public Map<String, URL> getURLs(String param) throws Exception {
        TreeMap<String, URL> ret = new TreeMap<String, URL>();
        String[] keys = param.split("/");
        RecordBase base = ((RecordBase)this.root).findRecord(keys, 0);
        if (base != null) {
            ViewBase.addURLs((TreeNode)base, ret);
        }
        return ret;
    }

    @Override
    public Map<String, URL> getAllPeaksURLs() {
        return this.peaksUrlsMap;
    }

    public String choosenAssembly() {
        String ret = this.species.equalsIgnoreCase("worm") ? this.genomes.getWorm() : this.genomes.getFly();
        return ret;
    }

    public TreeNode[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(TreeNode[] selectedNodes) throws Exception {
        this.selectedNodes = selectedNodes;
        this.urlsMap.clear();
        if (selectedNodes == null) {
            return;
        }
        for (TreeNode treeNode : selectedNodes) {
            ViewBase.addURLs(treeNode, this.urlsMap);
        }
    }

    public void addTrackHUBFileURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            String identifier = subFile.getHubIdentifier();
            if (identifier.endsWith("bw") || identifier.endsWith("bb") || identifier.endsWith("Peak.gz")) {
                urls.put(identifier, new URL(subFile.getDownloadLink()));
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                this.addTrackHUBFileURLs(child, urls);
            }
        }
    }

    public void addPeaksURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            String id = subFile.getId().toLowerCase();
            if (id.contains("optimal") && id.endsWith(".gz")) {
                urls.put(String.format("%s/%s/%s", this.species, subFile.getAssembly(), subFile.getAccession() + "_" + subFile.getId()), new URL(subFile.getDownloadLink()));
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                this.addPeaksURLs(child, urls);
            }
        }
    }

    public static void addURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            urls.put(ViewBase.nodeIdentifier(node), new URL(subFile.getDownloadLink()));
        } else {
            for (TreeNode child : node.getChildren()) {
                ViewBase.addURLs(child, urls);
            }
        }
    }

    public static String nodeIdentifier(TreeNode node) {
        TreeNodeRecord record = (TreeNodeRecord)node.getData();
        if (node.getParent() == null) {
            return String.format("/%s", record.getId());
        }
        return String.format("%s/%s", ViewBase.nodeIdentifier(node.getParent()), record.getId());
    }
}

