/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.modern.ExpRecordBase;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.TreeNodeRecord;

public class TF
extends ExpRecordBase
implements Serializable,
TreeNodeRecord {
    String gene;
    String dbxref;
    String assembly;
    String geneType;

    public TF(String assembly, Experiment exp, TreeNode parent, String type) {
        super(parent);
        this.gene = exp.getGene();
        this.exp = exp;
        this.assembly = assembly;
        this.dbxref = exp.getDbxref();
        this.geneType = type;
    }

    public TF(String assembly, String gene, TreeNode parent, String type) {
        super(parent);
        this.gene = gene;
        this.exp = null;
        this.assembly = assembly;
        this.geneType = type;
    }

    public void setDbxref(String xref) {
        this.dbxref = xref;
    }

    @Override
    public String getUniqueId() {
        if (this.exp != null) {
            return this.exp.getAccession();
        }
        return this.gene;
    }

    @Override
    public String getId() {
        return this.gene;
    }

    @Override
    public String getStrain() {
        if (this.exp == null) {
            return "";
        }
        String strain = this.exp.getStrain();
        return strain;
    }

    @Override
    public String getStrainLink() {
        if (this.exp != null) {
            return this.exp.getStrainLink();
        }
        return "";
    }

    @Override
    public boolean getStrainInExternalDB() {
        boolean r = !this.getStrainLink().equals("");
        return r;
    }

    @Override
    public boolean getStrainNotInExternalDB() {
        boolean r = this.getStrainLink().equals("");
        return r;
    }

    @Override
    public String getAccession() {
        if (this.exp == null) {
            return "";
        }
        return this.exp.getAccession();
    }

    @Override
    public String getMetaDataLink() {
        if (this.exp == null) {
            return "";
        }
        String acc = this.exp.getAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/", acc);
    }

    @Override
    public String getInputMetaDataLink() {
        if (this.exp == null) {
            return "";
        }
        String inputAcc = this.exp.getInputAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/", inputAcc);
    }

    @Override
    public String getInputAccession() {
        if (this.exp == null) {
            return "";
        }
        String inputAcc = this.exp.getInputAccession();
        return inputAcc;
    }

    @Override
    public String getRecordType() {
        return this.geneType;
    }

    @Override
    public String getWormbaseLink() {
        if (this.gene == null) {
            return "";
        }
        return String.format("http://www.wormbase.org/species/c_elegans/gene/%s/", this.gene);
    }

    @Override
    public String getWormbase() {
        if (this.gene == null) {
            return "";
        }
        return "WormBase";
    }

    @Override
    public String getFlybaseLink() {
        return String.format("http://flybase.org/reports/%s.html", this.dbxref);
    }

    @Override
    public String getFlybase() {
        if (this.gene == null) {
            return "";
        }
        return "FlyBase";
    }

    public String getExternalLink() {
        if (this.assembly.equals("ce11") || this.assembly.equals("ce10")) {
            return this.getWormbaseLink();
        }
        return this.getFlybaseLink();
    }

    public String getSpecies() {
        if (this.assembly.equals("ce11") || this.assembly.equals("ce10")) {
            return "worm";
        }
        return "fly";
    }

    @Override
    public String getBDGPLink() {
        return String.format("http://insitu.fruitfly.org/cgi-bin/ex/report.pl?ftype=1&ftext=%s", this.dbxref);
    }

    @Override
    public String getBDGPLabel() {
        if (this.gene == null) {
            return "";
        }
        return "Homepage";
    }

    @Override
    public String getIdentifierTooltip() {
        return "Gene";
    }

    @Override
    public Boolean getTooltip() {
        return true;
    }

    @Override
    public String getUcscLink() {
        if (this.exp == null) {
            int n = TrackHub.countHubFiles((TreeNode)this);
            if (n > 0) {
                return String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?db=%s&hubClear=http://waterston.gs.washington.edu/modERN/%s_hub.txt", this.assembly, this.getId());
            }
            return "";
        }
        if (!this.exp.isVisual()) {
            return "";
        }
        String acc = this.exp.getAccession();
        String ret = String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?hubClear=https://www.encodeproject.org/experiments/%s/@@hub/hub.txt&db=%s", acc, this.assembly);
        return ret;
    }

    @Override
    public String getBrowser() {
        if (this.exp == null) {
            int n = TrackHub.countHubFiles((TreeNode)this);
            if (n > 0) {
                return "TrackHub";
            }
            return "";
        }
        if (!this.exp.isVisual()) {
            return "";
        }
        return "UCSC";
    }

    @Override
    public String getDownload() {
        if (this.exp == null) {
            return "All Stages for this Gene";
        }
        return "All DataTypes for this Gene";
    }

    @Override
    public String getMicrographURL() {
        if (this.exp == null) {
            return "";
        }
        String ret = this.exp.getBiosample().getJpegUrl();
        if (ret == null) {
            return "";
        }
        return ret;
    }

    @Override
    public String getMicrographLabel() {
        if (this.exp == null) {
            return "";
        }
        if (this.getMicrographURL().equals("")) {
            return "";
        }
        return "View";
    }

    @Override
    public String getDbxref() {
        return this.dbxref;
    }

    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s", parent.getHubIdentifier(), this.gene);
    }
}

