/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.json.JsonObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.fly.FlyBaseGenes;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;

public class SpeciesService
implements Runnable {
    File jsonDir;
    String species;
    TreeMap<String, TreeMap<String, List<Experiment>>> byTFStage = new TreeMap();
    TreeMap<String, TreeMap<String, List<Experiment>>> byStageTF = new TreeMap();
    TreeMap<String, String> dbxrefs = new TreeMap();
    TreeMap<String, String> commonNames = new TreeMap();
    FlyBaseGenes flyGenes;
    GeneTypes geneTypes;
    TreeMap<String, Experiment> expMap;
    boolean complete = false;

    public SpeciesService(File jsonFile, String species) throws Exception {
        this.jsonDir = jsonFile;
        this.species = species;
        if (species.equalsIgnoreCase("fly")) {
            this.flyGenes = new FlyBaseGenes();
            this.geneTypes = new FlyGeneTypes();
        } else {
            this.geneTypes = new WormGeneTypes();
        }
    }

    public List<Experiment> getAllExperiments() {
        ArrayList<Experiment> ret = new ArrayList<Experiment>();
        for (TreeMap<String, List<Experiment>> stagemap : this.byTFStage.values()) {
            for (List<Experiment> exps : stagemap.values()) {
                ret.addAll(exps);
            }
        }
        return ret;
    }

    public TreeMap<String, List<Experiment>> getExpByStage(String gene) {
        return this.byTFStage.get(gene);
    }

    public TreeMap<String, List<Experiment>> getExpByTF(String stage) {
        return this.byStageTF.get(stage);
    }

    public List getAllTFs() {
        return new ArrayList<String>(this.byTFStage.keySet());
    }

    public Set<String> getAllStages() {
        return this.byStageTF.keySet();
    }

    public String getGeneType(String gene) {
        return this.geneTypes.getType(gene);
    }

    @Override
    public void run() {
        System.out.println(this.species);
        TreeMap tempTFStage = new TreeMap(new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        TreeMap tempStageTF = new TreeMap();
        TreeMap<String, String> tempDbxrefs = new TreeMap<String, String>();
        TreeMap<String, String> tempCommon = new TreeMap<String, String>();
        try {
            this.expMap = new TreeMap();
            org.rhwlab.encode.objects.Experiment encodeExp = new org.rhwlab.encode.objects.Experiment();
            Class<?> cl = encodeExp.getClass();
            Selection select = new Selection(this.jsonDir, cl);
            for (int i = 0; i < select.getObjectCount(); ++i) {
                Experiment exp = null;
                JsonObject json = select.getEncodeObject(i).getJsonObject();
                if (json.getString("accession").equals("ENCSR660AYK")) {
                    boolean bl = false;
                }
                try {
                    String expStatus = json.getString("status");
                    if (expStatus.equals("released")) {
                        exp = new Experiment(json);
                        this.expMap.put(exp.accession, exp);
                        continue;
                    }
                    System.out.printf("Not Released: %s\n", json.getString("accession"));
                    continue;
                }
                catch (Exception exc) {
                    System.out.printf("Failed: %s\n", json.getString("accession"));
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(0);
        }
        for (Experiment exp : this.expMap.values()) {
            ArrayList<Experiment> list;
            ArrayList<Experiment> expList;
            if (exp.isControl()) continue;
            if (exp.getDbxref() == null && this.species.equalsIgnoreCase("fly")) {
                exp.setDbxref(this.flyGenes.getFBgnID(exp.getGene()));
            }
            if (exp.getDbxref() == null || exp.getGene() == null) {
                System.out.printf("Error in %s\n", exp.getAccession());
                continue;
            }
            tempDbxrefs.put(exp.getDbxref(), exp.getGene());
            tempCommon.put(exp.getGene(), exp.getDbxref());
            Experiment inputExp = this.expMap.get(exp.getInputAccession());
            if (inputExp == null) {
                System.out.printf("Control %s for %s not released \n", exp.getInputAccession(), exp.accession);
            }
            exp.setInput(inputExp);
            TreeMap<String, ArrayList<Experiment>> stageMap = (TreeMap<String, ArrayList<Experiment>>)tempTFStage.get(exp.getGene());
            if (stageMap == null) {
                stageMap = new TreeMap<String, ArrayList<Experiment>>();
                tempTFStage.put(exp.getGene(), stageMap);
            }
            if ((expList = (ArrayList<Experiment>)stageMap.get(exp.getStage())) == null) {
                expList = new ArrayList<Experiment>();
                stageMap.put(exp.getStage(), expList);
            }
            expList.add(exp);
            TreeMap<String, ArrayList<Experiment>> tfMap = (TreeMap<String, ArrayList<Experiment>>)tempStageTF.get(exp.getStage());
            if (tfMap == null) {
                tfMap = new TreeMap<String, ArrayList<Experiment>>();
                tempStageTF.put(exp.getStage(), tfMap);
            }
            if ((list = (ArrayList<Experiment>)tfMap.get(exp.getGene())) == null) {
                list = new ArrayList<Experiment>();
                tfMap.put(exp.getGene(), list);
            }
            list.add(exp);
        }
        this.byStageTF = tempStageTF;
        this.byTFStage = tempTFStage;
        this.dbxrefs = tempDbxrefs;
        this.commonNames = tempCommon;
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getSpecies() {
        return this.species;
    }

    public Collection<Experiment> getExperiments() {
        return this.expMap.values();
    }

    public boolean inDB(String tf) {
        return this.dbxrefs.get(tf) != null;
    }

    public String getCommonName(String dbxref) {
        return this.dbxrefs.get(dbxref);
    }

    public String getAnyRandomName() {
        Random rnd = new Random();
        int n = rnd.nextInt(this.dbxrefs.size());
        int i = 0;
        String ret = null;
        for (String r : this.dbxrefs.values()) {
            if (i == n) {
                ret = r;
                break;
            }
            ++i;
        }
        return ret;
    }

    public String getDbxref(String commonName) {
        return this.commonNames.get(commonName);
    }
}

