/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.util.List;
import org.primefaces.model.TreeNode;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.TF;

public class OrthologTF
extends TF {
    List<String> orthologs;

    public OrthologTF(String assembly, String gene, TreeNode parent, String type) {
        super(assembly, gene, parent, type);
    }

    public OrthologTF(String assembly, Experiment exp, TreeNode parent, String type) {
        super(assembly, exp, parent, type);
    }

    public void setOrthologs(List<String> o) {
        this.orthologs = o;
    }

    @Override
    public String getOrthologLabel() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        if (this.orthologs == null || this.orthologs.isEmpty()) {
            return "";
        }
        for (String ort : this.orthologs) {
            if (!first) {
                builder.append(" : ");
            }
            first = false;
            builder.append(ort);
        }
        return builder.toString();
    }

    @Override
    public String getOrthologLink() {
        if (this.dbxref == null || this.orthologs == null || this.orthologs.isEmpty()) {
            return "";
        }
        if (this.dbxref.startsWith("WBGene")) {
            return "faces/wormOrtholog.xhtml";
        }
        return "faces/flyOrtholog.xhtml";
    }
}

