/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import org.primefaces.model.TreeNode;
import org.rhwlab.modern.ExpRecordBase;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.TreeNodeRecord;

public class LifeStage
extends ExpRecordBase
implements Serializable,
TreeNodeRecord {
    String stage;
    String assembly;

    public LifeStage(String stage, TreeNode parent) {
        super(parent);
        this.stage = stage;
        this.assembly = null;
        this.exp = null;
    }

    public LifeStage(String assembly, Experiment exp, TreeNode parent) {
        super(parent);
        this.stage = exp.getStage();
        this.assembly = assembly;
        this.exp = exp;
    }

    @Override
    public String getDownload() {
        if (this.exp != null) {
            return "All DataTypes for this Stage";
        }
        return "All TFs for this Stage";
    }

    @Override
    public String getUniqueId() {
        if (this.exp != null) {
            return this.exp.getAccession();
        }
        return this.stage;
    }

    @Override
    public String getId() {
        return this.stage;
    }

    @Override
    public String getStrainLink() {
        if (this.exp != null) {
            return this.exp.getStrainLink();
        }
        return "";
    }

    @Override
    public boolean getStrainInExternalDB() {
        boolean r = !this.getStrainLink().equals("");
        return r;
    }

    @Override
    public boolean getStrainNotInExternalDB() {
        boolean r = this.getStrainLink().equals("");
        return r;
    }

    @Override
    public String getAccession() {
        if (this.exp == null) {
            return "";
        }
        String acc = this.exp.getAccession();
        return acc;
    }

    @Override
    public String getMetaDataLink() {
        if (this.exp == null) {
            return "";
        }
        String acc = this.exp.getAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/", acc);
    }

    @Override
    public String getInputMetaDataLink() {
        if (this.exp == null) {
            return "";
        }
        String inputAcc = this.exp.getInputAccession();
        return String.format("https://www.encodeproject.org/experiments/%s/", inputAcc);
    }

    @Override
    public String getInputAccession() {
        if (this.exp == null) {
            return "";
        }
        String inputAcc = this.exp.getInputAccession();
        return inputAcc;
    }

    @Override
    public String getRecordType() {
        return "Stage";
    }

    @Override
    public String getStrain() {
        if (this.exp == null) {
            return "";
        }
        return this.exp.getStrain();
    }

    @Override
    public String getUcscLink() {
        if (this.exp == null) {
            return "";
        }
        if (!this.exp.isVisual()) {
            return "";
        }
        String acc = this.exp.getAccession();
        String ret = String.format("http://genome.ucsc.edu/cgi-bin/hgTracks?hubClear=https://www.encodeproject.org/experiments/%s/@@hub/hub.txt&db=%s", acc, this.assembly);
        return ret;
    }

    @Override
    public String getBrowser() {
        if (this.exp == null) {
            return "";
        }
        if (!this.exp.isVisual()) {
            return "";
        }
        return "UCSC";
    }

    @Override
    public String getMicrographURL() {
        if (this.exp == null) {
            return "";
        }
        if (this.exp.getBiosample() == null) {
            return "";
        }
        String ret = this.exp.getBiosample().getJpegUrl();
        if (ret == null) {
            return "";
        }
        return ret;
    }

    @Override
    public String getMicrographLabel() {
        if (this.exp == null) {
            return "";
        }
        if (this.getMicrographURL().equals("")) {
            return "";
        }
        return "View";
    }

    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s/%s/%s", parent.getHubIdentifier(), this.getId().replaceAll(" ", "_"), this.getStrain(), this.getAccession());
    }
}

