/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.modern.RecordBase;
import org.rhwlab.modern.TreeNodeRecord;

public class FileType
extends RecordBase
implements Serializable,
TreeNodeRecord {
    String type;
    String assembly;
    static TreeMap<String, String> map;
    public static TreeMap<String, String> trackHubMap;
    public static TreeMap<String, String> fileTypesInHubMap;

    public FileType(String type, String assembly, TreeNode parent) {
        super(parent);
        map = new TreeMap();
        map.put("alignments", "These files contain the sequence reads aligned to the genome with an alignment score greater than 30");
        map.put("control normalized signal", "Replicates and pooled replicates with input subtracted to view signal tracks in UCSC genome browser or IGB. Allows you to view signal above input");
        map.put("optimal idr thresholded peaks", "Files give you the called peaks that passed IDR for both replicates");
        map.put("peaks", "Files give you the called peaks even below IDR for both replicates");
        map.put("read-depth normalized signal", "These wig files are scaled based on the number of reads");
        map.put("signal of unique reads", "These wig files are NOT scaled based on the number of reads.");
        map.put("reads", "The fastq files are the raw data for each replicate");
        trackHubMap = new TreeMap();
        trackHubMap.put("control normalized signal", "Subtracted");
        trackHubMap.put("optimal idr thresholded peaks", "Optimal");
        trackHubMap.put("read-depth normalized signal", "Scaled");
        trackHubMap.put("signal of unique reads", "Raw");
        trackHubMap.put("peaks", "Peaks");
        trackHubMap.put("alignments", "Alignments");
        trackHubMap.put("reads", "Reads");
        fileTypesInHubMap.put("Subtracted", "bigWig 0 1000");
        fileTypesInHubMap.put("Optimal", "bigBed 6 +");
        fileTypesInHubMap.put("Scaled", "bigWig 0 1000");
        fileTypesInHubMap.put("Raw", "bigWig 0 1000");
        fileTypesInHubMap.put("Peaks", "bigBed 6 +");
        this.type = type;
        this.assembly = assembly;
    }

    @Override
    public String getDownload() {
        return "All Files for this DataType";
    }

    @Override
    public String getId() {
        return this.type;
    }

    @Override
    public String getRecordType() {
        return "DataType";
    }

    @Override
    public Boolean getTooltip() {
        return this.getIdentifierTooltip() != null;
    }

    @Override
    public String getIdentifierTooltip() {
        return map.get(this.getId());
    }

    @Override
    public String getHubIdentifier() {
        TreeNodeRecord parent = (TreeNodeRecord)this.getParent();
        return String.format("%s/%s", parent.getHubIdentifier(), trackHubMap.get(this.getId()));
    }

    static {
        trackHubMap = new TreeMap();
        fileTypesInHubMap = new TreeMap();
    }
}

