/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;

public class FileDescription
implements Comparable {
    String replicate;
    String assembly;
    String outputType;
    String fileType;

    public FileDescription() {
    }

    public FileDescription(DCCFile dccFile) {
        this.assembly = dccFile.getAssembly();
        if (dccFile.getAssembly() == null) {
            this.assembly = "-";
        }
        this.fileType = dccFile.getFileType();
        this.outputType = dccFile.outputType;
        this.replicate = dccFile.replicates.length > 1 ? "C" : "d";
    }

    public static void reportUploadStatus(Experiment exp, PrintStream stream, String resource) throws Exception {
        List<FileDescription> fileDescs = FileDescription.readDescriptions(resource);
        String tf = exp.gene;
        if (exp.control) {
            tf = "Control";
        }
        stream.printf("%s %s %s %s %s\n", exp.getAccession(), exp.species, tf, exp.stage, exp.strain);
        block0: for (DCCFile dccFile : exp.getFiles()) {
            FileDescription dccDesc = new FileDescription(dccFile);
            for (int i = 0; i < fileDescs.size(); ++i) {
                if (fileDescs.get(i).compareTo(dccDesc) != 0) continue;
                fileDescs.remove(i);
                continue block0;
            }
        }
        for (FileDescription desc : fileDescs) {
            stream.printf("   %s %s %s %s\n", desc.assembly, desc.replicate, desc.outputType, desc.fileType);
        }
    }

    public static List<FileDescription> readDescriptions(String resource) throws Exception {
        ArrayList<FileDescription> ret = new ArrayList<FileDescription>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileDescription().getClass().getResourceAsStream(resource)));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(",");
            FileDescription desc = new FileDescription();
            desc.replicate = tokens[0];
            desc.assembly = tokens[1];
            desc.outputType = tokens[2];
            desc.fileType = tokens[3];
            ret.add(desc);
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    public int compareTo(Object o) {
        FileDescription other = (FileDescription)o;
        int ret = this.replicate.compareTo(other.replicate);
        if (ret != 0) {
            return ret;
        }
        ret = this.assembly.compareTo(other.assembly);
        if (ret != 0) {
            return ret;
        }
        ret = this.outputType.compareTo(other.outputType);
        if (ret != 0) {
            return ret;
        }
        return this.fileType.compareTo(other.fileType);
    }

    public static void main(String[] args) throws Exception {
        List<FileDescription> descSet = FileDescription.readDescriptions("/org/rhwlab/encode/WormExperimentalFiles");
        boolean iuashdfi = false;
    }
}

