/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.cgc.CGCStrain;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.modern.Biosample;
import org.rhwlab.modern.DCCFile;

public class Experiment
implements Serializable {
    String accession;
    String stage;
    String inputAccession;
    Experiment input;
    String strain;
    TreeMap<String, DCCFile> files = new TreeMap();
    TreeMap<String, DCCFile> unreleased = new TreeMap();
    String gene;
    Biosample biosample;
    boolean control;
    String dbxref;
    List<String> orthologs;
    CGCStrain cgc;
    String donorUrl;
    boolean visual;
    String species;
    int[] biologicalReplicates;
    String status;

    public Experiment(String accession) throws Exception {
        this(EncodeObject.getFromEncode(accession));
    }

    public Experiment(JsonObject obj) throws Exception {
        JsonArray possibleControls;
        int n;
        this.accession = obj.getString("accession");
        this.status = obj.getString("status");
        this.visual = obj.getJsonObject("visualize") != null;
        JsonArray filesObj = obj.getJsonArray("files");
        for (int i = 0; i < filesObj.size(); ++i) {
            DCCFile dccFile = new DCCFile(filesObj.getJsonObject(i));
            this.files.put(dccFile.getAccession(), dccFile);
        }
        JsonArray replicates = obj.getJsonArray("replicates");
        if (replicates.isEmpty()) {
            return;
        }
        this.biologicalReplicates = new int[replicates.size()];
        for (int i = 0; i < replicates.size(); ++i) {
            this.biologicalReplicates[i] = replicates.getJsonObject(i).getInt("biological_replicate_number");
        }
        JsonObject rep1 = replicates.getJsonObject(0);
        JsonObject library = rep1.getJsonObject("library");
        if (library == null) {
            return;
        }
        JsonObject sample = library.getJsonObject("biosample");
        if (sample == null) {
            return;
        }
        JsonString stageObj = sample.getJsonString("life_stage");
        if (stageObj == null) {
            return;
        }
        this.stage = stageObj.getString();
        JsonObject donor = sample.getJsonObject("donor");
        this.strain = "";
        if (donor != null) {
            JsonArray dbxs;
            this.species = donor.getJsonObject("organism").getString("name");
            this.strain = donor.getString("strain_name", "");
            JsonString urlObj = donor.getJsonString("url");
            if (urlObj != null) {
                this.donorUrl = urlObj.getString();
            } else if (donor.getJsonObject("organism").getString("name").equals("dmelanogaster") && (dbxs = donor.getJsonArray("dbxrefs")).size() > 0) {
                this.donorUrl = String.format("http://flystocks.bio.indiana.edu/Reports/%s.html", dbxs.getString(0).split(":")[1]);
            }
        }
        if ((n = (possibleControls = obj.getJsonArray("possible_controls")).size()) > 0) {
            this.inputAccession = possibleControls.getJsonObject(0).getJsonString("accession").getString();
            JsonObject organism = sample.getJsonObject("organism");
            String organismName = organism.getString("name");
            if (organismName.equals("celegans")) {
                this.biosample = new Biosample(sample);
                if (!this.strain.equals("")) {
                    // empty if block
                }
            }
        }
        this.control = false;
        JsonObject target = obj.getJsonObject("target");
        if (target != null) {
            JsonString geneString;
            JsonArray investigated = target.getJsonArray("investigated_as");
            for (int i = 0; i < investigated.size(); ++i) {
                if (!investigated.getString(i).equals("control")) continue;
                this.control = true;
                break;
            }
            if ((geneString = target.getJsonString("gene_name")) != null) {
                if (geneString.getString().startsWith("Sry")) {
                    boolean bl = false;
                }
                this.gene = geneString.getString();
            } else {
                this.gene = target.getString("label");
            }
            if (this.gene.startsWith("eGFP-")) {
                this.gene = this.gene.substring(5);
            }
            this.dbxref = null;
            JsonArray dbxrefArray = target.getJsonArray("dbxref");
            for (int i = 0; i < dbxrefArray.size(); ++i) {
                String[] tokens = dbxrefArray.getString(i).split(":");
                if (tokens[0].equals("WormBase") && tokens[1].startsWith("WBGene")) {
                    this.dbxref = tokens[1];
                    break;
                }
                if (!tokens[0].equalsIgnoreCase("FlyBase") || !tokens[1].startsWith("FBgn")) continue;
                this.dbxref = tokens[1];
            }
        }
    }

    public String getStatus() {
        return this.status;
    }

    public int[] getReplicates() {
        return this.biologicalReplicates;
    }

    public DCCFile[] getFiles() {
        return this.files.values().toArray(new DCCFile[0]);
    }

    public DCCFile[] getUnreleasedFiles() {
        return this.unreleased.values().toArray(new DCCFile[0]);
    }

    public void setInput(Experiment input) {
        this.input = input;
    }

    public String getStrain() {
        return this.strain;
    }

    public String getInputAccession() {
        return this.inputAccession;
    }

    public String getAccession() {
        return this.accession;
    }

    public Experiment getInput() {
        return this.input;
    }

    public String getGene() {
        return this.gene;
    }

    public String getStage() {
        return this.stage;
    }

    public String getSpecies() {
        return this.species;
    }

    public Biosample getBiosample() {
        return this.biosample;
    }

    public boolean isControl() {
        return this.control;
    }

    public String getDbxref() {
        return this.dbxref;
    }

    public void setDbxref(String dbx) {
        this.dbxref = dbx;
    }

    public void setOrthologs(List<String> orthologs) {
        this.orthologs = orthologs;
    }

    public List<String> getOrthologs() {
        return this.orthologs;
    }

    public String getStrainLink() {
        if (this.dbxref == null) {
            return "";
        }
        if (this.dbxref.startsWith("WBGene")) {
            if (this.cgc != null) {
                if (this.cgc.getUrl() == null) {
                    return "";
                }
                return this.cgc.getUrl();
            }
            return "";
        }
        if (this.donorUrl != null) {
            return this.donorUrl;
        }
        return "";
    }

    public boolean isVisual() {
        return this.visual;
    }
}

