/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.File;
import java.io.Serializable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;

public class DCCFile
implements Serializable {
    String accession;
    String submittedName;
    String fileType;
    String outputType;
    String assembly;
    String href;
    int[] replicates;
    String status;

    public DCCFile(JsonObject jsonObj) {
        this.accession = jsonObj.getString("accession");
        this.status = jsonObj.getString("status");
        this.submittedName = new File(jsonObj.getString("submitted_file_name")).getName();
        this.fileType = jsonObj.getString("file_type");
        this.outputType = jsonObj.getString("output_type");
        JsonString assemblyObj = jsonObj.getJsonString("assembly");
        this.assembly = assemblyObj != null ? assemblyObj.getString() : null;
        this.href = jsonObj.getString("href");
        JsonArray jsonReps = jsonObj.getJsonArray("biological_replicates");
        if (jsonReps != null) {
            this.replicates = new int[jsonReps.size()];
            for (int i = 0; i < jsonReps.size(); ++i) {
                this.replicates[i] = jsonReps.getInt(i);
            }
        }
    }

    public String getAccession() {
        return this.accession;
    }

    public String getSubmittedFileName() {
        return this.submittedName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public String getHref() {
        return this.href;
    }

    public String getAssembly() {
        return this.assembly;
    }

    public int[] getReplicates() {
        return this.replicates;
    }

    public String getStatus() {
        return this.status;
    }
}

