/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.modern;

import java.io.Serializable;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.EncodeUrl;

public class Biosample
implements Serializable {
    String accession;
    String jpegURL;

    public Biosample(JsonObject obj) {
        JsonArray cArray = obj.getJsonArray("characterizations");
        for (int i = 0; i < cArray.size(); ++i) {
            JsonObject cObj = cArray.getJsonObject(i);
            String method = cObj.getString("characterization_method");
            if (!method.equals("immunofluorescence")) continue;
            String id = cObj.getString("@id");
            JsonObject attach = cObj.getJsonObject("attachment");
            String href = attach.getString("href");
            this.jpegURL = String.format("https://www.encodeproject.org%s%s", id, href);
            break;
        }
    }

    public Biosample(String accession) throws Exception {
        this.accession = accession;
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org/biosamples/%s/?format=json", accession));
        url.getJson();
        JsonObject obj = url.getJsonObject();
        JsonArray cArray = obj.getJsonArray("characterizations");
        for (int i = 0; i < cArray.size(); ++i) {
            JsonObject cObj = cArray.getJsonObject(i);
            String method = cObj.getString("characterization_method");
            if (!method.equals("immunofluorescence")) continue;
            String id = cObj.getString("@id");
            JsonObject attach = cObj.getJsonObject("attachment");
            String href = attach.getString("href");
            this.jpegURL = String.format("https://www.encodeproject.org%s%s", id, href);
            break;
        }
    }

    public String getJpegUrl() {
        return this.jpegURL;
    }
}

