/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.qa;

import java.io.File;
import java.io.PrintStream;
import java.util.TreeMap;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;

public class ChipSeqUpload {
    String[] assemblies;
    Experiment exp;
    PrintStream stream;
    static String[] wormAssembly = new String[]{"ce10", "ce11"};
    static String[] flyAssembly = new String[]{"dm3", "dm6"};
    static int reads = 0;
    static int align = 1;
    static int signal = 2;
    static int depth = 3;
    static int control = 4;
    static int peaks = 5;
    static int optimal = 6;
    static int fastq = 0;
    static int bam = 1;
    static int bigWig = 2;
    static int bigBed = 3;
    static int bed = 4;
    static int[] repAssembly = new int[]{align, bam, signal, bigWig, depth, bigWig, control, bigWig, peaks, bigBed, peaks, bed};
    static int[] ipAssembly = new int[]{signal, bigWig, depth, bigWig, control, bigWig, peaks, bigBed, peaks, bed, optimal, bigBed, optimal, bed};
    static int[] inputAssembly = new int[]{align, bam, signal, bigWig, depth, bigWig};
    static String[] outTypes = new String[]{"reads", "alignments", "signal of unique reads", "read-depth normalized signal", "control normalized signal", "peaks", "optimal idr thresholded peaks"};
    static String[] fileTypes = new String[]{"fastq", "bam", "bigWig", "bigBed narrowPeak", "bed narrowPeak"};

    public ChipSeqUpload(Experiment exp, String[] assemblies, PrintStream stream) {
        this.assemblies = assemblies;
        this.exp = exp;
        this.stream = stream;
    }

    public void reportExperimentIP() {
        this.stream.printf("%s,%s,%s,%s,%s,%s\n", this.exp.getAccession(), this.exp.getSpecies(), this.exp.getGene(), this.exp.getStage(), this.exp.getStrain(), this.exp.getStatus());
        for (int replicate : this.exp.getReplicates()) {
            this.reportIP_Replicate(replicate);
        }
        for (String assembly : this.assemblies) {
            this.reportIP_Assembly(assembly);
        }
        this.reportInput();
        this.stream.println();
    }

    private void reportIP_Replicate(int rep) {
        if (this.findFile(this.exp.getFiles(), rep, null, reads, fastq) == null) {
            DCCFile unreleased = this.findFile(this.exp.getUnreleasedFiles(), rep, null, reads, fastq);
            if (unreleased == null) {
                this.stream.printf("   replicate %d,reads,fastq\n", rep);
            } else {
                this.stream.printf("   replicate %d,reads,fastq   %s\n", rep, unreleased.getStatus());
            }
        }
        for (String assembly : this.assemblies) {
            this.reportIP_ReplicateAssembly(rep, assembly);
        }
    }

    private void reportIP_ReplicateAssembly(int rep, String assembly) {
        for (int i = 0; i < repAssembly.length; i += 2) {
            if (this.findFile(this.exp.getFiles(), rep, assembly, repAssembly[i], repAssembly[i + 1]) != null) continue;
            DCCFile unreleased = this.findFile(this.exp.getUnreleasedFiles(), rep, assembly, repAssembly[i], repAssembly[i + 1]);
            if (unreleased == null) {
                this.stream.printf("   replicate %d,assembly %s,%s,%s\n", rep, assembly, outTypes[repAssembly[i]], fileTypes[repAssembly[i + 1]]);
                continue;
            }
            this.stream.printf("   replicate %d,assembly %s,%s,%s   %s\n", rep, assembly, outTypes[repAssembly[i]], fileTypes[repAssembly[i + 1]], unreleased.getStatus());
        }
    }

    private void reportIP_Assembly(String assembly) {
        for (int i = 0; i < ipAssembly.length; i += 2) {
            if (this.findFile(this.exp.getFiles(), this.exp.getReplicates(), assembly, ipAssembly[i], ipAssembly[i + 1]) != null) continue;
            DCCFile unreleased = this.findFile(this.exp.getUnreleasedFiles(), this.exp.getReplicates(), assembly, ipAssembly[i], ipAssembly[i + 1]);
            if (unreleased == null) {
                this.stream.printf("   combined,assembly %s,%s,%s\n", assembly, outTypes[ipAssembly[i]], fileTypes[ipAssembly[i + 1]]);
                continue;
            }
            this.stream.printf("   combined,assembly %s,%s,%s   %s\n", assembly, outTypes[ipAssembly[i]], fileTypes[ipAssembly[i + 1]], unreleased.getStatus());
        }
    }

    private void reportInput() {
        Experiment inputExp = this.exp.getInput();
        if (inputExp == null) {
            this.stream.println("Missing input control");
            return;
        }
        this.stream.printf("   Input Experiment %s\n", inputExp.getAccession());
        for (int replicate : inputExp.getReplicates()) {
            if (this.findFile(inputExp.getFiles(), replicate, null, reads, fastq) != null) continue;
            DCCFile unreleased = this.findFile(inputExp.getUnreleasedFiles(), replicate, null, reads, fastq);
            if (unreleased == null) {
                this.stream.printf("      replicate %d,reads,fastq\n", replicate);
                continue;
            }
            this.stream.printf("      replicate %d,reads,fastq   %s\n", replicate, unreleased.getStatus());
        }
        for (String assembly : this.assemblies) {
            for (int i = 0; i < inputAssembly.length; i += 2) {
                if (this.findFile(inputExp.getFiles(), inputExp.getReplicates(), assembly, inputAssembly[i], inputAssembly[i + 1]) != null) continue;
                DCCFile unreleased = this.findFile(inputExp.getUnreleasedFiles(), inputExp.getReplicates(), assembly, inputAssembly[i], inputAssembly[i + 1]);
                if (unreleased == null) {
                    this.stream.printf("      combined,assembly %s,%s,%s\n", assembly, outTypes[inputAssembly[i]], fileTypes[inputAssembly[i + 1]]);
                    continue;
                }
                this.stream.printf("      combined,assembly %s,%s,%s   %s\n", assembly, outTypes[inputAssembly[i]], fileTypes[inputAssembly[i + 1]], unreleased.getStatus());
            }
        }
    }

    private DCCFile findFile(DCCFile[] dccFiles, Object reps, String assembly, int outType, int fileType) {
        for (DCCFile dccFile : dccFiles) {
            if (assembly != null && !assembly.equals(dccFile.getAssembly()) || !outTypes[outType].equals(dccFile.getOutputType()) || !fileTypes[fileType].equals(dccFile.getFileType())) continue;
            int[] dccReps = dccFile.getReplicates();
            if (!(reps instanceof int[] ? ((int[])reps).length == dccReps.length : dccReps.length == 1 && dccReps[0] == (Integer)reps)) continue;
            return dccFile;
        }
        return null;
    }

    public static void report(File dir, String[] assemblies) throws Exception {
        Experiment exp;
        Class<?> cl = new org.rhwlab.encode.objects.Experiment().getClass();
        Selection selection = new Selection(dir, cl);
        String reportFile = new File(dir, "UploadReport").getPath();
        PrintStream stream = new PrintStream(reportFile);
        TreeMap<String, Experiment> expMap = new TreeMap<String, Experiment>();
        int i = 0;
        for (int r = 0; r < selection.getObjectCount(); ++r) {
            EncodeObject obj = selection.getEncodeObject(r);
            System.out.printf("%d %s\n", i, obj.getJsonObject().getString("accession"));
            ++i;
            exp = new Experiment(obj.getJsonObject());
            expMap.put(exp.getAccession(), exp);
        }
        for (String acc : expMap.keySet()) {
            String inpAccession;
            exp = (Experiment)expMap.get(acc);
            if (exp.isControl() || (inpAccession = exp.getInputAccession()) == null) continue;
            Experiment control = (Experiment)expMap.get(inpAccession);
            exp.setInput(control);
        }
        for (Experiment exp2 : expMap.values()) {
            if (exp2.isControl()) continue;
            ChipSeqUpload upload = new ChipSeqUpload(exp2, assemblies, stream);
            upload.reportExperimentIP();
        }
        stream.close();
    }

    public static void main(String[] args) throws Exception {
        ChipSeqUpload.report(new File("/net/waterston/vol2/home/gevirl/FlyChipSeqExperiments"), flyAssembly);
    }
}

