/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ortholog;

import java.io.Serializable;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ortholog.OrthologService;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.ViewBase;

public class OrthologView
extends ViewBase
implements Serializable {
    String tf;
    String title;

    public OrthologView() {
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        this.tf = req.getParameter("TF");
    }

    public String getTitle() {
        String source;
        this.title = "ChipSeq";
        if (this.service != null && this.tf != null && (source = this.service.getCommonName(this.tf)) != null) {
            this.title = String.format("ChipSeq for Ortholog of %s", this.service.getCommonName(this.tf));
        }
        return this.title;
    }

    public void setService(OrthologService service) {
        this.service = service;
    }

    @Override
    public void setGenomes(ReferenceGenome gen) {
        this.genomes = gen;
    }

    public TreeNode getRoot() {
        if (this.root == null) {
            this.buildTree();
        }
        return this.root;
    }

    public String getTF() {
        return this.tf;
    }

    private void buildTree() {
        if (this.tf == null) {
            return;
        }
        if (this.tf.startsWith("WBGene")) {
            List<String> flys = this.service.getWormOrthologsCommonName(this.tf);
            this.root = this.service.createTree("fly", flys, this.genomes.getFly());
        } else {
            List<String> worms = this.service.getFlyOrthologsCommonName(this.tf);
            this.root = this.service.createTree("worm", worms, this.genomes.getWorm());
        }
        boolean iusfhuis = false;
    }

    @Override
    public TreeNode[] getSelectedNodes() {
        return this.selectedNodes;
    }

    @Override
    public void setSelectedNodes(TreeNode[] selectedNodes) throws Exception {
        this.selectedNodes = selectedNodes;
        this.urlsMap.clear();
        if (selectedNodes == null) {
            return;
        }
        for (TreeNode treeNode : selectedNodes) {
            OrthologView.addURLs(treeNode, this.urlsMap);
        }
    }

    @Override
    public String getZipFileName() {
        return String.format("%s_Ortholog.zip", this.tf);
    }
}

